#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSProcessActorChild = 8175,
  JSProcessActorParent = 8195,
  JSWindowActorChild = 8216,
  JSWindowActorParent = 8235,
  KeyEvent = 8255,
  KeyboardEvent = 8264,
  KeyframeEffect = 8278,
  L10nFileSource = 8293,
  L10nOverlays = 8308,
  L10nRegistry = 8321,
  LargestContentfulPaint = 8334,
  LegacyMozTCPSocket = 8357,
  LlamaRunner = 8376,
  Localization = 8388,
  Location = 8401,
  Lock = 8410,
  LockManager = 8415,
  MIDIAccess = 8427,
  MIDIConnectionEvent = 8438,
  MIDIInput = 8458,
  MIDIInputMap = 8468,
  MIDIMessageEvent = 8481,
  MIDIOutput = 8498,
  MIDIOutputMap = 8509,
  MIDIPort = 8523,
  MLS = 8532,
  MLSGroupView = 8536,
  MOZ_debug = 8549,
  MatchGlob = 8559,
  MatchPattern = 8569,
  MatchPatternSet = 8582,
  MathMLElement = 8598,
  MediaCapabilities = 8612,
  MediaControlService = 8630,
  MediaController = 8650,
  MediaDeviceInfo = 8666,
  MediaDevices = 8682,
  MediaElementAudioSourceNode = 8695,
  MediaEncryptedEvent = 8723,
  MediaError = 8743,
  MediaKeyError = 8754,
  MediaKeyMessageEvent = 8768,
  MediaKeySession = 8789,
  MediaKeyStatusMap = 8805,
  MediaKeyStatusMap_Iterator = 8823,
  MediaKeySystemAccess = 8850,
  MediaKeys = 8871,
  MediaList = 8881,
  MediaMetadata = 8891,
  MediaQueryList = 8905,
  MediaQueryListEvent = 8920,
  MediaRecorder = 8940,
  MediaRecorderErrorEvent = 8954,
  MediaSession = 8978,
  MediaSource = 8991,
  MediaStream = 9003,
  MediaStreamAudioDestinationNode = 9015,
  MediaStreamAudioSourceNode = 9047,
  MediaStreamError = 9074,
  MediaStreamEvent = 9091,
  MediaStreamTrack = 9108,
  MediaStreamTrackAudioSourceNode = 9125,
  MediaStreamTrackEvent = 9157,
  MerchantValidationEvent = 9179,
  MessageBroadcaster = 9203,
  MessageChannel = 9222,
  MessageEvent = 9237,
  MessageListenerManager = 9250,
  MessagePort = 9273,
  MessageSender = 9285,
  MimeType = 9299,
  MimeTypeArray = 9308,
  MouseEvent = 9322,
  MouseScrollEvent = 9333,
  MozCanvasPrintState = 9350,
  MozDocumentMatcher = 9370,
  MozDocumentObserver = 9389,
  MozQueryInterface = 9409,
  MozSharedMap = 9427,
  MozSharedMap_Iterator = 9440,
  MozSharedMapChangeEvent = 9462,
  MozStorageAsyncStatementParams = 9486,
  MozStorageStatementParams = 9517,
  MozStorageStatementRow = 9543,
  MozWritableSharedMap = 9566,
  MutationObserver = 9587,
  MutationRecord = 9604,
  NamedNodeMap = 9619,
  NavigateEvent = 9632,
  Navigation = 9646,
  NavigationActivation = 9657,
  NavigationCurrentEntryChangeEvent = 9678,
  NavigationDestination = 9712,
  NavigationHistoryEntry = 9734,
  NavigationPrecommitController = 9757,
  NavigationPreloadManager = 9787,
  NavigationTransition = 9812,
  Navigator = 9833,
  NavigatorLogin = 9843,
  NetworkInformation = 9858,
  Node = 9877,
  NodeFilter = 9882,
  NodeIterator = 9893,
  NodeList = 9906,
  Notification = 9915,
  NotificationEvent = 9928,
  NotifyPaintEvent = 9946,
  OES_draw_buffers_indexed = 9963,
  OES_element_index_uint = 9988,
  OES_fbo_render_mipmap = 10011,
  OES_standard_derivatives = 10033,
  OES_texture_float = 10058,
  OES_texture_float_linear = 10076,
  OES_texture_half_float = 10101,
  OES_texture_half_float_linear = 10124,
  OES_vertex_array_object = 10154,
  OVR_multiview2 = 10178,
  OfflineAudioCompletionEvent = 10193,
  OfflineAudioContext = 10221,
  OffscreenCanvas = 10241,
  OffscreenCanvasRenderingContext2D = 10257,
  Option = 10291,
  OscillatorNode = 10298,
  PageTransitionEvent = 10313,
  PaintRequest = 10333,
  PaintRequestList = 10346,
  PaintWorkletGlobalScope = 10363,
  PannerNode = 10387,
  ParentProcessMessageManager = 10398,
  Path2D = 10426,
  PathUtils = 10433,
  PaymentAddress = 10443,
  PaymentMethodChangeEvent = 10458,
  PaymentRequest = 10483,
  PaymentRequestUpdateEvent = 10498,
  PaymentResponse = 10524,
  PeerConnectionImpl = 10540,
  PeerConnectionObserver = 10559,
  Performance = 10582,
  PerformanceEntry = 10594,
  PerformanceEntryEvent = 10611,
  PerformanceEventTiming = 10633,
  PerformanceMark = 10656,
  PerformanceMeasure = 10672,
  PerformanceNavigation = 10691,
  PerformanceNavigationTiming = 10713,
  PerformanceObserver = 10741,
  PerformanceObserverEntryList = 10761,
  PerformancePaintTiming = 10790,
  PerformanceResourceTiming = 10813,
  PerformanceServerTiming = 10839,
  PerformanceTiming = 10863,
  PeriodicWave = 10881,
  PermissionStatus = 10894,
  Permissions = 10911,
  PlacesBookmark = 10923,
  PlacesBookmarkAddition = 10938,
  PlacesBookmarkChanged = 10961,
  PlacesBookmarkGuid = 10983,
  PlacesBookmarkKeyword = 11002,
  PlacesBookmarkMoved = 11024,
  PlacesBookmarkRemoved = 11044,
  PlacesBookmarkTags = 11066,
  PlacesBookmarkTime = 11085,
  PlacesBookmarkTitle = 11104,
  PlacesBookmarkUrl = 11124,
  PlacesEvent = 11142,
  PlacesEventCounts = 11154,
  PlacesFavicon = 11172,
  PlacesHistoryCleared = 11186,
  PlacesObservers = 11207,
  PlacesPurgeCaches = 11223,
  PlacesRanking = 11241,
  PlacesVisit = 11255,
  PlacesVisitRemoved = 11267,
  PlacesVisitTitle = 11286,
  PlacesWeakCallbackWrapper = 11303,
  Plugin = 11329,
  PluginArray = 11336,
  PluginCrashedEvent = 11348,
  PointerEvent = 11367,
  PopStateEvent = 11380,
  PopupBlockedEvent = 11394,
  PopupPositionedEvent = 11412,
  PositionStateEvent = 11433,
  PrecompiledScript = 11452,
  PrivateAttribution = 11470,
  ProcessMessageManager = 11489,
  ProcessingInstruction = 11511,
  ProgressEvent = 11533,
  PromiseDebugging = 11547,
  PromiseNativeHandler = 11564,
  PromiseRejectionEvent = 11585,
  PublicKeyCredential = 11607,
  PushEvent = 11627,
  PushManager = 11637,
  PushManagerImpl = 11649,
  PushMessageData = 11665,
  PushSubscription = 11681,
  PushSubscriptionChangeEvent = 11698,
  PushSubscriptionOptions = 11726,
  RTCCertificate = 11750,
  RTCDTMFSender = 11765,
  RTCDTMFToneChangeEvent = 11779,
  RTCDataChannel = 11802,
  RTCDataChannelEvent = 11817,
  RTCDtlsTransport = 11837,
  RTCEncodedAudioFrame = 11854,
  RTCEncodedVideoFrame = 11875,
  RTCIceCandidate = 11896,
  RTCIceTransport = 11912,
  RTCIdentityProviderRegistrar = 11928,
  RTCPeerConnection = 11957,
  RTCPeerConnectionIceEvent = 11975,
  RTCPeerConnectionStatic = 12001,
  RTCRtpReceiver = 12025,
  RTCRtpScriptTransform = 12040,
  RTCRtpScriptTransformer = 12062,
  RTCRtpSender = 12086,
  RTCRtpTransceiver = 12099,
  RTCSctpTransport = 12117,
  RTCSessionDescription = 12134,
  RTCStatsReport = 12156,
  RTCTrackEvent = 12171,
  RTCTransformEvent = 12185,
  RadioNodeList = 12203,
  Range = 12217,
  ReadableByteStreamController = 12223,
  ReadableStream = 12252,
  ReadableStream_AsyncIterator = 12267,
  ReadableStreamBYOBReader = 12296,
  ReadableStreamBYOBRequest = 12321,
  ReadableStreamDefaultController = 12347,
  ReadableStreamDefaultReader = 12379,
  RedirectBlockedEvent = 12407,
  Report = 12428,
  ReportBody = 12435,
  ReportingObserver = 12446,
  Request = 12464,
  ResizeObserver = 12472,
  ResizeObserverEntry = 12487,
  ResizeObserverSize = 12507,
  Response = 12526,
  SVGAElement = 12535,
  SVGAngle = 12547,
  SVGAnimateElement = 12556,
  SVGAnimateMotionElement = 12574,
  SVGAnimateTransformElement = 12598,
  SVGAnimatedAngle = 12625,
  SVGAnimatedBoolean = 12642,
  SVGAnimatedEnumeration = 12661,
  SVGAnimatedInteger = 12684,
  SVGAnimatedLength = 12703,
  SVGAnimatedLengthList = 12721,
  SVGAnimatedNumber = 12743,
  SVGAnimatedNumberList = 12761,
  SVGAnimatedPreserveAspectRatio = 12783,
  SVGAnimatedRect = 12814,
  SVGAnimatedString = 12830,
  SVGAnimatedTransformList = 12848,
  SVGAnimationElement = 12873,
  SVGCircleElement = 12893,
  SVGClipPathElement = 12910,
  SVGComponentTransferFunctionElement = 12929,
  SVGDefsElement = 12965,
  SVGDescElement = 12980,
  SVGElement = 12995,
  SVGEllipseElement = 13006,
  SVGFEBlendElement = 13024,
  SVGFEColorMatrixElement = 13042,
  SVGFEComponentTransferElement = 13066,
  SVGFECompositeElement = 13096,
  SVGFEConvolveMatrixElement = 13118,
  SVGFEDiffuseLightingElement = 13145,
  SVGFEDisplacementMapElement = 13173,
  SVGFEDistantLightElement = 13201,
  SVGFEDropShadowElement = 13226,
  SVGFEFloodElement = 13249,
  SVGFEFuncAElement = 13267,
  SVGFEFuncBElement = 13285,
  SVGFEFuncGElement = 13303,
  SVGFEFuncRElement = 13321,
  SVGFEGaussianBlurElement = 13339,
  SVGFEImageElement = 13364,
  SVGFEMergeElement = 13382,
  SVGFEMergeNodeElement = 13400,
  SVGFEMorphologyElement = 13422,
  SVGFEOffsetElement = 13445,
  SVGFEPointLightElement = 13464,
  SVGFESpecularLightingElement = 13487,
  SVGFESpotLightElement = 13516,
  SVGFETileElement = 13538,
  SVGFETurbulenceElement = 13555,
  SVGFilterElement = 13578,
  SVGForeignObjectElement = 13595,
  SVGGElement = 13619,
  SVGGeometryElement = 13631,
  SVGGradientElement = 13650,
  SVGGraphicsElement = 13669,
  SVGImageElement = 13688,
  SVGLength = 13704,
  SVGLengthList = 13714,
  SVGLineElement = 13728,
  SVGLinearGradientElement = 13743,
  SVGMPathElement = 13768,
  SVGMarkerElement = 13784,
  SVGMaskElement = 13801,
  SVGMatrix = 13816,
  SVGMetadataElement = 13826,
  SVGNumber = 13845,
  SVGNumberList = 13855,
  SVGPathElement = 13869,
  SVGPathSegment = 13884,
  SVGPatternElement = 13899,
  SVGPoint = 13917,
  SVGPointList = 13926,
  SVGPolygonElement = 13939,
  SVGPolylineElement = 13957,
  SVGPreserveAspectRatio = 13976,
  SVGRadialGradientElement = 13999,
  SVGRect = 14024,
  SVGRectElement = 14032,
  SVGSVGElement = 14047,
  SVGScriptElement = 14061,
  SVGSetElement = 14078,
  SVGStopElement = 14092,
  SVGStringList = 14107,
  SVGStyleElement = 14121,
  SVGSwitchElement = 14137,
  SVGSymbolElement = 14154,
  SVGTSpanElement = 14171,
  SVGTextContentElement = 14187,
  SVGTextElement = 14209,
  SVGTextPathElement = 14224,
  SVGTextPositioningElement = 14243,
  SVGTitleElement = 14269,
  SVGTransform = 14285,
  SVGTransformList = 14298,
  SVGUnitTypes = 14315,
  SVGUseElement = 14328,
  SVGViewElement = 14342,
  Sanitizer = 14357,
  Scheduler = 14367,
  Screen = 14377,
  ScreenLuminance = 14384,
  ScreenOrientation = 14400,
  ScriptProcessorNode = 14418,
  ScrollAreaEvent = 14438,
  SecurityPolicyViolationEvent = 14454,
  Selection = 14483,
  ServiceWorker = 14493,
  ServiceWorkerContainer = 14507,
  ServiceWorkerGlobalScope = 14530,
  ServiceWorkerRegistration = 14555,
  SessionStoreFormData = 14581,
  SessionStoreScrollData = 14602,
  SessionStoreUtils = 14625,
  ShadowRealmGlobalScope = 14643,
  ShadowRoot = 14666,
  SharedWorker = 14677,
  SharedWorkerGlobalScope = 14690,
  SimpleGestureEvent = 14714,
  SourceBuffer = 14733,
  SourceBufferList = 14746,
  SpeechGrammar = 14763,
  SpeechGrammarList = 14777,
  SpeechRecognition = 14795,
  SpeechRecognitionAlternative = 14813,
  SpeechRecognitionError = 14842,
  SpeechRecognitionEvent = 14865,
  SpeechRecognitionResult = 14888,
  SpeechRecognitionResultList = 14912,
  SpeechSynthesis = 14940,
  SpeechSynthesisErrorEvent = 14956,
  SpeechSynthesisEvent = 14982,
  SpeechSynthesisUtterance = 15003,
  SpeechSynthesisVoice = 15028,
  StaticRange = 15049,
  StereoPannerNode = 15061,
  Storage = 15078,
  StorageEvent = 15086,
  StorageManager = 15099,
  StreamFilter = 15114,
  StreamFilterDataEvent = 15127,
  StructuredCloneHolder = 15149,
  StructuredCloneTester = 15171,
  StylePropertyMap = 15193,
  StylePropertyMapReadOnly = 15210,
  StylePropertyMapReadOnly_Iterator = 15235,
  StyleSheet = 15269,
  StyleSheetApplicableStateChangeEvent = 15280,
  StyleSheetList = 15317,
  StyleSheetRemovedEvent = 15332,
  SubmitEvent = 15355,
  SubtleCrypto = 15367,
  SyncMessageSender = 15380,
  SyncReadFile = 15398,
  TCPServerSocket = 15411,
  TCPServerSocketEvent = 15427,
  TCPSocket = 15448,
  TCPSocketErrorEvent = 15458,
  TCPSocketEvent = 15478,
  TaskController = 15493,
  TaskPriorityChangeEvent = 15508,
  TaskSignal = 15532,
  Tensor = 15543,
  TestUtils = 15550,
  TestingDeprecatedInterface = 15560,
  Text = 15587,
  TextClause = 15592,
  TextDecoder = 15603,
  TextDecoderStream = 15615,
  TextEncoder = 15633,
  TextEncoderStream = 15645,
  TextEvent = 15663,
  TextMetrics = 15673,
  TextTrack = 15685,
  TextTrackCue = 15695,
  TextTrackCueList = 15708,
  TextTrackList = 15725,
  TimeEvent = 15739,
  TimeRanges = 15749,
  ToggleEvent = 15760,
  Touch = 15772,
  TouchEvent = 15778,
  TouchList = 15789,
  TrackEvent = 15799,
  TransformStream = 15810,
  TransformStreamDefaultController = 15826,
  TransitionEvent = 15859,
  TreeColumn = 15875,
  TreeColumns = 15886,
  TreeContentView = 15898,
  TreeWalker = 15914,
  TrustedHTML = 15925,
  TrustedScript = 15937,
  TrustedScriptURL = 15951,
  TrustedTypePolicy = 15968,
  TrustedTypePolicyFactory = 15986,
  UDPMessageEvent = 16011,
  UDPSocket = 16027,
  UIEvent = 16037,
  URL = 16045,
  URLPattern = 16049,
  URLSearchParams = 16060,
  URLSearchParams_Iterator = 16076,
  UniFFIPointer = 16101,
  UniFFIScaffolding = 16115,
  UserActivation = 16133,
  UserInteraction = 16148,
  UserProximityEvent = 16164,
  VRDisplay = 16183,
  VRDisplayCapabilities = 16193,
  VRDisplayEvent = 16215,
  VREyeParameters = 16230,
  VRFieldOfView = 16246,
  VRFrameData = 16260,
  VRMockController = 16272,
  VRMockDisplay = 16289,
  VRPose = 16303,
  VRServiceTest = 16310,
  VRStageParameters = 16324,
  VTTCue = 16342,
  VTTRegion = 16349,
  ValidityState = 16359,
  VideoColorSpace = 16373,
  VideoDecoder = 16389,
  VideoEncoder = 16402,
  VideoFrame = 16415,
  VideoPlaybackQuality = 16426,
  VideoTrack = 16447,
  VideoTrackList = 16458,
  ViewTransition = 16473,
  VisualViewport = 16488,
  WEBGL_color_buffer_float = 16503,
  WEBGL_compressed_texture_astc = 16528,
  WEBGL_compressed_texture_etc = 16558,
  WEBGL_compressed_texture_etc1 = 16587,
  WEBGL_compressed_texture_pvrtc = 16617,
  WEBGL_compressed_texture_s3tc = 16648,
  WEBGL_compressed_texture_s3tc_srgb = 16678,
  WEBGL_debug_renderer_info = 16713,
  WEBGL_debug_shaders = 16739,
  WEBGL_depth_texture = 16759,
  WEBGL_draw_buffers = 16779,
  WEBGL_explicit_present = 16798,
  WEBGL_lose_context = 16821,
  WEBGL_provoking_vertex = 16840,
  WGSLLanguageFeatures = 16863,
  WakeLock = 16884,
  WakeLockSentinel = 16893,
  WaveShaperNode = 16910,
  WebExtensionContentScript = 16925,
  WebExtensionPolicy = 16951,
  WebGL2RenderingContext = 16970,
  WebGLActiveInfo = 16993,
  WebGLBuffer = 17009,
  WebGLContextEvent = 17021,
  WebGLFramebuffer = 17039,
  WebGLProgram = 17056,
  WebGLQuery = 17069,
  WebGLRenderbuffer = 17080,
  WebGLRenderingContext = 17098,
  WebGLSampler = 17120,
  WebGLShader = 17133,
  WebGLShaderPrecisionFormat = 17145,
  WebGLSync = 17172,
  WebGLTexture = 17182,
  WebGLTransformFeedback = 17195,
  WebGLUniformLocation = 17218,
  WebGLVertexArrayObject = 17239,
  WebKitCSSMatrix = 17262,
  WebSocket = 17278,
  WebTransport = 17288,
  WebTransportBidirectionalStream = 17301,
  WebTransportDatagramDuplexStream = 17333,
  WebTransportError = 17366,
  WebTransportReceiveStream = 17384,
  WebTransportSendStream = 17410,
  WebrtcGlobalInformation = 17433,
  WheelEvent = 17457,
  Window = 17468,
  WindowClient = 17475,
  WindowContext = 17488,
  WindowGlobalChild = 17502,
  WindowGlobalParent = 17520,
  WindowRoot = 17539,
  Worker = 17550,
  WorkerDebuggerGlobalScope = 17557,
  WorkerGlobalScope = 17583,
  WorkerLocation = 17601,
  WorkerNavigator = 17616,
  WorkerTestUtils = 17632,
  Worklet = 17648,
  WorkletGlobalScope = 17656,
  WritableStream = 17675,
  WritableStreamDefaultController = 17690,
  WritableStreamDefaultWriter = 17722,
  XMLDocument = 17750,
  XMLHttpRequest = 17762,
  XMLHttpRequestEventTarget = 17777,
  XMLHttpRequestUpload = 17803,
  XMLSerializer = 17824,
  XPathEvaluator = 17838,
  XPathExpression = 17853,
  XPathResult = 17869,
  XRBoundedReferenceSpace = 17881,
  XRFrame = 17905,
  XRInputSource = 17913,
  XRInputSourceArray = 17927,
  XRInputSourceEvent = 17946,
  XRInputSourcesChangeEvent = 17965,
  XRPose = 17991,
  XRReferenceSpace = 17998,
  XRReferenceSpaceEvent = 18015,
  XRRenderState = 18037,
  XRRigidTransform = 18051,
  XRSession = 18068,
  XRSessionEvent = 18078,
  XRSpace = 18093,
  XRSystem = 18101,
  XRView = 18110,
  XRViewerPose = 18117,
  XRViewport = 18130,
  XRWebGLLayer = 18141,
  XSLTProcessor = 18154,
  XULCommandEvent = 18168,
  XULElement = 18184,
  XULFrameElement = 18195,
  XULMenuElement = 18211,
  XULPopupElement = 18226,
  XULResizerElement = 18242,
  XULTextElement = 18260,
  XULTreeElement = 18275,
  console = 18290,
  webkitSpeechGrammar = 18298,
  webkitSpeechGrammarList = 18318,
  webkitSpeechRecognition = 18342,
  webkitURL = 18366,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
