// Generated from libavcodec/vulkan/ffv1_common.comp
const char *ff_source_ffv1_common_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"struct SliceContext {\n"
"    RangeCoder c;\n"
"\n"
"#if !defined(DECODE)\n"
"    PutBitContext pb; /* 8*8 bytes */\n"
"#else\n"
"    GetBitContext gb;\n"
"#endif\n"
"\n"
"    ivec2 slice_dim;\n"
"    ivec2 slice_pos;\n"
"    ivec2 slice_rct_coef;\n"
"    u8vec3 quant_table_idx;\n"
"\n"
"    uint hdr_len; // only used for golomb\n"
"\n"
"    uint slice_coding_mode;\n"
"    bool slice_reset_contexts;\n"
"};\n"
"\n"
"/* -1, { -1, 0 } */\n"
"int predict(int L, ivec2 top)\n"
"{\n"
"    return mid_pred(L, L + top[1] - top[0], top[1]);\n"
"}\n"
"\n"
"/* { -2, -1 }, { -1, 0, 1 }, 0 */\n"
"int get_context(VTYPE2 cur_l, VTYPE3 top_l, TYPE top2, uint8_t quant_table_idx)\n"
"{\n"
"    const int LT = top_l[0]; /* -1 */\n"
"    const int T  = top_l[1]; /*  0 */\n"
"    const int RT = top_l[2]; /*  1 */\n"
"    const int L  = cur_l[1]; /* -1 */\n"
"\n"
"    int base = quant_table[quant_table_idx][0][(L - LT) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][1][(LT - T) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][2][(T - RT) & MAX_QUANT_TABLE_MASK];\n"
"\n"
"    if ((quant_table[quant_table_idx][3][127] == 0) &&\n"
"        (quant_table[quant_table_idx][4][127] == 0))\n"
"        return base;\n"
"\n"
"    const int TT = top2;     /* -2 */\n"
"    const int LL = cur_l[0]; /* -2 */\n"
"    return base +\n"
"           quant_table[quant_table_idx][3][(LL - L) & MAX_QUANT_TABLE_MASK] +\n"
"           quant_table[quant_table_idx][4][(TT - T) & MAX_QUANT_TABLE_MASK];\n"
"}\n"
"\n"
"const uint32_t log2_run[41] = {\n"
"     0,  0,  0,  0,  1,  1,  1,  1,\n"
"     2,  2,  2,  2,  3,  3,  3,  3,\n"
"     4,  4,  5,  5,  6,  6,  7,  7,\n"
"     8,  9, 10, 11, 12, 13, 14, 15,\n"
"    16, 17, 18, 19, 20, 21, 22, 23,\n"
"    24,\n"
"};\n"
"\n"
"uint slice_coord(uint width, uint sx, uint num_h_slices, uint chroma_shift)\n"
"{\n"
"    uint mpw = 1 << chroma_shift;\n"
"    uint awidth = align(width, mpw);\n"
"\n"
"    if ((version < 4) || ((version == 4) && (micro_version < 3)))\n"
"        return width * sx / num_h_slices;\n"
"\n"
"    sx = (2 * awidth * sx + num_h_slices * mpw) / (2 * num_h_slices * mpw) * mpw;\n"
"    if (sx == awidth)\n"
"        sx = width;\n"
"\n"
"    return sx;\n"
"}\n"
"\n"
"#ifdef RGB\n"
"#define RGB_LBUF (RGB_LINECACHE - 1)\n"
"#define LADDR(p) (ivec2((p).x, ((p).y & RGB_LBUF)))\n"
"\n"
"ivec2 get_pred(readonly uimage2D pred, ivec2 sp, ivec2 off,\n"
"               int comp, int sw, uint8_t quant_table_idx, bool extend_lookup)\n"
"{\n"
"    const ivec2 yoff_border1 = expectEXT(off.x == 0, false) ? off + ivec2(1, -1) : off;\n"
"\n"
"    /* Thanks to the same coincidence as below, we can skip checking if off == 0, 1 */\n"
"    VTYPE3 top  = VTYPE3(TYPE(imageLoad(pred, sp + LADDR(yoff_border1 + ivec2(-1, -1)))[comp]),\n"
"                         TYPE(imageLoad(pred, sp + LADDR(off + ivec2(0, -1)))[comp]),\n"
"                         TYPE(imageLoad(pred, sp + LADDR(off + ivec2(min(1, sw - off.x - 1), -1)))[comp]));\n"
"\n"
"    /* Normally, we'd need to check if off != ivec2(0, 0) here, since otherwise, we must\n"
"     * return zero. However, ivec2(-1,  0) + ivec2(1, -1) == ivec2(0, -1), e.g. previous\n"
"     * row, 0 offset, same slice, which is zero since we zero out the buffer for RGB */\n"
"    TYPE cur = TYPE(imageLoad(pred, sp + LADDR(yoff_border1 + ivec2(-1,  0)))[comp]);\n"
"\n"
"    int base = quant_table[quant_table_idx][0][(cur    - top[0]) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][1][(top[0] - top[1]) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][2][(top[1] - top[2]) & MAX_QUANT_TABLE_MASK];\n"
"\n"
"    if (expectEXT(extend_lookup, false)) {\n"
"        TYPE cur2 = TYPE(0);\n"
"        if (expectEXT(off.x > 0, true)) {\n"
"            const ivec2 yoff_border2 = expectEXT(off.x == 1, false) ? ivec2(-1, -1) : ivec2(-2, 0);\n"
"            cur2 = TYPE(imageLoad(pred, sp + LADDR(off + yoff_border2))[comp]);\n"
"        }\n"
"        base += quant_table[quant_table_idx][3][(cur2 - cur) & MAX_QUANT_TABLE_MASK];\n"
"\n"
"        /* top-2 became current upon swap */\n"
"        TYPE top2 = TYPE(imageLoad(pred, sp + LADDR(off))[comp]);\n"
"        base += quant_table[quant_table_idx][4][(top2 - top[1]) & MAX_QUANT_TABLE_MASK];\n"
"    }\n"
"\n"
"    /* context, prediction */\n"
"    return ivec2(base, predict(cur, VTYPE2(top)));\n"
"}\n"
"\n"
"#else /* RGB */\n"
"\n"
"#define LADDR(p) (p)\n"
"\n"
"ivec2 get_pred(readonly uimage2D pred, ivec2 sp, ivec2 off,\n"
"               int comp, int sw, uint8_t quant_table_idx, bool extend_lookup)\n"
"{\n"
"    const ivec2 yoff_border1 = off.x == 0 ? ivec2(1, -1) : ivec2(0, 0);\n"
"    sp += off;\n"
"\n"
"    VTYPE3 top  = VTYPE3(TYPE(0),\n"
"                         TYPE(0),\n"
"                         TYPE(0));\n"
"    if (off.y > 0 && off != ivec2(0, 1))\n"
"        top[0] = TYPE(imageLoad(pred, sp + ivec2(-1, -1) + yoff_border1)[comp]);\n"
"    if (off.y > 0) {\n"
"        top[1] = TYPE(imageLoad(pred, sp + ivec2(0, -1))[comp]);\n"
"        top[2] = TYPE(imageLoad(pred, sp + ivec2(min(1, sw - off.x - 1), -1))[comp]);\n"
"    }\n"
"\n"
"    TYPE cur = TYPE(0);\n"
"    if (off != ivec2(0, 0))\n"
"        cur = TYPE(imageLoad(pred, sp + ivec2(-1,  0) + yoff_border1)[comp]);\n"
"\n"
"    int base = quant_table[quant_table_idx][0][(cur - top[0]) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][1][(top[0] - top[1]) & MAX_QUANT_TABLE_MASK] +\n"
"               quant_table[quant_table_idx][2][(top[1] - top[2]) & MAX_QUANT_TABLE_MASK];\n"
"\n"
"    if (expectEXT(extend_lookup, false)) {\n"
"        TYPE cur2 = TYPE(0);\n"
"        if (off.x > 0 && off != ivec2(1, 0)) {\n"
"            const ivec2 yoff_border2 = off.x == 1 ? ivec2(1, -1) : ivec2(0, 0);\n"
"            cur2 = TYPE(imageLoad(pred, sp + ivec2(-2,  0) + yoff_border2)[comp]);\n"
"        }\n"
"        base += quant_table[quant_table_idx][3][(cur2 - cur) & MAX_QUANT_TABLE_MASK];\n"
"\n"
"        TYPE top2 = TYPE(0);\n"
"        if (off.y > 1)\n"
"            top2 = TYPE(imageLoad(pred, sp + ivec2(0, -2))[comp]);\n"
"        base += quant_table[quant_table_idx][4][(top2 - top[1]) & MAX_QUANT_TABLE_MASK];\n"
"    }\n"
"\n"
"    /* context, prediction */\n"
"    return ivec2(base, predict(cur, VTYPE2(top)));\n"
"}\n"
"#endif\n"
;
