#ifndef WRITEODFTEXT_H
#define WRITEODFTEXT_H
#include "writeodf.h"
namespace writeodf {
class text_alphabetical_index_auto_mark_file : public OdfWriter {
public:
    text_alphabetical_index_auto_mark_file(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "text:alphabetical-index-auto-mark-file", false) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    text_alphabetical_index_auto_mark_file(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "text:alphabetical-index-auto-mark-file", false) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_author_initials : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_author_initials(OdfWriter* x) :OdfWriter(x, "text:author-initials", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_author_initials(KoXmlWriter* x) :OdfWriter(x, "text:author-initials", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bookmark_end : public OdfWriter {
public:
    text_bookmark_end(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark-end", false) {
        addAttribute("text:name", text_name);
    }
    text_bookmark_end(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark-end", false) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_creator : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_creator(OdfWriter* x) :OdfWriter(x, "text:creator", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_creator(KoXmlWriter* x) :OdfWriter(x, "text:creator", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_editing_cycles : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_editing_cycles(OdfWriter* x) :OdfWriter(x, "text:editing-cycles", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_editing_cycles(KoXmlWriter* x) :OdfWriter(x, "text:editing-cycles", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_file_name : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_file_name(OdfWriter* x) :OdfWriter(x, "text:file-name", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_file_name(KoXmlWriter* x) :OdfWriter(x, "text:file-name", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_hidden_text : public OdfWriter {
public:
    text_hidden_text(OdfWriter* x, const QString& text_condition, const QString& text_string_value) :OdfWriter(x, "text:hidden-text", false) {
        addAttribute("text:condition", text_condition);
        addAttribute("text:string-value", text_string_value);
    }
    text_hidden_text(KoXmlWriter* x, const QString& text_condition, const QString& text_string_value) :OdfWriter(x, "text:hidden-text", false) {
        addAttribute("text:condition", text_condition);
        addAttribute("text:string-value", text_string_value);
    }
    template<class T>
    void set_text_is_hidden(const T& value) {
        addAttribute("text:is-hidden", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_bibliography : public OdfWriter {
public:
    text_index_entry_bibliography(OdfWriter* x, const QString& text_bibliography_data_field) :OdfWriter(x, "text:index-entry-bibliography", false) {
        addAttribute("text:bibliography-data-field", text_bibliography_data_field);
    }
    text_index_entry_bibliography(KoXmlWriter* x, const QString& text_bibliography_data_field) :OdfWriter(x, "text:index-entry-bibliography", false) {
        addAttribute("text:bibliography-data-field", text_bibliography_data_field);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_link_end : public OdfWriter {
public:
    text_index_entry_link_end(OdfWriter* x) :OdfWriter(x, "text:index-entry-link-end", false) {
    }
    text_index_entry_link_end(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-link-end", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_page_number : public OdfWriter {
public:
    text_index_entry_page_number(OdfWriter* x) :OdfWriter(x, "text:index-entry-page-number", false) {
    }
    text_index_entry_page_number(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-page-number", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_tab_stop : public OdfWriter {
public:
    text_index_entry_tab_stop(OdfWriter* x) :OdfWriter(x, "text:index-entry-tab-stop", false) {
    }
    text_index_entry_tab_stop(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-tab-stop", false) {
    }
    void set_style_leader_char(const QString& value) {
        addAttribute("style:leader-char", value);
    }
    void set_style_position(const QString& value) {
        addAttribute("style:position", value);
    }
    template<class T>
    void set_style_type(const T& value) {
        addAttribute("style:type", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_source_style : public OdfWriter {
public:
    text_index_source_style(OdfWriter* x, const QString& text_style_name) :OdfWriter(x, "text:index-source-style", false) {
        addAttribute("text:style-name", text_style_name);
    }
    text_index_source_style(KoXmlWriter* x, const QString& text_style_name) :OdfWriter(x, "text:index-source-style", false) {
        addAttribute("text:style-name", text_style_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_initial_creator : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_initial_creator(OdfWriter* x) :OdfWriter(x, "text:initial-creator", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_initial_creator(KoXmlWriter* x) :OdfWriter(x, "text:initial-creator", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_keywords : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_keywords(OdfWriter* x) :OdfWriter(x, "text:keywords", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_keywords(KoXmlWriter* x) :OdfWriter(x, "text:keywords", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_list_style : public OdfWriter {
public:
    text_list_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "text:list-style", true) {
        addAttribute("style:name", style_name);
    }
    text_list_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "text:list-style", true) {
        addAttribute("style:name", style_name);
    }
    text_list_level_style_bullet add_text_list_level_style_bullet(const QString& text_bullet_char, quint64 text_level);
    text_list_level_style_image add_text_list_level_style_image(quint64 text_level);
    text_list_level_style_number add_text_list_level_style_number(quint64 text_level);
    void set_style_display_name(const QString& value) {
        addAttribute("style:display-name", value);
    }
    template<class T>
    void set_text_consecutive_numbering(const T& value) {
        addAttribute("text:consecutive-numbering", value);
    }
};
class text_note : public OdfWriter, public group_text_note_class {
public:
    text_note(OdfWriter* x, const QString& text_note_class) :OdfWriter(x, "text:note", true), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    text_note(KoXmlWriter* x, const QString& text_note_class) :OdfWriter(x, "text:note", true), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    text_note_body add_text_note_body();
    text_note_citation add_text_note_citation();
    void set_text_id(const QString& value) {
        addAttribute("text:id", value);
    }
};
class text_note_citation : public OdfWriter {
public:
    text_note_citation(OdfWriter* x) :OdfWriter(x, "text:note-citation", false) {
    }
    text_note_citation(KoXmlWriter* x) :OdfWriter(x, "text:note-citation", false) {
    }
    void set_text_label(const QString& value) {
        addAttribute("text:label", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_note_continuation_notice_forward : public OdfWriter {
public:
    text_note_continuation_notice_forward(OdfWriter* x) :OdfWriter(x, "text:note-continuation-notice-forward", false) {
    }
    text_note_continuation_notice_forward(KoXmlWriter* x) :OdfWriter(x, "text:note-continuation-notice-forward", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_outline_style : public OdfWriter {
public:
    text_outline_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "text:outline-style", true) {
        addAttribute("style:name", style_name);
    }
    text_outline_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "text:outline-style", true) {
        addAttribute("style:name", style_name);
    }
    text_outline_level_style add_text_outline_level_style(quint64 text_level);
};
class text_page : public OdfWriter {
public:
    text_page(OdfWriter* x, const QString& text_master_page_name) :OdfWriter(x, "text:page", false) {
        addAttribute("text:master-page-name", text_master_page_name);
    }
    text_page(KoXmlWriter* x, const QString& text_master_page_name) :OdfWriter(x, "text:page", false) {
        addAttribute("text:master-page-name", text_master_page_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_page_sequence : public OdfWriter {
public:
    text_page_sequence(OdfWriter* x) :OdfWriter(x, "text:page-sequence", true) {
    }
    text_page_sequence(KoXmlWriter* x) :OdfWriter(x, "text:page-sequence", true) {
    }
    text_page add_text_page(const QString& text_master_page_name);
};
class text_page_variable_set : public OdfWriter {
public:
    text_page_variable_set(OdfWriter* x) :OdfWriter(x, "text:page-variable-set", false) {
    }
    text_page_variable_set(KoXmlWriter* x) :OdfWriter(x, "text:page-variable-set", false) {
    }
    template<class T>
    void set_text_active(const T& value) {
        addAttribute("text:active", value);
    }
    void set_text_page_adjust(qint64 value) {
        addAttribute("text:page-adjust", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_reference_mark : public OdfWriter {
public:
    text_reference_mark(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark", false) {
        addAttribute("text:name", text_name);
    }
    text_reference_mark(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark", false) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_reference_mark_start : public OdfWriter {
public:
    text_reference_mark_start(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark-start", false) {
        addAttribute("text:name", text_name);
    }
    text_reference_mark_start(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark-start", false) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_ruby : public OdfWriter {
public:
    text_ruby(OdfWriter* x) :OdfWriter(x, "text:ruby", true) {
    }
    text_ruby(KoXmlWriter* x) :OdfWriter(x, "text:ruby", true) {
    }
    text_ruby_base add_text_ruby_base();
    text_ruby_text add_text_ruby_text();
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_ruby_text : public OdfWriter {
public:
    text_ruby_text(OdfWriter* x) :OdfWriter(x, "text:ruby-text", false) {
    }
    text_ruby_text(KoXmlWriter* x) :OdfWriter(x, "text:ruby-text", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_script : public OdfWriter {
public:
    text_script(OdfWriter* x) :OdfWriter(x, "text:script", false) {
    }
    text_script(KoXmlWriter* x) :OdfWriter(x, "text:script", false) {
    }
    void set_script_language(const QString& value) {
        addAttribute("script:language", value);
    }
    void set_xlink_href(const QUrl& value) {
        addAttribute("xlink:href", value);
    }
    template<class T>
    void set_xlink_type(const T& value) {
        addAttribute("xlink:type", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_section_source : public OdfWriter {
public:
    text_section_source(OdfWriter* x) :OdfWriter(x, "text:section-source", false) {
    }
    text_section_source(KoXmlWriter* x) :OdfWriter(x, "text:section-source", false) {
    }
    void set_text_filter_name(const QString& value) {
        addAttribute("text:filter-name", value);
    }
    void set_text_section_name(const QString& value) {
        addAttribute("text:section-name", value);
    }
    void set_xlink_href(const QUrl& value) {
        addAttribute("xlink:href", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    template<class T>
    void set_xlink_type(const T& value) {
        addAttribute("xlink:type", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_company : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_company(OdfWriter* x) :OdfWriter(x, "text:sender-company", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_company(KoXmlWriter* x) :OdfWriter(x, "text:sender-company", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_email : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_email(OdfWriter* x) :OdfWriter(x, "text:sender-email", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_email(KoXmlWriter* x) :OdfWriter(x, "text:sender-email", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_firstname : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_firstname(OdfWriter* x) :OdfWriter(x, "text:sender-firstname", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_firstname(KoXmlWriter* x) :OdfWriter(x, "text:sender-firstname", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_lastname : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_lastname(OdfWriter* x) :OdfWriter(x, "text:sender-lastname", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_lastname(KoXmlWriter* x) :OdfWriter(x, "text:sender-lastname", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_phone_work : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_phone_work(OdfWriter* x) :OdfWriter(x, "text:sender-phone-work", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_phone_work(KoXmlWriter* x) :OdfWriter(x, "text:sender-phone-work", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_postal_code : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_postal_code(OdfWriter* x) :OdfWriter(x, "text:sender-postal-code", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_postal_code(KoXmlWriter* x) :OdfWriter(x, "text:sender-postal-code", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_street : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_street(OdfWriter* x) :OdfWriter(x, "text:sender-street", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_street(KoXmlWriter* x) :OdfWriter(x, "text:sender-street", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sequence_decls : public OdfWriter {
public:
    text_sequence_decls(OdfWriter* x) :OdfWriter(x, "text:sequence-decls", true) {
    }
    text_sequence_decls(KoXmlWriter* x) :OdfWriter(x, "text:sequence-decls", true) {
    }
    text_sequence_decl add_text_sequence_decl(quint64 text_display_outline_level, const QString& text_name);
};
class text_sheet_name : public OdfWriter {
public:
    text_sheet_name(OdfWriter* x) :OdfWriter(x, "text:sheet-name", false) {
    }
    text_sheet_name(KoXmlWriter* x) :OdfWriter(x, "text:sheet-name", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sort_key : public OdfWriter {
public:
    text_sort_key(OdfWriter* x, const QString& text_key) :OdfWriter(x, "text:sort-key", false) {
        addAttribute("text:key", text_key);
    }
    text_sort_key(KoXmlWriter* x, const QString& text_key) :OdfWriter(x, "text:sort-key", false) {
        addAttribute("text:key", text_key);
    }
    template<class T>
    void set_text_sort_ascending(const T& value) {
        addAttribute("text:sort-ascending", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_subject : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_subject(OdfWriter* x) :OdfWriter(x, "text:subject", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_subject(KoXmlWriter* x) :OdfWriter(x, "text:subject", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_template_name : public OdfWriter {
public:
    text_template_name(OdfWriter* x) :OdfWriter(x, "text:template-name", false) {
    }
    text_template_name(KoXmlWriter* x) :OdfWriter(x, "text:template-name", false) {
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_toc_mark : public OdfWriter, public group_text_outline_level {
public:
    text_toc_mark(OdfWriter* x, const QString& text_string_value) :OdfWriter(x, "text:toc-mark", false), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    text_toc_mark(KoXmlWriter* x, const QString& text_string_value) :OdfWriter(x, "text:toc-mark", false), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_field_decls : public OdfWriter {
public:
    text_user_field_decls(OdfWriter* x) :OdfWriter(x, "text:user-field-decls", true) {
    }
    text_user_field_decls(KoXmlWriter* x) :OdfWriter(x, "text:user-field-decls", true) {
    }
    text_user_field_decl add_text_user_field_decl(const QString& text_name);
};
class text_variable_decls : public OdfWriter {
public:
    text_variable_decls(OdfWriter* x) :OdfWriter(x, "text:variable-decls", true) {
    }
    text_variable_decls(KoXmlWriter* x) :OdfWriter(x, "text:variable-decls", true) {
    }
    text_variable_decl add_text_variable_decl(const QString& office_value_type, const QString& text_name);
};
class text_alphabetical_index_mark_end : public OdfWriter, public group_text_id {
public:
    text_alphabetical_index_mark_end(OdfWriter* x, const QString& text_id) :OdfWriter(x, "text:alphabetical-index-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    text_alphabetical_index_mark_end(KoXmlWriter* x, const QString& text_id) :OdfWriter(x, "text:alphabetical-index-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_alphabetical_index_source : public OdfWriter, public group_text_index_scope_attr, public group_text_index_title_template, public group_text_relative_tab_stop_position_attr {
public:
    text_alphabetical_index_source(OdfWriter* x) :OdfWriter(x, "text:alphabetical-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
    }
    text_alphabetical_index_source(KoXmlWriter* x) :OdfWriter(x, "text:alphabetical-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
    }
    text_alphabetical_index_entry_template add_text_alphabetical_index_entry_template(const QString& text_outline_level, const QString& text_style_name);
    void set_fo_country(const QString& value) {
        addAttribute("fo:country", value);
    }
    void set_fo_language(const QString& value) {
        addAttribute("fo:language", value);
    }
    void set_fo_script(const QString& value) {
        addAttribute("fo:script", value);
    }
    void set_style_rfc_language_tag(const QString& value) {
        addAttribute("style:rfc-language-tag", value);
    }
    template<class T>
    void set_text_alphabetical_separators(const T& value) {
        addAttribute("text:alphabetical-separators", value);
    }
    template<class T>
    void set_text_capitalize_entries(const T& value) {
        addAttribute("text:capitalize-entries", value);
    }
    template<class T>
    void set_text_combine_entries(const T& value) {
        addAttribute("text:combine-entries", value);
    }
    template<class T>
    void set_text_combine_entries_with_dash(const T& value) {
        addAttribute("text:combine-entries-with-dash", value);
    }
    template<class T>
    void set_text_combine_entries_with_pp(const T& value) {
        addAttribute("text:combine-entries-with-pp", value);
    }
    template<class T>
    void set_text_comma_separated(const T& value) {
        addAttribute("text:comma-separated", value);
    }
    template<class T>
    void set_text_ignore_case(const T& value) {
        addAttribute("text:ignore-case", value);
    }
    void set_text_main_entry_style_name(const QString& value) {
        addAttribute("text:main-entry-style-name", value);
    }
    void set_text_sort_algorithm(const QString& value) {
        addAttribute("text:sort-algorithm", value);
    }
    template<class T>
    void set_text_use_keys_as_entries(const T& value) {
        addAttribute("text:use-keys-as-entries", value);
    }
};
class text_bibliography_source : public OdfWriter, public group_text_index_title_template {
public:
    text_bibliography_source(OdfWriter* x) :OdfWriter(x, "text:bibliography-source", true), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_bibliography_source(KoXmlWriter* x) :OdfWriter(x, "text:bibliography-source", true), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_bibliography_entry_template add_text_bibliography_entry_template(const QString& text_bibliography_type, const QString& text_style_name);
};
class text_chapter : public OdfWriter {
public:
    text_chapter(OdfWriter* x, const QString& text_display, quint64 text_outline_level) :OdfWriter(x, "text:chapter", false) {
        addAttribute("text:display", text_display);
        addAttribute("text:outline-level", text_outline_level);
    }
    text_chapter(KoXmlWriter* x, const QString& text_display, quint64 text_outline_level) :OdfWriter(x, "text:chapter", false) {
        addAttribute("text:display", text_display);
        addAttribute("text:outline-level", text_outline_level);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_conditional_text : public OdfWriter {
public:
    text_conditional_text(OdfWriter* x, const QString& text_condition, const QString& text_string_value_if_false, const QString& text_string_value_if_true) :OdfWriter(x, "text:conditional-text", false) {
        addAttribute("text:condition", text_condition);
        addAttribute("text:string-value-if-false", text_string_value_if_false);
        addAttribute("text:string-value-if-true", text_string_value_if_true);
    }
    text_conditional_text(KoXmlWriter* x, const QString& text_condition, const QString& text_string_value_if_false, const QString& text_string_value_if_true) :OdfWriter(x, "text:conditional-text", false) {
        addAttribute("text:condition", text_condition);
        addAttribute("text:string-value-if-false", text_string_value_if_false);
        addAttribute("text:string-value-if-true", text_string_value_if_true);
    }
    template<class T>
    void set_text_current_value(const T& value) {
        addAttribute("text:current-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_illustration_index_source : public OdfWriter, public group_text_illustration_index_source_attrs, public group_text_index_title_template {
public:
    text_illustration_index_source(OdfWriter* x) :OdfWriter(x, "text:illustration-index-source", true), group_text_illustration_index_source_attrs(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_illustration_index_source(KoXmlWriter* x) :OdfWriter(x, "text:illustration-index-source", true), group_text_illustration_index_source_attrs(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_illustration_index_entry_template add_text_illustration_index_entry_template(const QString& text_style_name);
};
class text_index_entry_link_start : public OdfWriter {
public:
    text_index_entry_link_start(OdfWriter* x) :OdfWriter(x, "text:index-entry-link-start", false) {
    }
    text_index_entry_link_start(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-link-start", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_text : public OdfWriter {
public:
    text_index_entry_text(OdfWriter* x) :OdfWriter(x, "text:index-entry-text", false) {
    }
    text_index_entry_text(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-text", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_linenumbering_configuration : public OdfWriter, public group_common_num_format_attlist {
public:
    text_linenumbering_configuration(OdfWriter* x) :OdfWriter(x, "text:linenumbering-configuration", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_linenumbering_configuration(KoXmlWriter* x) :OdfWriter(x, "text:linenumbering-configuration", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_linenumbering_separator add_text_linenumbering_separator();
    template<class T>
    void set_text_count_empty_lines(const T& value) {
        addAttribute("text:count-empty-lines", value);
    }
    template<class T>
    void set_text_count_in_text_boxes(const T& value) {
        addAttribute("text:count-in-text-boxes", value);
    }
    void set_text_increment(quint64 value) {
        addAttribute("text:increment", value);
    }
    template<class T>
    void set_text_number_lines(const T& value) {
        addAttribute("text:number-lines", value);
    }
    template<class T>
    void set_text_number_position(const T& value) {
        addAttribute("text:number-position", value);
    }
    void set_text_offset(const QString& value) {
        addAttribute("text:offset", value);
    }
    template<class T>
    void set_text_restart_on_page(const T& value) {
        addAttribute("text:restart-on-page", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_list_level_style_image : public OdfWriter, public group_common_draw_data_attlist, public group_office_binary_data, public group_style_list_level_properties, public group_text_list_level_style_attr {
public:
    text_list_level_style_image(OdfWriter* x, quint64 text_level) :OdfWriter(x, "text:list-level-style-image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
    }
    text_list_level_style_image(KoXmlWriter* x, quint64 text_level) :OdfWriter(x, "text:list-level-style-image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
    }
};
class text_measure : public OdfWriter {
public:
    text_measure(OdfWriter* x, const QString& text_kind) :OdfWriter(x, "text:measure", false) {
        addAttribute("text:kind", text_kind);
    }
    text_measure(KoXmlWriter* x, const QString& text_kind) :OdfWriter(x, "text:measure", false) {
        addAttribute("text:kind", text_kind);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_note_continuation_notice_backward : public OdfWriter {
public:
    text_note_continuation_notice_backward(OdfWriter* x) :OdfWriter(x, "text:note-continuation-notice-backward", false) {
    }
    text_note_continuation_notice_backward(KoXmlWriter* x) :OdfWriter(x, "text:note-continuation-notice-backward", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_notes_configuration : public OdfWriter, public group_common_num_format_attlist, public group_common_num_format_prefix_suffix_attlist, public group_text_note_class {
public:
    text_notes_configuration(OdfWriter* x, const QString& text_note_class) :OdfWriter(x, "text:notes-configuration", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    text_notes_configuration(KoXmlWriter* x, const QString& text_note_class) :OdfWriter(x, "text:notes-configuration", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    text_note_continuation_notice_backward add_text_note_continuation_notice_backward();
    text_note_continuation_notice_forward add_text_note_continuation_notice_forward();
    void set_text_citation_body_style_name(const QString& value) {
        addAttribute("text:citation-body-style-name", value);
    }
    void set_text_citation_style_name(const QString& value) {
        addAttribute("text:citation-style-name", value);
    }
    void set_text_default_style_name(const QString& value) {
        addAttribute("text:default-style-name", value);
    }
    template<class T>
    void set_text_footnotes_position(const T& value) {
        addAttribute("text:footnotes-position", value);
    }
    void set_text_master_page_name(const QString& value) {
        addAttribute("text:master-page-name", value);
    }
    template<class T>
    void set_text_start_numbering_at(const T& value) {
        addAttribute("text:start-numbering-at", value);
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
};
class text_object_index_source : public OdfWriter, public group_text_index_scope_attr, public group_text_index_title_template, public group_text_relative_tab_stop_position_attr {
public:
    text_object_index_source(OdfWriter* x) :OdfWriter(x, "text:object-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
    }
    text_object_index_source(KoXmlWriter* x) :OdfWriter(x, "text:object-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
    }
    text_object_index_entry_template add_text_object_index_entry_template(const QString& text_style_name);
    template<class T>
    void set_text_use_chart_objects(const T& value) {
        addAttribute("text:use-chart-objects", value);
    }
    template<class T>
    void set_text_use_draw_objects(const T& value) {
        addAttribute("text:use-draw-objects", value);
    }
    template<class T>
    void set_text_use_math_objects(const T& value) {
        addAttribute("text:use-math-objects", value);
    }
    template<class T>
    void set_text_use_other_objects(const T& value) {
        addAttribute("text:use-other-objects", value);
    }
    template<class T>
    void set_text_use_spreadsheet_objects(const T& value) {
        addAttribute("text:use-spreadsheet-objects", value);
    }
};
class text_reference_mark_end : public OdfWriter {
public:
    text_reference_mark_end(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark-end", false) {
        addAttribute("text:name", text_name);
    }
    text_reference_mark_end(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:reference-mark-end", false) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_country : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_country(OdfWriter* x) :OdfWriter(x, "text:sender-country", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_country(KoXmlWriter* x) :OdfWriter(x, "text:sender-country", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_initials : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_initials(OdfWriter* x) :OdfWriter(x, "text:sender-initials", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_initials(KoXmlWriter* x) :OdfWriter(x, "text:sender-initials", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_position : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_position(OdfWriter* x) :OdfWriter(x, "text:sender-position", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_position(KoXmlWriter* x) :OdfWriter(x, "text:sender-position", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_title : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_title(OdfWriter* x) :OdfWriter(x, "text:sender-title", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_title(KoXmlWriter* x) :OdfWriter(x, "text:sender-title", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sequence_decl : public OdfWriter, public group_common_field_name_attlist {
public:
    text_sequence_decl(OdfWriter* x, quint64 text_display_outline_level, const QString& text_name) :OdfWriter(x, "text:sequence-decl", false), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
        addAttribute("text:display-outline-level", text_display_outline_level);
    }
    text_sequence_decl(KoXmlWriter* x, quint64 text_display_outline_level, const QString& text_name) :OdfWriter(x, "text:sequence-decl", false), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
        addAttribute("text:display-outline-level", text_display_outline_level);
    }
    void set_text_separation_character(const QString& value) {
        addAttribute("text:separation-character", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_soft_page_break : public OdfWriter {
public:
    text_soft_page_break(OdfWriter* x) :OdfWriter(x, "text:soft-page-break", false) {
    }
    text_soft_page_break(KoXmlWriter* x) :OdfWriter(x, "text:soft-page-break", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_tab : public OdfWriter {
public:
    text_tab(OdfWriter* x) :OdfWriter(x, "text:tab", false) {
    }
    text_tab(KoXmlWriter* x) :OdfWriter(x, "text:tab", false) {
    }
    void set_text_tab_ref(quint64 value) {
        addAttribute("text:tab-ref", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_toc_mark_end : public OdfWriter, public group_text_id {
public:
    text_toc_mark_end(OdfWriter* x, const QString& text_id) :OdfWriter(x, "text:toc-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    text_toc_mark_end(KoXmlWriter* x, const QString& text_id) :OdfWriter(x, "text:toc-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_tracked_changes : public OdfWriter {
public:
    text_tracked_changes(OdfWriter* x) :OdfWriter(x, "text:tracked-changes", true) {
    }
    text_tracked_changes(KoXmlWriter* x) :OdfWriter(x, "text:tracked-changes", true) {
    }
    text_changed_region add_text_changed_region(const QString& xml_id);
    template<class T>
    void set_text_track_changes(const T& value) {
        addAttribute("text:track-changes", value);
    }
};
class text_user_index_mark_end : public OdfWriter, public group_text_id {
public:
    text_user_index_mark_end(OdfWriter* x, const QString& text_id) :OdfWriter(x, "text:user-index-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    text_user_index_mark_end(KoXmlWriter* x, const QString& text_id) :OdfWriter(x, "text:user-index-mark-end", false), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bookmark : public OdfWriter, public group_xml_id {
public:
    text_bookmark(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark", false), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    text_bookmark(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark", false), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bookmark_start : public OdfWriter, public group_common_in_content_meta_attlist, public group_xml_id {
public:
    text_bookmark_start(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark-start", false), group_common_in_content_meta_attlist(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    text_bookmark_start(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:bookmark-start", false), group_common_in_content_meta_attlist(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_change_end : public OdfWriter, public group_change_mark_attr {
public:
    text_change_end(OdfWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change-end", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    text_change_end(KoXmlWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change-end", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_changed_region : public OdfWriter, public group_xml_id {
public:
    text_changed_region(OdfWriter* x, const QString& xml_id) :OdfWriter(x, "text:changed-region", true), group_xml_id(*static_cast<OdfWriter*>(this), xml_id) {
    }
    text_changed_region(KoXmlWriter* x, const QString& xml_id) :OdfWriter(x, "text:changed-region", true), group_xml_id(*static_cast<OdfWriter*>(this), xml_id) {
    }
    text_deletion add_text_deletion();
    text_format_change add_text_format_change();
    text_insertion add_text_insertion();
    void set_text_id(const QString& value) {
        addAttribute("text:id", value);
    }
};
class text_dde_connection : public OdfWriter {
public:
    text_dde_connection(OdfWriter* x, const QString& text_connection_name) :OdfWriter(x, "text:dde-connection", false) {
        addAttribute("text:connection-name", text_connection_name);
    }
    text_dde_connection(KoXmlWriter* x, const QString& text_connection_name) :OdfWriter(x, "text:dde-connection", false) {
        addAttribute("text:connection-name", text_connection_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_dde_connection_decls : public OdfWriter {
public:
    text_dde_connection_decls(OdfWriter* x) :OdfWriter(x, "text:dde-connection-decls", true) {
    }
    text_dde_connection_decls(KoXmlWriter* x) :OdfWriter(x, "text:dde-connection-decls", true) {
    }
    text_dde_connection_decl add_text_dde_connection_decl(const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic, const QString& office_name);
};
class text_description : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_description(OdfWriter* x) :OdfWriter(x, "text:description", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_description(KoXmlWriter* x) :OdfWriter(x, "text:description", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_execute_macro : public OdfWriter, public group_office_event_listeners {
public:
    text_execute_macro(OdfWriter* x) :OdfWriter(x, "text:execute-macro", false), group_office_event_listeners(*static_cast<OdfWriter*>(this)) {
    }
    text_execute_macro(KoXmlWriter* x) :OdfWriter(x, "text:execute-macro", false), group_office_event_listeners(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_name(const QString& value) {
        addAttribute("text:name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_hidden_paragraph : public OdfWriter {
public:
    text_hidden_paragraph(OdfWriter* x, const QString& text_condition) :OdfWriter(x, "text:hidden-paragraph", false) {
        addAttribute("text:condition", text_condition);
    }
    text_hidden_paragraph(KoXmlWriter* x, const QString& text_condition) :OdfWriter(x, "text:hidden-paragraph", false) {
        addAttribute("text:condition", text_condition);
    }
    template<class T>
    void set_text_is_hidden(const T& value) {
        addAttribute("text:is-hidden", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_span : public OdfWriter {
public:
    text_index_entry_span(OdfWriter* x) :OdfWriter(x, "text:index-entry-span", false) {
    }
    text_index_entry_span(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-span", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_linenumbering_separator : public OdfWriter {
public:
    text_linenumbering_separator(OdfWriter* x) :OdfWriter(x, "text:linenumbering-separator", false) {
    }
    text_linenumbering_separator(KoXmlWriter* x) :OdfWriter(x, "text:linenumbering-separator", false) {
    }
    void set_text_increment(quint64 value) {
        addAttribute("text:increment", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_list_level_style_bullet : public OdfWriter, public group_common_num_format_prefix_suffix_attlist, public group_style_list_level_properties, public group_style_text_properties, public group_text_list_level_style_attr {
public:
    text_list_level_style_bullet(OdfWriter* x, const QString& text_bullet_char, quint64 text_level) :OdfWriter(x, "text:list-level-style-bullet", true), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
        addAttribute("text:bullet-char", text_bullet_char);
    }
    text_list_level_style_bullet(KoXmlWriter* x, const QString& text_bullet_char, quint64 text_level) :OdfWriter(x, "text:list-level-style-bullet", true), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
        addAttribute("text:bullet-char", text_bullet_char);
    }
    void set_text_bullet_relative_size(const QString& value) {
        addAttribute("text:bullet-relative-size", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_reference_ref : public OdfWriter, public group_text_bookmark_ref_content, public group_text_common_ref_content {
public:
    text_reference_ref(OdfWriter* x) :OdfWriter(x, "text:reference-ref", false), group_text_bookmark_ref_content(*static_cast<OdfWriter*>(this)), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    text_reference_ref(KoXmlWriter* x) :OdfWriter(x, "text:reference-ref", false), group_text_bookmark_ref_content(*static_cast<OdfWriter*>(this)), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_s : public OdfWriter {
public:
    text_s(OdfWriter* x) :OdfWriter(x, "text:s", false) {
    }
    text_s(KoXmlWriter* x) :OdfWriter(x, "text:s", false) {
    }
    void set_text_c(quint64 value) {
        addAttribute("text:c", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_city : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_city(OdfWriter* x) :OdfWriter(x, "text:sender-city", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_city(KoXmlWriter* x) :OdfWriter(x, "text:sender-city", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_phone_private : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_phone_private(OdfWriter* x) :OdfWriter(x, "text:sender-phone-private", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_phone_private(KoXmlWriter* x) :OdfWriter(x, "text:sender-phone-private", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_of_content_source : public OdfWriter, public group_text_index_source_styles, public group_text_index_title_template {
public:
    text_table_of_content_source(OdfWriter* x) :OdfWriter(x, "text:table-of-content-source", true), group_text_index_source_styles(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_table_of_content_source(KoXmlWriter* x) :OdfWriter(x, "text:table-of-content-source", true), group_text_index_source_styles(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_table_of_content_entry_template add_text_table_of_content_entry_template(quint64 text_outline_level, const QString& text_style_name);
    template<class T>
    void set_text_index_scope(const T& value) {
        addAttribute("text:index-scope", value);
    }
    void set_text_outline_level(quint64 value) {
        addAttribute("text:outline-level", value);
    }
    template<class T>
    void set_text_relative_tab_stop_position(const T& value) {
        addAttribute("text:relative-tab-stop-position", value);
    }
    template<class T>
    void set_text_use_index_marks(const T& value) {
        addAttribute("text:use-index-marks", value);
    }
    template<class T>
    void set_text_use_index_source_styles(const T& value) {
        addAttribute("text:use-index-source-styles", value);
    }
    template<class T>
    void set_text_use_outline_level(const T& value) {
        addAttribute("text:use-outline-level", value);
    }
};
class text_toc_mark_start : public OdfWriter, public group_text_id, public group_text_outline_level {
public:
    text_toc_mark_start(OdfWriter* x, const QString& text_id) :OdfWriter(x, "text:toc-mark-start", false), group_text_id(*static_cast<OdfWriter*>(this), text_id), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
    }
    text_toc_mark_start(KoXmlWriter* x, const QString& text_id) :OdfWriter(x, "text:toc-mark-start", false), group_text_id(*static_cast<OdfWriter*>(this), text_id), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_index_mark_start : public OdfWriter, public group_text_id, public group_text_index_name, public group_text_outline_level {
public:
    text_user_index_mark_start(OdfWriter* x, const QString& text_id, const QString& text_index_name) :OdfWriter(x, "text:user-index-mark-start", false), group_text_id(*static_cast<OdfWriter*>(this), text_id), group_text_index_name(*static_cast<OdfWriter*>(this), text_index_name), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
    }
    text_user_index_mark_start(KoXmlWriter* x, const QString& text_id, const QString& text_index_name) :OdfWriter(x, "text:user-index-mark-start", false), group_text_id(*static_cast<OdfWriter*>(this), text_id), group_text_index_name(*static_cast<OdfWriter*>(this), text_index_name), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_variable_decl : public OdfWriter, public group_common_field_name_attlist, public group_common_value_type_attlist {
public:
    text_variable_decl(OdfWriter* x, const QString& office_value_type, const QString& text_name) :OdfWriter(x, "text:variable-decl", false), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_type_attlist(*static_cast<OdfWriter*>(this), office_value_type) {
    }
    text_variable_decl(KoXmlWriter* x, const QString& office_value_type, const QString& text_name) :OdfWriter(x, "text:variable-decl", false), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_type_attlist(*static_cast<OdfWriter*>(this), office_value_type) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_author_name : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_author_name(OdfWriter* x) :OdfWriter(x, "text:author-name", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_author_name(KoXmlWriter* x) :OdfWriter(x, "text:author-name", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bibliography_configuration : public OdfWriter {
public:
    text_bibliography_configuration(OdfWriter* x) :OdfWriter(x, "text:bibliography-configuration", true) {
    }
    text_bibliography_configuration(KoXmlWriter* x) :OdfWriter(x, "text:bibliography-configuration", true) {
    }
    text_sort_key add_text_sort_key(const QString& text_key);
    void set_fo_country(const QString& value) {
        addAttribute("fo:country", value);
    }
    void set_fo_language(const QString& value) {
        addAttribute("fo:language", value);
    }
    void set_fo_script(const QString& value) {
        addAttribute("fo:script", value);
    }
    void set_style_rfc_language_tag(const QString& value) {
        addAttribute("style:rfc-language-tag", value);
    }
    template<class T>
    void set_text_numbered_entries(const T& value) {
        addAttribute("text:numbered-entries", value);
    }
    void set_text_prefix(const QString& value) {
        addAttribute("text:prefix", value);
    }
    void set_text_sort_algorithm(const QString& value) {
        addAttribute("text:sort-algorithm", value);
    }
    template<class T>
    void set_text_sort_by_position(const T& value) {
        addAttribute("text:sort-by-position", value);
    }
    void set_text_suffix(const QString& value) {
        addAttribute("text:suffix", value);
    }
};
class text_bibliography_mark : public OdfWriter {
public:
    text_bibliography_mark(OdfWriter* x, const QString& text_bibliography_type) :OdfWriter(x, "text:bibliography-mark", false) {
        addAttribute("text:bibliography-type", text_bibliography_type);
    }
    text_bibliography_mark(KoXmlWriter* x, const QString& text_bibliography_type) :OdfWriter(x, "text:bibliography-mark", false) {
        addAttribute("text:bibliography-type", text_bibliography_type);
    }
    void set_text_address(const QString& value) {
        addAttribute("text:address", value);
    }
    void set_text_annote(const QString& value) {
        addAttribute("text:annote", value);
    }
    void set_text_author(const QString& value) {
        addAttribute("text:author", value);
    }
    void set_text_booktitle(const QString& value) {
        addAttribute("text:booktitle", value);
    }
    void set_text_chapter(const QString& value) {
        addAttribute("text:chapter", value);
    }
    void set_text_custom1(const QString& value) {
        addAttribute("text:custom1", value);
    }
    void set_text_custom2(const QString& value) {
        addAttribute("text:custom2", value);
    }
    void set_text_custom3(const QString& value) {
        addAttribute("text:custom3", value);
    }
    void set_text_custom4(const QString& value) {
        addAttribute("text:custom4", value);
    }
    void set_text_custom5(const QString& value) {
        addAttribute("text:custom5", value);
    }
    void set_text_edition(const QString& value) {
        addAttribute("text:edition", value);
    }
    void set_text_editor(const QString& value) {
        addAttribute("text:editor", value);
    }
    void set_text_howpublished(const QString& value) {
        addAttribute("text:howpublished", value);
    }
    void set_text_identifier(const QString& value) {
        addAttribute("text:identifier", value);
    }
    void set_text_institution(const QString& value) {
        addAttribute("text:institution", value);
    }
    void set_text_isbn(const QString& value) {
        addAttribute("text:isbn", value);
    }
    void set_text_issn(const QString& value) {
        addAttribute("text:issn", value);
    }
    void set_text_journal(const QString& value) {
        addAttribute("text:journal", value);
    }
    void set_text_month(const QString& value) {
        addAttribute("text:month", value);
    }
    void set_text_note(const QString& value) {
        addAttribute("text:note", value);
    }
    void set_text_number(const QString& value) {
        addAttribute("text:number", value);
    }
    void set_text_organizations(const QString& value) {
        addAttribute("text:organizations", value);
    }
    void set_text_pages(const QString& value) {
        addAttribute("text:pages", value);
    }
    void set_text_publisher(const QString& value) {
        addAttribute("text:publisher", value);
    }
    void set_text_report_type(const QString& value) {
        addAttribute("text:report-type", value);
    }
    void set_text_school(const QString& value) {
        addAttribute("text:school", value);
    }
    void set_text_series(const QString& value) {
        addAttribute("text:series", value);
    }
    void set_text_title(const QString& value) {
        addAttribute("text:title", value);
    }
    void set_text_url(const QString& value) {
        addAttribute("text:url", value);
    }
    void set_text_volume(const QString& value) {
        addAttribute("text:volume", value);
    }
    void set_text_year(const QString& value) {
        addAttribute("text:year", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_change : public OdfWriter, public group_change_mark_attr {
public:
    text_change(OdfWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    text_change(KoXmlWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_character_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_character_count(OdfWriter* x) :OdfWriter(x, "text:character-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_character_count(KoXmlWriter* x) :OdfWriter(x, "text:character-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_source_styles : public OdfWriter {
public:
    text_index_source_styles(OdfWriter* x, quint64 text_outline_level) :OdfWriter(x, "text:index-source-styles", true) {
        addAttribute("text:outline-level", text_outline_level);
    }
    text_index_source_styles(KoXmlWriter* x, quint64 text_outline_level) :OdfWriter(x, "text:index-source-styles", true) {
        addAttribute("text:outline-level", text_outline_level);
    }
    text_index_source_style add_text_index_source_style(const QString& text_style_name);
};
class text_index_title_template : public OdfWriter {
public:
    text_index_title_template(OdfWriter* x) :OdfWriter(x, "text:index-title-template", false) {
    }
    text_index_title_template(KoXmlWriter* x) :OdfWriter(x, "text:index-title-template", false) {
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_line_break : public OdfWriter {
public:
    text_line_break(OdfWriter* x) :OdfWriter(x, "text:line-break", false) {
    }
    text_line_break(KoXmlWriter* x) :OdfWriter(x, "text:line-break", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_list_level_style_number : public OdfWriter, public group_common_num_format_attlist, public group_common_num_format_prefix_suffix_attlist, public group_style_list_level_properties, public group_style_text_properties, public group_text_list_level_style_attr {
public:
    text_list_level_style_number(OdfWriter* x, quint64 text_level) :OdfWriter(x, "text:list-level-style-number", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
    }
    text_list_level_style_number(KoXmlWriter* x, quint64 text_level) :OdfWriter(x, "text:list-level-style-number", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)), group_text_list_level_style_attr(*static_cast<OdfWriter*>(this), text_level) {
    }
    void set_text_display_levels(quint64 value) {
        addAttribute("text:display-levels", value);
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_note_ref : public OdfWriter, public group_text_common_ref_content, public group_text_note_class {
public:
    text_note_ref(OdfWriter* x, const QString& text_note_class) :OdfWriter(x, "text:note-ref", false), group_text_common_ref_content(*static_cast<OdfWriter*>(this)), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    text_note_ref(KoXmlWriter* x, const QString& text_note_class) :OdfWriter(x, "text:note-ref", false), group_text_common_ref_content(*static_cast<OdfWriter*>(this)), group_text_note_class(*static_cast<OdfWriter*>(this), text_note_class) {
    }
    template<class T>
    void set_text_reference_format(const T& value) {
        addAttribute("text:reference-format", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_numbered_paragraph : public OdfWriter, public group_text_h, public group_text_number, public group_text_p, public group_xml_id {
public:
    text_numbered_paragraph(OdfWriter* x, const QString& text_list_id) :OdfWriter(x, "text:numbered-paragraph", true), group_text_h(*static_cast<OdfWriter*>(this)), group_text_number(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:list-id", text_list_id);
    }
    text_numbered_paragraph(KoXmlWriter* x, const QString& text_list_id) :OdfWriter(x, "text:numbered-paragraph", true), group_text_h(*static_cast<OdfWriter*>(this)), group_text_number(*static_cast<OdfWriter*>(this)), group_text_p(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:list-id", text_list_id);
    }
    template<class T>
    void set_text_continue_numbering(const T& value) {
        addAttribute("text:continue-numbering", value);
    }
    void set_text_level(quint64 value) {
        addAttribute("text:level", value);
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_outline_level_style : public OdfWriter, public group_common_num_format_attlist, public group_common_num_format_prefix_suffix_attlist, public group_style_list_level_properties, public group_style_text_properties {
public:
    text_outline_level_style(OdfWriter* x, quint64 text_level) :OdfWriter(x, "text:outline-level-style", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:level", text_level);
    }
    text_outline_level_style(KoXmlWriter* x, quint64 text_level) :OdfWriter(x, "text:outline-level-style", true), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_style_list_level_properties(*static_cast<OdfWriter*>(this)), group_style_text_properties(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:level", text_level);
    }
    void set_text_display_levels(quint64 value) {
        addAttribute("text:display-levels", value);
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_page_continuation : public OdfWriter {
public:
    text_page_continuation(OdfWriter* x, const QString& text_select_page) :OdfWriter(x, "text:page-continuation", false) {
        addAttribute("text:select-page", text_select_page);
    }
    text_page_continuation(KoXmlWriter* x, const QString& text_select_page) :OdfWriter(x, "text:page-continuation", false) {
        addAttribute("text:select-page", text_select_page);
    }
    void set_text_string_value(const QString& value) {
        addAttribute("text:string-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_page_number : public OdfWriter, public group_common_field_fixed_attlist, public group_common_field_num_format_attlist {
public:
    text_page_number(OdfWriter* x) :OdfWriter(x, "text:page-number", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_page_number(KoXmlWriter* x) :OdfWriter(x, "text:page-number", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_page_adjust(qint64 value) {
        addAttribute("text:page-adjust", value);
    }
    template<class T>
    void set_text_select_page(const T& value) {
        addAttribute("text:select-page", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_paragraph_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_paragraph_count(OdfWriter* x) :OdfWriter(x, "text:paragraph-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_paragraph_count(KoXmlWriter* x) :OdfWriter(x, "text:paragraph-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_printed_by : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_printed_by(OdfWriter* x) :OdfWriter(x, "text:printed-by", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_printed_by(KoXmlWriter* x) :OdfWriter(x, "text:printed-by", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_state_or_province : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_state_or_province(OdfWriter* x) :OdfWriter(x, "text:sender-state-or-province", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_state_or_province(KoXmlWriter* x) :OdfWriter(x, "text:sender-state-or-province", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sequence_ref : public OdfWriter, public group_text_common_ref_content {
public:
    text_sequence_ref(OdfWriter* x) :OdfWriter(x, "text:sequence-ref", false), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    text_sequence_ref(KoXmlWriter* x) :OdfWriter(x, "text:sequence-ref", false), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_text_reference_format(const T& value) {
        addAttribute("text:reference-format", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_table_count(OdfWriter* x) :OdfWriter(x, "text:table-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_table_count(KoXmlWriter* x) :OdfWriter(x, "text:table-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_index_source : public OdfWriter, public group_text_illustration_index_source_attrs, public group_text_index_title_template {
public:
    text_table_index_source(OdfWriter* x) :OdfWriter(x, "text:table-index-source", true), group_text_illustration_index_source_attrs(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_table_index_source(KoXmlWriter* x) :OdfWriter(x, "text:table-index-source", true), group_text_illustration_index_source_attrs(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)) {
    }
    text_table_index_entry_template add_text_table_index_entry_template(const QString& text_style_name);
};
class text_table_of_content_entry_template : public OdfWriter, public group_text_index_entry_chapter, public group_text_index_entry_page_number, public group_text_index_entry_span, public group_text_index_entry_tab_stop, public group_text_index_entry_text {
public:
    text_table_of_content_entry_template(OdfWriter* x, quint64 text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:table-of-content-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
    text_table_of_content_entry_template(KoXmlWriter* x, quint64 text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:table-of-content-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
    text_index_entry_link_end add_text_index_entry_link_end();
    text_index_entry_link_start add_text_index_entry_link_start();
};
class text_user_index_mark : public OdfWriter, public group_text_index_name, public group_text_outline_level {
public:
    text_user_index_mark(OdfWriter* x, const QString& text_index_name, const QString& text_string_value) :OdfWriter(x, "text:user-index-mark", false), group_text_index_name(*static_cast<OdfWriter*>(this), text_index_name), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    text_user_index_mark(KoXmlWriter* x, const QString& text_index_name, const QString& text_string_value) :OdfWriter(x, "text:user-index-mark", false), group_text_index_name(*static_cast<OdfWriter*>(this), text_index_name), group_text_outline_level(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_alphabetical_index_mark : public OdfWriter, public group_text_alphabetical_index_mark_attrs {
public:
    text_alphabetical_index_mark(OdfWriter* x, const QString& text_string_value) :OdfWriter(x, "text:alphabetical-index-mark", false), group_text_alphabetical_index_mark_attrs(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    text_alphabetical_index_mark(KoXmlWriter* x, const QString& text_string_value) :OdfWriter(x, "text:alphabetical-index-mark", false), group_text_alphabetical_index_mark_attrs(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:string-value", text_string_value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bookmark_ref : public OdfWriter, public group_text_bookmark_ref_content, public group_text_common_ref_content {
public:
    text_bookmark_ref(OdfWriter* x) :OdfWriter(x, "text:bookmark-ref", false), group_text_bookmark_ref_content(*static_cast<OdfWriter*>(this)), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    text_bookmark_ref(KoXmlWriter* x) :OdfWriter(x, "text:bookmark-ref", false), group_text_bookmark_ref_content(*static_cast<OdfWriter*>(this)), group_text_common_ref_content(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_creation_date : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_creation_date(OdfWriter* x) :OdfWriter(x, "text:creation-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_creation_date(KoXmlWriter* x) :OdfWriter(x, "text:creation-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_text_date_value(const T& value) {
        addAttribute("text:date-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_dde_connection_decl : public OdfWriter, public group_common_dde_connection_decl_attlist {
public:
    text_dde_connection_decl(OdfWriter* x, const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic, const QString& office_name) :OdfWriter(x, "text:dde-connection-decl", false), group_common_dde_connection_decl_attlist(*static_cast<OdfWriter*>(this), office_dde_application, office_dde_item, office_dde_topic) {
        addAttribute("office:name", office_name);
    }
    text_dde_connection_decl(KoXmlWriter* x, const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic, const QString& office_name) :OdfWriter(x, "text:dde-connection-decl", false), group_common_dde_connection_decl_attlist(*static_cast<OdfWriter*>(this), office_dde_application, office_dde_item, office_dde_topic) {
        addAttribute("office:name", office_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_editing_duration : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_editing_duration(OdfWriter* x) :OdfWriter(x, "text:editing-duration", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_editing_duration(KoXmlWriter* x) :OdfWriter(x, "text:editing-duration", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_duration(Duration value) {
        addAttribute("text:duration", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_image_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_image_count(OdfWriter* x) :OdfWriter(x, "text:image-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_image_count(KoXmlWriter* x) :OdfWriter(x, "text:image-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_entry_chapter : public OdfWriter {
public:
    text_index_entry_chapter(OdfWriter* x) :OdfWriter(x, "text:index-entry-chapter", false) {
    }
    text_index_entry_chapter(KoXmlWriter* x) :OdfWriter(x, "text:index-entry-chapter", false) {
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
    void set_text_outline_level(quint64 value) {
        addAttribute("text:outline-level", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_modification_date : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_modification_date(OdfWriter* x) :OdfWriter(x, "text:modification-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_modification_date(KoXmlWriter* x) :OdfWriter(x, "text:modification-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_date_value(const QDate& value) {
        addAttribute("text:date-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_object_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_object_count(OdfWriter* x) :OdfWriter(x, "text:object-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_object_count(KoXmlWriter* x) :OdfWriter(x, "text:object-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_object_index_entry_template : public OdfWriter, public group_text_illustration_index_entry_content {
public:
    text_object_index_entry_template(OdfWriter* x, const QString& text_style_name) :OdfWriter(x, "text:object-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
    text_object_index_entry_template(KoXmlWriter* x, const QString& text_style_name) :OdfWriter(x, "text:object-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
};
class text_page_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_page_count(OdfWriter* x) :OdfWriter(x, "text:page-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_page_count(KoXmlWriter* x) :OdfWriter(x, "text:page-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_placeholder : public OdfWriter, public group_common_field_description_attlist {
public:
    text_placeholder(OdfWriter* x, const QString& text_placeholder_type) :OdfWriter(x, "text:placeholder", false), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:placeholder-type", text_placeholder_type);
    }
    text_placeholder(KoXmlWriter* x, const QString& text_placeholder_type) :OdfWriter(x, "text:placeholder", false), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:placeholder-type", text_placeholder_type);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_print_time : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_print_time(OdfWriter* x) :OdfWriter(x, "text:print-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_print_time(KoXmlWriter* x) :OdfWriter(x, "text:print-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_time_value(const QTime& value) {
        addAttribute("text:time-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sequence : public OdfWriter, public group_common_field_formula_attlist, public group_common_field_name_attlist, public group_common_field_num_format_attlist {
public:
    text_sequence(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:sequence", false), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sequence(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:sequence", false), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_ref_name(const QString& value) {
        addAttribute("text:ref-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_formula : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_display_value_formula_attlist, public group_common_field_formula_attlist {
public:
    text_table_formula(OdfWriter* x) :OdfWriter(x, "text:table-formula", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_table_formula(KoXmlWriter* x) :OdfWriter(x, "text:table-formula", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_index_entry_template : public OdfWriter, public group_text_illustration_index_entry_content {
public:
    text_table_index_entry_template(OdfWriter* x, const QString& text_style_name) :OdfWriter(x, "text:table-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
    text_table_index_entry_template(KoXmlWriter* x, const QString& text_style_name) :OdfWriter(x, "text:table-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
};
class text_text_input : public OdfWriter, public group_common_field_description_attlist {
public:
    text_text_input(OdfWriter* x) :OdfWriter(x, "text:text-input", false), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_text_input(KoXmlWriter* x) :OdfWriter(x, "text:text-input", false), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_title : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_title(OdfWriter* x) :OdfWriter(x, "text:title", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_title(KoXmlWriter* x) :OdfWriter(x, "text:title", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_field_decl : public OdfWriter, public group_common_field_formula_attlist, public group_common_field_name_attlist, public group_common_value_and_type_attlist {
public:
    text_user_field_decl(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-decl", false), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_user_field_decl(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-decl", false), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_field_input : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_description_attlist, public group_common_field_name_attlist {
public:
    text_user_field_input(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-input", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    text_user_field_input(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-input", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_index_entry_template : public OdfWriter, public group_text_index_entry_chapter, public group_text_index_entry_page_number, public group_text_index_entry_span, public group_text_index_entry_tab_stop, public group_text_index_entry_text {
public:
    text_user_index_entry_template(OdfWriter* x, quint64 text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:user-index-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
    text_user_index_entry_template(KoXmlWriter* x, quint64 text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:user-index-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
};
class text_variable_get : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_display_value_formula_attlist, public group_common_field_name_attlist {
public:
    text_variable_get(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:variable-get", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    text_variable_get(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:variable-get", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_variable_set : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_display_value_none_attlist, public group_common_field_formula_attlist, public group_common_field_name_attlist, public group_common_value_and_type_attlist {
public:
    text_variable_set(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:variable-set", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_none_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_variable_set(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:variable-set", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_none_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_alphabetical_index_entry_template : public OdfWriter, public group_text_index_entry_chapter, public group_text_index_entry_page_number, public group_text_index_entry_span, public group_text_index_entry_tab_stop, public group_text_index_entry_text {
public:
    text_alphabetical_index_entry_template(OdfWriter* x, const QString& text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:alphabetical-index-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
    text_alphabetical_index_entry_template(KoXmlWriter* x, const QString& text_outline_level, const QString& text_style_name) :OdfWriter(x, "text:alphabetical-index-entry-template", true), group_text_index_entry_chapter(*static_cast<OdfWriter*>(this)), group_text_index_entry_page_number(*static_cast<OdfWriter*>(this)), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)), group_text_index_entry_text(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
        addAttribute("text:style-name", text_style_name);
    }
};
class text_change_start : public OdfWriter, public group_change_mark_attr {
public:
    text_change_start(OdfWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change-start", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    text_change_start(KoXmlWriter* x, const QString& text_change_id) :OdfWriter(x, "text:change-start", false), group_change_mark_attr(*static_cast<OdfWriter*>(this), text_change_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_database_display : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_database_table {
public:
    text_database_display(OdfWriter* x, const QString& text_column_name, const QString& text_table_name) :OdfWriter(x, "text:database-display", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
        addAttribute("text:column-name", text_column_name);
    }
    text_database_display(KoXmlWriter* x, const QString& text_column_name, const QString& text_table_name) :OdfWriter(x, "text:database-display", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
        addAttribute("text:column-name", text_column_name);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_database_next : public OdfWriter, public group_common_field_database_table {
public:
    text_database_next(OdfWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-next", true), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    text_database_next(KoXmlWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-next", true), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    void set_text_condition(const QString& value) {
        addAttribute("text:condition", value);
    }
};
class text_database_row_select : public OdfWriter, public group_common_field_database_table {
public:
    text_database_row_select(OdfWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-row-select", true), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    text_database_row_select(KoXmlWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-row-select", true), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    void set_text_condition(const QString& value) {
        addAttribute("text:condition", value);
    }
    void set_text_row_number(quint64 value) {
        addAttribute("text:row-number", value);
    }
};
class text_list_header : public OdfWriter, public group_text_list_item_content, public group_xml_id {
public:
    text_list_header(OdfWriter* x) :OdfWriter(x, "text:list-header", true), group_text_list_item_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    text_list_header(KoXmlWriter* x) :OdfWriter(x, "text:list-header", true), group_text_list_item_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
};
class text_modification_time : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_modification_time(OdfWriter* x) :OdfWriter(x, "text:modification-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_modification_time(KoXmlWriter* x) :OdfWriter(x, "text:modification-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_time_value(const QTime& value) {
        addAttribute("text:time-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_number : public OdfWriter {
public:
    text_number(OdfWriter* x) :OdfWriter(x, "text:number", false) {
    }
    text_number(KoXmlWriter* x) :OdfWriter(x, "text:number", false) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_print_date : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_print_date(OdfWriter* x) :OdfWriter(x, "text:print-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_print_date(KoXmlWriter* x) :OdfWriter(x, "text:print-date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_date_value(const QDate& value) {
        addAttribute("text:date-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_defined : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_user_defined(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:user-defined", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    text_user_defined(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:user-defined", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:name", text_name);
    }
    template<class T>
    void set_office_boolean_value(const T& value) {
        addAttribute("office:boolean-value", value);
    }
    template<class T>
    void set_office_date_value(const T& value) {
        addAttribute("office:date-value", value);
    }
    void set_office_string_value(const QString& value) {
        addAttribute("office:string-value", value);
    }
    void set_office_time_value(Duration value) {
        addAttribute("office:time-value", value);
    }
    void set_office_value(double value) {
        addAttribute("office:value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_variable_input : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_description_attlist, public group_common_field_display_value_none_attlist, public group_common_field_name_attlist, public group_common_value_type_attlist {
public:
    text_variable_input(OdfWriter* x, const QString& office_value_type, const QString& text_name) :OdfWriter(x, "text:variable-input", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_none_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_type_attlist(*static_cast<OdfWriter*>(this), office_value_type) {
    }
    text_variable_input(KoXmlWriter* x, const QString& office_value_type, const QString& text_name) :OdfWriter(x, "text:variable-input", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_description_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_none_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name), group_common_value_type_attlist(*static_cast<OdfWriter*>(this), office_value_type) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_alphabetical_index : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_alphabetical_index(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:alphabetical-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_alphabetical_index(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:alphabetical-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_alphabetical_index_source add_text_alphabetical_index_source();
};
class text_bibliography : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_bibliography(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:bibliography", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_bibliography(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:bibliography", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_bibliography_source add_text_bibliography_source();
};
class text_creation_time : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_creation_time(OdfWriter* x) :OdfWriter(x, "text:creation-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_creation_time(KoXmlWriter* x) :OdfWriter(x, "text:creation-time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_text_time_value(const T& value) {
        addAttribute("text:time-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_database_row_number : public OdfWriter, public group_common_field_database_table, public group_common_field_num_format_attlist {
public:
    text_database_row_number(OdfWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-row-number", false), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_database_row_number(KoXmlWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-row-number", false), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_value(quint64 value) {
        addAttribute("text:value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_illustration_index : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_illustration_index(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:illustration-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_illustration_index(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:illustration-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_illustration_index_source add_text_illustration_index_source();
};
class text_list_item : public OdfWriter, public group_text_list_item_content, public group_xml_id {
public:
    text_list_item(OdfWriter* x) :OdfWriter(x, "text:list-item", true), group_text_list_item_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    text_list_item(KoXmlWriter* x) :OdfWriter(x, "text:list-item", true), group_text_list_item_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
    void set_text_style_override(const QString& value) {
        addAttribute("text:style-override", value);
    }
};
class text_object_index : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_object_index(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:object-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_object_index(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:object-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_object_index_source add_text_object_index_source();
};
class text_page_variable_get : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_page_variable_get(OdfWriter* x) :OdfWriter(x, "text:page-variable-get", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_page_variable_get(KoXmlWriter* x) :OdfWriter(x, "text:page-variable-get", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_table_of_content : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_table_of_content(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:table-of-content", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_table_of_content(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:table-of-content", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_table_of_content_source add_text_table_of_content_source();
};
class text_user_field_get : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_name_attlist {
public:
    text_user_field_get(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-get", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    text_user_field_get(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:user-field-get", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_name_attlist(*static_cast<OdfWriter*>(this), text_name) {
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_user_index_source : public OdfWriter, public group_text_index_scope_attr, public group_text_index_source_styles, public group_text_index_title_template, public group_text_relative_tab_stop_position_attr {
public:
    text_user_index_source(OdfWriter* x, const QString& text_index_name) :OdfWriter(x, "text:user-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_source_styles(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:index-name", text_index_name);
    }
    text_user_index_source(KoXmlWriter* x, const QString& text_index_name) :OdfWriter(x, "text:user-index-source", true), group_text_index_scope_attr(*static_cast<OdfWriter*>(this)), group_text_index_source_styles(*static_cast<OdfWriter*>(this)), group_text_index_title_template(*static_cast<OdfWriter*>(this)), group_text_relative_tab_stop_position_attr(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:index-name", text_index_name);
    }
    text_user_index_entry_template add_text_user_index_entry_template(quint64 text_outline_level, const QString& text_style_name);
    template<class T>
    void set_text_copy_outline_levels(const T& value) {
        addAttribute("text:copy-outline-levels", value);
    }
    template<class T>
    void set_text_use_floating_frames(const T& value) {
        addAttribute("text:use-floating-frames", value);
    }
    template<class T>
    void set_text_use_graphics(const T& value) {
        addAttribute("text:use-graphics", value);
    }
    template<class T>
    void set_text_use_index_marks(const T& value) {
        addAttribute("text:use-index-marks", value);
    }
    template<class T>
    void set_text_use_index_source_styles(const T& value) {
        addAttribute("text:use-index-source-styles", value);
    }
    template<class T>
    void set_text_use_objects(const T& value) {
        addAttribute("text:use-objects", value);
    }
    template<class T>
    void set_text_use_tables(const T& value) {
        addAttribute("text:use-tables", value);
    }
};
class text_alphabetical_index_mark_start : public OdfWriter, public group_text_alphabetical_index_mark_attrs, public group_text_id {
public:
    text_alphabetical_index_mark_start(OdfWriter* x, const QString& text_id) :OdfWriter(x, "text:alphabetical-index-mark-start", false), group_text_alphabetical_index_mark_attrs(*static_cast<OdfWriter*>(this)), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    text_alphabetical_index_mark_start(KoXmlWriter* x, const QString& text_id) :OdfWriter(x, "text:alphabetical-index-mark-start", false), group_text_alphabetical_index_mark_attrs(*static_cast<OdfWriter*>(this)), group_text_id(*static_cast<OdfWriter*>(this), text_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_database_name : public OdfWriter, public group_common_field_database_table {
public:
    text_database_name(OdfWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-name", false), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    text_database_name(KoXmlWriter* x, const QString& text_table_name) :OdfWriter(x, "text:database-name", false), group_common_field_database_table(*static_cast<OdfWriter*>(this), text_table_name) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_illustration_index_entry_template : public OdfWriter, public group_text_illustration_index_entry_content {
public:
    text_illustration_index_entry_template(OdfWriter* x, const QString& text_style_name) :OdfWriter(x, "text:illustration-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
    text_illustration_index_entry_template(KoXmlWriter* x, const QString& text_style_name) :OdfWriter(x, "text:illustration-index-entry-template", true), group_text_illustration_index_entry_content(*static_cast<OdfWriter*>(this), text_style_name) {
    }
};
class text_list : public OdfWriter, public group_xml_id {
public:
    text_list(OdfWriter* x) :OdfWriter(x, "text:list", true), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    text_list(KoXmlWriter* x) :OdfWriter(x, "text:list", true), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    text_list_header add_text_list_header();
    text_list_item add_text_list_item();
    void set_text_continue_list(const QString& value) {
        addAttribute("text:continue-list", value);
    }
    template<class T>
    void set_text_continue_numbering(const T& value) {
        addAttribute("text:continue-numbering", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
};
class text_meta_field : public OdfWriter, public group_common_field_data_style_name_attlist, public group_paragraph_content_or_hyperlink, public group_xml_id {
public:
    text_meta_field(OdfWriter* x, const QString& xml_id) :OdfWriter(x, "text:meta-field", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this), xml_id) {
    }
    text_meta_field(KoXmlWriter* x, const QString& xml_id) :OdfWriter(x, "text:meta-field", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this), xml_id) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_p : public OdfWriter, public group_paragraph_attrs, public group_paragraph_content_or_hyperlink {
public:
    text_p(OdfWriter* x) :OdfWriter(x, "text:p", false), group_paragraph_attrs(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    text_p(KoXmlWriter* x) :OdfWriter(x, "text:p", false), group_paragraph_attrs(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_span : public OdfWriter, public group_paragraph_content_or_hyperlink {
public:
    text_span(OdfWriter* x) :OdfWriter(x, "text:span", false), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    text_span(KoXmlWriter* x) :OdfWriter(x, "text:span", false), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_text_class_names(const T& value) {
        addAttribute("text:class-names", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_time : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_time(OdfWriter* x) :OdfWriter(x, "text:time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_time(KoXmlWriter* x) :OdfWriter(x, "text:time", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_time_adjust(Duration value) {
        addAttribute("text:time-adjust", value);
    }
    template<class T>
    void set_text_time_value(const T& value) {
        addAttribute("text:time-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_word_count : public OdfWriter, public group_common_field_num_format_attlist {
public:
    text_word_count(OdfWriter* x) :OdfWriter(x, "text:word-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_word_count(KoXmlWriter* x) :OdfWriter(x, "text:word-count", false), group_common_field_num_format_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_bibliography_entry_template : public OdfWriter, public group_text_index_entry_span, public group_text_index_entry_tab_stop {
public:
    text_bibliography_entry_template(OdfWriter* x, const QString& text_bibliography_type, const QString& text_style_name) :OdfWriter(x, "text:bibliography-entry-template", true), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:bibliography-type", text_bibliography_type);
        addAttribute("text:style-name", text_style_name);
    }
    text_bibliography_entry_template(KoXmlWriter* x, const QString& text_bibliography_type, const QString& text_style_name) :OdfWriter(x, "text:bibliography-entry-template", true), group_text_index_entry_span(*static_cast<OdfWriter*>(this)), group_text_index_entry_tab_stop(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:bibliography-type", text_bibliography_type);
        addAttribute("text:style-name", text_style_name);
    }
    text_index_entry_bibliography add_text_index_entry_bibliography(const QString& text_bibliography_data_field);
};
class text_note_body : public OdfWriter, public group_text_content {
public:
    text_note_body(OdfWriter* x) :OdfWriter(x, "text:note-body", true), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
    text_note_body(KoXmlWriter* x) :OdfWriter(x, "text:note-body", true), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
};
class text_section : public OdfWriter, public group_common_section_attlist, public group_office_dde_source, public group_text_content {
public:
    text_section(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:section", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_office_dde_source(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
    text_section(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:section", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_office_dde_source(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
    text_section_source add_text_section_source();
    void set_text_condition(const QString& value) {
        addAttribute("text:condition", value);
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
};
class text_table_index : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_table_index(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:table-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_table_index(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:table-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_table_index_source add_text_table_index_source();
};
class text_date : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_fixed_attlist {
public:
    text_date(OdfWriter* x) :OdfWriter(x, "text:date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_date(KoXmlWriter* x) :OdfWriter(x, "text:date", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_text_date_adjust(Duration value) {
        addAttribute("text:date-adjust", value);
    }
    template<class T>
    void set_text_date_value(const T& value) {
        addAttribute("text:date-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_expression : public OdfWriter, public group_common_field_data_style_name_attlist, public group_common_field_display_value_formula_attlist, public group_common_field_formula_attlist, public group_common_value_and_type_attlist {
public:
    text_expression(OdfWriter* x) :OdfWriter(x, "text:expression", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_expression(KoXmlWriter* x) :OdfWriter(x, "text:expression", false), group_common_field_data_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_field_display_value_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_field_formula_attlist(*static_cast<OdfWriter*>(this)), group_common_value_and_type_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_h : public OdfWriter, public group_paragraph_attrs, public group_paragraph_content_or_hyperlink, public group_text_number {
public:
    text_h(OdfWriter* x, quint64 text_outline_level) :OdfWriter(x, "text:h", false), group_paragraph_attrs(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_text_number(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
    }
    text_h(KoXmlWriter* x, quint64 text_outline_level) :OdfWriter(x, "text:h", false), group_paragraph_attrs(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_text_number(*static_cast<OdfWriter*>(this)) {
        addAttribute("text:outline-level", text_outline_level);
    }
    template<class T>
    void set_text_is_list_header(const T& value) {
        addAttribute("text:is-list-header", value);
    }
    template<class T>
    void set_text_restart_numbering(const T& value) {
        addAttribute("text:restart-numbering", value);
    }
    void set_text_start_value(quint64 value) {
        addAttribute("text:start-value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_title : public OdfWriter, public group_common_section_attlist, public group_index_content_main {
public:
    text_index_title(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:index-title", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_index_content_main(*static_cast<OdfWriter*>(this)) {
    }
    text_index_title(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:index-title", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_index_content_main(*static_cast<OdfWriter*>(this)) {
    }
};
class text_meta : public OdfWriter, public group_common_in_content_meta_attlist, public group_paragraph_content_or_hyperlink, public group_xml_id {
public:
    text_meta(OdfWriter* x) :OdfWriter(x, "text:meta", false), group_common_in_content_meta_attlist(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    text_meta(KoXmlWriter* x) :OdfWriter(x, "text:meta", false), group_common_in_content_meta_attlist(*static_cast<OdfWriter*>(this)), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_sender_fax : public OdfWriter, public group_common_field_fixed_attlist {
public:
    text_sender_fax(OdfWriter* x) :OdfWriter(x, "text:sender-fax", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    text_sender_fax(KoXmlWriter* x) :OdfWriter(x, "text:sender-fax", false), group_common_field_fixed_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_index_body : public OdfWriter, public group_index_content_main {
public:
    text_index_body(OdfWriter* x) :OdfWriter(x, "text:index-body", true), group_index_content_main(*static_cast<OdfWriter*>(this)) {
    }
    text_index_body(KoXmlWriter* x) :OdfWriter(x, "text:index-body", true), group_index_content_main(*static_cast<OdfWriter*>(this)) {
    }
};
class text_ruby_base : public OdfWriter, public group_paragraph_content_or_hyperlink {
public:
    text_ruby_base(OdfWriter* x) :OdfWriter(x, "text:ruby-base", false), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    text_ruby_base(KoXmlWriter* x) :OdfWriter(x, "text:ruby-base", false), group_paragraph_content_or_hyperlink(*static_cast<OdfWriter*>(this)) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class text_deletion : public OdfWriter, public group_office_change_info, public group_text_content {
public:
    text_deletion(OdfWriter* x) :OdfWriter(x, "text:deletion", true), group_office_change_info(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
    text_deletion(KoXmlWriter* x) :OdfWriter(x, "text:deletion", true), group_office_change_info(*static_cast<OdfWriter*>(this)), group_text_content(*static_cast<OdfWriter*>(this)) {
    }
};
class text_insertion : public OdfWriter, public group_office_change_info {
public:
    text_insertion(OdfWriter* x) :OdfWriter(x, "text:insertion", true), group_office_change_info(*static_cast<OdfWriter*>(this)) {
    }
    text_insertion(KoXmlWriter* x) :OdfWriter(x, "text:insertion", true), group_office_change_info(*static_cast<OdfWriter*>(this)) {
    }
};
class text_format_change : public OdfWriter, public group_office_change_info {
public:
    text_format_change(OdfWriter* x) :OdfWriter(x, "text:format-change", true), group_office_change_info(*static_cast<OdfWriter*>(this)) {
    }
    text_format_change(KoXmlWriter* x) :OdfWriter(x, "text:format-change", true), group_office_change_info(*static_cast<OdfWriter*>(this)) {
    }
};
class text_user_index : public OdfWriter, public group_common_section_attlist, public group_text_index_body {
public:
    text_user_index(OdfWriter* x, const QString& text_name) :OdfWriter(x, "text:user-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_user_index(KoXmlWriter* x, const QString& text_name) :OdfWriter(x, "text:user-index", true), group_common_section_attlist(*static_cast<OdfWriter*>(this), text_name), group_text_index_body(*static_cast<OdfWriter*>(this)) {
    }
    text_user_index_source add_text_user_index_source(const QString& text_index_name);
};
class text_a : public OdfWriter, public group_office_event_listeners, public group_paragraph_content {
public:
    text_a(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "text:a", false), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_paragraph_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    text_a(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "text:a", false), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_paragraph_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    void set_office_name(const QString& value) {
        addAttribute("office:name", value);
    }
    template<class T>
    void set_office_target_frame_name(const T& value) {
        addAttribute("office:target-frame-name", value);
    }
    void set_office_title(const QString& value) {
        addAttribute("office:title", value);
    }
    void set_text_style_name(const QString& value) {
        addAttribute("text:style-name", value);
    }
    void set_text_visited_style_name(const QString& value) {
        addAttribute("text:visited-style-name", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
}
inline writeodf::text_change
writeodf::group_change_marks::add_text_change(const QString& text_change_id) {
    return writeodf::text_change(&xml, text_change_id);
}
inline writeodf::text_change_end
writeodf::group_change_marks::add_text_change_end(const QString& text_change_id) {
    return writeodf::text_change_end(&xml, text_change_id);
}
inline writeodf::text_change_start
writeodf::group_change_marks::add_text_change_start(const QString& text_change_id) {
    return writeodf::text_change_start(&xml, text_change_id);
}
inline writeodf::text_alphabetical_index
writeodf::group_text_alphabetical_index::add_text_alphabetical_index(const QString& text_name) {
    return writeodf::text_alphabetical_index(&xml, text_name);
}
inline writeodf::text_bibliography
writeodf::group_text_bibliography::add_text_bibliography(const QString& text_name) {
    return writeodf::text_bibliography(&xml, text_name);
}
inline writeodf::text_h
writeodf::group_text_h::add_text_h(quint64 text_outline_level) {
    return writeodf::text_h(&xml, text_outline_level);
}
inline writeodf::text_illustration_index
writeodf::group_text_illustration_index::add_text_illustration_index(const QString& text_name) {
    return writeodf::text_illustration_index(&xml, text_name);
}
inline writeodf::text_index_entry_chapter
writeodf::group_text_index_entry_chapter::add_text_index_entry_chapter() {
    return writeodf::text_index_entry_chapter(&xml);
}
inline writeodf::text_index_entry_span
writeodf::group_text_index_entry_span::add_text_index_entry_span() {
    return writeodf::text_index_entry_span(&xml);
}
inline writeodf::text_index_entry_text
writeodf::group_text_index_entry_text::add_text_index_entry_text() {
    return writeodf::text_index_entry_text(&xml);
}
inline writeodf::text_index_title
writeodf::group_text_index_title::add_text_index_title(const QString& text_name) {
    return writeodf::text_index_title(&xml, text_name);
}
inline writeodf::text_list
writeodf::group_text_list::add_text_list() {
    return writeodf::text_list(&xml);
}
inline writeodf::text_number
writeodf::group_text_number::add_text_number() {
    return writeodf::text_number(&xml);
}
inline writeodf::text_soft_page_break
writeodf::group_text_soft_page_break::add_text_soft_page_break() {
    return writeodf::text_soft_page_break(&xml);
}
inline writeodf::text_table_of_content
writeodf::group_text_table_of_content::add_text_table_of_content(const QString& text_name) {
    return writeodf::text_table_of_content(&xml, text_name);
}
inline writeodf::text_user_index
writeodf::group_text_user_index::add_text_user_index(const QString& text_name) {
    return writeodf::text_user_index(&xml, text_name);
}
inline writeodf::text_list_level_style_bullet
writeodf::text_list_style::add_text_list_level_style_bullet(const QString& text_bullet_char, quint64 text_level) {
    return writeodf::text_list_level_style_bullet(this, text_bullet_char, text_level);
}
inline writeodf::text_list_level_style_image
writeodf::text_list_style::add_text_list_level_style_image(quint64 text_level) {
    return writeodf::text_list_level_style_image(this, text_level);
}
inline writeodf::text_list_level_style_number
writeodf::text_list_style::add_text_list_level_style_number(quint64 text_level) {
    return writeodf::text_list_level_style_number(this, text_level);
}
inline writeodf::text_note_body
writeodf::text_note::add_text_note_body() {
    return writeodf::text_note_body(this);
}
inline writeodf::text_note_citation
writeodf::text_note::add_text_note_citation() {
    return writeodf::text_note_citation(this);
}
inline writeodf::text_outline_level_style
writeodf::text_outline_style::add_text_outline_level_style(quint64 text_level) {
    return writeodf::text_outline_level_style(this, text_level);
}
inline writeodf::text_page
writeodf::text_page_sequence::add_text_page(const QString& text_master_page_name) {
    return writeodf::text_page(this, text_master_page_name);
}
inline writeodf::text_ruby_base
writeodf::text_ruby::add_text_ruby_base() {
    return writeodf::text_ruby_base(this);
}
inline writeodf::text_ruby_text
writeodf::text_ruby::add_text_ruby_text() {
    return writeodf::text_ruby_text(this);
}
inline writeodf::text_sequence_decl
writeodf::text_sequence_decls::add_text_sequence_decl(quint64 text_display_outline_level, const QString& text_name) {
    return writeodf::text_sequence_decl(this, text_display_outline_level, text_name);
}
inline writeodf::text_user_field_decl
writeodf::text_user_field_decls::add_text_user_field_decl(const QString& text_name) {
    return writeodf::text_user_field_decl(this, text_name);
}
inline writeodf::text_variable_decl
writeodf::text_variable_decls::add_text_variable_decl(const QString& office_value_type, const QString& text_name) {
    return writeodf::text_variable_decl(this, office_value_type, text_name);
}
inline writeodf::text_index_entry_page_number
writeodf::group_text_index_entry_page_number::add_text_index_entry_page_number() {
    return writeodf::text_index_entry_page_number(&xml);
}
inline writeodf::text_index_title_template
writeodf::group_text_index_title_template::add_text_index_title_template() {
    return writeodf::text_index_title_template(&xml);
}
inline writeodf::text_list_style
writeodf::group_text_list_style::add_text_list_style(const QString& style_name) {
    return writeodf::text_list_style(&xml, style_name);
}
inline writeodf::text_object_index
writeodf::group_text_object_index::add_text_object_index(const QString& text_name) {
    return writeodf::text_object_index(&xml, text_name);
}
inline writeodf::text_section
writeodf::group_text_section::add_text_section(const QString& text_name) {
    return writeodf::text_section(&xml, text_name);
}
inline writeodf::text_tracked_changes
writeodf::group_text_tracked_changes::add_text_tracked_changes() {
    return writeodf::text_tracked_changes(&xml);
}
inline writeodf::text_alphabetical_index_entry_template
writeodf::text_alphabetical_index_source::add_text_alphabetical_index_entry_template(const QString& text_outline_level, const QString& text_style_name) {
    return writeodf::text_alphabetical_index_entry_template(this, text_outline_level, text_style_name);
}
inline writeodf::text_bibliography_entry_template
writeodf::text_bibliography_source::add_text_bibliography_entry_template(const QString& text_bibliography_type, const QString& text_style_name) {
    return writeodf::text_bibliography_entry_template(this, text_bibliography_type, text_style_name);
}
inline writeodf::text_illustration_index_entry_template
writeodf::text_illustration_index_source::add_text_illustration_index_entry_template(const QString& text_style_name) {
    return writeodf::text_illustration_index_entry_template(this, text_style_name);
}
inline writeodf::text_linenumbering_separator
writeodf::text_linenumbering_configuration::add_text_linenumbering_separator() {
    return writeodf::text_linenumbering_separator(this);
}
inline writeodf::text_note_continuation_notice_backward
writeodf::text_notes_configuration::add_text_note_continuation_notice_backward() {
    return writeodf::text_note_continuation_notice_backward(this);
}
inline writeodf::text_note_continuation_notice_forward
writeodf::text_notes_configuration::add_text_note_continuation_notice_forward() {
    return writeodf::text_note_continuation_notice_forward(this);
}
inline writeodf::text_object_index_entry_template
writeodf::text_object_index_source::add_text_object_index_entry_template(const QString& text_style_name) {
    return writeodf::text_object_index_entry_template(this, text_style_name);
}
inline writeodf::text_changed_region
writeodf::text_tracked_changes::add_text_changed_region(const QString& xml_id) {
    return writeodf::text_changed_region(this, xml_id);
}
inline writeodf::text_alphabetical_index_auto_mark_file
writeodf::group_text_decls::add_text_alphabetical_index_auto_mark_file(const QUrl& xlink_href) {
    return writeodf::text_alphabetical_index_auto_mark_file(&xml, xlink_href);
}
inline writeodf::text_dde_connection_decls
writeodf::group_text_decls::add_text_dde_connection_decls() {
    return writeodf::text_dde_connection_decls(&xml);
}
inline writeodf::text_sequence_decls
writeodf::group_text_decls::add_text_sequence_decls() {
    return writeodf::text_sequence_decls(&xml);
}
inline writeodf::text_user_field_decls
writeodf::group_text_decls::add_text_user_field_decls() {
    return writeodf::text_user_field_decls(&xml);
}
inline writeodf::text_variable_decls
writeodf::group_text_decls::add_text_variable_decls() {
    return writeodf::text_variable_decls(&xml);
}
inline writeodf::text_index_body
writeodf::group_text_index_body::add_text_index_body() {
    return writeodf::text_index_body(&xml);
}
inline writeodf::text_index_source_styles
writeodf::group_text_index_source_styles::add_text_index_source_styles(quint64 text_outline_level) {
    return writeodf::text_index_source_styles(&xml, text_outline_level);
}
inline writeodf::text_notes_configuration
writeodf::group_text_notes_configuration::add_text_notes_configuration(const QString& text_note_class) {
    return writeodf::text_notes_configuration(&xml, text_note_class);
}
inline writeodf::text_table_index
writeodf::group_text_table_index::add_text_table_index(const QString& text_name) {
    return writeodf::text_table_index(&xml, text_name);
}
inline writeodf::text_deletion
writeodf::text_changed_region::add_text_deletion() {
    return writeodf::text_deletion(this);
}
inline writeodf::text_format_change
writeodf::text_changed_region::add_text_format_change() {
    return writeodf::text_format_change(this);
}
inline writeodf::text_insertion
writeodf::text_changed_region::add_text_insertion() {
    return writeodf::text_insertion(this);
}
inline writeodf::text_dde_connection_decl
writeodf::text_dde_connection_decls::add_text_dde_connection_decl(const QString& office_dde_application, const QString& office_dde_item, const QString& office_dde_topic, const QString& office_name) {
    return writeodf::text_dde_connection_decl(this, office_dde_application, office_dde_item, office_dde_topic, office_name);
}
inline writeodf::text_table_of_content_entry_template
writeodf::text_table_of_content_source::add_text_table_of_content_entry_template(quint64 text_outline_level, const QString& text_style_name) {
    return writeodf::text_table_of_content_entry_template(this, text_outline_level, text_style_name);
}
inline writeodf::text_index_entry_tab_stop
writeodf::group_text_index_entry_tab_stop::add_text_index_entry_tab_stop() {
    return writeodf::text_index_entry_tab_stop(&xml);
}
inline writeodf::text_p
writeodf::group_text_p::add_text_p() {
    return writeodf::text_p(&xml);
}
inline writeodf::text_sort_key
writeodf::text_bibliography_configuration::add_text_sort_key(const QString& text_key) {
    return writeodf::text_sort_key(this, text_key);
}
inline writeodf::text_index_source_style
writeodf::text_index_source_styles::add_text_index_source_style(const QString& text_style_name) {
    return writeodf::text_index_source_style(this, text_style_name);
}
inline writeodf::text_table_index_entry_template
writeodf::text_table_index_source::add_text_table_index_entry_template(const QString& text_style_name) {
    return writeodf::text_table_index_entry_template(this, text_style_name);
}
inline writeodf::text_index_entry_link_end
writeodf::text_table_of_content_entry_template::add_text_index_entry_link_end() {
    return writeodf::text_index_entry_link_end(this);
}
inline writeodf::text_index_entry_link_start
writeodf::text_table_of_content_entry_template::add_text_index_entry_link_start() {
    return writeodf::text_index_entry_link_start(this);
}
inline writeodf::text_alphabetical_index_mark
writeodf::group_paragraph_content::add_text_alphabetical_index_mark(const QString& text_string_value) {
    return writeodf::text_alphabetical_index_mark(&xml, text_string_value);
}
inline writeodf::text_alphabetical_index_mark_end
writeodf::group_paragraph_content::add_text_alphabetical_index_mark_end(const QString& text_id) {
    return writeodf::text_alphabetical_index_mark_end(&xml, text_id);
}
inline writeodf::text_alphabetical_index_mark_start
writeodf::group_paragraph_content::add_text_alphabetical_index_mark_start(const QString& text_id) {
    return writeodf::text_alphabetical_index_mark_start(&xml, text_id);
}
inline writeodf::text_author_initials
writeodf::group_paragraph_content::add_text_author_initials() {
    return writeodf::text_author_initials(&xml);
}
inline writeodf::text_author_name
writeodf::group_paragraph_content::add_text_author_name() {
    return writeodf::text_author_name(&xml);
}
inline writeodf::text_bibliography_mark
writeodf::group_paragraph_content::add_text_bibliography_mark(const QString& text_bibliography_type) {
    return writeodf::text_bibliography_mark(&xml, text_bibliography_type);
}
inline writeodf::text_bookmark
writeodf::group_paragraph_content::add_text_bookmark(const QString& text_name) {
    return writeodf::text_bookmark(&xml, text_name);
}
inline writeodf::text_bookmark_end
writeodf::group_paragraph_content::add_text_bookmark_end(const QString& text_name) {
    return writeodf::text_bookmark_end(&xml, text_name);
}
inline writeodf::text_bookmark_ref
writeodf::group_paragraph_content::add_text_bookmark_ref() {
    return writeodf::text_bookmark_ref(&xml);
}
inline writeodf::text_bookmark_start
writeodf::group_paragraph_content::add_text_bookmark_start(const QString& text_name) {
    return writeodf::text_bookmark_start(&xml, text_name);
}
inline writeodf::text_chapter
writeodf::group_paragraph_content::add_text_chapter(const QString& text_display, quint64 text_outline_level) {
    return writeodf::text_chapter(&xml, text_display, text_outline_level);
}
inline writeodf::text_character_count
writeodf::group_paragraph_content::add_text_character_count() {
    return writeodf::text_character_count(&xml);
}
inline writeodf::text_conditional_text
writeodf::group_paragraph_content::add_text_conditional_text(const QString& text_condition, const QString& text_string_value_if_false, const QString& text_string_value_if_true) {
    return writeodf::text_conditional_text(&xml, text_condition, text_string_value_if_false, text_string_value_if_true);
}
inline writeodf::text_creation_date
writeodf::group_paragraph_content::add_text_creation_date() {
    return writeodf::text_creation_date(&xml);
}
inline writeodf::text_creation_time
writeodf::group_paragraph_content::add_text_creation_time() {
    return writeodf::text_creation_time(&xml);
}
inline writeodf::text_creator
writeodf::group_paragraph_content::add_text_creator() {
    return writeodf::text_creator(&xml);
}
inline writeodf::text_database_display
writeodf::group_paragraph_content::add_text_database_display(const QString& text_column_name, const QString& text_table_name) {
    return writeodf::text_database_display(&xml, text_column_name, text_table_name);
}
inline writeodf::text_database_name
writeodf::group_paragraph_content::add_text_database_name(const QString& text_table_name) {
    return writeodf::text_database_name(&xml, text_table_name);
}
inline writeodf::text_database_next
writeodf::group_paragraph_content::add_text_database_next(const QString& text_table_name) {
    return writeodf::text_database_next(&xml, text_table_name);
}
inline writeodf::text_database_row_number
writeodf::group_paragraph_content::add_text_database_row_number(const QString& text_table_name) {
    return writeodf::text_database_row_number(&xml, text_table_name);
}
inline writeodf::text_database_row_select
writeodf::group_paragraph_content::add_text_database_row_select(const QString& text_table_name) {
    return writeodf::text_database_row_select(&xml, text_table_name);
}
inline writeodf::text_date
writeodf::group_paragraph_content::add_text_date() {
    return writeodf::text_date(&xml);
}
inline writeodf::text_dde_connection
writeodf::group_paragraph_content::add_text_dde_connection(const QString& text_connection_name) {
    return writeodf::text_dde_connection(&xml, text_connection_name);
}
inline writeodf::text_description
writeodf::group_paragraph_content::add_text_description() {
    return writeodf::text_description(&xml);
}
inline writeodf::text_editing_cycles
writeodf::group_paragraph_content::add_text_editing_cycles() {
    return writeodf::text_editing_cycles(&xml);
}
inline writeodf::text_editing_duration
writeodf::group_paragraph_content::add_text_editing_duration() {
    return writeodf::text_editing_duration(&xml);
}
inline writeodf::text_execute_macro
writeodf::group_paragraph_content::add_text_execute_macro() {
    return writeodf::text_execute_macro(&xml);
}
inline writeodf::text_expression
writeodf::group_paragraph_content::add_text_expression() {
    return writeodf::text_expression(&xml);
}
inline writeodf::text_file_name
writeodf::group_paragraph_content::add_text_file_name() {
    return writeodf::text_file_name(&xml);
}
inline writeodf::text_hidden_paragraph
writeodf::group_paragraph_content::add_text_hidden_paragraph(const QString& text_condition) {
    return writeodf::text_hidden_paragraph(&xml, text_condition);
}
inline writeodf::text_hidden_text
writeodf::group_paragraph_content::add_text_hidden_text(const QString& text_condition, const QString& text_string_value) {
    return writeodf::text_hidden_text(&xml, text_condition, text_string_value);
}
inline writeodf::text_image_count
writeodf::group_paragraph_content::add_text_image_count() {
    return writeodf::text_image_count(&xml);
}
inline writeodf::text_initial_creator
writeodf::group_paragraph_content::add_text_initial_creator() {
    return writeodf::text_initial_creator(&xml);
}
inline writeodf::text_keywords
writeodf::group_paragraph_content::add_text_keywords() {
    return writeodf::text_keywords(&xml);
}
inline writeodf::text_line_break
writeodf::group_paragraph_content::add_text_line_break() {
    return writeodf::text_line_break(&xml);
}
inline writeodf::text_measure
writeodf::group_paragraph_content::add_text_measure(const QString& text_kind) {
    return writeodf::text_measure(&xml, text_kind);
}
inline writeodf::text_meta
writeodf::group_paragraph_content::add_text_meta() {
    return writeodf::text_meta(&xml);
}
inline writeodf::text_meta_field
writeodf::group_paragraph_content::add_text_meta_field(const QString& xml_id) {
    return writeodf::text_meta_field(&xml, xml_id);
}
inline writeodf::text_modification_date
writeodf::group_paragraph_content::add_text_modification_date() {
    return writeodf::text_modification_date(&xml);
}
inline writeodf::text_modification_time
writeodf::group_paragraph_content::add_text_modification_time() {
    return writeodf::text_modification_time(&xml);
}
inline writeodf::text_note
writeodf::group_paragraph_content::add_text_note(const QString& text_note_class) {
    return writeodf::text_note(&xml, text_note_class);
}
inline writeodf::text_note_ref
writeodf::group_paragraph_content::add_text_note_ref(const QString& text_note_class) {
    return writeodf::text_note_ref(&xml, text_note_class);
}
inline writeodf::text_object_count
writeodf::group_paragraph_content::add_text_object_count() {
    return writeodf::text_object_count(&xml);
}
inline writeodf::text_page_continuation
writeodf::group_paragraph_content::add_text_page_continuation(const QString& text_select_page) {
    return writeodf::text_page_continuation(&xml, text_select_page);
}
inline writeodf::text_page_count
writeodf::group_paragraph_content::add_text_page_count() {
    return writeodf::text_page_count(&xml);
}
inline writeodf::text_page_number
writeodf::group_paragraph_content::add_text_page_number() {
    return writeodf::text_page_number(&xml);
}
inline writeodf::text_page_variable_get
writeodf::group_paragraph_content::add_text_page_variable_get() {
    return writeodf::text_page_variable_get(&xml);
}
inline writeodf::text_page_variable_set
writeodf::group_paragraph_content::add_text_page_variable_set() {
    return writeodf::text_page_variable_set(&xml);
}
inline writeodf::text_paragraph_count
writeodf::group_paragraph_content::add_text_paragraph_count() {
    return writeodf::text_paragraph_count(&xml);
}
inline writeodf::text_placeholder
writeodf::group_paragraph_content::add_text_placeholder(const QString& text_placeholder_type) {
    return writeodf::text_placeholder(&xml, text_placeholder_type);
}
inline writeodf::text_print_date
writeodf::group_paragraph_content::add_text_print_date() {
    return writeodf::text_print_date(&xml);
}
inline writeodf::text_print_time
writeodf::group_paragraph_content::add_text_print_time() {
    return writeodf::text_print_time(&xml);
}
inline writeodf::text_printed_by
writeodf::group_paragraph_content::add_text_printed_by() {
    return writeodf::text_printed_by(&xml);
}
inline writeodf::text_reference_mark
writeodf::group_paragraph_content::add_text_reference_mark(const QString& text_name) {
    return writeodf::text_reference_mark(&xml, text_name);
}
inline writeodf::text_reference_mark_end
writeodf::group_paragraph_content::add_text_reference_mark_end(const QString& text_name) {
    return writeodf::text_reference_mark_end(&xml, text_name);
}
inline writeodf::text_reference_mark_start
writeodf::group_paragraph_content::add_text_reference_mark_start(const QString& text_name) {
    return writeodf::text_reference_mark_start(&xml, text_name);
}
inline writeodf::text_reference_ref
writeodf::group_paragraph_content::add_text_reference_ref() {
    return writeodf::text_reference_ref(&xml);
}
inline writeodf::text_ruby
writeodf::group_paragraph_content::add_text_ruby() {
    return writeodf::text_ruby(&xml);
}
inline writeodf::text_s
writeodf::group_paragraph_content::add_text_s() {
    return writeodf::text_s(&xml);
}
inline writeodf::text_script
writeodf::group_paragraph_content::add_text_script() {
    return writeodf::text_script(&xml);
}
inline writeodf::text_sender_city
writeodf::group_paragraph_content::add_text_sender_city() {
    return writeodf::text_sender_city(&xml);
}
inline writeodf::text_sender_company
writeodf::group_paragraph_content::add_text_sender_company() {
    return writeodf::text_sender_company(&xml);
}
inline writeodf::text_sender_country
writeodf::group_paragraph_content::add_text_sender_country() {
    return writeodf::text_sender_country(&xml);
}
inline writeodf::text_sender_email
writeodf::group_paragraph_content::add_text_sender_email() {
    return writeodf::text_sender_email(&xml);
}
inline writeodf::text_sender_fax
writeodf::group_paragraph_content::add_text_sender_fax() {
    return writeodf::text_sender_fax(&xml);
}
inline writeodf::text_sender_firstname
writeodf::group_paragraph_content::add_text_sender_firstname() {
    return writeodf::text_sender_firstname(&xml);
}
inline writeodf::text_sender_initials
writeodf::group_paragraph_content::add_text_sender_initials() {
    return writeodf::text_sender_initials(&xml);
}
inline writeodf::text_sender_lastname
writeodf::group_paragraph_content::add_text_sender_lastname() {
    return writeodf::text_sender_lastname(&xml);
}
inline writeodf::text_sender_phone_private
writeodf::group_paragraph_content::add_text_sender_phone_private() {
    return writeodf::text_sender_phone_private(&xml);
}
inline writeodf::text_sender_phone_work
writeodf::group_paragraph_content::add_text_sender_phone_work() {
    return writeodf::text_sender_phone_work(&xml);
}
inline writeodf::text_sender_position
writeodf::group_paragraph_content::add_text_sender_position() {
    return writeodf::text_sender_position(&xml);
}
inline writeodf::text_sender_postal_code
writeodf::group_paragraph_content::add_text_sender_postal_code() {
    return writeodf::text_sender_postal_code(&xml);
}
inline writeodf::text_sender_state_or_province
writeodf::group_paragraph_content::add_text_sender_state_or_province() {
    return writeodf::text_sender_state_or_province(&xml);
}
inline writeodf::text_sender_street
writeodf::group_paragraph_content::add_text_sender_street() {
    return writeodf::text_sender_street(&xml);
}
inline writeodf::text_sender_title
writeodf::group_paragraph_content::add_text_sender_title() {
    return writeodf::text_sender_title(&xml);
}
inline writeodf::text_sequence
writeodf::group_paragraph_content::add_text_sequence(const QString& text_name) {
    return writeodf::text_sequence(&xml, text_name);
}
inline writeodf::text_sequence_ref
writeodf::group_paragraph_content::add_text_sequence_ref() {
    return writeodf::text_sequence_ref(&xml);
}
inline writeodf::text_sheet_name
writeodf::group_paragraph_content::add_text_sheet_name() {
    return writeodf::text_sheet_name(&xml);
}
inline writeodf::text_span
writeodf::group_paragraph_content::add_text_span() {
    return writeodf::text_span(&xml);
}
inline writeodf::text_subject
writeodf::group_paragraph_content::add_text_subject() {
    return writeodf::text_subject(&xml);
}
inline writeodf::text_tab
writeodf::group_paragraph_content::add_text_tab() {
    return writeodf::text_tab(&xml);
}
inline writeodf::text_table_count
writeodf::group_paragraph_content::add_text_table_count() {
    return writeodf::text_table_count(&xml);
}
inline writeodf::text_table_formula
writeodf::group_paragraph_content::add_text_table_formula() {
    return writeodf::text_table_formula(&xml);
}
inline writeodf::text_template_name
writeodf::group_paragraph_content::add_text_template_name() {
    return writeodf::text_template_name(&xml);
}
inline writeodf::text_text_input
writeodf::group_paragraph_content::add_text_text_input() {
    return writeodf::text_text_input(&xml);
}
inline writeodf::text_time
writeodf::group_paragraph_content::add_text_time() {
    return writeodf::text_time(&xml);
}
inline writeodf::text_title
writeodf::group_paragraph_content::add_text_title() {
    return writeodf::text_title(&xml);
}
inline writeodf::text_toc_mark
writeodf::group_paragraph_content::add_text_toc_mark(const QString& text_string_value) {
    return writeodf::text_toc_mark(&xml, text_string_value);
}
inline writeodf::text_toc_mark_end
writeodf::group_paragraph_content::add_text_toc_mark_end(const QString& text_id) {
    return writeodf::text_toc_mark_end(&xml, text_id);
}
inline writeodf::text_toc_mark_start
writeodf::group_paragraph_content::add_text_toc_mark_start(const QString& text_id) {
    return writeodf::text_toc_mark_start(&xml, text_id);
}
inline writeodf::text_user_defined
writeodf::group_paragraph_content::add_text_user_defined(const QString& text_name) {
    return writeodf::text_user_defined(&xml, text_name);
}
inline writeodf::text_user_field_get
writeodf::group_paragraph_content::add_text_user_field_get(const QString& text_name) {
    return writeodf::text_user_field_get(&xml, text_name);
}
inline writeodf::text_user_field_input
writeodf::group_paragraph_content::add_text_user_field_input(const QString& text_name) {
    return writeodf::text_user_field_input(&xml, text_name);
}
inline writeodf::text_user_index_mark
writeodf::group_paragraph_content::add_text_user_index_mark(const QString& text_index_name, const QString& text_string_value) {
    return writeodf::text_user_index_mark(&xml, text_index_name, text_string_value);
}
inline writeodf::text_user_index_mark_end
writeodf::group_paragraph_content::add_text_user_index_mark_end(const QString& text_id) {
    return writeodf::text_user_index_mark_end(&xml, text_id);
}
inline writeodf::text_user_index_mark_start
writeodf::group_paragraph_content::add_text_user_index_mark_start(const QString& text_id, const QString& text_index_name) {
    return writeodf::text_user_index_mark_start(&xml, text_id, text_index_name);
}
inline writeodf::text_variable_get
writeodf::group_paragraph_content::add_text_variable_get(const QString& text_name) {
    return writeodf::text_variable_get(&xml, text_name);
}
inline writeodf::text_variable_input
writeodf::group_paragraph_content::add_text_variable_input(const QString& office_value_type, const QString& text_name) {
    return writeodf::text_variable_input(&xml, office_value_type, text_name);
}
inline writeodf::text_variable_set
writeodf::group_paragraph_content::add_text_variable_set(const QString& text_name) {
    return writeodf::text_variable_set(&xml, text_name);
}
inline writeodf::text_word_count
writeodf::group_paragraph_content::add_text_word_count() {
    return writeodf::text_word_count(&xml);
}
inline writeodf::text_alphabetical_index_source
writeodf::text_alphabetical_index::add_text_alphabetical_index_source() {
    return writeodf::text_alphabetical_index_source(this);
}
inline writeodf::text_bibliography_source
writeodf::text_bibliography::add_text_bibliography_source() {
    return writeodf::text_bibliography_source(this);
}
inline writeodf::text_illustration_index_source
writeodf::text_illustration_index::add_text_illustration_index_source() {
    return writeodf::text_illustration_index_source(this);
}
inline writeodf::text_object_index_source
writeodf::text_object_index::add_text_object_index_source() {
    return writeodf::text_object_index_source(this);
}
inline writeodf::text_table_of_content_source
writeodf::text_table_of_content::add_text_table_of_content_source() {
    return writeodf::text_table_of_content_source(this);
}
inline writeodf::text_user_index_entry_template
writeodf::text_user_index_source::add_text_user_index_entry_template(quint64 text_outline_level, const QString& text_style_name) {
    return writeodf::text_user_index_entry_template(this, text_outline_level, text_style_name);
}
inline writeodf::text_a
writeodf::group_paragraph_content_or_hyperlink::add_text_a(const QUrl& xlink_href) {
    return writeodf::text_a(&xml, xlink_href);
}
inline writeodf::text_list_header
writeodf::text_list::add_text_list_header() {
    return writeodf::text_list_header(this);
}
inline writeodf::text_list_item
writeodf::text_list::add_text_list_item() {
    return writeodf::text_list_item(this);
}
inline writeodf::text_numbered_paragraph
writeodf::group_text_content::add_text_numbered_paragraph(const QString& text_list_id) {
    return writeodf::text_numbered_paragraph(&xml, text_list_id);
}
inline writeodf::text_index_entry_bibliography
writeodf::text_bibliography_entry_template::add_text_index_entry_bibliography(const QString& text_bibliography_data_field) {
    return writeodf::text_index_entry_bibliography(this, text_bibliography_data_field);
}
inline writeodf::text_section_source
writeodf::text_section::add_text_section_source() {
    return writeodf::text_section_source(this);
}
inline writeodf::text_table_index_source
writeodf::text_table_index::add_text_table_index_source() {
    return writeodf::text_table_index_source(this);
}
inline writeodf::text_user_index_source
writeodf::text_user_index::add_text_user_index_source(const QString& text_index_name) {
    return writeodf::text_user_index_source(this, text_index_name);
}
#endif
