// This file was automatically generated from records.xml
#ifndef SWINDER_RECORDS_H
#define SWINDER_RECORDS_H

#include "utils.h"

namespace Swinder {

void registerRecordClasses();

class BackupRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BackupRecord(Swinder::Workbook *book);
    virtual ~BackupRecord() override;

    BackupRecord( const BackupRecord& record );
    BackupRecord& operator=( const BackupRecord& record );

    bool isBackupEnabled() const;
    void setBackupEnabled( bool backupEnabled );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Backup"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BOFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BOFRecord(Swinder::Workbook *book);
    virtual ~BOFRecord() override;

    BOFRecord( const BOFRecord& record );
    BOFRecord& operator=( const BOFRecord& record );

    enum Type {
        Workbook = 0x0005,
        VBModule = 0x0006,
        Worksheet = 0x0010,
        Chart = 0x0020,
        MacroSheet = 0x0040,
        Workspace = 0x0100
    };

    static QString typeToString(Type type);

    enum VerXLHigh {
        HExcel97 = 0x0,
        HExcel2000 = 0x1,
        HExcel2002 = 0x2,
        HExcel2003 = 0x3,
        HExcel2007 = 0x4,
        HExcel2010 = 0x6
    };

    static QString verXLHighToString(VerXLHigh verXLHigh);

    enum VerLastXLSaved {
        LExcel97 = 0x0,
        LExcel2000 = 0x1,
        LExcel2002 = 0x2,
        LExcel2003 = 0x3,
        LExcel2007 = 0x4,
        LExcel2010 = 0x6
    };

    static QString verLastXLSavedToString(VerLastXLSaved verLastXLSaved);

    unsigned build() const;
    void setBuild( unsigned build );

    bool isFBeta() const;
    void setFBeta( bool fBeta );

    bool isFBetaAny() const;
    void setFBetaAny( bool fBetaAny );

    bool isFFontLimit() const;
    void setFFontLimit( bool fFontLimit );

    bool isFGIJmp() const;
    void setFGIJmp( bool fGIJmp );

    bool isFMacAny() const;
    void setFMacAny( bool fMacAny );

    bool isFOOM() const;
    void setFOOM( bool fOOM );

    bool isFRisc() const;
    void setFRisc( bool fRisc );

    bool isFRiscAny() const;
    void setFRiscAny( bool fRiscAny );

    bool isFWin() const;
    void setFWin( bool fWin );

    bool isFWinAny() const;
    void setFWinAny( bool fWinAny );

    unsigned rawVersion() const;
    void setRawVersion( unsigned rawVersion );

    Type type() const;
    void setType( Type type );

    VerLastXLSaved verLastXLSaved() const;
    void setVerLastXLSaved( VerLastXLSaved verLastXLSaved );

    unsigned verLowestBiff() const;
    void setVerLowestBiff( unsigned verLowestBiff );

    VerXLHigh verXLHigh() const;
    void setVerXLHigh( VerXLHigh verXLHigh );

    unsigned year() const;
    void setYear( unsigned year );

    unsigned version() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BOF"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class EOFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    EOFRecord(Swinder::Workbook *book);
    virtual ~EOFRecord() override;

    EOFRecord( const EOFRecord& record );
    EOFRecord& operator=( const EOFRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "EOF"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BlankRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BlankRecord(Swinder::Workbook *book);
    virtual ~BlankRecord() override;

    BlankRecord( const BlankRecord& record );
    BlankRecord& operator=( const BlankRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Blank"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BoolErrRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BoolErrRecord(Swinder::Workbook *book);
    virtual ~BoolErrRecord() override;

    BoolErrRecord( const BoolErrRecord& record );
    BoolErrRecord& operator=( const BoolErrRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    bool isError() const;
    void setError( bool error );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned value() const;
    void setValue( unsigned value );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    Value asValue() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BoolErr"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class StartBlockRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    StartBlockRecord(Swinder::Workbook *book);
    virtual ~StartBlockRecord() override;

    StartBlockRecord( const StartBlockRecord& record );
    StartBlockRecord& operator=( const StartBlockRecord& record );

    unsigned frtHeaderOld() const;
    void setFrtHeaderOld( unsigned frtHeaderOld );

    unsigned iObjectContext() const;
    void setIObjectContext( unsigned iObjectContext );

    unsigned iObjectInstance1() const;
    void setIObjectInstance1( unsigned iObjectInstance1 );

    unsigned iObjectInstance2() const;
    void setIObjectInstance2( unsigned iObjectInstance2 );

    unsigned iObjectKind() const;
    void setIObjectKind( unsigned iObjectKind );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "StartBlock"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class EndBlockRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    EndBlockRecord(Swinder::Workbook *book);
    virtual ~EndBlockRecord() override;

    EndBlockRecord( const EndBlockRecord& record );
    EndBlockRecord& operator=( const EndBlockRecord& record );

    unsigned frtHeaderOld() const;
    void setFrtHeaderOld( unsigned frtHeaderOld );

    unsigned iObjectKind() const;
    void setIObjectKind( unsigned iObjectKind );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "EndBlock"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ShapePropsStreamRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ShapePropsStreamRecord(Swinder::Workbook *book);
    virtual ~ShapePropsStreamRecord() override;

    ShapePropsStreamRecord( const ShapePropsStreamRecord& record );
    ShapePropsStreamRecord& operator=( const ShapePropsStreamRecord& record );

    unsigned cb() const;
    void setCb( unsigned cb );

    unsigned dwChecksum() const;
    void setDwChecksum( unsigned dwChecksum );

    unsigned grbitFrt() const;
    void setGrbitFrt( unsigned grbitFrt );

    QString rgb() const;
    void setRgb( QString rgb );

    unsigned rt() const;
    void setRt( unsigned rt );

    unsigned unused() const;
    void setUnused( unsigned unused );

    unsigned wObjContext() const;
    void setWObjContext( unsigned wObjContext );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ShapePropsStream"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class TextPropsStreamRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    TextPropsStreamRecord(Swinder::Workbook *book);
    virtual ~TextPropsStreamRecord() override;

    TextPropsStreamRecord( const TextPropsStreamRecord& record );
    TextPropsStreamRecord& operator=( const TextPropsStreamRecord& record );

    unsigned cb() const;
    void setCb( unsigned cb );

    unsigned dwChecksum() const;
    void setDwChecksum( unsigned dwChecksum );

    unsigned grbitFrt() const;
    void setGrbitFrt( unsigned grbitFrt );

    QString rgb() const;
    void setRgb( QString rgb );

    unsigned rt() const;
    void setRt( unsigned rt );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "TextPropsStream"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ChartFrtInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ChartFrtInfoRecord(Swinder::Workbook *book);
    virtual ~ChartFrtInfoRecord() override;

    ChartFrtInfoRecord( const ChartFrtInfoRecord& record );
    ChartFrtInfoRecord& operator=( const ChartFrtInfoRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ChartFrtInfo"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DataLabelExtContentsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DataLabelExtContentsRecord(Swinder::Workbook *book);
    virtual ~DataLabelExtContentsRecord() override;

    DataLabelExtContentsRecord( const DataLabelExtContentsRecord& record );
    DataLabelExtContentsRecord& operator=( const DataLabelExtContentsRecord& record );

    bool isFBubSize() const;
    void setFBubSize( bool fBubSize );

    bool isFCatName() const;
    void setFCatName( bool fCatName );

    bool isFPercent() const;
    void setFPercent( bool fPercent );

    bool isFSerName() const;
    void setFSerName( bool fSerName );

    bool isFValue() const;
    void setFValue( bool fValue );

    unsigned grbitFrt() const;
    void setGrbitFrt( unsigned grbitFrt );

    unsigned rt() const;
    void setRt( unsigned rt );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DataLabelExtContents"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ChartLayout12ARecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ChartLayout12ARecord(Swinder::Workbook *book);
    virtual ~ChartLayout12ARecord() override;

    ChartLayout12ARecord( const ChartLayout12ARecord& record );
    ChartLayout12ARecord& operator=( const ChartLayout12ARecord& record );

    unsigned dwChecksum() const;
    void setDwChecksum( unsigned dwChecksum );

    double dx() const;
    void setDx( double dx );

    double dy() const;
    void setDy( double dy );

    bool isFLayoutTargetInner() const;
    void setFLayoutTargetInner( bool fLayoutTargetInner );

    unsigned grbitFrt() const;
    void setGrbitFrt( unsigned grbitFrt );

    unsigned rt() const;
    void setRt( unsigned rt );

    unsigned wHeightMode() const;
    void setWHeightMode( unsigned wHeightMode );

    unsigned wWidthMode() const;
    void setWWidthMode( unsigned wWidthMode );

    unsigned wXMode() const;
    void setWXMode( unsigned wXMode );

    unsigned wYMode() const;
    void setWYMode( unsigned wYMode );

    double x() const;
    void setX( double x );

    int xBR() const;
    void setXBR( int xBR );

    int xTL() const;
    void setXTL( int xTL );

    double y() const;
    void setY( double y );

    int yBR() const;
    void setYBR( int yBR );

    int yTL() const;
    void setYTL( int yTL );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ChartLayout12A"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LeftMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LeftMarginRecord(Swinder::Workbook *book);
    virtual ~LeftMarginRecord() override;

    LeftMarginRecord( const LeftMarginRecord& record );
    LeftMarginRecord& operator=( const LeftMarginRecord& record );

    double leftMargin() const;
    void setLeftMargin( double leftMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "LeftMargin"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RightMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RightMarginRecord(Swinder::Workbook *book);
    virtual ~RightMarginRecord() override;

    RightMarginRecord( const RightMarginRecord& record );
    RightMarginRecord& operator=( const RightMarginRecord& record );

    double rightMargin() const;
    void setRightMargin( double rightMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RightMargin"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class TopMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    TopMarginRecord(Swinder::Workbook *book);
    virtual ~TopMarginRecord() override;

    TopMarginRecord( const TopMarginRecord& record );
    TopMarginRecord& operator=( const TopMarginRecord& record );

    double topMargin() const;
    void setTopMargin( double topMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "TopMargin"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BottomMarginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BottomMarginRecord(Swinder::Workbook *book);
    virtual ~BottomMarginRecord() override;

    BottomMarginRecord( const BottomMarginRecord& record );
    BottomMarginRecord& operator=( const BottomMarginRecord& record );

    double bottomMargin() const;
    void setBottomMargin( double bottomMargin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BottomMargin"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BoundSheetRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BoundSheetRecord(Swinder::Workbook *book);
    virtual ~BoundSheetRecord() override;

    BoundSheetRecord( const BoundSheetRecord& record );
    BoundSheetRecord& operator=( const BoundSheetRecord& record );

    enum SheetState {
        Visible = 0,
        Hidden = 1,
        StrongHidden = 2
    };

    static QString sheetStateToString(SheetState sheetState);

    enum SheetType {
        Worksheet = 0x00,
        Chart = 0x02,
        VBModule = 0x06
    };

    static QString sheetTypeToString(SheetType sheetType);

    unsigned bofPosition() const;
    void setBofPosition( unsigned bofPosition );

    QString sheetName() const;
    void setSheetName( QString sheetName );

    unsigned sheetNameLength() const;
    void setSheetNameLength( unsigned sheetNameLength );

    SheetState sheetState() const;
    void setSheetState( SheetState sheetState );

    SheetType sheetType() const;
    void setSheetType( SheetType sheetType );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BoundSheet"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcModeRecord(Swinder::Workbook *book);
    virtual ~CalcModeRecord() override;

    CalcModeRecord( const CalcModeRecord& record );
    CalcModeRecord& operator=( const CalcModeRecord& record );

    enum CalcMode {
        Manual = 0,
        Automatic = 1,
        SemiAutomatic = -1
    };

    static QString calcModeToString(CalcMode calcMode);

    CalcMode calcMode() const;
    void setCalcMode( CalcMode calcMode );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcMode"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ColInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ColInfoRecord(Swinder::Workbook *book);
    virtual ~ColInfoRecord() override;

    ColInfoRecord( const ColInfoRecord& record );
    ColInfoRecord& operator=( const ColInfoRecord& record );

    bool isBestFit() const;
    void setBestFit( bool bestFit );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    bool isHidden() const;
    void setHidden( bool hidden );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    bool isNonDefaultWidth() const;
    void setNonDefaultWidth( bool nonDefaultWidth );

    bool isNotCollapsed() const;
    void setNotCollapsed( bool notCollapsed );

    unsigned outlineLevel() const;
    void setOutlineLevel( unsigned outlineLevel );

    bool isShowPhonetic() const;
    void setShowPhonetic( bool showPhonetic );

    unsigned width() const;
    void setWidth( unsigned width );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    bool isCollapsed() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ColInfo"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DataTableRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DataTableRecord(Swinder::Workbook *book);
    virtual ~DataTableRecord() override;

    DataTableRecord( const DataTableRecord& record );
    DataTableRecord& operator=( const DataTableRecord& record );

    enum Direction {
        InputRow,
        InputColumn,
        Input2D
    };

    static QString directionToString(Direction direction);

    bool isAlwaysCalc() const;
    void setAlwaysCalc( bool alwaysCalc );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned firstRow() const;
    void setFirstRow( unsigned firstRow );

    unsigned inputColumn1() const;
    void setInputColumn1( unsigned inputColumn1 );

    unsigned inputColumn2() const;
    void setInputColumn2( unsigned inputColumn2 );

    unsigned inputRow1() const;
    void setInputRow1( unsigned inputRow1 );

    unsigned inputRow2() const;
    void setInputRow2( unsigned inputRow2 );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned lastRow() const;
    void setLastRow( unsigned lastRow );

    bool isRowColTable() const;
    void setRowColTable( bool rowColTable );

    bool isRowInput() const;
    void setRowInput( bool rowInput );

    Direction direction() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DataTable"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DateModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DateModeRecord(Swinder::Workbook *book);
    virtual ~DateModeRecord() override;

    DateModeRecord( const DateModeRecord& record );
    DateModeRecord& operator=( const DateModeRecord& record );

    bool isBase1904() const;
    void setBase1904( bool base1904 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DateMode"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DimensionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DimensionRecord(Swinder::Workbook *book);
    virtual ~DimensionRecord() override;

    DimensionRecord( const DimensionRecord& record );
    DimensionRecord& operator=( const DimensionRecord& record );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned firstRow() const;
    void setFirstRow( unsigned firstRow );

    unsigned lastColumnPlus1() const;
    void setLastColumnPlus1( unsigned lastColumnPlus1 );

    unsigned lastRowPlus1() const;
    void setLastRowPlus1( unsigned lastRowPlus1 );

    unsigned lastRow() const;

    unsigned lastColumn() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Dimension"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ExternSheetRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ExternSheetRecord(Swinder::Workbook *book);
    virtual ~ExternSheetRecord() override;

    ExternSheetRecord( const ExternSheetRecord& record );
    ExternSheetRecord& operator=( const ExternSheetRecord& record );

    unsigned bookRef( unsigned index ) const;
    void setBookRef( unsigned index, unsigned bookRef );

    unsigned firstSheetRef( unsigned index ) const;
    void setFirstSheetRef( unsigned index, unsigned firstSheetRef );

    unsigned lastSheetRef( unsigned index ) const;
    void setLastSheetRef( unsigned index, unsigned lastSheetRef );

    unsigned refCount() const;
    void setRefCount( unsigned refCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ExternSheet"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FontRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FontRecord(Swinder::Workbook *book);
    virtual ~FontRecord() override;

    FontRecord( const FontRecord& record );
    FontRecord& operator=( const FontRecord& record );

    enum Escapement {
        Normal = 0,
        Superscript = 1,
        Subscript = 2
    };

    static QString escapementToString(Escapement escapement);

    enum Underline {
        None = 0,
        Single = 1,
        Double = 2,
        SingleAccounting = 0x21,
        DoubleAccounting = 0x22
    };

    static QString underlineToString(Underline underline);

    enum FontFamily {
        Unknown = 0,
        Roman = 1,
        Swiss = 2,
        Modern = 3,
        Script = 4,
        Decorative = 5
    };

    static QString fontFamilyToString(FontFamily fontFamily);

    unsigned characterSet() const;
    void setCharacterSet( unsigned characterSet );

    unsigned colorIndex() const;
    void setColorIndex( unsigned colorIndex );

    bool isCondensed() const;
    void setCondensed( bool condensed );

    Escapement escapement() const;
    void setEscapement( Escapement escapement );

    bool isExtended() const;
    void setExtended( bool extended );

    FontFamily fontFamily() const;
    void setFontFamily( FontFamily fontFamily );

    QString fontName() const;
    void setFontName( QString fontName );

    unsigned fontNameLength() const;
    void setFontNameLength( unsigned fontNameLength );

    unsigned fontWeight() const;
    void setFontWeight( unsigned fontWeight );

    unsigned height() const;
    void setHeight( unsigned height );

    bool isItalic() const;
    void setItalic( bool italic );

    bool isOutline() const;
    void setOutline( bool outline );

    bool isShadow() const;
    void setShadow( bool shadow );

    bool isStrikeout() const;
    void setStrikeout( bool strikeout );

    Underline underline() const;
    void setUnderline( Underline underline );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Font"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HeaderRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HeaderRecord(Swinder::Workbook *book);
    virtual ~HeaderRecord() override;

    HeaderRecord( const HeaderRecord& record );
    HeaderRecord& operator=( const HeaderRecord& record );

    QString header() const;
    void setHeader( QString header );

    unsigned headerLength() const;
    void setHeaderLength( unsigned headerLength );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Header"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FooterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FooterRecord(Swinder::Workbook *book);
    virtual ~FooterRecord() override;

    FooterRecord( const FooterRecord& record );
    FooterRecord& operator=( const FooterRecord& record );

    QString footer() const;
    void setFooter( QString footer );

    unsigned footerLength() const;
    void setFooterLength( unsigned footerLength );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Footer"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FormatRecord(Swinder::Workbook *book);
    virtual ~FormatRecord() override;

    FormatRecord( const FormatRecord& record );
    FormatRecord& operator=( const FormatRecord& record );

    QString formatString() const;
    void setFormatString( QString formatString );

    unsigned formatStringLength() const;
    void setFormatStringLength( unsigned formatStringLength );

    unsigned index() const;
    void setIndex( unsigned index );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Format"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class XFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    XFRecord(Swinder::Workbook *book);
    virtual ~XFRecord() override;

    XFRecord( const XFRecord& record );
    XFRecord& operator=( const XFRecord& record );

    enum HorizontalAlignment {
        Unspecified = 0xFF,
        General = 0,
        Left = 1,
        Centered = 2,
        Right = 3,
        Filled = 4,
        Justified = 5,
        CenteredSelection = 6,
        Distributed = 7
    };

    static QString horizontalAlignmentToString(HorizontalAlignment horizontalAlignment);

    enum VerticalAlignment {
        Top = 0,
        VCentered = 1,
        Bottom = 2,
        VJustified = 3,
        VDistributed = 4
    };

    static QString verticalAlignmentToString(VerticalAlignment verticalAlignment);

    enum ReadingOrder {
        Context = 0,
        LeftToRight = 1,
        RightToLeft = 2
    };

    static QString readingOrderToString(ReadingOrder readingOrder);

    enum BorderStyle {
        NoLine = 0,
        Thin = 1,
        Medium = 2,
        Dashed = 3,
        Dotted = 4,
        Thick = 5,
        Double = 6,
        Hair = 7,
        MediumDashed = 8,
        ThinDashDotted = 9,
        MediumDashDotted = 10,
        ThinDashDotDotted = 11,
        MediumDashDotDotted = 12,
        SlantedMediumDashDotted = 13
    };

    static QString borderStyleToString(BorderStyle BorderStyle);

    enum FillPattern {
        Null = 0,
        Solid = 1,
        MediumGray = 2,
        DarkGray = 3,
        LightGray = 4,
        Horizontal = 5,
        Vertical = 6,
        DiagonalDown = 7,
        DiagonalUp = 8,
        DiagonalGrid = 9,
        ThickDiagonalGrid = 10,
        ThinHorizontal = 11,
        ThinVertical = 12,
        ThinDiagonalDown = 13,
        ThinDiagonalUp,
        ThinGrid = 15,
        ThinDiagonalGrid = 16,
        Gray1250 = 17,
        Gray0625 = 18
    };

    static QString fillPatternToString(FillPattern FillPattern);

    unsigned bottomBorderColor() const;
    void setBottomBorderColor( unsigned bottomBorderColor );

    BorderStyle bottomBorderStyle() const;
    void setBottomBorderStyle( BorderStyle bottomBorderStyle );

    unsigned diagonalBorderColor() const;
    void setDiagonalBorderColor( unsigned diagonalBorderColor );

    BorderStyle diagonalBorderStyle() const;
    void setDiagonalBorderStyle( BorderStyle diagonalBorderStyle );

    bool isDiagonalBottomLeftBorder() const;
    void setDiagonalBottomLeftBorder( bool diagonalBottomLeftBorder );

    bool isDiagonalTopLeftBorder() const;
    void setDiagonalTopLeftBorder( bool diagonalTopLeftBorder );

    bool isDontUpdateAlcFromParent() const;
    void setDontUpdateAlcFromParent( bool dontUpdateAlcFromParent );

    bool isDontUpdateBackgroundFromParent() const;
    void setDontUpdateBackgroundFromParent( bool dontUpdateBackgroundFromParent );

    bool isDontUpdateBorderFromParent() const;
    void setDontUpdateBorderFromParent( bool dontUpdateBorderFromParent );

    bool isDontUpdateFontFromParent() const;
    void setDontUpdateFontFromParent( bool dontUpdateFontFromParent );

    bool isDontUpdateNumberFormatFromParent() const;
    void setDontUpdateNumberFormatFromParent( bool dontUpdateNumberFormatFromParent );

    bool isDontUpdateProtectionFromParent() const;
    void setDontUpdateProtectionFromParent( bool dontUpdateProtectionFromParent );

    FillPattern fillPattern() const;
    void setFillPattern( FillPattern fillPattern );

    unsigned fontIndex() const;
    void setFontIndex( unsigned fontIndex );

    unsigned formatIndex() const;
    void setFormatIndex( unsigned formatIndex );

    bool isFormulaHidden() const;
    void setFormulaHidden( bool formulaHidden );

    bool hasPrefixChars() const;
    void setHasPrefixChars( bool hasPrefixChars );

    bool hasXFExt() const;
    void setHasXFExt( bool hasXFExt );

    HorizontalAlignment horizontalAlignment() const;
    void setHorizontalAlignment( HorizontalAlignment horizontalAlignment );

    unsigned indentationLevel() const;
    void setIndentationLevel( unsigned indentationLevel );

    bool isButton() const;
    void setIsButton( bool isButton );

    bool isStyleXF() const;
    void setIsStyleXF( bool isStyleXF );

    bool isLastLineJustified() const;
    void setLastLineJustified( bool lastLineJustified );

    unsigned leftBorderColor() const;
    void setLeftBorderColor( unsigned leftBorderColor );

    BorderStyle leftBorderStyle() const;
    void setLeftBorderStyle( BorderStyle leftBorderStyle );

    bool isLocked() const;
    void setLocked( bool locked );

    unsigned parentStyle() const;
    void setParentStyle( unsigned parentStyle );

    unsigned patternBackColor() const;
    void setPatternBackColor( unsigned patternBackColor );

    unsigned patternForeColor() const;
    void setPatternForeColor( unsigned patternForeColor );

    unsigned rawTextRotation1() const;
    void setRawTextRotation1( unsigned rawTextRotation1 );

    unsigned rawTextRotation97() const;
    void setRawTextRotation97( unsigned rawTextRotation97 );

    ReadingOrder readingOrder() const;
    void setReadingOrder( ReadingOrder readingOrder );

    unsigned rightBorderColor() const;
    void setRightBorderColor( unsigned rightBorderColor );

    BorderStyle rightBorderStyle() const;
    void setRightBorderStyle( BorderStyle rightBorderStyle );

    bool isShrinkToFit() const;
    void setShrinkToFit( bool shrinkToFit );

    bool isTextWrap() const;
    void setTextWrap( bool textWrap );

    unsigned topBorderColor() const;
    void setTopBorderColor( unsigned topBorderColor );

    BorderStyle topBorderStyle() const;
    void setTopBorderStyle( BorderStyle topBorderStyle );

    VerticalAlignment verticalAlignment() const;
    void setVerticalAlignment( VerticalAlignment verticalAlignment );

    int rotationAngle() const;

    bool stackedLetters() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "XF"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LabelRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LabelRecord(Swinder::Workbook *book);
    virtual ~LabelRecord() override;

    LabelRecord( const LabelRecord& record );
    LabelRecord& operator=( const LabelRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    QString label() const;
    void setLabel( QString label );

    unsigned labelLength() const;
    void setLabelLength( unsigned labelLength );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Label"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LabelSSTRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LabelSSTRecord(Swinder::Workbook *book);
    virtual ~LabelSSTRecord() override;

    LabelSSTRecord( const LabelSSTRecord& record );
    LabelSSTRecord& operator=( const LabelSSTRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned sstIndex() const;
    void setSstIndex( unsigned sstIndex );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "LabelSST"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MergedCellsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MergedCellsRecord(Swinder::Workbook *book);
    virtual ~MergedCellsRecord() override;

    MergedCellsRecord( const MergedCellsRecord& record );
    MergedCellsRecord& operator=( const MergedCellsRecord& record );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned firstColumn( unsigned index ) const;
    void setFirstColumn( unsigned index, unsigned firstColumn );

    unsigned firstRow( unsigned index ) const;
    void setFirstRow( unsigned index, unsigned firstRow );

    unsigned lastColumn( unsigned index ) const;
    void setLastColumn( unsigned index, unsigned lastColumn );

    unsigned lastRow( unsigned index ) const;
    void setLastRow( unsigned index, unsigned lastRow );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MergedCells"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MulBlankRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MulBlankRecord(Swinder::Workbook *book);
    virtual ~MulBlankRecord() override;

    MulBlankRecord( const MulBlankRecord& record );
    MulBlankRecord& operator=( const MulBlankRecord& record );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex( unsigned index ) const;
    void setXfIndex( unsigned index, unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MulBlank"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class NumberRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    NumberRecord(Swinder::Workbook *book);
    virtual ~NumberRecord() override;

    NumberRecord( const NumberRecord& record );
    NumberRecord& operator=( const NumberRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    double number() const;
    void setNumber( double number );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Number"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PaletteRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PaletteRecord(Swinder::Workbook *book);
    virtual ~PaletteRecord() override;

    PaletteRecord( const PaletteRecord& record );
    PaletteRecord& operator=( const PaletteRecord& record );

    unsigned blue( unsigned index ) const;
    void setBlue( unsigned index, unsigned blue );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned green( unsigned index ) const;
    void setGreen( unsigned index, unsigned green );

    unsigned red( unsigned index ) const;
    void setRed( unsigned index, unsigned red );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Palette"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RowRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RowRecord(Swinder::Workbook *book);
    virtual ~RowRecord() override;

    RowRecord( const RowRecord& record );
    RowRecord& operator=( const RowRecord& record );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned height() const;
    void setHeight( unsigned height );

    bool isHidden() const;
    void setHidden( bool hidden );

    unsigned lastColumnPlus1() const;
    void setLastColumnPlus1( unsigned lastColumnPlus1 );

    bool isNotCollapsed() const;
    void setNotCollapsed( bool notCollapsed );

    unsigned outlineLevel() const;
    void setOutlineLevel( unsigned outlineLevel );

    unsigned row() const;
    void setRow( unsigned row );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    bool isCollapsed() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Row"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class StringRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    StringRecord(Swinder::Workbook *book);
    virtual ~StringRecord() override;

    StringRecord( const StringRecord& record );
    StringRecord& operator=( const StringRecord& record );

    unsigned stringLength() const;
    void setStringLength( unsigned stringLength );

    QString ustring() const;
    void setUstring( QString ustring );

    Value value() const;

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "String"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class NoteRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    NoteRecord(Swinder::Workbook *book);
    virtual ~NoteRecord() override;

    NoteRecord( const NoteRecord& record );
    NoteRecord& operator=( const NoteRecord& record );

    unsigned column() const;
    void setColumn( unsigned column );

    unsigned idObj() const;
    void setIdObj( unsigned idObj );

    unsigned opts() const;
    void setOpts( unsigned opts );

    unsigned row() const;
    void setRow( unsigned row );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Note"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ProtectRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ProtectRecord(Swinder::Workbook *book);
    virtual ~ProtectRecord() override;

    ProtectRecord( const ProtectRecord& record );
    ProtectRecord& operator=( const ProtectRecord& record );

    bool isLocked() const;
    void setLocked( bool locked );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Protect"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DefaultRowHeightRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DefaultRowHeightRecord(Swinder::Workbook *book);
    virtual ~DefaultRowHeightRecord() override;

    DefaultRowHeightRecord( const DefaultRowHeightRecord& record );
    DefaultRowHeightRecord& operator=( const DefaultRowHeightRecord& record );

    bool isDyZero() const;
    void setDyZero( bool dyZero );

    bool isExAsc() const;
    void setExAsc( bool exAsc );

    bool isExDsc() const;
    void setExDsc( bool exDsc );

    int miyRw() const;
    void setMiyRw( int miyRw );

    int miyRwHidden() const;
    void setMiyRwHidden( int miyRwHidden );

    bool isUnsynced() const;
    void setUnsynced( bool unsynced );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DefaultRowHeight"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DefaultColWidthRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DefaultColWidthRecord(Swinder::Workbook *book);
    virtual ~DefaultColWidthRecord() override;

    DefaultColWidthRecord( const DefaultColWidthRecord& record );
    DefaultColWidthRecord& operator=( const DefaultColWidthRecord& record );

    unsigned cchdefColWidth() const;
    void setCchdefColWidth( unsigned cchdefColWidth );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DefaultColWidth"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HCenterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HCenterRecord(Swinder::Workbook *book);
    virtual ~HCenterRecord() override;

    HCenterRecord( const HCenterRecord& record );
    HCenterRecord& operator=( const HCenterRecord& record );

    bool isCentered() const;
    void setCentered( bool centered );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "HCenter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class VCenterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    VCenterRecord(Swinder::Workbook *book);
    virtual ~VCenterRecord() override;

    VCenterRecord( const VCenterRecord& record );
    VCenterRecord& operator=( const VCenterRecord& record );

    bool isCentered() const;
    void setCentered( bool centered );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "VCenter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SetupRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SetupRecord(Swinder::Workbook *book);
    virtual ~SetupRecord() override;

    SetupRecord( const SetupRecord& record );
    SetupRecord& operator=( const SetupRecord& record );

    enum ErrorPrintMode {
        ErrorsAsDisplayed = 0,
        ErrorsAsBlank = 1,
        ErrorsAsDashes = 2,
        ErrorsAsNA = 3
    };

    static QString errorPrintModeToString(ErrorPrintMode errorPrintMode);

    bool isCommentsAsEndNotes() const;
    void setCommentsAsEndNotes( bool commentsAsEndNotes );

    bool isCustumStartPageNumber() const;
    void setCustumStartPageNumber( bool custumStartPageNumber );

    bool isDraftQuality() const;
    void setDraftQuality( bool draftQuality );

    ErrorPrintMode errorPrintMode() const;
    void setErrorPrintMode( ErrorPrintMode errorPrintMode );

    unsigned fitHeightToPageCount() const;
    void setFitHeightToPageCount( unsigned fitHeightToPageCount );

    unsigned fitWidthToPageCount() const;
    void setFitWidthToPageCount( unsigned fitWidthToPageCount );

    double footerMargin() const;
    void setFooterMargin( double footerMargin );

    bool isGreyscale() const;
    void setGreyscale( bool greyscale );

    double headerMargin() const;
    void setHeaderMargin( double headerMargin );

    bool isLeftToRight() const;
    void setLeftToRight( bool leftToRight );

    bool isNoOrientationSet() const;
    void setNoOrientationSet( bool noOrientationSet );

    bool isNoPaperSizeSet() const;
    void setNoPaperSizeSet( bool noPaperSizeSet );

    unsigned numCopies() const;
    void setNumCopies( unsigned numCopies );

    unsigned paperSize() const;
    void setPaperSize( unsigned paperSize );

    bool isPortrait() const;
    void setPortrait( bool portrait );

    bool isPrintNotes() const;
    void setPrintNotes( bool printNotes );

    unsigned printResolution() const;
    void setPrintResolution( unsigned printResolution );

    unsigned scalePercentage() const;
    void setScalePercentage( unsigned scalePercentage );

    int startingPageNumber() const;
    void setStartingPageNumber( int startingPageNumber );

    unsigned verticalPrintResolution() const;
    void setVerticalPrintResolution( unsigned verticalPrintResolution );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Setup"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CrtLineRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CrtLineRecord(Swinder::Workbook *book);
    virtual ~CrtLineRecord() override;

    CrtLineRecord( const CrtLineRecord& record );
    CrtLineRecord& operator=( const CrtLineRecord& record );

    unsigned identifier() const;
    void setIdentifier( unsigned identifier );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CrtLine"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class UnitsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    UnitsRecord(Swinder::Workbook *book);
    virtual ~UnitsRecord() override;

    UnitsRecord( const UnitsRecord& record );
    UnitsRecord& operator=( const UnitsRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Units"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PrintSizeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PrintSizeRecord(Swinder::Workbook *book);
    virtual ~PrintSizeRecord() override;

    PrintSizeRecord( const PrintSizeRecord& record );
    PrintSizeRecord& operator=( const PrintSizeRecord& record );

    enum PrintSize {
        WorkbookDefaults = 0,
        FillPage = 1,
        FillPageProportionally = 2,
        SizeFromChartRecord = 3
    };

    static QString printSizeToString(PrintSize printSize);

    PrintSize printSize() const;
    void setPrintSize( PrintSize printSize );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PrintSize"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ChartRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ChartRecord(Swinder::Workbook *book);
    virtual ~ChartRecord() override;

    ChartRecord( const ChartRecord& record );
    ChartRecord& operator=( const ChartRecord& record );

    double height() const;
    void setHeight( double height );

    double width() const;
    void setWidth( double width );

    double x() const;
    void setX( double x );

    double y() const;
    void setY( double y );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Chart"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SheetExtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SheetExtRecord(Swinder::Workbook *book);
    virtual ~SheetExtRecord() override;

    SheetExtRecord( const SheetExtRecord& record );
    SheetExtRecord& operator=( const SheetExtRecord& record );

    unsigned cb() const;
    void setCb( unsigned cb );

    unsigned color() const;
    void setColor( unsigned color );

    bool isFCondFmtCalc() const;
    void setFCondFmtCalc( bool fCondFmtCalc );

    bool isFNotPublished() const;
    void setFNotPublished( bool fNotPublished );

    unsigned icvPlain() const;
    void setIcvPlain( unsigned icvPlain );

    unsigned icvPlain12() const;
    void setIcvPlain12( unsigned icvPlain12 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SheetExt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BeginRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BeginRecord(Swinder::Workbook *book);
    virtual ~BeginRecord() override;

    BeginRecord( const BeginRecord& record );
    BeginRecord& operator=( const BeginRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Begin"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class EndRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    EndRecord(Swinder::Workbook *book);
    virtual ~EndRecord() override;

    EndRecord( const EndRecord& record );
    EndRecord& operator=( const EndRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "End"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DataFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DataFormatRecord(Swinder::Workbook *book);
    virtual ~DataFormatRecord() override;

    DataFormatRecord( const DataFormatRecord& record );
    DataFormatRecord& operator=( const DataFormatRecord& record );

    unsigned iss() const;
    void setIss( unsigned iss );

    unsigned xi() const;
    void setXi( unsigned xi );

    unsigned yi() const;
    void setYi( unsigned yi );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DataFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LineFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LineFormatRecord(Swinder::Workbook *book);
    virtual ~LineFormatRecord() override;

    LineFormatRecord( const LineFormatRecord& record );
    LineFormatRecord& operator=( const LineFormatRecord& record );

    enum Lns {
        Solid = 0x0000,
        Dash = 0x0001,
        Dot = 0x0002,
        DashDot = 0x0003,
        DashDotDot = 0x0004,
        None = 0x0005,
        DarkGrayPattern = 0x0006,
        MediumGrayPattern = 0x0007,
        LightGrayPattern = 0x0008
    };

    static QString lnsToString(Lns lns);

    enum We {
        Hairline = 0xFFFF,
        NarrowSingle = 0x0000,
        MediumDouble = 0x0001,
        WideTriple = 0x0002
    };

    static QString weToString(We we);

    unsigned blue() const;
    void setBlue( unsigned blue );

    bool isFAuto() const;
    void setFAuto( bool fAuto );

    bool isFAutoCo() const;
    void setFAutoCo( bool fAutoCo );

    bool isFAxisOn() const;
    void setFAxisOn( bool fAxisOn );

    unsigned green() const;
    void setGreen( unsigned green );

    unsigned icv() const;
    void setIcv( unsigned icv );

    Lns lns() const;
    void setLns( Lns lns );

    unsigned red() const;
    void setRed( unsigned red );

    We we() const;
    void setWe( We we );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "LineFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MarkerFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MarkerFormatRecord(Swinder::Workbook *book);
    virtual ~MarkerFormatRecord() override;

    MarkerFormatRecord( const MarkerFormatRecord& record );
    MarkerFormatRecord& operator=( const MarkerFormatRecord& record );

    unsigned blueBackground() const;
    void setBlueBackground( unsigned blueBackground );

    unsigned blueForeground() const;
    void setBlueForeground( unsigned blueForeground );

    unsigned fAuto() const;
    void setFAuto( unsigned fAuto );

    unsigned fNotShowBrd() const;
    void setFNotShowBrd( unsigned fNotShowBrd );

    unsigned fNotShowInt() const;
    void setFNotShowInt( unsigned fNotShowInt );

    unsigned greenBackground() const;
    void setGreenBackground( unsigned greenBackground );

    unsigned greenForeground() const;
    void setGreenForeground( unsigned greenForeground );

    unsigned icvBack() const;
    void setIcvBack( unsigned icvBack );

    unsigned icvFore() const;
    void setIcvFore( unsigned icvFore );

    unsigned imk() const;
    void setImk( unsigned imk );

    unsigned redBackground() const;
    void setRedBackground( unsigned redBackground );

    unsigned redForeground() const;
    void setRedForeground( unsigned redForeground );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MarkerFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AreaFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AreaFormatRecord(Swinder::Workbook *book);
    virtual ~AreaFormatRecord() override;

    AreaFormatRecord( const AreaFormatRecord& record );
    AreaFormatRecord& operator=( const AreaFormatRecord& record );

    unsigned blueBackground() const;
    void setBlueBackground( unsigned blueBackground );

    unsigned blueForeground() const;
    void setBlueForeground( unsigned blueForeground );

    bool isFAuto() const;
    void setFAuto( bool fAuto );

    bool isFInvertNeg() const;
    void setFInvertNeg( bool fInvertNeg );

    unsigned fls() const;
    void setFls( unsigned fls );

    unsigned greenBackground() const;
    void setGreenBackground( unsigned greenBackground );

    unsigned greenForeground() const;
    void setGreenForeground( unsigned greenForeground );

    unsigned icvBackground() const;
    void setIcvBackground( unsigned icvBackground );

    unsigned icvForeground() const;
    void setIcvForeground( unsigned icvForeground );

    unsigned redBackground() const;
    void setRedBackground( unsigned redBackground );

    unsigned redForeground() const;
    void setRedForeground( unsigned redForeground );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AreaFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PieRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PieRecord(Swinder::Workbook *book);
    virtual ~PieRecord() override;

    PieRecord( const PieRecord& record );
    PieRecord& operator=( const PieRecord& record );

    unsigned anStart() const;
    void setAnStart( unsigned anStart );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFShowLdrLines() const;
    void setFShowLdrLines( bool fShowLdrLines );

    unsigned pcDonut() const;
    void setPcDonut( unsigned pcDonut );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Pie"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PieFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PieFormatRecord(Swinder::Workbook *book);
    virtual ~PieFormatRecord() override;

    PieFormatRecord( const PieFormatRecord& record );
    PieFormatRecord& operator=( const PieFormatRecord& record );

    int pcExplode() const;
    void setPcExplode( int pcExplode );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PieFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AttachedLabelRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AttachedLabelRecord(Swinder::Workbook *book);
    virtual ~AttachedLabelRecord() override;

    AttachedLabelRecord( const AttachedLabelRecord& record );
    AttachedLabelRecord& operator=( const AttachedLabelRecord& record );

    bool isFShowBubbleSizes() const;
    void setFShowBubbleSizes( bool fShowBubbleSizes );

    bool isFShowLabel() const;
    void setFShowLabel( bool fShowLabel );

    bool isFShowLabelAndPerc() const;
    void setFShowLabelAndPerc( bool fShowLabelAndPerc );

    bool isFShowPercent() const;
    void setFShowPercent( bool fShowPercent );

    bool isFShowSeriesName() const;
    void setFShowSeriesName( bool fShowSeriesName );

    bool isFShowValue() const;
    void setFShowValue( bool fShowValue );

    unsigned unused() const;
    void setUnused( unsigned unused );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AttachedLabel"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ChartFormatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ChartFormatRecord(Swinder::Workbook *book);
    virtual ~ChartFormatRecord() override;

    ChartFormatRecord( const ChartFormatRecord& record );
    ChartFormatRecord& operator=( const ChartFormatRecord& record );

    bool isFVaried() const;
    void setFVaried( bool fVaried );

    unsigned icrt() const;
    void setIcrt( unsigned icrt );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ChartFormat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LegendRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LegendRecord(Swinder::Workbook *book);
    virtual ~LegendRecord() override;

    LegendRecord( const LegendRecord& record );
    LegendRecord& operator=( const LegendRecord& record );

    unsigned dx() const;
    void setDx( unsigned dx );

    unsigned dy() const;
    void setDy( unsigned dy );

    bool isFAutoPosX() const;
    void setFAutoPosX( bool fAutoPosX );

    bool isFAutoPosY() const;
    void setFAutoPosY( bool fAutoPosY );

    bool isFAutoPosition() const;
    void setFAutoPosition( bool fAutoPosition );

    bool isFVert() const;
    void setFVert( bool fVert );

    bool isFWasDataTable() const;
    void setFWasDataTable( bool fWasDataTable );

    unsigned unused() const;
    void setUnused( unsigned unused );

    unsigned wSpace() const;
    void setWSpace( unsigned wSpace );

    unsigned x() const;
    void setX( unsigned x );

    unsigned y() const;
    void setY( unsigned y );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Legend"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SeriesListRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SeriesListRecord(Swinder::Workbook *book);
    virtual ~SeriesListRecord() override;

    SeriesListRecord( const SeriesListRecord& record );
    SeriesListRecord& operator=( const SeriesListRecord& record );

    unsigned cser() const;
    void setCser( unsigned cser );

    unsigned rgiser( unsigned index ) const;
    void setRgiser( unsigned index, unsigned rgiser );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SeriesList"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BarRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BarRecord(Swinder::Workbook *book);
    virtual ~BarRecord() override;

    BarRecord( const BarRecord& record );
    BarRecord& operator=( const BarRecord& record );

    bool isF100() const;
    void setF100( bool f100 );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFStacked() const;
    void setFStacked( bool fStacked );

    bool isFTranspose() const;
    void setFTranspose( bool fTranspose );

    unsigned pcGap() const;
    void setPcGap( unsigned pcGap );

    int pcOverlap() const;
    void setPcOverlap( int pcOverlap );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Bar"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LineRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LineRecord(Swinder::Workbook *book);
    virtual ~LineRecord() override;

    LineRecord( const LineRecord& record );
    LineRecord& operator=( const LineRecord& record );

    bool isF100() const;
    void setF100( bool f100 );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFStacked() const;
    void setFStacked( bool fStacked );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Line"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AreaRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AreaRecord(Swinder::Workbook *book);
    virtual ~AreaRecord() override;

    AreaRecord( const AreaRecord& record );
    AreaRecord& operator=( const AreaRecord& record );

    bool isF100() const;
    void setF100( bool f100 );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFStacked() const;
    void setFStacked( bool fStacked );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Area"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ScatterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ScatterRecord(Swinder::Workbook *book);
    virtual ~ScatterRecord() override;

    ScatterRecord( const ScatterRecord& record );
    ScatterRecord& operator=( const ScatterRecord& record );

    bool isFBubbles() const;
    void setFBubbles( bool fBubbles );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFShowNegBubbles() const;
    void setFShowNegBubbles( bool fShowNegBubbles );

    unsigned pcBubbleSizeRatio() const;
    void setPcBubbleSizeRatio( unsigned pcBubbleSizeRatio );

    unsigned wBubbleSize() const;
    void setWBubbleSize( unsigned wBubbleSize );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Scatter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AxisRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AxisRecord(Swinder::Workbook *book);
    virtual ~AxisRecord() override;

    AxisRecord( const AxisRecord& record );
    AxisRecord& operator=( const AxisRecord& record );

    unsigned wType() const;
    void setWType( unsigned wType );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Axis"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class TickRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    TickRecord(Swinder::Workbook *book);
    virtual ~TickRecord() override;

    TickRecord( const TickRecord& record );
    TickRecord& operator=( const TickRecord& record );

    unsigned blue() const;
    void setBlue( unsigned blue );

    bool isFAutoCo() const;
    void setFAutoCo( bool fAutoCo );

    bool isFAutoMode() const;
    void setFAutoMode( bool fAutoMode );

    bool isFAutoRot() const;
    void setFAutoRot( bool fAutoRot );

    unsigned green() const;
    void setGreen( unsigned green );

    unsigned iReadingOrder() const;
    void setIReadingOrder( unsigned iReadingOrder );

    unsigned icv() const;
    void setIcv( unsigned icv );

    unsigned red() const;
    void setRed( unsigned red );

    unsigned rot() const;
    void setRot( unsigned rot );

    unsigned tktMajor() const;
    void setTktMajor( unsigned tktMajor );

    unsigned tktMinor() const;
    void setTktMinor( unsigned tktMinor );

    unsigned tlt() const;
    void setTlt( unsigned tlt );

    unsigned trot() const;
    void setTrot( unsigned trot );

    unsigned unused() const;
    void setUnused( unsigned unused );

    unsigned wBkgMode() const;
    void setWBkgMode( unsigned wBkgMode );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Tick"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ValueRangeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ValueRangeRecord(Swinder::Workbook *book);
    virtual ~ValueRangeRecord() override;

    ValueRangeRecord( const ValueRangeRecord& record );
    ValueRangeRecord& operator=( const ValueRangeRecord& record );

    bool isFAutoCross() const;
    void setFAutoCross( bool fAutoCross );

    bool isFAutoMajor() const;
    void setFAutoMajor( bool fAutoMajor );

    bool isFAutoMax() const;
    void setFAutoMax( bool fAutoMax );

    bool isFAutoMin() const;
    void setFAutoMin( bool fAutoMin );

    bool isFAutoMinor() const;
    void setFAutoMinor( bool fAutoMinor );

    bool isFLog() const;
    void setFLog( bool fLog );

    bool isFMaxCross() const;
    void setFMaxCross( bool fMaxCross );

    bool isFReversed() const;
    void setFReversed( bool fReversed );

    double numCross() const;
    void setNumCross( double numCross );

    double numMajor() const;
    void setNumMajor( double numMajor );

    double numMax() const;
    void setNumMax( double numMax );

    double numMin() const;
    void setNumMin( double numMin );

    double numMinor() const;
    void setNumMinor( double numMinor );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ValueRange"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CatSerRangeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CatSerRangeRecord(Swinder::Workbook *book);
    virtual ~CatSerRangeRecord() override;

    CatSerRangeRecord( const CatSerRangeRecord& record );
    CatSerRangeRecord& operator=( const CatSerRangeRecord& record );

    unsigned catCross() const;
    void setCatCross( unsigned catCross );

    unsigned catLabel() const;
    void setCatLabel( unsigned catLabel );

    unsigned catMark() const;
    void setCatMark( unsigned catMark );

    bool isFBetween() const;
    void setFBetween( bool fBetween );

    bool isFMaxCross() const;
    void setFMaxCross( bool fMaxCross );

    bool isFReverse() const;
    void setFReverse( bool fReverse );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CatSerRange"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CrtLayout12Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CrtLayout12Record(Swinder::Workbook *book);
    virtual ~CrtLayout12Record() override;

    CrtLayout12Record( const CrtLayout12Record& record );
    CrtLayout12Record& operator=( const CrtLayout12Record& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CrtLayout12"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CatLabRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CatLabRecord(Swinder::Workbook *book);
    virtual ~CatLabRecord() override;

    CatLabRecord( const CatLabRecord& record );
    CatLabRecord& operator=( const CatLabRecord& record );

    unsigned at() const;
    void setAt( unsigned at );

    unsigned cAutoCatLabelReal() const;
    void setCAutoCatLabelReal( unsigned cAutoCatLabelReal );

    unsigned grbitFrt() const;
    void setGrbitFrt( unsigned grbitFrt );

    unsigned rt() const;
    void setRt( unsigned rt );

    unsigned wOffset() const;
    void setWOffset( unsigned wOffset );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CatLab"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AxisLineRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AxisLineRecord(Swinder::Workbook *book);
    virtual ~AxisLineRecord() override;

    AxisLineRecord( const AxisLineRecord& record );
    AxisLineRecord& operator=( const AxisLineRecord& record );

    enum Identifier {
        AxisItself = 0x0000,
        MajorGridlinesAlongTheAxis = 0x0001,
        MinorGridlinesAlongTheAxis = 0x0002,
        WallsAndFloorsOf3DChart = 0x0003
    };

    static QString identifierToString(Identifier identifier);

    Identifier identifier() const;
    void setIdentifier( Identifier identifier );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AxisLine"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CrtLinkRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CrtLinkRecord(Swinder::Workbook *book);
    virtual ~CrtLinkRecord() override;

    CrtLinkRecord( const CrtLinkRecord& record );
    CrtLinkRecord& operator=( const CrtLinkRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CrtLink"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DefaultTextRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DefaultTextRecord(Swinder::Workbook *book);
    virtual ~DefaultTextRecord() override;

    DefaultTextRecord( const DefaultTextRecord& record );
    DefaultTextRecord& operator=( const DefaultTextRecord& record );

    enum Identifier {
        ShowPercent0_or_ShowValue0 = 0x0000,
        ShowPercent1_or_ShowValue1 = 0x0001,
        Scalable0 = 0x0002,
        Scalable1 = 0x0003
    };

    static QString identifierToString(Identifier identifier);

    Identifier identifier() const;
    void setIdentifier( Identifier identifier );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DefaultText"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class TextRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    TextRecord(Swinder::Workbook *book);
    virtual ~TextRecord() override;

    TextRecord( const TextRecord& record );
    TextRecord& operator=( const TextRecord& record );

    unsigned at() const;
    void setAt( unsigned at );

    unsigned dx() const;
    void setDx( unsigned dx );

    unsigned dy() const;
    void setDy( unsigned dy );

    bool isFAutoColor() const;
    void setFAutoColor( bool fAutoColor );

    bool isFAutoMode() const;
    void setFAutoMode( bool fAutoMode );

    bool isFAutoText() const;
    void setFAutoText( bool fAutoText );

    bool isFDeleted() const;
    void setFDeleted( bool fDeleted );

    bool isFGenerated() const;
    void setFGenerated( bool fGenerated );

    bool isFShowBubbleSizes() const;
    void setFShowBubbleSizes( bool fShowBubbleSizes );

    bool isFShowKey() const;
    void setFShowKey( bool fShowKey );

    bool isFShowLabel() const;
    void setFShowLabel( bool fShowLabel );

    bool isFShowLabelAndPerc() const;
    void setFShowLabelAndPerc( bool fShowLabelAndPerc );

    bool isFShowPercent() const;
    void setFShowPercent( bool fShowPercent );

    bool isFShowValue() const;
    void setFShowValue( bool fShowValue );

    unsigned icvText() const;
    void setIcvText( unsigned icvText );

    unsigned rgbText() const;
    void setRgbText( unsigned rgbText );

    unsigned unused1() const;
    void setUnused1( unsigned unused1 );

    unsigned unused2() const;
    void setUnused2( unsigned unused2 );

    unsigned vat() const;
    void setVat( unsigned vat );

    unsigned wBkgMode() const;
    void setWBkgMode( unsigned wBkgMode );

    unsigned x() const;
    void setX( unsigned x );

    unsigned y() const;
    void setY( unsigned y );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Text"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FontXRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FontXRecord(Swinder::Workbook *book);
    virtual ~FontXRecord() override;

    FontXRecord( const FontXRecord& record );
    FontXRecord& operator=( const FontXRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "FontX"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ObjectLinkRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ObjectLinkRecord(Swinder::Workbook *book);
    virtual ~ObjectLinkRecord() override;

    ObjectLinkRecord( const ObjectLinkRecord& record );
    ObjectLinkRecord& operator=( const ObjectLinkRecord& record );

    enum WLinkObj {
        EntireChart = 0x0001,
        ValueOrVerticalAxis = 0x0002,
        CategoryOrHorizontalAxis = 0x0003,
        SeriesOrDatapoints = 0x0004,
        SeriesAxis = 0x0007,
        DisplayUnitsLabelsOfAxis = 0x000c
    };

    static QString wLinkObjToString(WLinkObj wLinkObj);

    WLinkObj wLinkObj() const;
    void setWLinkObj( WLinkObj wLinkObj );

    unsigned wLinkVar1() const;
    void setWLinkVar1( unsigned wLinkVar1 );

    unsigned wLinkVar2() const;
    void setWLinkVar2( unsigned wLinkVar2 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ObjectLink"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PlotAreaRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PlotAreaRecord(Swinder::Workbook *book);
    virtual ~PlotAreaRecord() override;

    PlotAreaRecord( const PlotAreaRecord& record );
    PlotAreaRecord& operator=( const PlotAreaRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PlotArea"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MsoDrawingSelectionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MsoDrawingSelectionRecord(Swinder::Workbook *book);
    virtual ~MsoDrawingSelectionRecord() override;

    MsoDrawingSelectionRecord( const MsoDrawingSelectionRecord& record );
    MsoDrawingSelectionRecord& operator=( const MsoDrawingSelectionRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MsoDrawingSelection"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Chart3dRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Chart3dRecord(Swinder::Workbook *book);
    virtual ~Chart3dRecord() override;

    Chart3dRecord( const Chart3dRecord& record );
    Chart3dRecord& operator=( const Chart3dRecord& record );

    int anElev() const;
    void setAnElev( int anElev );

    int anRot() const;
    void setAnRot( int anRot );

    bool isF3DScaling() const;
    void setF3DScaling( bool f3DScaling );

    bool isFCluster() const;
    void setFCluster( bool fCluster );

    bool isFNotPieChart() const;
    void setFNotPieChart( bool fNotPieChart );

    bool isFPerspective() const;
    void setFPerspective( bool fPerspective );

    bool isFWalls2D() const;
    void setFWalls2D( bool fWalls2D );

    int pcDepth() const;
    void setPcDepth( int pcDepth );

    int pcDist() const;
    void setPcDist( int pcDist );

    unsigned pcGap() const;
    void setPcGap( unsigned pcGap );

    unsigned pcHeight() const;
    void setPcHeight( unsigned pcHeight );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Chart3d"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PicFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PicFRecord(Swinder::Workbook *book);
    virtual ~PicFRecord() override;

    PicFRecord( const PicFRecord& record );
    PicFRecord& operator=( const PicFRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PicF"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DropBarRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DropBarRecord(Swinder::Workbook *book);
    virtual ~DropBarRecord() override;

    DropBarRecord( const DropBarRecord& record );
    DropBarRecord& operator=( const DropBarRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DropBar"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RadarRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RadarRecord(Swinder::Workbook *book);
    virtual ~RadarRecord() override;

    RadarRecord( const RadarRecord& record );
    RadarRecord& operator=( const RadarRecord& record );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFRdrAxLab() const;
    void setFRdrAxLab( bool fRdrAxLab );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Radar"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SurfRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SurfRecord(Swinder::Workbook *book);
    virtual ~SurfRecord() override;

    SurfRecord( const SurfRecord& record );
    SurfRecord& operator=( const SurfRecord& record );

    bool isF3DPhongShade() const;
    void setF3DPhongShade( bool f3DPhongShade );

    bool isFFillSurface() const;
    void setFFillSurface( bool fFillSurface );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Surf"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RadarAreaRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RadarAreaRecord(Swinder::Workbook *book);
    virtual ~RadarAreaRecord() override;

    RadarAreaRecord( const RadarAreaRecord& record );
    RadarAreaRecord& operator=( const RadarAreaRecord& record );

    bool isFHasShadow() const;
    void setFHasShadow( bool fHasShadow );

    bool isFRdrAxLab() const;
    void setFRdrAxLab( bool fRdrAxLab );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RadarArea"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AxisParentRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AxisParentRecord(Swinder::Workbook *book);
    virtual ~AxisParentRecord() override;

    AxisParentRecord( const AxisParentRecord& record );
    AxisParentRecord& operator=( const AxisParentRecord& record );

    unsigned iax() const;
    void setIax( unsigned iax );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AxisParent"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LegendExceptionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LegendExceptionRecord(Swinder::Workbook *book);
    virtual ~LegendExceptionRecord() override;

    LegendExceptionRecord( const LegendExceptionRecord& record );
    LegendExceptionRecord& operator=( const LegendExceptionRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "LegendException"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ShtPropsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ShtPropsRecord(Swinder::Workbook *book);
    virtual ~ShtPropsRecord() override;

    ShtPropsRecord( const ShtPropsRecord& record );
    ShtPropsRecord& operator=( const ShtPropsRecord& record );

    bool isFAlwaysAutoPlotArea() const;
    void setFAlwaysAutoPlotArea( bool fAlwaysAutoPlotArea );

    bool isFManPlotArea() const;
    void setFManPlotArea( bool fManPlotArea );

    bool isFManSerAlloc() const;
    void setFManSerAlloc( bool fManSerAlloc );

    bool isFNotSizeWIth() const;
    void setFNotSizeWIth( bool fNotSizeWIth );

    bool isFPlotVisOnly() const;
    void setFPlotVisOnly( bool fPlotVisOnly );

    unsigned mdBlank() const;
    void setMdBlank( unsigned mdBlank );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ShtProps"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SerToCrtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SerToCrtRecord(Swinder::Workbook *book);
    virtual ~SerToCrtRecord() override;

    SerToCrtRecord( const SerToCrtRecord& record );
    SerToCrtRecord& operator=( const SerToCrtRecord& record );

    unsigned identifier() const;
    void setIdentifier( unsigned identifier );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SerToCrt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AxesUsedRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AxesUsedRecord(Swinder::Workbook *book);
    virtual ~AxesUsedRecord() override;

    AxesUsedRecord( const AxesUsedRecord& record );
    AxesUsedRecord& operator=( const AxesUsedRecord& record );

    unsigned cAxes() const;
    void setCAxes( unsigned cAxes );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AxesUsed"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SBaseRefRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SBaseRefRecord(Swinder::Workbook *book);
    virtual ~SBaseRefRecord() override;

    SBaseRefRecord( const SBaseRefRecord& record );
    SBaseRefRecord& operator=( const SBaseRefRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SBaseRef"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SerParentRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SerParentRecord(Swinder::Workbook *book);
    virtual ~SerParentRecord() override;

    SerParentRecord( const SerParentRecord& record );
    SerParentRecord& operator=( const SerParentRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SerParent"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SerAuxTrendRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SerAuxTrendRecord(Swinder::Workbook *book);
    virtual ~SerAuxTrendRecord() override;

    SerAuxTrendRecord( const SerAuxTrendRecord& record );
    SerAuxTrendRecord& operator=( const SerAuxTrendRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SerAuxTrend"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class IFmtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    IFmtRecord(Swinder::Workbook *book);
    virtual ~IFmtRecord() override;

    IFmtRecord( const IFmtRecord& record );
    IFmtRecord& operator=( const IFmtRecord& record );

    unsigned ifmt() const;
    void setIfmt( unsigned ifmt );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "IFmt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PosRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PosRecord(Swinder::Workbook *book);
    virtual ~PosRecord() override;

    PosRecord( const PosRecord& record );
    PosRecord& operator=( const PosRecord& record );

    unsigned mdBotRt() const;
    void setMdBotRt( unsigned mdBotRt );

    unsigned mdTopLt() const;
    void setMdTopLt( unsigned mdTopLt );

    unsigned unused1() const;
    void setUnused1( unsigned unused1 );

    unsigned unused2() const;
    void setUnused2( unsigned unused2 );

    unsigned unused3() const;
    void setUnused3( unsigned unused3 );

    unsigned unused4() const;
    void setUnused4( unsigned unused4 );

    unsigned x1() const;
    void setX1( unsigned x1 );

    unsigned x2() const;
    void setX2( unsigned x2 );

    unsigned y1() const;
    void setY1( unsigned y1 );

    unsigned y2() const;
    void setY2( unsigned y2 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Pos"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AIRunsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AIRunsRecord(Swinder::Workbook *book);
    virtual ~AIRunsRecord() override;

    AIRunsRecord( const AIRunsRecord& record );
    AIRunsRecord& operator=( const AIRunsRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AIRuns"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SerAuxErrBarRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SerAuxErrBarRecord(Swinder::Workbook *book);
    virtual ~SerAuxErrBarRecord() override;

    SerAuxErrBarRecord( const SerAuxErrBarRecord& record );
    SerAuxErrBarRecord& operator=( const SerAuxErrBarRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SerAuxErrBar"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ClrtClientRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ClrtClientRecord(Swinder::Workbook *book);
    virtual ~ClrtClientRecord() override;

    ClrtClientRecord( const ClrtClientRecord& record );
    ClrtClientRecord& operator=( const ClrtClientRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ClrtClient"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SerFmtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SerFmtRecord(Swinder::Workbook *book);
    virtual ~SerFmtRecord() override;

    SerFmtRecord( const SerFmtRecord& record );
    SerFmtRecord& operator=( const SerFmtRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SerFmt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Chart3DBarShapeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Chart3DBarShapeRecord(Swinder::Workbook *book);
    virtual ~Chart3DBarShapeRecord() override;

    Chart3DBarShapeRecord( const Chart3DBarShapeRecord& record );
    Chart3DBarShapeRecord& operator=( const Chart3DBarShapeRecord& record );

    unsigned riser() const;
    void setRiser( unsigned riser );

    unsigned taper() const;
    void setTaper( unsigned taper );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Chart3DBarShape"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FbiRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FbiRecord(Swinder::Workbook *book);
    virtual ~FbiRecord() override;

    FbiRecord( const FbiRecord& record );
    FbiRecord& operator=( const FbiRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Fbi"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BopPopRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BopPopRecord(Swinder::Workbook *book);
    virtual ~BopPopRecord() override;

    BopPopRecord( const BopPopRecord& record );
    BopPopRecord& operator=( const BopPopRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BopPop"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AxcExtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AxcExtRecord(Swinder::Workbook *book);
    virtual ~AxcExtRecord() override;

    AxcExtRecord( const AxcExtRecord& record );
    AxcExtRecord& operator=( const AxcExtRecord& record );

    unsigned catCrossDate() const;
    void setCatCrossDate( unsigned catCrossDate );

    unsigned catMajor() const;
    void setCatMajor( unsigned catMajor );

    unsigned catMax() const;
    void setCatMax( unsigned catMax );

    unsigned catMin() const;
    void setCatMin( unsigned catMin );

    unsigned catMinor() const;
    void setCatMinor( unsigned catMinor );

    unsigned duBase() const;
    void setDuBase( unsigned duBase );

    unsigned duMajor() const;
    void setDuMajor( unsigned duMajor );

    unsigned duMinor() const;
    void setDuMinor( unsigned duMinor );

    bool isFAutoBase() const;
    void setFAutoBase( bool fAutoBase );

    bool isFAutoCross() const;
    void setFAutoCross( bool fAutoCross );

    bool isFAutoDate() const;
    void setFAutoDate( bool fAutoDate );

    bool isFAutoMajor() const;
    void setFAutoMajor( bool fAutoMajor );

    bool isFAutoMax() const;
    void setFAutoMax( bool fAutoMax );

    bool isFAutoMin() const;
    void setFAutoMin( bool fAutoMin );

    bool isFAutoMinor() const;
    void setFAutoMinor( bool fAutoMinor );

    bool isFDateAxis() const;
    void setFDateAxis( bool fDateAxis );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AxcExt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DatRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DatRecord(Swinder::Workbook *book);
    virtual ~DatRecord() override;

    DatRecord( const DatRecord& record );
    DatRecord& operator=( const DatRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Dat"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PlotGrowthRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PlotGrowthRecord(Swinder::Workbook *book);
    virtual ~PlotGrowthRecord() override;

    PlotGrowthRecord( const PlotGrowthRecord& record );
    PlotGrowthRecord& operator=( const PlotGrowthRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PlotGrowth"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SIIndexRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SIIndexRecord(Swinder::Workbook *book);
    virtual ~SIIndexRecord() override;

    SIIndexRecord( const SIIndexRecord& record );
    SIIndexRecord& operator=( const SIIndexRecord& record );

    unsigned numIndex() const;
    void setNumIndex( unsigned numIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SIIndex"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class GelFrameRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    GelFrameRecord(Swinder::Workbook *book);
    virtual ~GelFrameRecord() override;

    GelFrameRecord( const GelFrameRecord& record );
    GelFrameRecord& operator=( const GelFrameRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "GelFrame"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BobPopCustomRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BobPopCustomRecord(Swinder::Workbook *book);
    virtual ~BobPopCustomRecord() override;

    BobPopCustomRecord( const BobPopCustomRecord& record );
    BobPopCustomRecord& operator=( const BobPopCustomRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BobPopCustom"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Fbi2Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Fbi2Record(Swinder::Workbook *book);
    virtual ~Fbi2Record() override;

    Fbi2Record( const Fbi2Record& record );
    Fbi2Record& operator=( const Fbi2Record& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Fbi2"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ZoomLevelRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ZoomLevelRecord(Swinder::Workbook *book);
    virtual ~ZoomLevelRecord() override;

    ZoomLevelRecord( const ZoomLevelRecord& record );
    ZoomLevelRecord& operator=( const ZoomLevelRecord& record );

    int denominator() const;
    void setDenominator( int denominator );

    int numerator() const;
    void setNumerator( int numerator );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ZoomLevel"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FrameRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FrameRecord(Swinder::Workbook *book);
    virtual ~FrameRecord() override;

    FrameRecord( const FrameRecord& record );
    FrameRecord& operator=( const FrameRecord& record );

    enum FrameType {
        SimpleFrame = 0,
        ShadowedFrame = 4
    };

    static QString frameTypeToString(FrameType frameType);

    bool isAutoPosition() const;
    void setAutoPosition( bool autoPosition );

    bool isAutoSize() const;
    void setAutoSize( bool autoSize );

    FrameType frameType() const;
    void setFrameType( FrameType frameType );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Frame"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SeriesRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SeriesRecord(Swinder::Workbook *book);
    virtual ~SeriesRecord() override;

    SeriesRecord( const SeriesRecord& record );
    SeriesRecord& operator=( const SeriesRecord& record );

    enum DataTypeX {
        Numeric = 1,
        Textual = 3
    };

    static QString dataTypeXToString(DataTypeX dataTypeX);

    unsigned bubbleSizeDataType() const;
    void setBubbleSizeDataType( unsigned bubbleSizeDataType );

    unsigned countBubbleSizeValues() const;
    void setCountBubbleSizeValues( unsigned countBubbleSizeValues );

    unsigned countXValues() const;
    void setCountXValues( unsigned countXValues );

    unsigned countYValues() const;
    void setCountYValues( unsigned countYValues );

    DataTypeX dataTypeX() const;
    void setDataTypeX( DataTypeX dataTypeX );

    unsigned dataTypeY() const;
    void setDataTypeY( unsigned dataTypeY );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Series"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SeriesTextRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SeriesTextRecord(Swinder::Workbook *book);
    virtual ~SeriesTextRecord() override;

    SeriesTextRecord( const SeriesTextRecord& record );
    SeriesTextRecord& operator=( const SeriesTextRecord& record );

    unsigned stringLength() const;
    void setStringLength( unsigned stringLength );

    QString text() const;
    void setText( QString text );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "SeriesText"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class GridSetReservedRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    GridSetReservedRecord(Swinder::Workbook *book);
    virtual ~GridSetReservedRecord() override;

    GridSetReservedRecord( const GridSetReservedRecord& record );
    GridSetReservedRecord& operator=( const GridSetReservedRecord& record );

    unsigned gridSetReserved() const;
    void setGridSetReserved( unsigned gridSetReserved );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "GridSetReserved"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Excel9FileRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Excel9FileRecord(Swinder::Workbook *book);
    virtual ~Excel9FileRecord() override;

    Excel9FileRecord( const Excel9FileRecord& record );
    Excel9FileRecord& operator=( const Excel9FileRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Excel9File"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Compat12Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Compat12Record(Swinder::Workbook *book);
    virtual ~Compat12Record() override;

    Compat12Record( const Compat12Record& record );
    Compat12Record& operator=( const Compat12Record& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Compat12"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Window1Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Window1Record(Swinder::Workbook *book);
    virtual ~Window1Record() override;

    Window1Record( const Window1Record& record );
    Window1Record& operator=( const Window1Record& record );

    unsigned cTabSel() const;
    void setCTabSel( unsigned cTabSel );

    int dxWn() const;
    void setDxWn( int dxWn );

    int dyWn() const;
    void setDyWn( int dyWn );

    bool isFBotAdornment() const;
    void setFBotAdornment( bool fBotAdornment );

    bool isFDspHScroll() const;
    void setFDspHScroll( bool fDspHScroll );

    bool isFDspVScroll() const;
    void setFDspVScroll( bool fDspVScroll );

    bool isFHidden() const;
    void setFHidden( bool fHidden );

    bool isFIconic() const;
    void setFIconic( bool fIconic );

    bool isFNoAFDateGroup() const;
    void setFNoAFDateGroup( bool fNoAFDateGroup );

    bool isFVeryHidden() const;
    void setFVeryHidden( bool fVeryHidden );

    unsigned itabCur() const;
    void setItabCur( unsigned itabCur );

    unsigned itabFirst() const;
    void setItabFirst( unsigned itabFirst );

    unsigned wTabRatio() const;
    void setWTabRatio( unsigned wTabRatio );

    int xWn() const;
    void setXWn( int xWn );

    int yWn() const;
    void setYWn( int yWn );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Window1"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Window2Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Window2Record(Swinder::Workbook *book);
    virtual ~Window2Record() override;

    Window2Record( const Window2Record& record );
    Window2Record& operator=( const Window2Record& record );

    unsigned colLeft() const;
    void setColLeft( unsigned colLeft );

    bool isFDefaultHdr() const;
    void setFDefaultHdr( bool fDefaultHdr );

    bool isFDspFmlaRt() const;
    void setFDspFmlaRt( bool fDspFmlaRt );

    bool isFDspGridRt() const;
    void setFDspGridRt( bool fDspGridRt );

    bool isFDspGuts() const;
    void setFDspGuts( bool fDspGuts );

    bool isFDspRwColRt() const;
    void setFDspRwColRt( bool fDspRwColRt );

    bool isFDspZerosRt() const;
    void setFDspZerosRt( bool fDspZerosRt );

    bool isFFrozenNoSplit() const;
    void setFFrozenNoSplit( bool fFrozenNoSplit );

    bool isFFrozenRt() const;
    void setFFrozenRt( bool fFrozenRt );

    bool isFPaged() const;
    void setFPaged( bool fPaged );

    bool isFRightToLeft() const;
    void setFRightToLeft( bool fRightToLeft );

    bool isFSLV() const;
    void setFSLV( bool fSLV );

    bool isFSelected() const;
    void setFSelected( bool fSelected );

    unsigned icvHdr() const;
    void setIcvHdr( unsigned icvHdr );

    unsigned rwTop() const;
    void setRwTop( unsigned rwTop );

    unsigned wScaleNormal() const;
    void setWScaleNormal( unsigned wScaleNormal );

    unsigned wScaleSLV() const;
    void setWScaleSLV( unsigned wScaleSLV );

    bool hasSheetFields() const;

    void setHasSheetFields( bool value );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Window2"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ObjProtectedRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ObjProtectedRecord(Swinder::Workbook *book);
    virtual ~ObjProtectedRecord() override;

    ObjProtectedRecord( const ObjProtectedRecord& record );
    ObjProtectedRecord& operator=( const ObjProtectedRecord& record );

    unsigned fLockObj() const;
    void setFLockObj( unsigned fLockObj );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ObjProtected"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ScenarioProtectRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ScenarioProtectRecord(Swinder::Workbook *book);
    virtual ~ScenarioProtectRecord() override;

    ScenarioProtectRecord( const ScenarioProtectRecord& record );
    ScenarioProtectRecord& operator=( const ScenarioProtectRecord& record );

    unsigned fScenProtect() const;
    void setFScenProtect( unsigned fScenProtect );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ScenarioProtect"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class WinProtectRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    WinProtectRecord(Swinder::Workbook *book);
    virtual ~WinProtectRecord() override;

    WinProtectRecord( const WinProtectRecord& record );
    WinProtectRecord& operator=( const WinProtectRecord& record );

    unsigned fLockWin() const;
    void setFLockWin( unsigned fLockWin );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "WinProtect"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Prot4RevRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Prot4RevRecord(Swinder::Workbook *book);
    virtual ~Prot4RevRecord() override;

    Prot4RevRecord( const Prot4RevRecord& record );
    Prot4RevRecord& operator=( const Prot4RevRecord& record );

    unsigned fRevLock() const;
    void setFRevLock( unsigned fRevLock );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Prot4Rev"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class Prot4RevPassRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    Prot4RevPassRecord(Swinder::Workbook *book);
    virtual ~Prot4RevPassRecord() override;

    Prot4RevPassRecord( const Prot4RevPassRecord& record );
    Prot4RevPassRecord& operator=( const Prot4RevPassRecord& record );

    unsigned protPwdRev() const;
    void setProtPwdRev( unsigned protPwdRev );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Prot4RevPass"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PasswordRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PasswordRecord(Swinder::Workbook *book);
    virtual ~PasswordRecord() override;

    PasswordRecord( const PasswordRecord& record );
    PasswordRecord& operator=( const PasswordRecord& record );

    unsigned wPassword() const;
    void setWPassword( unsigned wPassword );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Password"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class InterfaceHdrRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    InterfaceHdrRecord(Swinder::Workbook *book);
    virtual ~InterfaceHdrRecord() override;

    InterfaceHdrRecord( const InterfaceHdrRecord& record );
    InterfaceHdrRecord& operator=( const InterfaceHdrRecord& record );

    unsigned codePage() const;
    void setCodePage( unsigned codePage );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "InterfaceHdr"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MmsReservedRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MmsReservedRecord(Swinder::Workbook *book);
    virtual ~MmsReservedRecord() override;

    MmsReservedRecord( const MmsReservedRecord& record );
    MmsReservedRecord& operator=( const MmsReservedRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MmsReserved"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class InterfaceEndRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    InterfaceEndRecord(Swinder::Workbook *book);
    virtual ~InterfaceEndRecord() override;

    InterfaceEndRecord( const InterfaceEndRecord& record );
    InterfaceEndRecord& operator=( const InterfaceEndRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "InterfaceEnd"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class LastWriteAccessRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    LastWriteAccessRecord(Swinder::Workbook *book);
    virtual ~LastWriteAccessRecord() override;

    LastWriteAccessRecord( const LastWriteAccessRecord& record );
    LastWriteAccessRecord& operator=( const LastWriteAccessRecord& record );

    QByteArray unusedBlob() const;
    void setUnusedBlob( QByteArray unusedBlob );

    QString userName() const;
    void setUserName( QString userName );

    unsigned userNameLength() const;
    void setUserNameLength( unsigned userNameLength );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "LastWriteAccess"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CodePageRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CodePageRecord(Swinder::Workbook *book);
    virtual ~CodePageRecord() override;

    CodePageRecord( const CodePageRecord& record );
    CodePageRecord& operator=( const CodePageRecord& record );

    unsigned codePage() const;
    void setCodePage( unsigned codePage );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CodePage"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DSFReservedRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DSFReservedRecord(Swinder::Workbook *book);
    virtual ~DSFReservedRecord() override;

    DSFReservedRecord( const DSFReservedRecord& record );
    DSFReservedRecord& operator=( const DSFReservedRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DSFReserved"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RRTabIdRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RRTabIdRecord(Swinder::Workbook *book);
    virtual ~RRTabIdRecord() override;

    RRTabIdRecord( const RRTabIdRecord& record );
    RRTabIdRecord& operator=( const RRTabIdRecord& record );

    unsigned sheetId( unsigned index ) const;
    void setSheetId( unsigned index, unsigned sheetId );

    unsigned sheetCount() const;
    void setSheetCount( unsigned sheetCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RRTabId"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HideObjRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HideObjRecord(Swinder::Workbook *book);
    virtual ~HideObjRecord() override;

    HideObjRecord( const HideObjRecord& record );
    HideObjRecord& operator=( const HideObjRecord& record );

    enum HideObj {
        ShowAll = 0x0000,
        ShowPlaceholder = 0x0001,
        HideAll = 0x0002
    };

    static QString hideObjToString(HideObj hideObj);

    HideObj hideObj() const;
    void setHideObj( HideObj hideObj );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "HideObj"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcPrecisionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcPrecisionRecord(Swinder::Workbook *book);
    virtual ~CalcPrecisionRecord() override;

    CalcPrecisionRecord( const CalcPrecisionRecord& record );
    CalcPrecisionRecord& operator=( const CalcPrecisionRecord& record );

    bool isFullPrec() const;
    void setFullPrec( bool fullPrec );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcPrecision"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RefreshAllRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RefreshAllRecord(Swinder::Workbook *book);
    virtual ~RefreshAllRecord() override;

    RefreshAllRecord( const RefreshAllRecord& record );
    RefreshAllRecord& operator=( const RefreshAllRecord& record );

    bool isRefreshAll() const;
    void setRefreshAll( bool refreshAll );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RefreshAll"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BookBoolRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BookBoolRecord(Swinder::Workbook *book);
    virtual ~BookBoolRecord() override;

    BookBoolRecord( const BookBoolRecord& record );
    BookBoolRecord& operator=( const BookBoolRecord& record );

    enum UpdateLinks {
        PromptUser = 0,
        DontUpdate = 1,
        SilentUpdate = 2
    };

    static QString updateLinksToString(UpdateLinks updateLinks);

    bool isEnvelopeInitDone() const;
    void setEnvelopeInitDone( bool envelopeInitDone );

    bool isEnvelopeVisible() const;
    void setEnvelopeVisible( bool envelopeVisible );

    bool hasEnvelope() const;
    void setHasEnvelope( bool hasEnvelope );

    bool isHideBorderUnselLists() const;
    void setHideBorderUnselLists( bool hideBorderUnselLists );

    bool isNoSaveSup() const;
    void setNoSaveSup( bool noSaveSup );

    UpdateLinks updateLinks() const;
    void setUpdateLinks( UpdateLinks updateLinks );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BookBool"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class StyleRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    StyleRecord(Swinder::Workbook *book);
    virtual ~StyleRecord() override;

    StyleRecord( const StyleRecord& record );
    StyleRecord& operator=( const StyleRecord& record );

    bool isBuiltIn() const;
    void setBuiltIn( bool builtIn );

    unsigned builtInOutlineLevel() const;
    void setBuiltInOutlineLevel( unsigned builtInOutlineLevel );

    unsigned builtInType() const;
    void setBuiltInType( unsigned builtInType );

    unsigned nameLength() const;
    void setNameLength( unsigned nameLength );

    QString styleName() const;
    void setStyleName( QString styleName );

    unsigned xfIndex() const;
    void setXfIndex( unsigned xfIndex );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Style"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class UsesELFsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    UsesELFsRecord(Swinder::Workbook *book);
    virtual ~UsesELFsRecord() override;

    UsesELFsRecord( const UsesELFsRecord& record );
    UsesELFsRecord& operator=( const UsesELFsRecord& record );

    bool isUsesElfs() const;
    void setUsesElfs( bool usesElfs );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "UsesELFs"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CountryRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CountryRecord(Swinder::Workbook *book);
    virtual ~CountryRecord() override;

    CountryRecord( const CountryRecord& record );
    CountryRecord& operator=( const CountryRecord& record );

    unsigned countryDef() const;
    void setCountryDef( unsigned countryDef );

    unsigned countryWinIni() const;
    void setCountryWinIni( unsigned countryWinIni );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Country"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ExtSSTRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ExtSSTRecord(Swinder::Workbook *book);
    virtual ~ExtSSTRecord() override;

    ExtSSTRecord( const ExtSSTRecord& record );
    ExtSSTRecord& operator=( const ExtSSTRecord& record );

    unsigned cbOffset( unsigned index ) const;
    void setCbOffset( unsigned index, unsigned cbOffset );

    unsigned dsst() const;
    void setDsst( unsigned dsst );

    unsigned ib( unsigned index ) const;
    void setIb( unsigned index, unsigned ib );

    unsigned groupCount() const;
    void setGroupCount( unsigned groupCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ExtSST"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class IndexRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    IndexRecord(Swinder::Workbook *book);
    virtual ~IndexRecord() override;

    IndexRecord( const IndexRecord& record );
    IndexRecord& operator=( const IndexRecord& record );

    unsigned dbCellPosition( unsigned index ) const;
    void setDbCellPosition( unsigned index, unsigned dbCellPosition );

    unsigned defColWidthPosition() const;
    void setDefColWidthPosition( unsigned defColWidthPosition );

    unsigned rowMaxPlus1() const;
    void setRowMaxPlus1( unsigned rowMaxPlus1 );

    unsigned rowMin() const;
    void setRowMin( unsigned rowMin );

    unsigned rowBlockCount() const;
    void setRowBlockCount( unsigned rowBlockCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Index"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class DBCellRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    DBCellRecord(Swinder::Workbook *book);
    virtual ~DBCellRecord() override;

    DBCellRecord( const DBCellRecord& record );
    DBCellRecord& operator=( const DBCellRecord& record );

    unsigned cellOffset( unsigned index ) const;
    void setCellOffset( unsigned index, unsigned cellOffset );

    unsigned firstRowOffset() const;
    void setFirstRowOffset( unsigned firstRowOffset );

    unsigned rowCount() const;
    void setRowCount( unsigned rowCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "DBCell"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcCountRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcCountRecord(Swinder::Workbook *book);
    virtual ~CalcCountRecord() override;

    CalcCountRecord( const CalcCountRecord& record );
    CalcCountRecord& operator=( const CalcCountRecord& record );

    int iterCount() const;
    void setIterCount( int iterCount );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcCount"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcRefModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcRefModeRecord(Swinder::Workbook *book);
    virtual ~CalcRefModeRecord() override;

    CalcRefModeRecord( const CalcRefModeRecord& record );
    CalcRefModeRecord& operator=( const CalcRefModeRecord& record );

    bool isRefA1() const;
    void setRefA1( bool refA1 );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcRefMode"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcIterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcIterRecord(Swinder::Workbook *book);
    virtual ~CalcIterRecord() override;

    CalcIterRecord( const CalcIterRecord& record );
    CalcIterRecord& operator=( const CalcIterRecord& record );

    bool isIterativeCalcs() const;
    void setIterativeCalcs( bool iterativeCalcs );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcIter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcDeltaRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcDeltaRecord(Swinder::Workbook *book);
    virtual ~CalcDeltaRecord() override;

    CalcDeltaRecord( const CalcDeltaRecord& record );
    CalcDeltaRecord& operator=( const CalcDeltaRecord& record );

    double numDelta() const;
    void setNumDelta( double numDelta );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcDelta"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CalcSaveRecalcRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CalcSaveRecalcRecord(Swinder::Workbook *book);
    virtual ~CalcSaveRecalcRecord() override;

    CalcSaveRecalcRecord( const CalcSaveRecalcRecord& record );
    CalcSaveRecalcRecord& operator=( const CalcSaveRecalcRecord& record );

    bool isRecalcBeforeSave() const;
    void setRecalcBeforeSave( bool recalcBeforeSave );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CalcSaveRecalc"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PrintRowColRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PrintRowColRecord(Swinder::Workbook *book);
    virtual ~PrintRowColRecord() override;

    PrintRowColRecord( const PrintRowColRecord& record );
    PrintRowColRecord& operator=( const PrintRowColRecord& record );

    bool isPrintRowColHeaders() const;
    void setPrintRowColHeaders( bool printRowColHeaders );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PrintRowCol"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PrintGridRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PrintGridRecord(Swinder::Workbook *book);
    virtual ~PrintGridRecord() override;

    PrintGridRecord( const PrintGridRecord& record );
    PrintGridRecord& operator=( const PrintGridRecord& record );

    bool isPrintGrid() const;
    void setPrintGrid( bool printGrid );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PrintGrid"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class GutsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    GutsRecord(Swinder::Workbook *book);
    virtual ~GutsRecord() override;

    GutsRecord( const GutsRecord& record );
    GutsRecord& operator=( const GutsRecord& record );

    unsigned maxColumnOutlineLevel() const;
    void setMaxColumnOutlineLevel( unsigned maxColumnOutlineLevel );

    unsigned maxRowOutlineLevel() const;
    void setMaxRowOutlineLevel( unsigned maxRowOutlineLevel );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Guts"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class WsBoolRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    WsBoolRecord(Swinder::Workbook *book);
    virtual ~WsBoolRecord() override;

    WsBoolRecord( const WsBoolRecord& record );
    WsBoolRecord& operator=( const WsBoolRecord& record );

    bool isAltExprEval() const;
    void setAltExprEval( bool altExprEval );

    bool isAltFormulaEntry() const;
    void setAltFormulaEntry( bool altFormulaEntry );

    bool isApplyStylesInOutline() const;
    void setApplyStylesInOutline( bool applyStylesInOutline );

    bool isColSumsRight() const;
    void setColSumsRight( bool colSumsRight );

    bool isDialogSheet() const;
    void setDialogSheet( bool dialogSheet );

    bool isFitToPage() const;
    void setFitToPage( bool fitToPage );

    bool isRowSumsBelow() const;
    void setRowSumsBelow( bool rowSumsBelow );

    bool isShowAutoBreaks() const;
    void setShowAutoBreaks( bool showAutoBreaks );

    bool isSyncHorizScrolling() const;
    void setSyncHorizScrolling( bool syncHorizScrolling );

    bool isSyncVertScrolling() const;
    void setSyncVertScrolling( bool syncVertScrolling );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "WsBool"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FeatHdrRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FeatHdrRecord(Swinder::Workbook *book);
    virtual ~FeatHdrRecord() override;

    FeatHdrRecord( const FeatHdrRecord& record );
    FeatHdrRecord& operator=( const FeatHdrRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "FeatHdr"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HeaderFooterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HeaderFooterRecord(Swinder::Workbook *book);
    virtual ~HeaderFooterRecord() override;

    HeaderFooterRecord( const HeaderFooterRecord& record );
    HeaderFooterRecord& operator=( const HeaderFooterRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "HeaderFooter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PLVRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PLVRecord(Swinder::Workbook *book);
    virtual ~PLVRecord() override;

    PLVRecord( const PLVRecord& record );
    PLVRecord& operator=( const PLVRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PLV"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BuiltInFnGroupCountRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BuiltInFnGroupCountRecord(Swinder::Workbook *book);
    virtual ~BuiltInFnGroupCountRecord() override;

    BuiltInFnGroupCountRecord( const BuiltInFnGroupCountRecord& record );
    BuiltInFnGroupCountRecord& operator=( const BuiltInFnGroupCountRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BuiltInFnGroupCount"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RecalcIdRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RecalcIdRecord(Swinder::Workbook *book);
    virtual ~RecalcIdRecord() override;

    RecalcIdRecord( const RecalcIdRecord& record );
    RecalcIdRecord& operator=( const RecalcIdRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RecalcId"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class StyleExtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    StyleExtRecord(Swinder::Workbook *book);
    virtual ~StyleExtRecord() override;

    StyleExtRecord( const StyleExtRecord& record );
    StyleExtRecord& operator=( const StyleExtRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "StyleExt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PhoneticInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PhoneticInfoRecord(Swinder::Workbook *book);
    virtual ~PhoneticInfoRecord() override;

    PhoneticInfoRecord( const PhoneticInfoRecord& record );
    PhoneticInfoRecord& operator=( const PhoneticInfoRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PhoneticInfo"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class SelectionRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    SelectionRecord(Swinder::Workbook *book);
    virtual ~SelectionRecord() override;

    SelectionRecord( const SelectionRecord& record );
    SelectionRecord& operator=( const SelectionRecord& record );

    unsigned colAct() const;
    void setColAct( unsigned colAct );

    unsigned cref() const;
    void setCref( unsigned cref );

    unsigned irefAct() const;
    void setIrefAct( unsigned irefAct );

    unsigned pnn() const;
    void setPnn( unsigned pnn );

    unsigned rwAct() const;
    void setRwAct( unsigned rwAct );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Selection"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class PrinterSettingsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    PrinterSettingsRecord(Swinder::Workbook *book);
    virtual ~PrinterSettingsRecord() override;

    PrinterSettingsRecord( const PrinterSettingsRecord& record );
    PrinterSettingsRecord& operator=( const PrinterSettingsRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "PrinterSettings"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class XFExtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    XFExtRecord(Swinder::Workbook *book);
    virtual ~XFExtRecord() override;

    XFExtRecord( const XFExtRecord& record );
    XFExtRecord& operator=( const XFExtRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "XFExt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class XFCRCRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    XFCRCRecord(Swinder::Workbook *book);
    virtual ~XFCRCRecord() override;

    XFCRCRecord( const XFCRCRecord& record );
    XFCRCRecord& operator=( const XFCRCRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "XFCRC"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class TableStylesRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    TableStylesRecord(Swinder::Workbook *book);
    virtual ~TableStylesRecord() override;

    TableStylesRecord( const TableStylesRecord& record );
    TableStylesRecord& operator=( const TableStylesRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "TableStyles"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class MTRSettingsRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    MTRSettingsRecord(Swinder::Workbook *book);
    virtual ~MTRSettingsRecord() override;

    MTRSettingsRecord( const MTRSettingsRecord& record );
    MTRSettingsRecord& operator=( const MTRSettingsRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "MTRSettings"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ForceFullCalculationRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ForceFullCalculationRecord(Swinder::Workbook *book);
    virtual ~ForceFullCalculationRecord() override;

    ForceFullCalculationRecord( const ForceFullCalculationRecord& record );
    ForceFullCalculationRecord& operator=( const ForceFullCalculationRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "ForceFullCalculation"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class BookExtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    BookExtRecord(Swinder::Workbook *book);
    virtual ~BookExtRecord() override;

    BookExtRecord( const BookExtRecord& record );
    BookExtRecord& operator=( const BookExtRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "BookExt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class ThemeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    ThemeRecord(Swinder::Workbook *book);
    virtual ~ThemeRecord() override;

    ThemeRecord( const ThemeRecord& record );
    ThemeRecord& operator=( const ThemeRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Theme"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CompressPicturesRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CompressPicturesRecord(Swinder::Workbook *book);
    virtual ~CompressPicturesRecord() override;

    CompressPicturesRecord( const CompressPicturesRecord& record );
    CompressPicturesRecord& operator=( const CompressPicturesRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CompressPictures"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FilterModeRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FilterModeRecord(Swinder::Workbook *book);
    virtual ~FilterModeRecord() override;

    FilterModeRecord( const FilterModeRecord& record );
    FilterModeRecord& operator=( const FilterModeRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "FilterMode"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AutoFilterRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AutoFilterRecord(Swinder::Workbook *book);
    virtual ~AutoFilterRecord() override;

    AutoFilterRecord( const AutoFilterRecord& record );
    AutoFilterRecord& operator=( const AutoFilterRecord& record );

    enum Join {
        JoinAnd = 0,
        JoinOr = 1
    };

    static QString joinToString(Join join);

    enum TopDirection {
        TopNBottom = 0,
        TopNTop = 1
    };

    static QString topDirectionToString(TopDirection topDirection);

    enum ValueType {
        UndefinedType = 0x00,
        RkNumber = 0x02,
        XNumber = 0x04,
        String = 0x06,
        BoolErr = 0x08,
        Blanks = 0x0c,
        NonBlanks = 0x0e
    };

    static QString valueTypeToString(ValueType valueType);

    enum Operation {
        Less = 1,
        Equal = 2,
        LEqual = 3,
        Greater = 4,
        NotEqual = 5,
        GEqual = 6
    };

    static QString operationToString(Operation operation);

    unsigned boolErrValue( unsigned index ) const;
    void setBoolErrValue( unsigned index, unsigned boolErrValue );

    unsigned charCount( unsigned index ) const;
    void setCharCount( unsigned index, unsigned charCount );

    unsigned entry() const;
    void setEntry( unsigned entry );

    bool isFCompare( unsigned index ) const;
    void setFCompare( unsigned index, bool fCompare );

    double floatValue( unsigned index ) const;
    void setFloatValue( unsigned index, double floatValue );

    bool isError( unsigned index ) const;
    void setIsError( unsigned index, bool isError );

    Join join() const;
    void setJoin( Join join );

    Operation operation( unsigned index ) const;
    void setOperation( unsigned index, Operation operation );

    unsigned rkValue( unsigned index ) const;
    void setRkValue( unsigned index, unsigned rkValue );

    bool isSimple1() const;
    void setSimple1( bool simple1 );

    bool isSimple2() const;
    void setSimple2( bool simple2 );

    QString string( unsigned index ) const;
    void setString( unsigned index, QString string );

    TopDirection topDirection() const;
    void setTopDirection( TopDirection topDirection );

    bool isTopN() const;
    void setTopN( bool topN );

    unsigned topNCount() const;
    void setTopNCount( unsigned topNCount );

    bool isTopPercentage() const;
    void setTopPercentage( bool topPercentage );

    QByteArray value( unsigned index ) const;
    void setValue( unsigned index, QByteArray value );

    ValueType valueType( unsigned index ) const;
    void setValueType( unsigned index, ValueType valueType );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AutoFilter"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AutoFilter12Record : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AutoFilter12Record(Swinder::Workbook *book);
    virtual ~AutoFilter12Record() override;

    AutoFilter12Record( const AutoFilter12Record& record );
    AutoFilter12Record& operator=( const AutoFilter12Record& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AutoFilter12"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class AutoFilterInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    AutoFilterInfoRecord(Swinder::Workbook *book);
    virtual ~AutoFilterInfoRecord() override;

    AutoFilterInfoRecord( const AutoFilterInfoRecord& record );
    AutoFilterInfoRecord& operator=( const AutoFilterInfoRecord& record );

    unsigned entries() const;
    void setEntries( unsigned entries );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "AutoFilterInfo"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class VerticalPageBreaksRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    VerticalPageBreaksRecord(Swinder::Workbook *book);
    virtual ~VerticalPageBreaksRecord() override;

    VerticalPageBreaksRecord( const VerticalPageBreaksRecord& record );
    VerticalPageBreaksRecord& operator=( const VerticalPageBreaksRecord& record );

    unsigned col( unsigned index ) const;
    void setCol( unsigned index, unsigned col );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned rowEnd( unsigned index ) const;
    void setRowEnd( unsigned index, unsigned rowEnd );

    unsigned rowStart( unsigned index ) const;
    void setRowStart( unsigned index, unsigned rowStart );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "VerticalPageBreaks"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HorizontalPageBreaksRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HorizontalPageBreaksRecord(Swinder::Workbook *book);
    virtual ~HorizontalPageBreaksRecord() override;

    HorizontalPageBreaksRecord( const HorizontalPageBreaksRecord& record );
    HorizontalPageBreaksRecord& operator=( const HorizontalPageBreaksRecord& record );

    unsigned colEnd( unsigned index ) const;
    void setColEnd( unsigned index, unsigned colEnd );

    unsigned colStart( unsigned index ) const;
    void setColStart( unsigned index, unsigned colStart );

    unsigned count() const;
    void setCount( unsigned count );

    unsigned row( unsigned index ) const;
    void setRow( unsigned index, unsigned row );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "HorizontalPageBreaks"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FilepassRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FilepassRecord(Swinder::Workbook *book);
    virtual ~FilepassRecord() override;

    FilepassRecord( const FilepassRecord& record );
    FilepassRecord& operator=( const FilepassRecord& record );

    enum EncryptionType {
        XORObfuscation = 0,
        RC4Encryption = 1
    };

    static QString encryptionTypeToString(EncryptionType encryptionType);

    QByteArray encryptedVerifier() const;
    void setEncryptedVerifier( QByteArray encryptedVerifier );

    QByteArray encryptedVerifierHash() const;
    void setEncryptedVerifierHash( QByteArray encryptedVerifierHash );

    EncryptionType encryptionType() const;
    void setEncryptionType( EncryptionType encryptionType );

    unsigned encryptionVersionMajor() const;
    void setEncryptionVersionMajor( unsigned encryptionVersionMajor );

    unsigned encryptionVersionMinor() const;
    void setEncryptionVersionMinor( unsigned encryptionVersionMinor );

    QByteArray salt() const;
    void setSalt( QByteArray salt );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "Filepass"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class UsrExclRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    UsrExclRecord(Swinder::Workbook *book);
    virtual ~UsrExclRecord() override;

    UsrExclRecord( const UsrExclRecord& record );
    UsrExclRecord& operator=( const UsrExclRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "UsrExcl"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class FileLockRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    FileLockRecord(Swinder::Workbook *book);
    virtual ~FileLockRecord() override;

    FileLockRecord( const FileLockRecord& record );
    FileLockRecord& operator=( const FileLockRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "FileLock"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RRDInfoRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RRDInfoRecord(Swinder::Workbook *book);
    virtual ~RRDInfoRecord() override;

    RRDInfoRecord( const RRDInfoRecord& record );
    RRDInfoRecord& operator=( const RRDInfoRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RRDInfo"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class RRDHeadRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    RRDHeadRecord(Swinder::Workbook *book);
    virtual ~RRDHeadRecord() override;

    RRDHeadRecord( const RRDHeadRecord& record );
    RRDHeadRecord& operator=( const RRDHeadRecord& record );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "RRDHead"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class HLinkRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    HLinkRecord(Swinder::Workbook *book);
    virtual ~HLinkRecord() override;

    HLinkRecord( const HLinkRecord& record );
    HLinkRecord& operator=( const HLinkRecord& record );

    bool isAbsFromGetdataRel() const;
    void setAbsFromGetdataRel( bool absFromGetdataRel );

    QString displayName() const;
    void setDisplayName( QString displayName );

    unsigned displayNameLength() const;
    void setDisplayNameLength( unsigned displayNameLength );

    unsigned firstColumn() const;
    void setFirstColumn( unsigned firstColumn );

    unsigned firstRow() const;
    void setFirstRow( unsigned firstRow );

    QString frameName() const;
    void setFrameName( QString frameName );

    unsigned frameNameLength() const;
    void setFrameNameLength( unsigned frameNameLength );

    QUuid guid() const;
    void setGuid( QUuid guid );

    bool hasCreationTime() const;
    void setHasCreationTime( bool hasCreationTime );

    bool hasDisplayName() const;
    void setHasDisplayName( bool hasDisplayName );

    bool hasFrameName() const;
    void setHasFrameName( bool hasFrameName );

    bool hasGUID() const;
    void setHasGUID( bool hasGUID );

    bool hasLocationStr() const;
    void setHasLocationStr( bool hasLocationStr );

    bool hasMoniker() const;
    void setHasMoniker( bool hasMoniker );

    QUuid hlinkClsid() const;
    void setHlinkClsid( QUuid hlinkClsid );

    bool isAbsolute() const;
    void setIsAbsolute( bool isAbsolute );

    unsigned lastColumn() const;
    void setLastColumn( unsigned lastColumn );

    unsigned lastRow() const;
    void setLastRow( unsigned lastRow );

    QString location() const;
    void setLocation( QString location );

    unsigned locationLength() const;
    void setLocationLength( unsigned locationLength );

    QString moniker() const;
    void setMoniker( QString moniker );

    unsigned monikerLength() const;
    void setMonikerLength( unsigned monikerLength );

    bool isMonikerSavedAsStr() const;
    void setMonikerSavedAsStr( bool monikerSavedAsStr );

    QUuid oleMonikerClsid() const;
    void setOleMonikerClsid( QUuid oleMonikerClsid );

    bool isSiteGaveDisplayName() const;
    void setSiteGaveDisplayName( bool siteGaveDisplayName );

    unsigned streamVersion() const;
    void setStreamVersion( unsigned streamVersion );

    QUuid urlMonikerSerialGUID() const;
    void setUrlMonikerSerialGUID( QUuid urlMonikerSerialGUID );

    unsigned urlMonikerSerialVersion() const;
    void setUrlMonikerSerialVersion( unsigned urlMonikerSerialVersion );

    unsigned urlMonikerSize() const;
    void setUrlMonikerSize( unsigned urlMonikerSize );

    unsigned urlMonikerURIFlags() const;
    void setUrlMonikerURIFlags( unsigned urlMonikerURIFlags );

    QString urlMonikerUrl() const;
    void setUrlMonikerUrl( QString urlMonikerUrl );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "HLink"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CondFmtRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CondFmtRecord(Swinder::Workbook *book);
    virtual ~CondFmtRecord() override;

    CondFmtRecord( const CondFmtRecord& record );
    CondFmtRecord& operator=( const CondFmtRecord& record );

    unsigned bbFirstColumn() const;
    void setBbFirstColumn( unsigned bbFirstColumn );

    unsigned bbFirstRow() const;
    void setBbFirstRow( unsigned bbFirstRow );

    unsigned bbLastColumn() const;
    void setBbLastColumn( unsigned bbLastColumn );

    unsigned bbLastRow() const;
    void setBbLastRow( unsigned bbLastRow );

    unsigned cfCount() const;
    void setCfCount( unsigned cfCount );

    unsigned firstColumn( unsigned index ) const;
    void setFirstColumn( unsigned index, unsigned firstColumn );

    unsigned firstRow( unsigned index ) const;
    void setFirstRow( unsigned index, unsigned firstRow );

    unsigned lastColumn( unsigned index ) const;
    void setLastColumn( unsigned index, unsigned lastColumn );

    unsigned lastRow( unsigned index ) const;
    void setLastRow( unsigned index, unsigned lastRow );

    unsigned nID() const;
    void setNID( unsigned nID );

    unsigned refCount() const;
    void setRefCount( unsigned refCount );

    bool isToughRecalc() const;
    void setToughRecalc( bool toughRecalc );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CondFmt"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

class CFRecord : public Record
{
public:
    static const unsigned id;

    virtual unsigned rtti() const override { return this->id; }

    CFRecord(Swinder::Workbook *book);
    virtual ~CFRecord() override;

    CFRecord( const CFRecord& record );
    CFRecord& operator=( const CFRecord& record );

    enum ConditionType {
        Function = 0x01,
        Formula = 0x02
    };

    static QString conditionTypeToString(ConditionType conditionType);

    enum ConditionFunction {
        Between = 0x01,
        Outside = 0x02,
        Equal = 0x03,
        NotEqual = 0x04,
        Greater = 0x05,
        Less = 0x06,
        GreaterOrEqual = 0x07,
        LessOrEqual = 0x08
    };

    static QString conditionFunctionToString(ConditionFunction conditionFunction);

    enum FontSuperSubScript {
        SSS_Ignore = -1,
        SSS_Normal = 0,
        SSS_Super = 1,
        SSS_Sub = 2
    };

    static QString fontSuperSubScriptToString(FontSuperSubScript fontSuperSubScript);

    enum Underline {
        UL_None = 0,
        UL_Single = 1,
        UL_Double = 2,
        UL_SingleAccounting = 0x21,
        UL_DoubleAccounting = 0x22,
        UL_Ignore = 0xff
    };

    static QString underlineToString(Underline underline);

    enum FontFamily {
        Unknown = 0,
        Roman = 1,
        Swiss = 2,
        Modern = 3,
        Script = 4,
        Decorative = 5
    };

    static QString fontFamilyToString(FontFamily fontFamily);

    enum HorizontalAlignment {
        Unspecified = 0xFF,
        General = 0,
        Left = 1,
        Centered = 2,
        Right = 3,
        Filled = 4,
        Justified = 5,
        CenteredSelection = 6,
        Distributed = 7
    };

    static QString horizontalAlignmentToString(HorizontalAlignment horizontalAlignment);

    enum VerticalAlignment {
        Top = 0,
        VCentered = 1,
        Bottom = 2,
        VJustified = 3,
        VDistributed = 4
    };

    static QString verticalAlignmentToString(VerticalAlignment verticalAlignment);

    enum ReadingOrder {
        Context = 0,
        LeftToRight = 1,
        RightToLeft = 2
    };

    static QString readingOrderToString(ReadingOrder readingOrder);

    enum FillPattern {
        Null = 0,
        Solid = 1,
        MediumGray = 2,
        DarkGray = 3,
        LightGray = 4,
        Horizontal = 5,
        Vertical = 6,
        DiagonalDown = 7,
        DiagonalUp = 8,
        DiagonalGrid = 9,
        ThickDiagonalGrid = 10,
        ThinHorizontal = 11,
        ThinVertical = 12,
        ThinDiagonalDown = 13,
        ThinDiagonalUp,
        ThinGrid = 15,
        ThinDiagonalGrid = 16,
        Gray1250 = 17,
        Gray0625 = 18
    };

    static QString fillPatternToString(FillPattern fillPattern);

    enum BorderStyle {
        NoLine = 0,
        Thin = 1,
        Medium = 2,
        Dashed = 3,
        Dotted = 4,
        Thick = 5,
        Double = 6,
        Hair = 7,
        MediumDashed = 8,
        ThinDashDotted = 9,
        MediumDashDotted = 10,
        ThinDashDotDotted = 11,
        MediumDashDotDotted = 12,
        SlantedMediumDashDotted = 13
    };

    static QString borderStyleToString(BorderStyle BorderStyle);

    bool isAlchNinch() const;
    void setAlchNinch( bool alchNinch );

    bool isAlcvNinch() const;
    void setAlcvNinch( bool alcvNinch );

    unsigned bottomBorderColor() const;
    void setBottomBorderColor( unsigned bottomBorderColor );

    BorderStyle bottomBorderStyle() const;
    void setBottomBorderStyle( BorderStyle bottomBorderStyle );

    bool isCIndentNinch() const;
    void setCIndentNinch( bool cIndentNinch );

    unsigned cce1() const;
    void setCce1( unsigned cce1 );

    unsigned cce2() const;
    void setCce2( unsigned cce2 );

    unsigned cchFont() const;
    void setCchFont( unsigned cchFont );

    unsigned characterSet() const;
    void setCharacterSet( unsigned characterSet );

    ConditionFunction conditionFunction() const;
    void setConditionFunction( ConditionFunction conditionFunction );

    ConditionType conditionType() const;
    void setConditionType( ConditionType conditionType );

    unsigned diagonalBorderColor() const;
    void setDiagonalBorderColor( unsigned diagonalBorderColor );

    BorderStyle diagonalBorderStyle() const;
    void setDiagonalBorderStyle( BorderStyle diagonalBorderStyle );

    bool isDiagonalBottomLeftBorder() const;
    void setDiagonalBottomLeftBorder( bool diagonalBottomLeftBorder );

    bool isDiagonalTopLeftBorder() const;
    void setDiagonalTopLeftBorder( bool diagonalTopLeftBorder );

    unsigned dxfnumusr_cb() const;
    void setDxfnumusr_cb( unsigned dxfnumusr_cb );

    bool isFIfmtUser() const;
    void setFIfmtUser( bool fIfmtUser );

    bool isFIfntNinch() const;
    void setFIfntNinch( bool fIfntNinch );

    bool isFIsNinch() const;
    void setFIsNinch( bool fIsNinch );

    bool isFMergeCellNinch() const;
    void setFMergeCellNinch( bool fMergeCellNinch );

    bool isFNewBorder() const;
    void setFNewBorder( bool fNewBorder );

    bool isFShrinkNicnh() const;
    void setFShrinkNicnh( bool fShrinkNicnh );

    bool isFZeroInited() const;
    void setFZeroInited( bool fZeroInited );

    FillPattern fillPattern() const;
    void setFillPattern( FillPattern fillPattern );

    QByteArray filler() const;
    void setFiller( QByteArray filler );

    int fontCharCount() const;
    void setFontCharCount( int fontCharCount );

    int fontColor() const;
    void setFontColor( int fontColor );

    FontFamily fontFamily() const;
    void setFontFamily( FontFamily fontFamily );

    int fontFirstChar() const;
    void setFontFirstChar( int fontFirstChar );

    int fontHeight() const;
    void setFontHeight( int fontHeight );

    unsigned fontId() const;
    void setFontId( unsigned fontId );

    bool isFontItalic() const;
    void setFontItalic( bool fontItalic );

    bool isFontItalicNinch() const;
    void setFontItalicNinch( bool fontItalicNinch );

    QString fontName() const;
    void setFontName( QString fontName );

    bool isFontNameIsUnicode() const;
    void setFontNameIsUnicode( bool fontNameIsUnicode );

    bool isFontStrikeout() const;
    void setFontStrikeout( bool fontStrikeout );

    bool isFontStrikeoutNinch() const;
    void setFontStrikeoutNinch( bool fontStrikeoutNinch );

    FontSuperSubScript fontSuperSubScript() const;
    void setFontSuperSubScript( FontSuperSubScript fontSuperSubScript );

    int fontWeight() const;
    void setFontWeight( int fontWeight );

    bool isFontWeightNinch() const;
    void setFontWeightNinch( bool fontWeightNinch );

    QString formatString() const;
    void setFormatString( QString formatString );

    unsigned formatStringLength() const;
    void setFormatStringLength( unsigned formatStringLength );

    bool isGlBottomNinch() const;
    void setGlBottomNinch( bool glBottomNinch );

    bool isGlDiagDownNinch() const;
    void setGlDiagDownNinch( bool glDiagDownNinch );

    bool isGlDiagUpNinch() const;
    void setGlDiagUpNinch( bool glDiagUpNinch );

    bool isGlLeftNinch() const;
    void setGlLeftNinch( bool glLeftNinch );

    bool isGlRightNinch() const;
    void setGlRightNinch( bool glRightNinch );

    bool isGlTopNinch() const;
    void setGlTopNinch( bool glTopNinch );

    bool isHidden() const;
    void setHidden( bool hidden );

    bool isHiddenNinch() const;
    void setHiddenNinch( bool hiddenNinch );

    HorizontalAlignment horizontalAlignment() const;
    void setHorizontalAlignment( HorizontalAlignment horizontalAlignment );

    bool isIReadingOrderNinch() const;
    void setIReadingOrderNinch( bool iReadingOrderNinch );

    bool isIbitAtrAlc() const;
    void setIbitAtrAlc( bool ibitAtrAlc );

    bool isIbitAtrBdr() const;
    void setIbitAtrBdr( bool ibitAtrBdr );

    bool isIbitAtrFnt() const;
    void setIbitAtrFnt( bool ibitAtrFnt );

    bool isIbitAtrNum() const;
    void setIbitAtrNum( bool ibitAtrNum );

    bool isIbitAtrPat() const;
    void setIbitAtrPat( bool ibitAtrPat );

    bool isIbitAtrProt() const;
    void setIbitAtrProt( bool ibitAtrProt );

    bool isIcvBNinch() const;
    void setIcvBNinch( bool icvBNinch );

    bool isIcvFNinch() const;
    void setIcvFNinch( bool icvFNinch );

    unsigned ifmt() const;
    void setIfmt( unsigned ifmt );

    bool isIfmtNinch() const;
    void setIfmtNinch( bool ifmtNinch );

    unsigned indentationLevel() const;
    void setIndentationLevel( unsigned indentationLevel );

    bool isKintoNinch() const;
    void setKintoNinch( bool kintoNinch );

    bool isLastLineJustified() const;
    void setLastLineJustified( bool lastLineJustified );

    unsigned leftBorderColor() const;
    void setLeftBorderColor( unsigned leftBorderColor );

    BorderStyle leftBorderStyle() const;
    void setLeftBorderStyle( BorderStyle leftBorderStyle );

    bool isLocked() const;
    void setLocked( bool locked );

    bool isLockedNinch() const;
    void setLockedNinch( bool lockedNinch );

    bool isMergeCell() const;
    void setMergeCell( bool mergeCell );

    unsigned patternBackColor() const;
    void setPatternBackColor( unsigned patternBackColor );

    unsigned patternForeColor() const;
    void setPatternForeColor( unsigned patternForeColor );

    unsigned rawRotation() const;
    void setRawRotation( unsigned rawRotation );

    ReadingOrder readingOrder() const;
    void setReadingOrder( ReadingOrder readingOrder );

    int relativeIndetationLevel() const;
    void setRelativeIndetationLevel( int relativeIndetationLevel );

    QByteArray rgce1() const;
    void setRgce1( QByteArray rgce1 );

    QByteArray rgce2() const;
    void setRgce2( QByteArray rgce2 );

    unsigned rightBorderColor() const;
    void setRightBorderColor( unsigned rightBorderColor );

    BorderStyle rightBorderStyle() const;
    void setRightBorderStyle( BorderStyle rightBorderStyle );

    bool isShrinkToFit() const;
    void setShrinkToFit( bool shrinkToFit );

    bool isSuperSubScriptNinch() const;
    void setSuperSubScriptNinch( bool superSubScriptNinch );

    bool isTextWrap() const;
    void setTextWrap( bool textWrap );

    unsigned topBorderColor() const;
    void setTopBorderColor( unsigned topBorderColor );

    BorderStyle topBorderStyle() const;
    void setTopBorderStyle( BorderStyle topBorderStyle );

    bool isTrotNinch() const;
    void setTrotNinch( bool trotNinch );

    Underline underline() const;
    void setUnderline( Underline underline );

    bool isUnderlineNinch() const;
    void setUnderlineNinch( bool underlineNinch );

    VerticalAlignment verticalAlignment() const;
    void setVerticalAlignment( VerticalAlignment verticalAlignment );

    bool isWrapNinch() const;
    void setWrapNinch( bool wrapNinch );

    virtual void setData( unsigned size, const unsigned char* data, const unsigned* continuePositions ) override;

    virtual void writeData( XlsRecordOutputStream& out ) const override;

    virtual const char* name() const override { return "CF"; }

    virtual void dump( std::ostream& out ) const override;

private:
    class Private;
    Private * const d;
};

} // namespace Swinder

#endif // SWINDER_RECORDS_H
