// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See command_validation_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2021-2026 Valve Corporation
 * Copyright (c) 2021-2026 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#include "command_validation.h"
#include "containers/custom_containers.h"

extern const char *kVUIDUndefined;

using Func = vvl::Func;
// clang-format off
static const auto &GetCommandValidationTable() {
static const vvl::unordered_map<Func, CommandValidationInfo> kCommandValidationTable {
{Func::vkCmdCopyBuffer, {
    "VUID-vkCmdCopyBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBuffer-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer-videocoding",
    "VUID-vkCmdCopyBuffer-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImage, {
    "VUID-vkCmdCopyImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImage-videocoding",
    "VUID-vkCmdCopyImage-suspended",
    false, true, false,
}},
{Func::vkCmdCopyBufferToImage, {
    "VUID-vkCmdCopyBufferToImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBufferToImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage-videocoding",
    "VUID-vkCmdCopyBufferToImage-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImageToBuffer, {
    "VUID-vkCmdCopyImageToBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImageToBuffer-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer-videocoding",
    "VUID-vkCmdCopyImageToBuffer-suspended",
    false, true, false,
}},
{Func::vkCmdUpdateBuffer, {
    "VUID-vkCmdUpdateBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdUpdateBuffer-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdUpdateBuffer-renderpass",
    CommandScope::Outside, "VUID-vkCmdUpdateBuffer-videocoding",
    "VUID-vkCmdUpdateBuffer-suspended",
    false, true, false,
}},
{Func::vkCmdFillBuffer, {
    "VUID-vkCmdFillBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdFillBuffer-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdFillBuffer-renderpass",
    CommandScope::Outside, "VUID-vkCmdFillBuffer-videocoding",
    "VUID-vkCmdFillBuffer-suspended",
    false, true, false,
}},
{Func::vkCmdPipelineBarrier, {
    "VUID-vkCmdPipelineBarrier-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdPipelineBarrier-suspended",
    false, false, true,
}},
{Func::vkCmdBeginQuery, {
    "VUID-vkCmdBeginQuery-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQuery-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdBeginQuery-suspended",
    true, true, false,
}},
{Func::vkCmdEndQuery, {
    "VUID-vkCmdEndQuery-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQuery-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdEndQuery-suspended",
    true, true, false,
}},
{Func::vkCmdResetQueryPool, {
    "VUID-vkCmdResetQueryPool-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdResetQueryPool-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResetQueryPool-renderpass",
    CommandScope::Outside, "VUID-vkCmdResetQueryPool-videocoding",
    "VUID-vkCmdResetQueryPool-suspended",
    false, true, false,
}},
{Func::vkCmdWriteTimestamp, {
    "VUID-vkCmdWriteTimestamp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdWriteTimestamp-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWriteTimestamp-suspended",
    false, true, false,
}},
{Func::vkCmdCopyQueryPoolResults, {
    "VUID-vkCmdCopyQueryPoolResults-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyQueryPoolResults-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyQueryPoolResults-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyQueryPoolResults-videocoding",
    "VUID-vkCmdCopyQueryPoolResults-suspended",
    false, true, false,
}},
{Func::vkCmdExecuteCommands, {
    "VUID-vkCmdExecuteCommands-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdExecuteCommands-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdExecuteCommands-videocoding",
    kVUIDUndefined,
    false, false, false,
}},
{Func::vkCmdBindPipeline, {
    "VUID-vkCmdBindPipeline-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdBindPipeline-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindPipeline-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorSets, {
    "VUID-vkCmdBindDescriptorSets-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdBindDescriptorSets-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorSets-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdClearColorImage, {
    "VUID-vkCmdClearColorImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdClearColorImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdClearColorImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdClearColorImage-videocoding",
    "VUID-vkCmdClearColorImage-suspended",
    false, true, false,
}},
{Func::vkCmdDispatch, {
    "VUID-vkCmdDispatch-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatch-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatch-videocoding",
    "VUID-vkCmdDispatch-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchIndirect, {
    "VUID-vkCmdDispatchIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchIndirect-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchIndirect-videocoding",
    "VUID-vkCmdDispatchIndirect-suspended",
    false, true, false,
}},
{Func::vkCmdSetEvent, {
    "VUID-vkCmdSetEvent-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdSetEvent-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdSetEvent-suspended",
    false, false, true,
}},
{Func::vkCmdResetEvent, {
    "VUID-vkCmdResetEvent-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResetEvent-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdResetEvent-suspended",
    false, false, true,
}},
{Func::vkCmdWaitEvents, {
    "VUID-vkCmdWaitEvents-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWaitEvents-suspended",
    false, false, true,
}},
{Func::vkCmdPushConstants, {
    "VUID-vkCmdPushConstants-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushConstants-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewport, {
    "VUID-vkCmdSetViewport-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewport-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewport-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetScissor, {
    "VUID-vkCmdSetScissor-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissor-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetScissor-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineWidth, {
    "VUID-vkCmdSetLineWidth-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineWidth-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineWidth-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBias, {
    "VUID-vkCmdSetDepthBias-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBias-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetBlendConstants, {
    "VUID-vkCmdSetBlendConstants-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetBlendConstants-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetBlendConstants-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBounds, {
    "VUID-vkCmdSetDepthBounds-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBounds-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBounds-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilCompareMask, {
    "VUID-vkCmdSetStencilCompareMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilCompareMask-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilCompareMask-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilWriteMask, {
    "VUID-vkCmdSetStencilWriteMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilWriteMask-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilWriteMask-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilReference, {
    "VUID-vkCmdSetStencilReference-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilReference-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilReference-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindIndexBuffer, {
    "VUID-vkCmdBindIndexBuffer-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindIndexBuffer-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindVertexBuffers, {
    "VUID-vkCmdBindVertexBuffers-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindVertexBuffers-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDraw, {
    "VUID-vkCmdDraw-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDraw-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDraw-renderpass",
    CommandScope::Outside, "VUID-vkCmdDraw-videocoding",
    "VUID-vkCmdDraw-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndexed, {
    "VUID-vkCmdDrawIndexed-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexed-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndexed-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndexed-videocoding",
    "VUID-vkCmdDrawIndexed-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndirect, {
    "VUID-vkCmdDrawIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirect-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndirect-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndirect-videocoding",
    "VUID-vkCmdDrawIndirect-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndexedIndirect, {
    "VUID-vkCmdDrawIndexedIndirect-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirect-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndexedIndirect-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndexedIndirect-videocoding",
    "VUID-vkCmdDrawIndexedIndirect-suspended",
    false, true, false,
}},
{Func::vkCmdBlitImage, {
    "VUID-vkCmdBlitImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBlitImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdBlitImage-videocoding",
    "VUID-vkCmdBlitImage-suspended",
    false, true, false,
}},
{Func::vkCmdClearDepthStencilImage, {
    "VUID-vkCmdClearDepthStencilImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearDepthStencilImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdClearDepthStencilImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdClearDepthStencilImage-videocoding",
    "VUID-vkCmdClearDepthStencilImage-suspended",
    false, true, false,
}},
{Func::vkCmdClearAttachments, {
    "VUID-vkCmdClearAttachments-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdClearAttachments-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdClearAttachments-renderpass",
    CommandScope::Outside, "VUID-vkCmdClearAttachments-videocoding",
    "VUID-vkCmdClearAttachments-suspended",
    false, true, false,
}},
{Func::vkCmdResolveImage, {
    "VUID-vkCmdResolveImage-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResolveImage-renderpass",
    CommandScope::Outside, "VUID-vkCmdResolveImage-videocoding",
    "VUID-vkCmdResolveImage-suspended",
    false, true, false,
}},
{Func::vkCmdBeginRenderPass, {
    "VUID-vkCmdBeginRenderPass-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass-videocoding",
    "VUID-vkCmdBeginRenderPass-suspended",
    true, true, true,
}},
{Func::vkCmdNextSubpass, {
    "VUID-vkCmdNextSubpass-commandBuffer-recording",
    "VUID-vkCmdNextSubpass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdNextSubpass-renderpass",
    CommandScope::Outside, "VUID-vkCmdNextSubpass-videocoding",
    "VUID-vkCmdNextSubpass-suspended",
    true, true, true,
}},
{Func::vkCmdEndRenderPass, {
    "VUID-vkCmdEndRenderPass-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRenderPass-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRenderPass-videocoding",
    "VUID-vkCmdEndRenderPass-suspended",
    true, true, true,
}},
{Func::vkCmdSetDeviceMask, {
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDispatchBase, {
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchBase-videocoding",
    "VUID-vkCmdDispatchBase-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndirectCount, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndirectCount-videocoding",
    "VUID-vkCmdDrawIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndexedIndirectCount, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
    "VUID-vkCmdDrawIndexedIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdBeginRenderPass2, {
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass2-videocoding",
    "VUID-vkCmdBeginRenderPass2-suspended",
    true, true, true,
}},
{Func::vkCmdNextSubpass2, {
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdNextSubpass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdNextSubpass2-videocoding",
    "VUID-vkCmdNextSubpass2-suspended",
    true, true, true,
}},
{Func::vkCmdEndRenderPass2, {
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRenderPass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRenderPass2-videocoding",
    "VUID-vkCmdEndRenderPass2-suspended",
    true, true, true,
}},
{Func::vkCmdPipelineBarrier2, {
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdPipelineBarrier2-suspended",
    false, false, true,
}},
{Func::vkCmdWriteTimestamp2, {
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWriteTimestamp2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyBuffer2, {
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer2-videocoding",
    "VUID-vkCmdCopyBuffer2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImage2, {
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImage2-videocoding",
    "VUID-vkCmdCopyImage2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyBufferToImage2, {
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage2-videocoding",
    "VUID-vkCmdCopyBufferToImage2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImageToBuffer2, {
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer2-videocoding",
    "VUID-vkCmdCopyImageToBuffer2-suspended",
    false, true, false,
}},
{Func::vkCmdSetEvent2, {
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdSetEvent2-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdSetEvent2-suspended",
    false, false, true,
}},
{Func::vkCmdResetEvent2, {
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResetEvent2-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdResetEvent2-suspended",
    false, false, true,
}},
{Func::vkCmdWaitEvents2, {
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWaitEvents2-suspended",
    false, false, true,
}},
{Func::vkCmdBlitImage2, {
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBlitImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdBlitImage2-videocoding",
    "VUID-vkCmdBlitImage2-suspended",
    false, true, false,
}},
{Func::vkCmdResolveImage2, {
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResolveImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdResolveImage2-videocoding",
    "VUID-vkCmdResolveImage2-suspended",
    false, true, false,
}},
{Func::vkCmdBeginRendering, {
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginRendering-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginRendering-videocoding",
    "VUID-vkCmdBeginRendering-suspended",
    true, true, false,
}},
{Func::vkCmdEndRendering, {
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRendering-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRendering-videocoding",
    "VUID-vkCmdEndRendering-suspended",
    true, true, false,
}},
{Func::vkCmdSetCullMode, {
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCullMode-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetFrontFace, {
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetFrontFace-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPrimitiveTopology, {
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPrimitiveTopology-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewportWithCount, {
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportWithCount-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetScissorWithCount, {
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetScissorWithCount-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindVertexBuffers2, {
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindVertexBuffers2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthTestEnable, {
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthWriteEnable, {
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthWriteEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthCompareOp, {
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthCompareOp-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBoundsTestEnable, {
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilTestEnable, {
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilOp, {
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilOp-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRasterizerDiscardEnable, {
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBiasEnable, {
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBiasEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPrimitiveRestartEnable, {
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSet, {
    "VUID-vkCmdPushDescriptorSet-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSet-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSet-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSetWithTemplate, {
    "VUID-vkCmdPushDescriptorSetWithTemplate-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplate-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSetWithTemplate-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorSets2, {
    "VUID-vkCmdBindDescriptorSets2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorSets2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorSets2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushConstants2, {
    "VUID-vkCmdPushConstants2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushConstants2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSet2, {
    "VUID-vkCmdPushDescriptorSet2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSet2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSet2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSetWithTemplate2, {
    "VUID-vkCmdPushDescriptorSetWithTemplate2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplate2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSetWithTemplate2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineStipple, {
    "VUID-vkCmdSetLineStipple-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStipple-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineStipple-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindIndexBuffer2, {
    "VUID-vkCmdBindIndexBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindIndexBuffer2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRenderingAttachmentLocations, {
    "VUID-vkCmdSetRenderingAttachmentLocations-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingAttachmentLocations-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdSetRenderingAttachmentLocations-renderpass",
    CommandScope::Outside, "VUID-vkCmdSetRenderingAttachmentLocations-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRenderingInputAttachmentIndices, {
    "VUID-vkCmdSetRenderingInputAttachmentIndices-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingInputAttachmentIndices-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdSetRenderingInputAttachmentIndices-renderpass",
    CommandScope::Outside, "VUID-vkCmdSetRenderingInputAttachmentIndices-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBeginVideoCodingKHR, {
    "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdBeginVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginVideoCodingKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginVideoCodingKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginVideoCodingKHR-videocoding",
    "VUID-vkCmdBeginVideoCodingKHR-suspended",
    true, true, false,
}},
{Func::vkCmdEndVideoCodingKHR, {
    "VUID-vkCmdEndVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdEndVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndVideoCodingKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdEndVideoCodingKHR-renderpass",
    CommandScope::Inside, "VUID-vkCmdEndVideoCodingKHR-videocoding",
    "VUID-vkCmdEndVideoCodingKHR-suspended",
    true, true, false,
}},
{Func::vkCmdControlVideoCodingKHR, {
    "VUID-vkCmdControlVideoCodingKHR-commandBuffer-recording",
    "VUID-vkCmdControlVideoCodingKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdControlVideoCodingKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdControlVideoCodingKHR-renderpass",
    CommandScope::Inside, "VUID-vkCmdControlVideoCodingKHR-videocoding",
    "VUID-vkCmdControlVideoCodingKHR-suspended",
    false, true, false,
}},
{Func::vkCmdDecodeVideoKHR, {
    "VUID-vkCmdDecodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdDecodeVideoKHR-bufferlevel",
    VK_QUEUE_VIDEO_DECODE_BIT_KHR, "VUID-vkCmdDecodeVideoKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDecodeVideoKHR-renderpass",
    CommandScope::Inside, "VUID-vkCmdDecodeVideoKHR-videocoding",
    "VUID-vkCmdDecodeVideoKHR-suspended",
    false, true, false,
}},
{Func::vkCmdBeginRenderingKHR, {
    "VUID-vkCmdBeginRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRendering-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginRendering-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginRendering-videocoding",
    "VUID-vkCmdBeginRendering-suspended",
    true, true, false,
}},
{Func::vkCmdEndRenderingKHR, {
    "VUID-vkCmdEndRendering-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRendering-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRendering-videocoding",
    "VUID-vkCmdEndRendering-suspended",
    true, true, false,
}},
{Func::vkCmdSetDeviceMaskKHR, {
    "VUID-vkCmdSetDeviceMask-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetDeviceMask-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDispatchBaseKHR, {
    "VUID-vkCmdDispatchBase-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchBase-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchBase-videocoding",
    "VUID-vkCmdDispatchBase-suspended",
    false, true, false,
}},
{Func::vkCmdPushDescriptorSetKHR, {
    "VUID-vkCmdPushDescriptorSet-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSet-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSet-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSetWithTemplateKHR, {
    "VUID-vkCmdPushDescriptorSetWithTemplate-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplate-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSetWithTemplate-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBeginRenderPass2KHR, {
    "VUID-vkCmdBeginRenderPass2-commandBuffer-recording",
    "VUID-vkCmdBeginRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginRenderPass2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginRenderPass2-videocoding",
    "VUID-vkCmdBeginRenderPass2-suspended",
    true, true, true,
}},
{Func::vkCmdNextSubpass2KHR, {
    "VUID-vkCmdNextSubpass2-commandBuffer-recording",
    "VUID-vkCmdNextSubpass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdNextSubpass2-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdNextSubpass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdNextSubpass2-videocoding",
    "VUID-vkCmdNextSubpass2-suspended",
    true, true, true,
}},
{Func::vkCmdEndRenderPass2KHR, {
    "VUID-vkCmdEndRenderPass2-commandBuffer-recording",
    "VUID-vkCmdEndRenderPass2-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRenderPass2-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRenderPass2-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRenderPass2-videocoding",
    "VUID-vkCmdEndRenderPass2-suspended",
    true, true, true,
}},
{Func::vkCmdDrawIndirectCountKHR, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndirectCount-videocoding",
    "VUID-vkCmdDrawIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndexedIndirectCountKHR, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
    "VUID-vkCmdDrawIndexedIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdSetFragmentShadingRateKHR, {
    "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateKHR-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetFragmentShadingRateKHR-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRenderingAttachmentLocationsKHR, {
    "VUID-vkCmdSetRenderingAttachmentLocations-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingAttachmentLocations-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdSetRenderingAttachmentLocations-renderpass",
    CommandScope::Outside, "VUID-vkCmdSetRenderingAttachmentLocations-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRenderingInputAttachmentIndicesKHR, {
    "VUID-vkCmdSetRenderingInputAttachmentIndices-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRenderingInputAttachmentIndices-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdSetRenderingInputAttachmentIndices-renderpass",
    CommandScope::Outside, "VUID-vkCmdSetRenderingInputAttachmentIndices-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdEncodeVideoKHR, {
    "VUID-vkCmdEncodeVideoKHR-commandBuffer-recording",
    "VUID-vkCmdEncodeVideoKHR-bufferlevel",
    VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEncodeVideoKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdEncodeVideoKHR-renderpass",
    CommandScope::Inside, "VUID-vkCmdEncodeVideoKHR-videocoding",
    "VUID-vkCmdEncodeVideoKHR-suspended",
    false, true, false,
}},
{Func::vkCmdSetEvent2KHR, {
    "VUID-vkCmdSetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdSetEvent2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdSetEvent2-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdSetEvent2-suspended",
    false, false, true,
}},
{Func::vkCmdResetEvent2KHR, {
    "VUID-vkCmdResetEvent2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdResetEvent2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResetEvent2-renderpass",
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdResetEvent2-suspended",
    false, false, true,
}},
{Func::vkCmdWaitEvents2KHR, {
    "VUID-vkCmdWaitEvents2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWaitEvents2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWaitEvents2-suspended",
    false, false, true,
}},
{Func::vkCmdPipelineBarrier2KHR, {
    "VUID-vkCmdPipelineBarrier2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdPipelineBarrier2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdPipelineBarrier2-suspended",
    false, false, true,
}},
{Func::vkCmdWriteTimestamp2KHR, {
    "VUID-vkCmdWriteTimestamp2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdWriteTimestamp2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    "VUID-vkCmdWriteTimestamp2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyBuffer2KHR, {
    "VUID-vkCmdCopyBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBuffer2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBuffer2-videocoding",
    "VUID-vkCmdCopyBuffer2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImage2KHR, {
    "VUID-vkCmdCopyImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImage2-videocoding",
    "VUID-vkCmdCopyImage2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyBufferToImage2KHR, {
    "VUID-vkCmdCopyBufferToImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyBufferToImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyBufferToImage2-videocoding",
    "VUID-vkCmdCopyBufferToImage2-suspended",
    false, true, false,
}},
{Func::vkCmdCopyImageToBuffer2KHR, {
    "VUID-vkCmdCopyImageToBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyImageToBuffer2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer2-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyImageToBuffer2-videocoding",
    "VUID-vkCmdCopyImageToBuffer2-suspended",
    false, true, false,
}},
{Func::vkCmdBlitImage2KHR, {
    "VUID-vkCmdBlitImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBlitImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBlitImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdBlitImage2-videocoding",
    "VUID-vkCmdBlitImage2-suspended",
    false, true, false,
}},
{Func::vkCmdResolveImage2KHR, {
    "VUID-vkCmdResolveImage2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdResolveImage2-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdResolveImage2-renderpass",
    CommandScope::Outside, "VUID-vkCmdResolveImage2-videocoding",
    "VUID-vkCmdResolveImage2-suspended",
    false, true, false,
}},
{Func::vkCmdTraceRaysIndirect2KHR, {
    "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirect2KHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdTraceRaysIndirect2KHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdTraceRaysIndirect2KHR-videocoding",
    "VUID-vkCmdTraceRaysIndirect2KHR-suspended",
    false, true, false,
}},
{Func::vkCmdBindIndexBuffer2KHR, {
    "VUID-vkCmdBindIndexBuffer2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindIndexBuffer2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindIndexBuffer2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineStippleKHR, {
    "VUID-vkCmdSetLineStipple-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStipple-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineStipple-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorSets2KHR, {
    "VUID-vkCmdBindDescriptorSets2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorSets2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorSets2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushConstants2KHR, {
    "VUID-vkCmdPushConstants2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushConstants2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushConstants2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSet2KHR, {
    "VUID-vkCmdPushDescriptorSet2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSet2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSet2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDescriptorSetWithTemplate2KHR, {
    "VUID-vkCmdPushDescriptorSetWithTemplate2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDescriptorSetWithTemplate2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDescriptorSetWithTemplate2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDescriptorBufferOffsets2EXT, {
    "VUID-vkCmdSetDescriptorBufferOffsets2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdSetDescriptorBufferOffsets2EXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDescriptorBufferOffsets2EXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT, {
    "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplers2EXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdCopyMemoryIndirectKHR, {
    "VUID-vkCmdCopyMemoryIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryIndirectKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryIndirectKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryIndirectKHR-videocoding",
    "VUID-vkCmdCopyMemoryIndirectKHR-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMemoryToImageIndirectKHR, {
    "VUID-vkCmdCopyMemoryToImageIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToImageIndirectKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToImageIndirectKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToImageIndirectKHR-videocoding",
    "VUID-vkCmdCopyMemoryToImageIndirectKHR-suspended",
    false, true, false,
}},
{Func::vkCmdEndRendering2KHR, {
    "VUID-vkCmdEndRendering2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering2KHR-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRendering2KHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRendering2KHR-videocoding",
    "VUID-vkCmdEndRendering2KHR-suspended",
    true, true, false,
}},
{Func::vkCmdDebugMarkerBeginEXT, {
    "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdDebugMarkerBeginEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDebugMarkerEndEXT, {
    "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdDebugMarkerEndEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDebugMarkerInsertEXT, {
    "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdDebugMarkerInsertEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindTransformFeedbackBuffersEXT, {
    "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindTransformFeedbackBuffersEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindTransformFeedbackBuffersEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBeginTransformFeedbackEXT, {
    "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginTransformFeedbackEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdBeginTransformFeedbackEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginTransformFeedbackEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdEndTransformFeedbackEXT, {
    "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndTransformFeedbackEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndTransformFeedbackEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndTransformFeedbackEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBeginQueryIndexedEXT, {
    "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdBeginQueryIndexedEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBeginQueryIndexedEXT-videocoding",
    "VUID-vkCmdBeginQueryIndexedEXT-suspended",
    true, true, false,
}},
{Func::vkCmdEndQueryIndexedEXT, {
    "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR, "VUID-vkCmdEndQueryIndexedEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdEndQueryIndexedEXT-videocoding",
    "VUID-vkCmdEndQueryIndexedEXT-suspended",
    true, true, false,
}},
{Func::vkCmdDrawIndirectByteCountEXT, {
    "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectByteCountEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndirectByteCountEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndirectByteCountEXT-videocoding",
    "VUID-vkCmdDrawIndirectByteCountEXT-suspended",
    false, true, false,
}},
{Func::vkCmdCuLaunchKernelNVX, {
    "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCuLaunchKernelNVX-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdCuLaunchKernelNVX-videocoding",
    "VUID-vkCmdCuLaunchKernelNVX-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndirectCountAMD, {
    "VUID-vkCmdDrawIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndirectCount-videocoding",
    "VUID-vkCmdDrawIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdDrawIndexedIndirectCountAMD, {
    "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawIndexedIndirectCount-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawIndexedIndirectCount-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawIndexedIndirectCount-videocoding",
    "VUID-vkCmdDrawIndexedIndirectCount-suspended",
    false, true, false,
}},
{Func::vkCmdBeginConditionalRenderingEXT, {
    "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginConditionalRenderingEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBeginConditionalRenderingEXT-videocoding",
    "VUID-vkCmdBeginConditionalRenderingEXT-suspended",
    true, true, false,
}},
{Func::vkCmdEndConditionalRenderingEXT, {
    "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndConditionalRenderingEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdEndConditionalRenderingEXT-videocoding",
    "VUID-vkCmdEndConditionalRenderingEXT-suspended",
    true, true, false,
}},
{Func::vkCmdSetViewportWScalingNV, {
    "VUID-vkCmdSetViewportWScalingNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportWScalingNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDiscardRectangleEXT, {
    "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDiscardRectangleEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDiscardRectangleEnableEXT, {
    "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDiscardRectangleEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDiscardRectangleModeEXT, {
    "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDiscardRectangleModeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDiscardRectangleModeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBeginDebugUtilsLabelEXT, {
    "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdBeginDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdEndDebugUtilsLabelEXT, {
    "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdEndDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdInsertDebugUtilsLabelEXT, {
    "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_VIDEO_DECODE_BIT_KHR | VK_QUEUE_VIDEO_ENCODE_BIT_KHR | VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdInsertDebugUtilsLabelEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Both, kVUIDUndefined,
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdInitializeGraphScratchMemoryAMDX, {
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-recording",
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdInitializeGraphScratchMemoryAMDX-videocoding",
    "VUID-vkCmdInitializeGraphScratchMemoryAMDX-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchGraphAMDX, {
    "VUID-vkCmdDispatchGraphAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphAMDX-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchGraphAMDX-videocoding",
    "VUID-vkCmdDispatchGraphAMDX-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchGraphIndirectAMDX, {
    "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectAMDX-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchGraphIndirectAMDX-videocoding",
    "VUID-vkCmdDispatchGraphIndirectAMDX-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchGraphIndirectCountAMDX, {
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-recording",
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchGraphIndirectCountAMDX-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdDispatchGraphIndirectCountAMDX-videocoding",
    "VUID-vkCmdDispatchGraphIndirectCountAMDX-suspended",
    false, true, false,
}},
{Func::vkCmdBindSamplerHeapEXT, {
    "VUID-vkCmdBindSamplerHeapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindSamplerHeapEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindSamplerHeapEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindResourceHeapEXT, {
    "VUID-vkCmdBindResourceHeapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindResourceHeapEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindResourceHeapEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPushDataEXT, {
    "VUID-vkCmdPushDataEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPushDataEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdPushDataEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetSampleLocationsEXT, {
    "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetSampleLocationsEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindShadingRateImageNV, {
    "VUID-vkCmdBindShadingRateImageNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindShadingRateImageNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindShadingRateImageNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewportShadingRatePaletteNV, {
    "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportShadingRatePaletteNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportShadingRatePaletteNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoarseSampleOrderNV, {
    "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoarseSampleOrderNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoarseSampleOrderNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBuildAccelerationStructureNV, {
    "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructureNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructureNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructureNV-videocoding",
    "VUID-vkCmdBuildAccelerationStructureNV-suspended",
    false, true, false,
}},
{Func::vkCmdCopyAccelerationStructureNV, {
    "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureNV-videocoding",
    "VUID-vkCmdCopyAccelerationStructureNV-suspended",
    false, true, false,
}},
{Func::vkCmdTraceRaysNV, {
    "VUID-vkCmdTraceRaysNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdTraceRaysNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdTraceRaysNV-videocoding",
    "VUID-vkCmdTraceRaysNV-suspended",
    false, true, false,
}},
{Func::vkCmdWriteAccelerationStructuresPropertiesNV, {
    "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-videocoding",
    "VUID-vkCmdWriteAccelerationStructuresPropertiesNV-suspended",
    false, true, false,
}},
{Func::vkCmdWriteBufferMarkerAMD, {
    "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteBufferMarkerAMD-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdWriteBufferMarkerAMD-videocoding",
    "VUID-vkCmdWriteBufferMarkerAMD-suspended",
    false, true, false,
}},
{Func::vkCmdWriteBufferMarker2AMD, {
    "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteBufferMarker2AMD-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdWriteBufferMarker2AMD-videocoding",
    "VUID-vkCmdWriteBufferMarker2AMD-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMeshTasksNV, {
    "VUID-vkCmdDrawMeshTasksNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksNV-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksNV-videocoding",
    "VUID-vkCmdDrawMeshTasksNV-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMeshTasksIndirectNV, {
    "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectNV-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksIndirectNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksIndirectNV-videocoding",
    "VUID-vkCmdDrawMeshTasksIndirectNV-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMeshTasksIndirectCountNV, {
    "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountNV-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksIndirectCountNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksIndirectCountNV-videocoding",
    "VUID-vkCmdDrawMeshTasksIndirectCountNV-suspended",
    false, true, false,
}},
{Func::vkCmdSetExclusiveScissorEnableNV, {
    "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetExclusiveScissorEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetExclusiveScissorNV, {
    "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExclusiveScissorNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetExclusiveScissorNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCheckpointNV, {
    "VUID-vkCmdSetCheckpointNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetCheckpointNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCheckpointNV-videocoding",
    "VUID-vkCmdSetCheckpointNV-suspended",
    false, true, false,
}},
{Func::vkCmdSetPerformanceMarkerINTEL, {
    "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceMarkerINTEL-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPerformanceMarkerINTEL-videocoding",
    "VUID-vkCmdSetPerformanceMarkerINTEL-suspended",
    true, true, false,
}},
{Func::vkCmdSetPerformanceStreamMarkerINTEL, {
    "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPerformanceStreamMarkerINTEL-videocoding",
    "VUID-vkCmdSetPerformanceStreamMarkerINTEL-suspended",
    true, true, false,
}},
{Func::vkCmdSetPerformanceOverrideINTEL, {
    "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_TRANSFER_BIT, "VUID-vkCmdSetPerformanceOverrideINTEL-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPerformanceOverrideINTEL-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineStippleEXT, {
    "VUID-vkCmdSetLineStipple-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStipple-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineStipple-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCullModeEXT, {
    "VUID-vkCmdSetCullMode-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCullMode-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCullMode-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetFrontFaceEXT, {
    "VUID-vkCmdSetFrontFace-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFrontFace-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetFrontFace-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPrimitiveTopologyEXT, {
    "VUID-vkCmdSetPrimitiveTopology-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveTopology-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPrimitiveTopology-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewportWithCountEXT, {
    "VUID-vkCmdSetViewportWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWithCount-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportWithCount-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetScissorWithCountEXT, {
    "VUID-vkCmdSetScissorWithCount-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetScissorWithCount-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetScissorWithCount-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindVertexBuffers2EXT, {
    "VUID-vkCmdBindVertexBuffers2-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBindVertexBuffers2-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindVertexBuffers2-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthTestEnableEXT, {
    "VUID-vkCmdSetDepthTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthWriteEnableEXT, {
    "VUID-vkCmdSetDepthWriteEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthWriteEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthWriteEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthCompareOpEXT, {
    "VUID-vkCmdSetDepthCompareOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthCompareOp-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthCompareOp-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBoundsTestEnableEXT, {
    "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBoundsTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBoundsTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilTestEnableEXT, {
    "VUID-vkCmdSetStencilTestEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilTestEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilTestEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetStencilOpEXT, {
    "VUID-vkCmdSetStencilOp-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetStencilOp-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetStencilOp-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdPreprocessGeneratedCommandsNV, {
    "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPreprocessGeneratedCommandsNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdPreprocessGeneratedCommandsNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdPreprocessGeneratedCommandsNV-videocoding",
    "VUID-vkCmdPreprocessGeneratedCommandsNV-suspended",
    false, true, false,
}},
{Func::vkCmdExecuteGeneratedCommandsNV, {
    "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdExecuteGeneratedCommandsNV-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdExecuteGeneratedCommandsNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdExecuteGeneratedCommandsNV-videocoding",
    "VUID-vkCmdExecuteGeneratedCommandsNV-suspended",
    false, true, false,
}},
{Func::vkCmdBindPipelineShaderGroupNV, {
    "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindPipelineShaderGroupNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindPipelineShaderGroupNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBias2EXT, {
    "VUID-vkCmdSetDepthBias2EXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBias2EXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBias2EXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdCudaLaunchKernelNV, {
    "VUID-vkCmdCudaLaunchKernelNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCudaLaunchKernelNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdCudaLaunchKernelNV-videocoding",
    "VUID-vkCmdCudaLaunchKernelNV-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchTileQCOM, {
    "VUID-vkCmdDispatchTileQCOM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDispatchTileQCOM-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDispatchTileQCOM-renderpass",
    CommandScope::Outside, "VUID-vkCmdDispatchTileQCOM-videocoding",
    "VUID-vkCmdDispatchTileQCOM-suspended",
    false, true, false,
}},
{Func::vkCmdBeginPerTileExecutionQCOM, {
    "VUID-vkCmdBeginPerTileExecutionQCOM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBeginPerTileExecutionQCOM-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdBeginPerTileExecutionQCOM-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginPerTileExecutionQCOM-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdEndPerTileExecutionQCOM, {
    "VUID-vkCmdEndPerTileExecutionQCOM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdEndPerTileExecutionQCOM-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndPerTileExecutionQCOM-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndPerTileExecutionQCOM-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorBuffersEXT, {
    "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdBindDescriptorBuffersEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorBuffersEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDescriptorBufferOffsetsEXT, {
    "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT | VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDescriptorBufferOffsetsEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindDescriptorBufferEmbeddedSamplersEXT, {
    "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindDescriptorBufferEmbeddedSamplersEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetFragmentShadingRateEnumNV, {
    "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetFragmentShadingRateEnumNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetFragmentShadingRateEnumNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetVertexInputEXT, {
    "VUID-vkCmdSetVertexInputEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetVertexInputEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetVertexInputEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSubpassShadingHUAWEI, {
    "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSubpassShadingHUAWEI-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdSubpassShadingHUAWEI-renderpass",
    CommandScope::Outside, "VUID-vkCmdSubpassShadingHUAWEI-videocoding",
    "VUID-vkCmdSubpassShadingHUAWEI-suspended",
    false, true, false,
}},
{Func::vkCmdBindInvocationMaskHUAWEI, {
    "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindInvocationMaskHUAWEI-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBindInvocationMaskHUAWEI-renderpass",
    CommandScope::Outside, "VUID-vkCmdBindInvocationMaskHUAWEI-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPatchControlPointsEXT, {
    "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPatchControlPointsEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPatchControlPointsEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRasterizerDiscardEnableEXT, {
    "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizerDiscardEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetRasterizerDiscardEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthBiasEnableEXT, {
    "VUID-vkCmdSetDepthBiasEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthBiasEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthBiasEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLogicOpEXT, {
    "VUID-vkCmdSetLogicOpEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLogicOpEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPrimitiveRestartEnableEXT, {
    "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPrimitiveRestartEnable-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPrimitiveRestartEnable-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetColorWriteEnableEXT, {
    "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetColorWriteEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDrawMultiEXT, {
    "VUID-vkCmdDrawMultiEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMultiEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMultiEXT-videocoding",
    "VUID-vkCmdDrawMultiEXT-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMultiIndexedEXT, {
    "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMultiIndexedEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMultiIndexedEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMultiIndexedEXT-videocoding",
    "VUID-vkCmdDrawMultiIndexedEXT-suspended",
    false, true, false,
}},
{Func::vkCmdBuildMicromapsEXT, {
    "VUID-vkCmdBuildMicromapsEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildMicromapsEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildMicromapsEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildMicromapsEXT-videocoding",
    "VUID-vkCmdBuildMicromapsEXT-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMicromapEXT, {
    "VUID-vkCmdCopyMicromapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMicromapEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMicromapEXT-videocoding",
    "VUID-vkCmdCopyMicromapEXT-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMicromapToMemoryEXT, {
    "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMicromapToMemoryEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMicromapToMemoryEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMicromapToMemoryEXT-videocoding",
    "VUID-vkCmdCopyMicromapToMemoryEXT-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMemoryToMicromapEXT, {
    "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToMicromapEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToMicromapEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToMicromapEXT-videocoding",
    "VUID-vkCmdCopyMemoryToMicromapEXT-suspended",
    false, true, false,
}},
{Func::vkCmdWriteMicromapsPropertiesEXT, {
    "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteMicromapsPropertiesEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdWriteMicromapsPropertiesEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdWriteMicromapsPropertiesEXT-videocoding",
    "VUID-vkCmdWriteMicromapsPropertiesEXT-suspended",
    false, true, false,
}},
{Func::vkCmdDrawClusterHUAWEI, {
    "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterHUAWEI-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawClusterHUAWEI-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawClusterHUAWEI-videocoding",
    "VUID-vkCmdDrawClusterHUAWEI-suspended",
    false, true, false,
}},
{Func::vkCmdDrawClusterIndirectHUAWEI, {
    "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawClusterIndirectHUAWEI-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawClusterIndirectHUAWEI-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawClusterIndirectHUAWEI-videocoding",
    "VUID-vkCmdDrawClusterIndirectHUAWEI-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMemoryIndirectNV, {
    "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryIndirectNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryIndirectNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryIndirectNV-videocoding",
    "VUID-vkCmdCopyMemoryIndirectNV-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMemoryToImageIndirectNV, {
    "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToImageIndirectNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToImageIndirectNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToImageIndirectNV-videocoding",
    "VUID-vkCmdCopyMemoryToImageIndirectNV-suspended",
    false, true, false,
}},
{Func::vkCmdDecompressMemoryNV, {
    "VUID-vkCmdDecompressMemoryNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryNV-videocoding",
    "VUID-vkCmdDecompressMemoryNV-suspended",
    false, true, false,
}},
{Func::vkCmdDecompressMemoryIndirectCountNV, {
    "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryIndirectCountNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryIndirectCountNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryIndirectCountNV-videocoding",
    "VUID-vkCmdDecompressMemoryIndirectCountNV-suspended",
    false, true, false,
}},
{Func::vkCmdUpdatePipelineIndirectBufferNV, {
    "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdUpdatePipelineIndirectBufferNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdUpdatePipelineIndirectBufferNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdUpdatePipelineIndirectBufferNV-videocoding",
    "VUID-vkCmdUpdatePipelineIndirectBufferNV-suspended",
    false, true, false,
}},
{Func::vkCmdSetDepthClampEnableEXT, {
    "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClampEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthClampEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetPolygonModeEXT, {
    "VUID-vkCmdSetPolygonModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetPolygonModeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetPolygonModeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRasterizationSamplesEXT, {
    "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationSamplesEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetRasterizationSamplesEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetSampleMaskEXT, {
    "VUID-vkCmdSetSampleMaskEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleMaskEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetSampleMaskEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetAlphaToCoverageEnableEXT, {
    "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToCoverageEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetAlphaToCoverageEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetAlphaToOneEnableEXT, {
    "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAlphaToOneEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetAlphaToOneEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLogicOpEnableEXT, {
    "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLogicOpEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLogicOpEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetColorBlendEnableEXT, {
    "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetColorBlendEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetColorBlendEquationEXT, {
    "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendEquationEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetColorBlendEquationEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetColorWriteMaskEXT, {
    "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorWriteMaskEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetColorWriteMaskEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetTessellationDomainOriginEXT, {
    "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetTessellationDomainOriginEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetTessellationDomainOriginEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRasterizationStreamEXT, {
    "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRasterizationStreamEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetRasterizationStreamEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetConservativeRasterizationModeEXT, {
    "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetConservativeRasterizationModeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetConservativeRasterizationModeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetExtraPrimitiveOverestimationSizeEXT, {
    "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetExtraPrimitiveOverestimationSizeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthClipEnableEXT, {
    "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthClipEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetSampleLocationsEnableEXT, {
    "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetSampleLocationsEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetSampleLocationsEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetColorBlendAdvancedEXT, {
    "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetColorBlendAdvancedEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetColorBlendAdvancedEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetProvokingVertexModeEXT, {
    "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetProvokingVertexModeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetProvokingVertexModeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineRasterizationModeEXT, {
    "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineRasterizationModeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineRasterizationModeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetLineStippleEnableEXT, {
    "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetLineStippleEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetLineStippleEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthClipNegativeOneToOneEXT, {
    "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthClipNegativeOneToOneEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewportWScalingEnableNV, {
    "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportWScalingEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportWScalingEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetViewportSwizzleNV, {
    "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetViewportSwizzleNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetViewportSwizzleNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageToColorEnableNV, {
    "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageToColorEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageToColorLocationNV, {
    "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageToColorLocationNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageToColorLocationNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageModulationModeNV, {
    "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationModeNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageModulationModeNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageModulationTableEnableNV, {
    "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageModulationTableEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageModulationTableNV, {
    "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageModulationTableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageModulationTableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetShadingRateImageEnableNV, {
    "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetShadingRateImageEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetShadingRateImageEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetRepresentativeFragmentTestEnableNV, {
    "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetRepresentativeFragmentTestEnableNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetCoverageReductionModeNV, {
    "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetCoverageReductionModeNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetCoverageReductionModeNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdCopyTensorARM, {
    "VUID-vkCmdCopyTensorARM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_TRANSFER_BIT | VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyTensorARM-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyTensorARM-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyTensorARM-videocoding",
    "VUID-vkCmdCopyTensorARM-suspended",
    false, true, false,
}},
{Func::vkCmdOpticalFlowExecuteNV, {
    "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_OPTICAL_FLOW_BIT_NV, "VUID-vkCmdOpticalFlowExecuteNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdOpticalFlowExecuteNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdOpticalFlowExecuteNV-videocoding",
    "VUID-vkCmdOpticalFlowExecuteNV-suspended",
    false, true, false,
}},
{Func::vkCmdBindShadersEXT, {
    "VUID-vkCmdBindShadersEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindShadersEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdBindShadersEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdSetDepthClampRangeEXT, {
    "VUID-vkCmdSetDepthClampRangeEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetDepthClampRangeEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetDepthClampRangeEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdConvertCooperativeVectorMatrixNV, {
    "VUID-vkCmdConvertCooperativeVectorMatrixNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdConvertCooperativeVectorMatrixNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdConvertCooperativeVectorMatrixNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdConvertCooperativeVectorMatrixNV-videocoding",
    "VUID-vkCmdConvertCooperativeVectorMatrixNV-suspended",
    false, true, false,
}},
{Func::vkCmdDispatchDataGraphARM, {
    "VUID-vkCmdDispatchDataGraphARM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_DATA_GRAPH_BIT_ARM, "VUID-vkCmdDispatchDataGraphARM-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDispatchDataGraphARM-renderpass",
    CommandScope::Outside, "VUID-vkCmdDispatchDataGraphARM-videocoding",
    "VUID-vkCmdDispatchDataGraphARM-suspended",
    false, true, false,
}},
{Func::vkCmdSetAttachmentFeedbackLoopEnableEXT, {
    "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetAttachmentFeedbackLoopEnableEXT-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBindTileMemoryQCOM, {
    "VUID-vkCmdBindTileMemoryQCOM-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBindTileMemoryQCOM-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBindTileMemoryQCOM-renderpass",
    CommandScope::Outside, "VUID-vkCmdBindTileMemoryQCOM-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDecompressMemoryEXT, {
    "VUID-vkCmdDecompressMemoryEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryEXT-videocoding",
    "VUID-vkCmdDecompressMemoryEXT-suspended",
    false, true, false,
}},
{Func::vkCmdDecompressMemoryIndirectCountEXT, {
    "VUID-vkCmdDecompressMemoryIndirectCountEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdDecompressMemoryIndirectCountEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryIndirectCountEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDecompressMemoryIndirectCountEXT-videocoding",
    "VUID-vkCmdDecompressMemoryIndirectCountEXT-suspended",
    false, true, false,
}},
{Func::vkCmdBuildClusterAccelerationStructureIndirectNV, {
    "VUID-vkCmdBuildClusterAccelerationStructureIndirectNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildClusterAccelerationStructureIndirectNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildClusterAccelerationStructureIndirectNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildClusterAccelerationStructureIndirectNV-videocoding",
    "VUID-vkCmdBuildClusterAccelerationStructureIndirectNV-suspended",
    false, true, false,
}},
{Func::vkCmdBuildPartitionedAccelerationStructuresNV, {
    "VUID-vkCmdBuildPartitionedAccelerationStructuresNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildPartitionedAccelerationStructuresNV-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildPartitionedAccelerationStructuresNV-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildPartitionedAccelerationStructuresNV-videocoding",
    "VUID-vkCmdBuildPartitionedAccelerationStructuresNV-suspended",
    false, true, false,
}},
{Func::vkCmdPreprocessGeneratedCommandsEXT, {
    "VUID-vkCmdPreprocessGeneratedCommandsEXT-commandBuffer-recording",
    "VUID-vkCmdPreprocessGeneratedCommandsEXT-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdPreprocessGeneratedCommandsEXT-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdPreprocessGeneratedCommandsEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdPreprocessGeneratedCommandsEXT-videocoding",
    "VUID-vkCmdPreprocessGeneratedCommandsEXT-suspended",
    false, true, false,
}},
{Func::vkCmdExecuteGeneratedCommandsEXT, {
    "VUID-vkCmdExecuteGeneratedCommandsEXT-commandBuffer-recording",
    "VUID-vkCmdExecuteGeneratedCommandsEXT-bufferlevel",
    VK_QUEUE_GRAPHICS_BIT | VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdExecuteGeneratedCommandsEXT-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdExecuteGeneratedCommandsEXT-videocoding",
    "VUID-vkCmdExecuteGeneratedCommandsEXT-suspended",
    false, true, false,
}},
{Func::vkCmdEndRendering2EXT, {
    "VUID-vkCmdEndRendering2KHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdEndRendering2KHR-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdEndRendering2KHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdEndRendering2KHR-videocoding",
    "VUID-vkCmdEndRendering2KHR-suspended",
    true, true, false,
}},
{Func::vkCmdBeginCustomResolveEXT, {
    "VUID-vkCmdBeginCustomResolveEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdBeginCustomResolveEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdBeginCustomResolveEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdBeginCustomResolveEXT-videocoding",
    "VUID-vkCmdBeginCustomResolveEXT-suspended",
    false, true, false,
}},
{Func::vkCmdSetComputeOccupancyPriorityNV, {
    "VUID-vkCmdSetComputeOccupancyPriorityNV-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetComputeOccupancyPriorityNV-commandBuffer-cmdpool",
    CommandScope::Both, kVUIDUndefined,
    CommandScope::Outside, "VUID-vkCmdSetComputeOccupancyPriorityNV-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdBuildAccelerationStructuresKHR, {
    "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructuresKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructuresKHR-videocoding",
    "VUID-vkCmdBuildAccelerationStructuresKHR-suspended",
    false, true, false,
}},
{Func::vkCmdBuildAccelerationStructuresIndirectKHR, {
    "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-videocoding",
    "VUID-vkCmdBuildAccelerationStructuresIndirectKHR-suspended",
    false, true, false,
}},
{Func::vkCmdCopyAccelerationStructureKHR, {
    "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureKHR-videocoding",
    "VUID-vkCmdCopyAccelerationStructureKHR-suspended",
    false, true, false,
}},
{Func::vkCmdCopyAccelerationStructureToMemoryKHR, {
    "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-videocoding",
    "VUID-vkCmdCopyAccelerationStructureToMemoryKHR-suspended",
    false, true, false,
}},
{Func::vkCmdCopyMemoryToAccelerationStructureKHR, {
    "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-videocoding",
    "VUID-vkCmdCopyMemoryToAccelerationStructureKHR-suspended",
    false, true, false,
}},
{Func::vkCmdWriteAccelerationStructuresPropertiesKHR, {
    "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-videocoding",
    "VUID-vkCmdWriteAccelerationStructuresPropertiesKHR-suspended",
    false, true, false,
}},
{Func::vkCmdTraceRaysKHR, {
    "VUID-vkCmdTraceRaysKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdTraceRaysKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdTraceRaysKHR-videocoding",
    "VUID-vkCmdTraceRaysKHR-suspended",
    false, true, false,
}},
{Func::vkCmdTraceRaysIndirectKHR, {
    "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdTraceRaysIndirectKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdTraceRaysIndirectKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdTraceRaysIndirectKHR-videocoding",
    "VUID-vkCmdTraceRaysIndirectKHR-suspended",
    false, true, false,
}},
{Func::vkCmdSetRayTracingPipelineStackSizeKHR, {
    "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-recording",
    nullptr,
    VK_QUEUE_COMPUTE_BIT, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-commandBuffer-cmdpool",
    CommandScope::Outside, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-renderpass",
    CommandScope::Outside, "VUID-vkCmdSetRayTracingPipelineStackSizeKHR-videocoding",
    kVUIDUndefined,
    true, false, false,
}},
{Func::vkCmdDrawMeshTasksEXT, {
    "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksEXT-videocoding",
    "VUID-vkCmdDrawMeshTasksEXT-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMeshTasksIndirectEXT, {
    "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksIndirectEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksIndirectEXT-videocoding",
    "VUID-vkCmdDrawMeshTasksIndirectEXT-suspended",
    false, true, false,
}},
{Func::vkCmdDrawMeshTasksIndirectCountEXT, {
    "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-recording",
    nullptr,
    VK_QUEUE_GRAPHICS_BIT, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-commandBuffer-cmdpool",
    CommandScope::Inside, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-renderpass",
    CommandScope::Outside, "VUID-vkCmdDrawMeshTasksIndirectCountEXT-videocoding",
    "VUID-vkCmdDrawMeshTasksIndirectCountEXT-suspended",
    false, true, false,
}},
};
return kCommandValidationTable;
}
// clang-format on

const CommandValidationInfo &GetCommandValidationInfo(vvl::Func command) {
    auto info_it = GetCommandValidationTable().find(command);
    assert(info_it != GetCommandValidationTable().end());
    return info_it->second;
}

// NOLINTEND
