// third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class DeviceEmulationParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DeviceEmulationParamsDataView> {
  using Data = ::blink::mojom::internal::DeviceEmulationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class EmulatedScreenType : int32_t {
  
  kDesktop = 0,
  
  kMobile = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, EmulatedScreenType value);
inline bool IsKnownEnumValue(EmulatedScreenType value) {
  return internal::EmulatedScreenType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DeviceEmulationParamsDataView {
 public:
  DeviceEmulationParamsDataView() = default;

  DeviceEmulationParamsDataView(
      internal::DeviceEmulationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScreenType(UserType* output) const {
    auto data_value = data_->screen_type;
    return mojo::internal::Deserialize<::blink::mojom::EmulatedScreenType>(
        data_value, output);
  }
  EmulatedScreenType screen_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::EmulatedScreenType>(data_->screen_type));
  }
  inline void GetScreenSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenSize(UserType* output) {
    
    auto* pointer = data_->screen_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetViewPositionDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointDataView, UserType>(),
    "Attempting to read the optional `view_position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewPosition` instead "
    "of `ReadViewPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_position.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetViewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewSize(UserType* output) {
    
    auto* pointer = data_->view_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  float scale() const {
    return data_->scale;
  }
  inline void GetViewportOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportOffset(UserType* output) {
    
    auto* pointer = data_->viewport_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  float viewport_scale() const {
    return data_->viewport_scale;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScreenOrientationType(UserType* output) const {
    auto data_value = data_->screen_orientation_type;
    return mojo::internal::Deserialize<::display::mojom::ScreenOrientation>(
        data_value, output);
  }
  ::display::mojom::ScreenOrientation screen_orientation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::ScreenOrientation>(data_->screen_orientation_type));
  }
  uint32_t screen_orientation_angle() const {
    return data_->screen_orientation_angle;
  }
  inline void GetViewportSegmentsDataView(
      mojo::ArrayDataView<::gfx::mojom::RectDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportSegments(UserType* output) {
    
    auto* pointer = data_->viewport_segments.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDevicePosture(UserType* output) const {
    auto data_value = data_->device_posture;
    return mojo::internal::Deserialize<::blink::mojom::DevicePostureType>(
        data_value, output);
  }
  ::blink::mojom::DevicePostureType device_posture() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DevicePostureType>(data_->device_posture));
  }
 private:
  internal::DeviceEmulationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::EmulatedScreenType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::EmulatedScreenType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::EmulatedScreenType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::EmulatedScreenType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::EmulatedScreenType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeviceEmulationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DeviceEmulationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DeviceEmulationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::blink::mojom::EmulatedScreenType>(
        Traits::screen_type(input), &fragment->screen_type);
    decltype(Traits::screen_size(input)) in_screen_size = Traits::screen_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->screen_size)::BaseType> screen_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_screen_size, screen_size_fragment);
    fragment->screen_size.Set(
        screen_size_fragment.is_null() ? nullptr : screen_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->screen_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null screen_size in DeviceEmulationParams struct");
    decltype(Traits::view_position(input)) in_view_position = Traits::view_position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_position)::BaseType> view_position_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_view_position, view_position_fragment);
    fragment->view_position.Set(
        view_position_fragment.is_null() ? nullptr : view_position_fragment.data());
    decltype(Traits::view_size(input)) in_view_size = Traits::view_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_size)::BaseType> view_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_view_size, view_size_fragment);
    fragment->view_size.Set(
        view_size_fragment.is_null() ? nullptr : view_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->view_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_size in DeviceEmulationParams struct");
    fragment->device_scale_factor = Traits::device_scale_factor(input);
    fragment->scale = Traits::scale(input);
    decltype(Traits::viewport_offset(input)) in_viewport_offset = Traits::viewport_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_offset)::BaseType> viewport_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_viewport_offset, viewport_offset_fragment);
    fragment->viewport_offset.Set(
        viewport_offset_fragment.is_null() ? nullptr : viewport_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->viewport_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_offset in DeviceEmulationParams struct");
    fragment->viewport_scale = Traits::viewport_scale(input);
    mojo::internal::Serialize<::display::mojom::ScreenOrientation>(
        Traits::screen_orientation_type(input), &fragment->screen_orientation_type);
    fragment->screen_orientation_angle = Traits::screen_orientation_angle(input);
    decltype(Traits::viewport_segments(input)) in_viewport_segments = Traits::viewport_segments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewport_segments)::BaseType>
        viewport_segments_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& viewport_segments_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::RectDataView>>(
        in_viewport_segments, viewport_segments_fragment, &viewport_segments_validate_params);
    fragment->viewport_segments.Set(
        viewport_segments_fragment.is_null() ? nullptr : viewport_segments_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->viewport_segments.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_segments in DeviceEmulationParams struct");
    mojo::internal::Serialize<::blink::mojom::DevicePostureType>(
        Traits::device_posture(input), &fragment->device_posture);
  }

  static bool Deserialize(::blink::mojom::internal::DeviceEmulationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DeviceEmulationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void DeviceEmulationParamsDataView::GetScreenSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->screen_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DeviceEmulationParamsDataView::GetViewPositionDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->view_position.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void DeviceEmulationParamsDataView::GetViewSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->view_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void DeviceEmulationParamsDataView::GetViewportOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->viewport_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void DeviceEmulationParamsDataView::GetViewportSegmentsDataView(
    mojo::ArrayDataView<::gfx::mojom::RectDataView>* output) {
  auto pointer = data_->viewport_segments.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::RectDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::EmulatedScreenType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::EmulatedScreenType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_DEVICE_EMULATION_PARAMS_MOJOM_SHARED_H_