// services/network/public/mojom/no_vary_search.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/no_vary_search.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/no_vary_search.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* NoVarySearchParseErrorToStringHelper(NoVarySearchParseError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NoVarySearchParseError::kOk:
      return "kOk";
    case NoVarySearchParseError::kDefaultValue:
      return "kDefaultValue";
    case NoVarySearchParseError::kNotDictionary:
      return "kNotDictionary";
    case NoVarySearchParseError::kUnknownDictionaryKey:
      return "kUnknownDictionaryKey";
    case NoVarySearchParseError::kNonBooleanKeyOrder:
      return "kNonBooleanKeyOrder";
    case NoVarySearchParseError::kParamsNotStringList:
      return "kParamsNotStringList";
    case NoVarySearchParseError::kExceptNotStringList:
      return "kExceptNotStringList";
    case NoVarySearchParseError::kExceptWithoutTrueParams:
      return "kExceptWithoutTrueParams";
    default:
      return nullptr;
  }
}

std::string NoVarySearchParseErrorToString(NoVarySearchParseError value) {
  const char *str = NoVarySearchParseErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NoVarySearchParseError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NoVarySearchParseError value) {
  return os << NoVarySearchParseErrorToString(value);
}

namespace internal {
// static
bool SearchParamsVariance_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SearchParamsVariance_Data* object = static_cast<const SearchParamsVariance_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SearchParamsVariance_Tag::kNoVaryParams: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_no_vary_params, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& no_vary_params_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      if (!mojo::internal::ValidateContainer(object->data.f_no_vary_params, validation_context,
                                             &no_vary_params_validate_params)) {
        return false;
      }
      return true;
    }
    case SearchParamsVariance_Tag::kVaryParams: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_vary_params, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& vary_params_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      if (!mojo::internal::ValidateContainer(object->data.f_vary_params, validation_context,
                                             &vary_params_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SearchParamsVariance");
      return false;
    }
  }
}
// static
bool NoVarySearchWithParseError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const NoVarySearchWithParseError_Data* object = static_cast<const NoVarySearchWithParseError_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case NoVarySearchWithParseError_Tag::kNoVarySearch: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_no_vary_search, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_no_vary_search, validation_context))
        return false;
      return true;
    }
    case NoVarySearchWithParseError_Tag::kParseError: {


      if (!::network::mojom::internal::NoVarySearchParseError_Data
            ::Validate(object->data.f_parse_error, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in NoVarySearchWithParseError");
      return false;
    }
  }
}


// static
bool NoVarySearch_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NoVarySearch_Data* object =
      static_cast<const NoVarySearch_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->search_variance, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->search_variance, validation_context))
    return false;

  return true;
}

NoVarySearch_Data::NoVarySearch_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NoVarySearchParseError>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NoVarySearchParseError value) {
  return std::move(context).WriteString(::network::mojom::NoVarySearchParseErrorToString(value));
}

} // namespace perfetto