// media/capture/mojom/video_effects_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SHARED_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_effects_manager.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class ImageEnhancementDataView;

class BlurDataView;

class FramingDataView;

class VideoEffectsConfigurationDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ImageEnhancementDataView> {
  using Data = ::media::mojom::internal::ImageEnhancement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BlurDataView> {
  using Data = ::media::mojom::internal::Blur_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::FramingDataView> {
  using Data = ::media::mojom::internal::Framing_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEffectsConfigurationDataView> {
  using Data = ::media::mojom::internal::VideoEffectsConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class SetConfigurationResult : int32_t {
  
  kOk = 0,
  
  kError = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SetConfigurationResult value);
inline bool IsKnownEnumValue(SetConfigurationResult value) {
  return internal::SetConfigurationResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class VideoEffectsConfigurationObserverInterfaceBase {};

using VideoEffectsConfigurationObserverPtrDataView =
    mojo::InterfacePtrDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverRequestDataView =
    mojo::InterfaceRequestDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoEffectsConfigurationObserverInterfaceBase>;
using VideoEffectsConfigurationObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoEffectsConfigurationObserverInterfaceBase>;
class ReadonlyVideoEffectsManagerInterfaceBase {};

using ReadonlyVideoEffectsManagerPtrDataView =
    mojo::InterfacePtrDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerRequestDataView =
    mojo::InterfaceRequestDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ReadonlyVideoEffectsManagerInterfaceBase>;
using ReadonlyVideoEffectsManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ReadonlyVideoEffectsManagerInterfaceBase>;


class ImageEnhancementDataView {
 public:
  ImageEnhancementDataView() = default;

  ImageEnhancementDataView(
      internal::ImageEnhancement_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool lighting() const {
    return data_->lighting;
  }
 private:
  internal::ImageEnhancement_Data* data_ = nullptr;
};


class BlurDataView {
 public:
  BlurDataView() = default;

  BlurDataView(
      internal::Blur_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::Blur_Data* data_ = nullptr;
};


class FramingDataView {
 public:
  FramingDataView() = default;

  FramingDataView(
      internal::Framing_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPaddingRatiosDataView(
      ::gfx::mojom::InsetsFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaddingRatios(UserType* output) {
    
    auto* pointer = data_->padding_ratios.Get();
    return mojo::internal::Deserialize<::gfx::mojom::InsetsFDataView>(
        pointer, output, message_);
  }
 private:
  internal::Framing_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoEffectsConfigurationDataView {
 public:
  VideoEffectsConfigurationDataView() = default;

  VideoEffectsConfigurationDataView(
      internal::VideoEffectsConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetImageEnhancementDataView(
      ImageEnhancementDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageEnhancement(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ImageEnhancementDataView, UserType>(),
    "Attempting to read the optional `image_enhancement` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageEnhancement` instead "
    "of `ReadImageEnhancement if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_enhancement.Get();
    return mojo::internal::Deserialize<::media::mojom::ImageEnhancementDataView>(
        pointer, output, message_);
  }
  inline void GetBlurDataView(
      BlurDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlur(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::BlurDataView, UserType>(),
    "Attempting to read the optional `blur` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlur` instead "
    "of `ReadBlur if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blur.Get();
    return mojo::internal::Deserialize<::media::mojom::BlurDataView>(
        pointer, output, message_);
  }
  inline void GetFramingDataView(
      FramingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFraming(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::FramingDataView, UserType>(),
    "Attempting to read the optional `framing` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFraming` instead "
    "of `ReadFraming if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->framing.Get();
    return mojo::internal::Deserialize<::media::mojom::FramingDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoEffectsConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::SetConfigurationResult>
    : public mojo::internal::EnumHashImpl<::media::mojom::SetConfigurationResult> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SetConfigurationResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::SetConfigurationResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::SetConfigurationResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ImageEnhancementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ImageEnhancementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ImageEnhancement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->lighting = Traits::lighting(input);
  }

  static bool Deserialize(::media::mojom::internal::ImageEnhancement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ImageEnhancementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::BlurDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BlurDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Blur_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::media::mojom::internal::Blur_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::BlurDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::FramingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::FramingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Framing_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::padding_ratios(input)) in_padding_ratios = Traits::padding_ratios(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->padding_ratios)::BaseType> padding_ratios_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::InsetsFDataView>(
        in_padding_ratios, padding_ratios_fragment);
    fragment->padding_ratios.Set(
        padding_ratios_fragment.is_null() ? nullptr : padding_ratios_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->padding_ratios.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null padding_ratios in Framing struct");
  }

  static bool Deserialize(::media::mojom::internal::Framing_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::FramingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEffectsConfigurationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEffectsConfigurationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoEffectsConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::image_enhancement(input)) in_image_enhancement = Traits::image_enhancement(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_enhancement)::BaseType> image_enhancement_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::ImageEnhancementDataView>(
        in_image_enhancement, image_enhancement_fragment);
    fragment->image_enhancement.Set(
        image_enhancement_fragment.is_null() ? nullptr : image_enhancement_fragment.data());
    decltype(Traits::blur(input)) in_blur = Traits::blur(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blur)::BaseType> blur_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::BlurDataView>(
        in_blur, blur_fragment);
    fragment->blur.Set(
        blur_fragment.is_null() ? nullptr : blur_fragment.data());
    decltype(Traits::framing(input)) in_framing = Traits::framing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->framing)::BaseType> framing_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::FramingDataView>(
        in_framing, framing_fragment);
    fragment->framing.Set(
        framing_fragment.is_null() ? nullptr : framing_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::VideoEffectsConfiguration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoEffectsConfigurationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {





inline void FramingDataView::GetPaddingRatiosDataView(
    ::gfx::mojom::InsetsFDataView* output) {
  auto pointer = data_->padding_ratios.Get();
  *output = ::gfx::mojom::InsetsFDataView(pointer, message_);
}


inline void VideoEffectsConfigurationDataView::GetImageEnhancementDataView(
    ImageEnhancementDataView* output) {
  auto pointer = data_->image_enhancement.Get();
  *output = ImageEnhancementDataView(pointer, message_);
}
inline void VideoEffectsConfigurationDataView::GetBlurDataView(
    BlurDataView* output) {
  auto pointer = data_->blur.Get();
  *output = BlurDataView(pointer, message_);
}
inline void VideoEffectsConfigurationDataView::GetFramingDataView(
    FramingDataView* output) {
  auto pointer = data_->framing.Get();
  *output = FramingDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::SetConfigurationResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::SetConfigurationResult value);
};

} // namespace perfetto

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_EFFECTS_MANAGER_MOJOM_SHARED_H_