// device/vr/public/mojom/vr_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_H_
#define DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/vr_service.mojom-features.h"  // IWYU pragma: export
#include "device/vr/public/mojom/vr_service.mojom-shared.h"  // IWYU pragma: export
#include "device/vr/public/mojom/vr_service.mojom-forward.h"  // IWYU pragma: export
#include "device/gamepad/public/mojom/gamepad.mojom.h"
#include "device/vr/public/mojom/xr_hand_tracking_data.mojom.h"
#include "device/vr/public/mojom/xr_session.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "gpu/ipc/common/exported_shared_image.mojom.h"
#include "gpu/ipc/common/shared_image_metadata.mojom-forward.h"
#include "gpu/ipc/common/mailbox_holder.mojom.h"
#include "gpu/ipc/common/sync_token.mojom.h"
#include "ui/display/mojom/display.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/gpu_fence_handle.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "device/vr/public/mojom/vr_service_mojom_traits.h"
#include "base/component_export.h"




namespace device::mojom {

class VRServiceProxy;

template <typename ImplRefTraits>
class VRServiceStub;

class VRServiceRequestValidator;
class VRServiceResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRService
    : public VRServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    1802524859
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VRServiceInterfaceBase;
  using Proxy_ = VRServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceRequestValidator;
  using ResponseValidator_ = VRServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kRequestSessionMinVersion = 0,
    kSupportsSessionMinVersion = 0,
    kExitPresentMinVersion = 0,
    kSetFramesThrottledMinVersion = 0,
    kMakeXrCompatibleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SupportsSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExitPresent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFramesThrottled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MakeXrCompatible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VRService() = default;

  
  virtual void SetClient(::mojo::PendingRemote<VRServiceClient> client) = 0;


  using RequestSessionCallback = base::OnceCallback<void(RequestSessionResultPtr)>;
  
  virtual void RequestSession(::device::mojom::XRSessionOptionsPtr options, RequestSessionCallback callback) = 0;


  using SupportsSessionCallback = base::OnceCallback<void(bool)>;
  
  virtual void SupportsSession(::device::mojom::XRSessionOptionsPtr options, SupportsSessionCallback callback) = 0;


  using ExitPresentCallback = base::OnceCallback<void()>;
  
  virtual void ExitPresent(ExitPresentCallback callback) = 0;

  
  virtual void SetFramesThrottled(bool throttled) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result);

  using MakeXrCompatibleCallback = base::OnceCallback<void(XrCompatibleResult)>;
  
  virtual void MakeXrCompatible(MakeXrCompatibleCallback callback) = 0;
};

class XRSessionMetricsRecorderProxy;

template <typename ImplRefTraits>
class XRSessionMetricsRecorderStub;

class XRSessionMetricsRecorderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorder
    : public XRSessionMetricsRecorderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRSessionMetricsRecorderInterfaceBase;
  using Proxy_ = XRSessionMetricsRecorderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionMetricsRecorderStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionMetricsRecorderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReportFeatureUsedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReportFeatureUsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRSessionMetricsRecorder() = default;

  
  virtual void ReportFeatureUsed(::device::mojom::XRSessionFeature feature) = 0;
};

class VRServiceClientProxy;

template <typename ImplRefTraits>
class VRServiceClientStub;

class VRServiceClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClient
    : public VRServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VRServiceClientInterfaceBase;
  using Proxy_ = VRServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VRServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = VRServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VRServiceClient() = default;

  
  virtual void OnDeviceChanged() = 0;
};

class XREnvironmentIntegrationProviderProxy;

template <typename ImplRefTraits>
class XREnvironmentIntegrationProviderStub;

class XREnvironmentIntegrationProviderRequestValidator;
class XREnvironmentIntegrationProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProvider
    : public XREnvironmentIntegrationProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XREnvironmentIntegrationProviderInterfaceBase;
  using Proxy_ = XREnvironmentIntegrationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XREnvironmentIntegrationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XREnvironmentIntegrationProviderRequestValidator;
  using ResponseValidator_ = XREnvironmentIntegrationProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeToHitTestMinVersion = 0,
    kSubscribeToHitTestForTransientInputMinVersion = 0,
    kUnsubscribeFromHitTestMinVersion = 0,
    kCreateAnchorMinVersion = 0,
    kCreatePlaneAnchorMinVersion = 0,
    kDetachAnchorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SubscribeToHitTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubscribeToHitTestForTransientInput_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnsubscribeFromHitTest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAnchor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatePlaneAnchor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DetachAnchor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XREnvironmentIntegrationProvider() = default;


  using SubscribeToHitTestCallback = base::OnceCallback<void(SubscribeToHitTestResult, uint64_t)>;
  
  virtual void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) = 0;


  using SubscribeToHitTestForTransientInputCallback = base::OnceCallback<void(SubscribeToHitTestResult, uint64_t)>;
  
  virtual void SubscribeToHitTestForTransientInput(const std::string& profile_name, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) = 0;

  
  virtual void UnsubscribeFromHitTest(uint64_t subscription_id) = 0;


  using CreateAnchorCallback = base::OnceCallback<void(CreateAnchorResult, uint64_t)>;
  
  virtual void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorCallback callback) = 0;


  using CreatePlaneAnchorCallback = base::OnceCallback<void(CreateAnchorResult, uint64_t)>;
  
  virtual void CreatePlaneAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreatePlaneAnchorCallback callback) = 0;

  
  virtual void DetachAnchor(uint64_t anchor_id) = 0;
};

class XRFrameDataProviderProxy;

template <typename ImplRefTraits>
class XRFrameDataProviderStub;

class XRFrameDataProviderRequestValidator;
class XRFrameDataProviderResponseValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProvider
    : public XRFrameDataProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRFrameDataProviderInterfaceBase;
  using Proxy_ = XRFrameDataProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRFrameDataProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRFrameDataProviderRequestValidator;
  using ResponseValidator_ = XRFrameDataProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetFrameDataMinVersion = 0,
    kGetEnvironmentIntegrationProviderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetFrameData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEnvironmentIntegrationProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRFrameDataProvider() = default;


  using GetFrameDataCallback = base::OnceCallback<void(XRFrameDataPtr)>;
  
  virtual void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) = 0;

  
  virtual void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) = 0;
};

class XRPresentationProviderProxy;

template <typename ImplRefTraits>
class XRPresentationProviderStub;

class XRPresentationProviderRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProvider
    : public XRPresentationProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRPresentationProviderInterfaceBase;
  using Proxy_ = XRPresentationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationProviderStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateLayerBoundsMinVersion = 0,
    kSubmitFrameMissingMinVersion = 0,
    kSubmitFrameMinVersion = 0,
    kSubmitFrameDrawnIntoTextureMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateLayerBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrameMissing_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SubmitFrameDrawnIntoTexture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRPresentationProvider() = default;

  
  virtual void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) = 0;

  
  virtual void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) = 0;

  
  virtual void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) = 0;

  
  virtual void SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) = 0;
};

class XRPresentationClientProxy;

template <typename ImplRefTraits>
class XRPresentationClientStub;

class XRPresentationClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClient
    : public XRPresentationClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRPresentationClientInterfaceBase;
  using Proxy_ = XRPresentationClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRPresentationClientStub<ImplRefTraits>;

  using RequestValidator_ = XRPresentationClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSubmitFrameTransferredMinVersion = 0,
    kOnSubmitFrameRenderedMinVersion = 0,
    kOnSubmitFrameGpuFenceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSubmitFrameTransferred_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSubmitFrameRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSubmitFrameGpuFence_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRPresentationClient() = default;

  
  virtual void OnSubmitFrameTransferred(bool success) = 0;

  
  virtual void OnSubmitFrameRendered() = 0;

  
  virtual void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) = 0;
};

class XRSessionClientProxy;

template <typename ImplRefTraits>
class XRSessionClientStub;

class XRSessionClientRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClient
    : public XRSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = XRSessionClientInterfaceBase;
  using Proxy_ = XRSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = XRSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = XRSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnExitPresentMinVersion = 0,
    kOnVisibilityStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnExitPresent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVisibilityStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~XRSessionClient() = default;

  
  virtual void OnExitPresent() = 0;

  
  virtual void OnVisibilityStateChanged(XRVisibilityState visibility_state) = 0;
};

class WebXrInternalsRendererListenerProxy;

template <typename ImplRefTraits>
class WebXrInternalsRendererListenerStub;

class WebXrInternalsRendererListenerRequestValidator;


class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListener
    : public WebXrInternalsRendererListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebXrInternalsRendererListenerInterfaceBase;
  using Proxy_ = WebXrInternalsRendererListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebXrInternalsRendererListenerStub<ImplRefTraits>;

  using RequestValidator_ = WebXrInternalsRendererListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFrameDataMinVersion = 0,
    kOnConsoleLogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFrameData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConsoleLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebXrInternalsRendererListener() = default;

  
  virtual void OnFrameData(::device::mojom::XrFrameStatisticsPtr xrframe_statistics) = 0;

  
  virtual void OnConsoleLog(::device::mojom::XrLogMessagePtr xrlogging_statistics) = 0;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceProxy
    : public VRService {
 public:
  using InterfaceType = VRService;

  explicit VRServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<VRServiceClient> client) final;
  
  void RequestSession(::device::mojom::XRSessionOptionsPtr options, RequestSessionCallback callback) final;
  
  void SupportsSession(::device::mojom::XRSessionOptionsPtr options, SupportsSessionCallback callback) final;
  
  void ExitPresent(ExitPresentCallback callback) final;
  
  void SetFramesThrottled(bool throttled) final;
  
  bool MakeXrCompatible(XrCompatibleResult* out_xr_compatible_result) final;
  
  void MakeXrCompatible(MakeXrCompatibleCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorderProxy
    : public XRSessionMetricsRecorder {
 public:
  using InterfaceType = XRSessionMetricsRecorder;

  explicit XRSessionMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReportFeatureUsed(::device::mojom::XRSessionFeature feature) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClientProxy
    : public VRServiceClient {
 public:
  using InterfaceType = VRServiceClient;

  explicit VRServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderProxy
    : public XREnvironmentIntegrationProvider {
 public:
  using InterfaceType = XREnvironmentIntegrationProvider;

  explicit XREnvironmentIntegrationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SubscribeToHitTest(XRNativeOriginInformationPtr native_origin_information, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestCallback callback) final;
  
  void SubscribeToHitTestForTransientInput(const std::string& profile_name, const std::vector<EntityTypeForHitTest>& entity_types, XRRayPtr ray, SubscribeToHitTestForTransientInputCallback callback) final;
  
  void UnsubscribeFromHitTest(uint64_t subscription_id) final;
  
  void CreateAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, CreateAnchorCallback callback) final;
  
  void CreatePlaneAnchor(XRNativeOriginInformationPtr native_origin_information, const ::device::Pose& native_origin_from_anchor, uint64_t plane_id, CreatePlaneAnchorCallback callback) final;
  
  void DetachAnchor(uint64_t anchor_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderProxy
    : public XRFrameDataProvider {
 public:
  using InterfaceType = XRFrameDataProvider;

  explicit XRFrameDataProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetFrameData(XRFrameDataRequestOptionsPtr options, GetFrameDataCallback callback) final;
  
  void GetEnvironmentIntegrationProvider(::mojo::PendingAssociatedReceiver<XREnvironmentIntegrationProvider> environment_provider) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProviderProxy
    : public XRPresentationProvider {
 public:
  using InterfaceType = XRPresentationProvider;

  explicit XRPresentationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateLayerBounds(int16_t frame_id, const ::gfx::RectF& left_bounds, const ::gfx::RectF& right_bounds, const ::gfx::Size& source_size) final;
  
  void SubmitFrameMissing(int16_t frame_id, const ::gpu::SyncToken& sync_token) final;
  
  void SubmitFrame(int16_t frame_id, const ::gpu::MailboxHolder& mailbox_holder, ::base::TimeDelta time_waited) final;
  
  void SubmitFrameDrawnIntoTexture(int16_t frameId, const ::gpu::SyncToken& sync_token, ::base::TimeDelta time_waited) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClientProxy
    : public XRPresentationClient {
 public:
  using InterfaceType = XRPresentationClient;

  explicit XRPresentationClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSubmitFrameTransferred(bool success) final;
  
  void OnSubmitFrameRendered() final;
  
  void OnSubmitFrameGpuFence(::gfx::GpuFenceHandle gpu_fence_handle) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClientProxy
    : public XRSessionClient {
 public:
  using InterfaceType = XRSessionClient;

  explicit XRSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnExitPresent() final;
  
  void OnVisibilityStateChanged(XRVisibilityState visibility_state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListenerProxy
    : public WebXrInternalsRendererListener {
 public:
  using InterfaceType = WebXrInternalsRendererListener;

  explicit WebXrInternalsRendererListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFrameData(::device::mojom::XrFrameStatisticsPtr xrframe_statistics) final;
  
  void OnConsoleLog(::device::mojom::XrLogMessagePtr xrlogging_statistics) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceStubDispatch {
 public:
  static bool Accept(VRService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRService>>
class VRServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceStub() = default;
  ~VRServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorderStubDispatch {
 public:
  static bool Accept(XRSessionMetricsRecorder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionMetricsRecorder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionMetricsRecorder>>
class XRSessionMetricsRecorderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionMetricsRecorderStub() = default;
  ~XRSessionMetricsRecorderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionMetricsRecorderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClientStubDispatch {
 public:
  static bool Accept(VRServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VRServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VRServiceClient>>
class VRServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VRServiceClientStub() = default;
  ~VRServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VRServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderStubDispatch {
 public:
  static bool Accept(XREnvironmentIntegrationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XREnvironmentIntegrationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XREnvironmentIntegrationProvider>>
class XREnvironmentIntegrationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XREnvironmentIntegrationProviderStub() = default;
  ~XREnvironmentIntegrationProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XREnvironmentIntegrationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderStubDispatch {
 public:
  static bool Accept(XRFrameDataProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRFrameDataProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRFrameDataProvider>>
class XRFrameDataProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRFrameDataProviderStub() = default;
  ~XRFrameDataProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRFrameDataProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProviderStubDispatch {
 public:
  static bool Accept(XRPresentationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationProvider>>
class XRPresentationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationProviderStub() = default;
  ~XRPresentationProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClientStubDispatch {
 public:
  static bool Accept(XRPresentationClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRPresentationClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRPresentationClient>>
class XRPresentationClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRPresentationClientStub() = default;
  ~XRPresentationClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRPresentationClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClientStubDispatch {
 public:
  static bool Accept(XRSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      XRSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<XRSessionClient>>
class XRSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  XRSessionClientStub() = default;
  ~XRSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return XRSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListenerStubDispatch {
 public:
  static bool Accept(WebXrInternalsRendererListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebXrInternalsRendererListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebXrInternalsRendererListener>>
class WebXrInternalsRendererListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebXrInternalsRendererListenerStub() = default;
  ~WebXrInternalsRendererListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebXrInternalsRendererListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebXrInternalsRendererListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionMetricsRecorderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) WebXrInternalsRendererListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XREnvironmentIntegrationProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRDepthConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthConfig, T>::value>;
  using DataView = XRDepthConfigDataView;
  using Data_ = internal::XRDepthConfig_Data;

  template <typename... Args>
  static XRDepthConfigPtr New(Args&&... args) {
    return XRDepthConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthConfigPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthConfig>::Convert(*this);
  }


  XRDepthConfig();

  XRDepthConfig(
      ::device::mojom::XRDepthUsage depth_usage,
      ::device::mojom::XRDepthDataFormat depth_data_format);


  ~XRDepthConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthConfigPtr>
  XRDepthConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthConfig_UnserializedMessageContext<
            UserType, XRDepthConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthConfig_UnserializedMessageContext<
            UserType, XRDepthConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::mojom::XRDepthUsage depth_usage;
  
  ::device::mojom::XRDepthDataFormat depth_data_format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRFieldOfView {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRFieldOfView, T>::value>;
  using DataView = VRFieldOfViewDataView;
  using Data_ = internal::VRFieldOfView_Data;

  template <typename... Args>
  static VRFieldOfViewPtr New(Args&&... args) {
    return VRFieldOfViewPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRFieldOfViewPtr From(const U& u) {
    return mojo::TypeConverter<VRFieldOfViewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRFieldOfView>::Convert(*this);
  }


  VRFieldOfView();

  VRFieldOfView(
      float up_degrees,
      float down_degrees,
      float left_degrees,
      float right_degrees);


  ~VRFieldOfView();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRFieldOfViewPtr>
  VRFieldOfViewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRFieldOfView::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRFieldOfView::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRFieldOfView::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRFieldOfView_UnserializedMessageContext<
            UserType, VRFieldOfView::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRFieldOfView::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float up_degrees;
  
  float down_degrees;
  
  float left_degrees;
  
  float right_degrees;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRFieldOfView::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationTransportOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationTransportOptions, T>::value>;
  using DataView = XRPresentationTransportOptionsDataView;
  using Data_ = internal::XRPresentationTransportOptions_Data;

  template <typename... Args>
  static XRPresentationTransportOptionsPtr New(Args&&... args) {
    return XRPresentationTransportOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationTransportOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationTransportOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationTransportOptions>::Convert(*this);
  }


  XRPresentationTransportOptions();

  XRPresentationTransportOptions(
      XRPresentationTransportMethod transport_method,
      bool wait_for_transfer_notification,
      bool wait_for_render_notification,
      bool wait_for_gpu_fence);


  ~XRPresentationTransportOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationTransportOptionsPtr>
  XRPresentationTransportOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPresentationTransportOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationTransportOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPresentationTransportOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationTransportOptions_UnserializedMessageContext<
            UserType, XRPresentationTransportOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationTransportOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRPresentationTransportMethod transport_method;
  
  bool wait_for_transfer_notification;
  
  bool wait_for_render_notification;
  
  bool wait_for_gpu_fence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRInputSourceSpaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceSpaceInfo, T>::value>;
  using DataView = XRInputSourceSpaceInfoDataView;
  using Data_ = internal::XRInputSourceSpaceInfo_Data;

  template <typename... Args>
  static XRInputSourceSpaceInfoPtr New(Args&&... args) {
    return XRInputSourceSpaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceSpaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceSpaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceSpaceInfo>::Convert(*this);
  }


  XRInputSourceSpaceInfo();

  XRInputSourceSpaceInfo(
      uint32_t input_source_id,
      XRInputSourceSpaceType input_source_space_type);


  ~XRInputSourceSpaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceSpaceInfoPtr>
  XRInputSourceSpaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceSpaceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceSpaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceSpaceInfo_UnserializedMessageContext<
            UserType, XRInputSourceSpaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceSpaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceSpaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceSpaceInfo_UnserializedMessageContext<
            UserType, XRInputSourceSpaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceSpaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t input_source_id;
  
  XRInputSourceSpaceType input_source_space_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHandJointSpaceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHandJointSpaceInfo, T>::value>;
  using DataView = XRHandJointSpaceInfoDataView;
  using Data_ = internal::XRHandJointSpaceInfo_Data;

  template <typename... Args>
  static XRHandJointSpaceInfoPtr New(Args&&... args) {
    return XRHandJointSpaceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHandJointSpaceInfoPtr From(const U& u) {
    return mojo::TypeConverter<XRHandJointSpaceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHandJointSpaceInfo>::Convert(*this);
  }


  XRHandJointSpaceInfo();

  XRHandJointSpaceInfo(
      XRHandedness handedness,
      ::device::mojom::XRHandJoint joint);


  ~XRHandJointSpaceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHandJointSpaceInfoPtr>
  XRHandJointSpaceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHandJointSpaceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHandJointSpaceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHandJointSpaceInfo_UnserializedMessageContext<
            UserType, XRHandJointSpaceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHandJointSpaceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHandJointSpaceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHandJointSpaceInfo_UnserializedMessageContext<
            UserType, XRHandJointSpaceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHandJointSpaceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRHandedness handedness;
  
  ::device::mojom::XRHandJoint joint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPlanePointData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlanePointData, T>::value>;
  using DataView = XRPlanePointDataDataView;
  using Data_ = internal::XRPlanePointData_Data;

  template <typename... Args>
  static XRPlanePointDataPtr New(Args&&... args) {
    return XRPlanePointDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlanePointDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlanePointDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlanePointData>::Convert(*this);
  }


  XRPlanePointData();

  XRPlanePointData(
      float x,
      float z);


  ~XRPlanePointData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlanePointDataPtr>
  XRPlanePointDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlanePointData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlanePointData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlanePointData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlanePointData_UnserializedMessageContext<
            UserType, XRPlanePointData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlanePointData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float x;
  
  float z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlanePointData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) RgbTupleF32 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RgbTupleF32, T>::value>;
  using DataView = RgbTupleF32DataView;
  using Data_ = internal::RgbTupleF32_Data;

  template <typename... Args>
  static RgbTupleF32Ptr New(Args&&... args) {
    return RgbTupleF32Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RgbTupleF32Ptr From(const U& u) {
    return mojo::TypeConverter<RgbTupleF32Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RgbTupleF32>::Convert(*this);
  }


  RgbTupleF32();

  RgbTupleF32(
      float red,
      float green,
      float blue);


  ~RgbTupleF32();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RgbTupleF32Ptr>
  RgbTupleF32Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbTupleF32::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RgbTupleF32::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RgbTupleF32::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RgbTupleF32_UnserializedMessageContext<
            UserType, RgbTupleF32::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RgbTupleF32::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float red;
  
  float green;
  
  float blue;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RgbTupleF32::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) RgbaTupleF16 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RgbaTupleF16, T>::value>;
  using DataView = RgbaTupleF16DataView;
  using Data_ = internal::RgbaTupleF16_Data;

  template <typename... Args>
  static RgbaTupleF16Ptr New(Args&&... args) {
    return RgbaTupleF16Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RgbaTupleF16Ptr From(const U& u) {
    return mojo::TypeConverter<RgbaTupleF16Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RgbaTupleF16>::Convert(*this);
  }


  RgbaTupleF16();

  RgbaTupleF16(
      uint16_t red,
      uint16_t green,
      uint16_t blue,
      uint16_t alpha);


  ~RgbaTupleF16();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RgbaTupleF16Ptr>
  RgbaTupleF16Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RgbaTupleF16::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RgbaTupleF16::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RgbaTupleF16_UnserializedMessageContext<
            UserType, RgbaTupleF16::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RgbaTupleF16::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RgbaTupleF16::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RgbaTupleF16_UnserializedMessageContext<
            UserType, RgbaTupleF16::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RgbaTupleF16::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t red;
  
  uint16_t green;
  
  uint16_t blue;
  
  uint16_t alpha;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RgbaTupleF16::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRDepthDataStillValid {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataStillValid, T>::value>;
  using DataView = XRDepthDataStillValidDataView;
  using Data_ = internal::XRDepthDataStillValid_Data;

  template <typename... Args>
  static XRDepthDataStillValidPtr New(Args&&... args) {
    return XRDepthDataStillValidPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataStillValidPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataStillValidPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataStillValid>::Convert(*this);
  }


  XRDepthDataStillValid();


  ~XRDepthDataStillValid();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataStillValidPtr>
  XRDepthDataStillValidPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRDepthDataStillValid::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataStillValid::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthDataStillValid::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataStillValid_UnserializedMessageContext<
            UserType, XRDepthDataStillValid::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataStillValid::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameDataRequestOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameDataRequestOptions, T>::value>;
  using DataView = XRFrameDataRequestOptionsDataView;
  using Data_ = internal::XRFrameDataRequestOptions_Data;

  template <typename... Args>
  static XRFrameDataRequestOptionsPtr New(Args&&... args) {
    return XRFrameDataRequestOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataRequestOptionsPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataRequestOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameDataRequestOptions>::Convert(*this);
  }


  XRFrameDataRequestOptions();

  XRFrameDataRequestOptions(
      bool include_lighting_estimation_data,
      uint32_t stage_parameters_id);


  ~XRFrameDataRequestOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataRequestOptionsPtr>
  XRFrameDataRequestOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRFrameDataRequestOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameDataRequestOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRFrameDataRequestOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameDataRequestOptions_UnserializedMessageContext<
            UserType, XRFrameDataRequestOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameDataRequestOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool include_lighting_estimation_data;
  
  uint32_t stage_parameters_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRNativeOriginInformation {
 public:
  using DataView = XRNativeOriginInformationDataView;
  using Data_ = internal::XRNativeOriginInformation_Data;
  using Tag = Data_::XRNativeOriginInformation_Tag;

  template <typename... Args>
  static XRNativeOriginInformationPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |input_source_space_info|.
  static XRNativeOriginInformationPtr
  NewInputSourceSpaceInfo(
      XRInputSourceSpaceInfoPtr value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_input_source_space_info(std::move(value));
    return result;
  }
  // Construct an instance holding |plane_id|.
  static XRNativeOriginInformationPtr
  NewPlaneId(
      uint64_t value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_plane_id(std::move(value));
    return result;
  }
  // Construct an instance holding |anchor_id|.
  static XRNativeOriginInformationPtr
  NewAnchorId(
      uint64_t value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_anchor_id(std::move(value));
    return result;
  }
  // Construct an instance holding |reference_space_type|.
  static XRNativeOriginInformationPtr
  NewReferenceSpaceType(
      XRReferenceSpaceType value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_reference_space_type(std::move(value));
    return result;
  }
  // Construct an instance holding |hand_joint_space_info|.
  static XRNativeOriginInformationPtr
  NewHandJointSpaceInfo(
      XRHandJointSpaceInfoPtr value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_hand_joint_space_info(std::move(value));
    return result;
  }
  // Construct an instance holding |image_index|.
  static XRNativeOriginInformationPtr
  NewImageIndex(
      uint32_t value) {
    auto result = XRNativeOriginInformationPtr(std::in_place);
    result->set_image_index(std::move(value));
    return result;
  }

  template <typename U>
  static XRNativeOriginInformationPtr From(const U& u) {
    return mojo::TypeConverter<XRNativeOriginInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRNativeOriginInformation>::Convert(*this);
  }

  XRNativeOriginInformation();
  ~XRNativeOriginInformation();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  XRNativeOriginInformation(const XRNativeOriginInformation& other) = delete;
  XRNativeOriginInformation& operator=(const XRNativeOriginInformation& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRNativeOriginInformationPtr>
  XRNativeOriginInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRNativeOriginInformation>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRNativeOriginInformation>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_input_source_space_info() const { return tag_ == Tag::kInputSourceSpaceInfo; }

  
  XRInputSourceSpaceInfoPtr& get_input_source_space_info() const {
    CHECK(tag_ == Tag::kInputSourceSpaceInfo);
    return *(data_.input_source_space_info);
  }

  
  void set_input_source_space_info(
      XRInputSourceSpaceInfoPtr input_source_space_info);
  
  bool is_plane_id() const { return tag_ == Tag::kPlaneId; }

  
  uint64_t get_plane_id() const {
    CHECK(tag_ == Tag::kPlaneId);
    return data_.plane_id;
  }

  
  void set_plane_id(
      uint64_t plane_id);
  
  bool is_anchor_id() const { return tag_ == Tag::kAnchorId; }

  
  uint64_t get_anchor_id() const {
    CHECK(tag_ == Tag::kAnchorId);
    return data_.anchor_id;
  }

  
  void set_anchor_id(
      uint64_t anchor_id);
  
  bool is_reference_space_type() const { return tag_ == Tag::kReferenceSpaceType; }

  
  XRReferenceSpaceType get_reference_space_type() const {
    CHECK(tag_ == Tag::kReferenceSpaceType);
    return data_.reference_space_type;
  }

  
  void set_reference_space_type(
      XRReferenceSpaceType reference_space_type);
  
  bool is_hand_joint_space_info() const { return tag_ == Tag::kHandJointSpaceInfo; }

  
  XRHandJointSpaceInfoPtr& get_hand_joint_space_info() const {
    CHECK(tag_ == Tag::kHandJointSpaceInfo);
    return *(data_.hand_joint_space_info);
  }

  
  void set_hand_joint_space_info(
      XRHandJointSpaceInfoPtr hand_joint_space_info);
  
  bool is_image_index() const { return tag_ == Tag::kImageIndex; }

  
  uint32_t get_image_index() const {
    CHECK(tag_ == Tag::kImageIndex);
    return data_.image_index;
  }

  
  void set_image_index(
      uint32_t image_index);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRNativeOriginInformation::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRNativeOriginInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    XRInputSourceSpaceInfoPtr* input_source_space_info;
    uint64_t plane_id;
    uint64_t anchor_id;
    XRReferenceSpaceType reference_space_type;
    XRHandJointSpaceInfoPtr* hand_joint_space_info;
    uint32_t image_index;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRDepthData {
 public:
  using DataView = XRDepthDataDataView;
  using Data_ = internal::XRDepthData_Data;
  using Tag = Data_::XRDepthData_Tag;

  template <typename... Args>
  static XRDepthDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |data_still_valid|.
  static XRDepthDataPtr
  NewDataStillValid(
      XRDepthDataStillValidPtr value) {
    auto result = XRDepthDataPtr(std::in_place);
    result->set_data_still_valid(std::move(value));
    return result;
  }
  // Construct an instance holding |updated_depth_data|.
  static XRDepthDataPtr
  NewUpdatedDepthData(
      XRDepthDataUpdatedPtr value) {
    auto result = XRDepthDataPtr(std::in_place);
    result->set_updated_depth_data(std::move(value));
    return result;
  }

  template <typename U>
  static XRDepthDataPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthData>::Convert(*this);
  }

  XRDepthData();
  ~XRDepthData();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  XRDepthData(const XRDepthData& other) = delete;
  XRDepthData& operator=(const XRDepthData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = XRDepthDataPtr>
  XRDepthDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRDepthData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, XRDepthData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_data_still_valid() const { return tag_ == Tag::kDataStillValid; }

  
  XRDepthDataStillValidPtr& get_data_still_valid() const {
    CHECK(tag_ == Tag::kDataStillValid);
    return *(data_.data_still_valid);
  }

  
  void set_data_still_valid(
      XRDepthDataStillValidPtr data_still_valid);
  
  bool is_updated_depth_data() const { return tag_ == Tag::kUpdatedDepthData; }

  
  XRDepthDataUpdatedPtr& get_updated_depth_data() const {
    CHECK(tag_ == Tag::kUpdatedDepthData);
    return *(data_.updated_depth_data);
  }

  
  void set_updated_depth_data(
      XRDepthDataUpdatedPtr updated_depth_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<XRDepthData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    XRDepthDataStillValidPtr* data_still_valid;
    XRDepthDataUpdatedPtr* updated_depth_data;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) RequestSessionResult {
 public:
  using DataView = RequestSessionResultDataView;
  using Data_ = internal::RequestSessionResult_Data;
  using Tag = Data_::RequestSessionResult_Tag;

  template <typename... Args>
  static RequestSessionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |success|.
  static RequestSessionResultPtr
  NewSuccess(
      RequestSessionSuccessPtr value) {
    auto result = RequestSessionResultPtr(std::in_place);
    result->set_success(std::move(value));
    return result;
  }
  // Construct an instance holding |failure_reason|.
  static RequestSessionResultPtr
  NewFailureReason(
      ::device::mojom::RequestSessionError value) {
    auto result = RequestSessionResultPtr(std::in_place);
    result->set_failure_reason(std::move(value));
    return result;
  }

  template <typename U>
  static RequestSessionResultPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionResult>::Convert(*this);
  }

  RequestSessionResult();
  ~RequestSessionResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  RequestSessionResult(const RequestSessionResult& other) = delete;
  RequestSessionResult& operator=(const RequestSessionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = RequestSessionResultPtr>
  RequestSessionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, RequestSessionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, RequestSessionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_success() const { return tag_ == Tag::kSuccess; }

  
  RequestSessionSuccessPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return *(data_.success);
  }

  
  void set_success(
      RequestSessionSuccessPtr success);
  
  bool is_failure_reason() const { return tag_ == Tag::kFailureReason; }

  
  ::device::mojom::RequestSessionError get_failure_reason() const {
    CHECK(tag_ == Tag::kFailureReason);
    return data_.failure_reason;
  }

  
  void set_failure_reason(
      ::device::mojom::RequestSessionError failure_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<RequestSessionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    RequestSessionSuccessPtr* success;
    ::device::mojom::RequestSessionError failure_reason;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSessionDeviceConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSessionDeviceConfig, T>::value>;
  using DataView = XRSessionDeviceConfigDataView;
  using Data_ = internal::XRSessionDeviceConfig_Data;

  template <typename... Args>
  static XRSessionDeviceConfigPtr New(Args&&... args) {
    return XRSessionDeviceConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionDeviceConfigPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionDeviceConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSessionDeviceConfig>::Convert(*this);
  }


  XRSessionDeviceConfig();

  XRSessionDeviceConfig(
      float default_framebuffer_scale,
      std::vector<XRViewPtr> views,
      bool supports_viewport_scaling,
      bool enable_anti_aliasing,
      XRDepthConfigPtr depth_configuration);

XRSessionDeviceConfig(const XRSessionDeviceConfig&) = delete;
XRSessionDeviceConfig& operator=(const XRSessionDeviceConfig&) = delete;

  ~XRSessionDeviceConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionDeviceConfigPtr>
  XRSessionDeviceConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSessionDeviceConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSessionDeviceConfig_UnserializedMessageContext<
            UserType, XRSessionDeviceConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSessionDeviceConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSessionDeviceConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSessionDeviceConfig_UnserializedMessageContext<
            UserType, XRSessionDeviceConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSessionDeviceConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  float default_framebuffer_scale;
  
  std::vector<XRViewPtr> views;
  
  bool supports_viewport_scaling;
  
  bool enable_anti_aliasing;
  
  XRDepthConfigPtr depth_configuration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSession {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSession, T>::value>;
  using DataView = XRSessionDataView;
  using Data_ = internal::XRSession_Data;

  template <typename... Args>
  static XRSessionPtr New(Args&&... args) {
    return XRSessionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSessionPtr From(const U& u) {
    return mojo::TypeConverter<XRSessionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSession>::Convert(*this);
  }


  XRSession();

  XRSession(
      ::mojo::PendingRemote<XRFrameDataProvider> data_provider,
      ::mojo::PendingReceiver<XRSessionClient> client_receiver,
      XRPresentationConnectionPtr submit_frame_sink,
      std::vector<::device::mojom::XRSessionFeature> enabled_features,
      XRSessionDeviceConfigPtr device_config,
      XREnvironmentBlendMode enviroment_blend_mode,
      XRInteractionMode interaction_mode);

XRSession(const XRSession&) = delete;
XRSession& operator=(const XRSession&) = delete;

  ~XRSession();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSessionPtr>
  XRSessionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSession::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSession::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSession::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSession_UnserializedMessageContext<
            UserType, XRSession::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSession::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<XRFrameDataProvider> data_provider;
  
  ::mojo::PendingReceiver<XRSessionClient> client_receiver;
  
  XRPresentationConnectionPtr submit_frame_sink;
  
  std::vector<::device::mojom::XRSessionFeature> enabled_features;
  
  XRSessionDeviceConfigPtr device_config;
  
  XREnvironmentBlendMode enviroment_blend_mode;
  
  XRInteractionMode interaction_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSession::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPresentationConnection {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPresentationConnection, T>::value>;
  using DataView = XRPresentationConnectionDataView;
  using Data_ = internal::XRPresentationConnection_Data;

  template <typename... Args>
  static XRPresentationConnectionPtr New(Args&&... args) {
    return XRPresentationConnectionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPresentationConnectionPtr From(const U& u) {
    return mojo::TypeConverter<XRPresentationConnectionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPresentationConnection>::Convert(*this);
  }


  XRPresentationConnection();

  XRPresentationConnection(
      ::mojo::PendingRemote<XRPresentationProvider> provider,
      ::mojo::PendingReceiver<XRPresentationClient> client_receiver,
      XRPresentationTransportOptionsPtr transport_options);

XRPresentationConnection(const XRPresentationConnection&) = delete;
XRPresentationConnection& operator=(const XRPresentationConnection&) = delete;

  ~XRPresentationConnection();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPresentationConnectionPtr>
  XRPresentationConnectionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPresentationConnection::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPresentationConnection::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPresentationConnection_UnserializedMessageContext<
            UserType, XRPresentationConnection::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPresentationConnection::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<XRPresentationProvider> provider;
  
  ::mojo::PendingReceiver<XRPresentationClient> client_receiver;
  
  XRPresentationTransportOptionsPtr transport_options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRInputSourceDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceDescription, T>::value>;
  using DataView = XRInputSourceDescriptionDataView;
  using Data_ = internal::XRInputSourceDescription_Data;

  template <typename... Args>
  static XRInputSourceDescriptionPtr New(Args&&... args) {
    return XRInputSourceDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceDescription>::Convert(*this);
  }


  XRInputSourceDescription();

  XRInputSourceDescription(
      XRTargetRayMode target_ray_mode,
      XRHandedness handedness,
      const std::optional<::gfx::Transform>& input_from_pointer,
      std::vector<std::string> profiles);


  ~XRInputSourceDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceDescriptionPtr>
  XRInputSourceDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceDescription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceDescription_UnserializedMessageContext<
            UserType, XRInputSourceDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRTargetRayMode target_ray_mode;
  
  XRHandedness handedness;
  
  std::optional<::gfx::Transform> input_from_pointer;
  
  std::vector<std::string> profiles;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRInputSourceState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRInputSourceState, T>::value>;
  using DataView = XRInputSourceStateDataView;
  using Data_ = internal::XRInputSourceState_Data;

  template <typename... Args>
  static XRInputSourceStatePtr New(Args&&... args) {
    return XRInputSourceStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRInputSourceStatePtr From(const U& u) {
    return mojo::TypeConverter<XRInputSourceStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRInputSourceState>::Convert(*this);
  }


  XRInputSourceState();

  XRInputSourceState(
      uint32_t source_id,
      XRInputSourceDescriptionPtr description,
      const std::optional<::gfx::Transform>& mojo_from_input,
      bool emulated_position,
      bool is_auxiliary,
      bool primary_input_pressed,
      bool primary_input_clicked,
      bool primary_squeeze_pressed,
      bool primary_squeeze_clicked,
      const std::optional<::device::Gamepad>& gamepad,
      const std::optional<::gfx::PointF>& overlay_pointer_position,
      ::device::mojom::XRHandTrackingDataPtr hand_tracking_data);

XRInputSourceState(const XRInputSourceState&) = delete;
XRInputSourceState& operator=(const XRInputSourceState&) = delete;

  ~XRInputSourceState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRInputSourceStatePtr>
  XRInputSourceStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRInputSourceState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRInputSourceState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRInputSourceState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRInputSourceState_UnserializedMessageContext<
            UserType, XRInputSourceState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRInputSourceState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t source_id;
  
  XRInputSourceDescriptionPtr description;
  
  std::optional<::gfx::Transform> mojo_from_input;
  
  bool emulated_position;
  
  bool is_auxiliary;
  
  bool primary_input_pressed;
  
  bool primary_input_clicked;
  
  bool primary_squeeze_pressed;
  
  bool primary_squeeze_clicked;
  
  std::optional<::device::Gamepad> gamepad;
  
  std::optional<::gfx::PointF> overlay_pointer_position;
  
  ::device::mojom::XRHandTrackingDataPtr hand_tracking_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRInputSourceState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRPose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRPose, T>::value>;
  using DataView = VRPoseDataView;
  using Data_ = internal::VRPose_Data;

  template <typename... Args>
  static VRPosePtr New(Args&&... args) {
    return VRPosePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRPosePtr From(const U& u) {
    return mojo::TypeConverter<VRPosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRPose>::Convert(*this);
  }


  VRPose();

  VRPose(
      const std::optional<::gfx::Quaternion>& orientation,
      const std::optional<::gfx::Point3F>& position,
      bool emulated_position);


  ~VRPose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRPosePtr>
  VRPosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRPose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRPose::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRPose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRPose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRPose_UnserializedMessageContext<
            UserType, VRPose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRPose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::gfx::Quaternion> orientation;
  
  std::optional<::gfx::Point3F> position;
  
  bool emulated_position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRPose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) Pose {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Pose, T>::value>;
  using DataView = PoseDataView;
  using Data_ = internal::Pose_Data;

  template <typename... Args>
  static PosePtr New(Args&&... args) {
    return PosePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PosePtr From(const U& u) {
    return mojo::TypeConverter<PosePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Pose>::Convert(*this);
  }


  Pose();

  Pose(
      const ::gfx::Quaternion& orientation,
      const ::gfx::Point3F& position);


  ~Pose();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PosePtr>
  PosePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Pose::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Pose::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Pose::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Pose::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Pose_UnserializedMessageContext<
            UserType, Pose::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Pose::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Quaternion orientation;
  
  ::gfx::Point3F position;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Pose::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRRay {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRRay, T>::value>;
  using DataView = XRRayDataView;
  using Data_ = internal::XRRay_Data;

  template <typename... Args>
  static XRRayPtr New(Args&&... args) {
    return XRRayPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRRayPtr From(const U& u) {
    return mojo::TypeConverter<XRRayPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRRay>::Convert(*this);
  }


  XRRay();

  XRRay(
      const ::gfx::Point3F& origin,
      const ::gfx::Vector3dF& direction);


  ~XRRay();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRRayPtr>
  XRRayPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRRay::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRRay::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRRay::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRRay::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRRay_UnserializedMessageContext<
            UserType, XRRay::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRRay::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Point3F origin;
  
  ::gfx::Vector3dF direction;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRRay::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHitResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitResult, T>::value>;
  using DataView = XRHitResultDataView;
  using Data_ = internal::XRHitResult_Data;

  template <typename... Args>
  static XRHitResultPtr New(Args&&... args) {
    return XRHitResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitResultPtr From(const U& u) {
    return mojo::TypeConverter<XRHitResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitResult>::Convert(*this);
  }


  XRHitResult();

  XRHitResult(
      const ::device::Pose& mojo_from_result,
      uint64_t plane_id);


  ~XRHitResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitResultPtr>
  XRHitResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitResult_UnserializedMessageContext<
            UserType, XRHitResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::device::Pose mojo_from_result;
  
  uint64_t plane_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRView {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRView, T>::value>;
  using DataView = XRViewDataView;
  using Data_ = internal::XRView_Data;

  template <typename... Args>
  static XRViewPtr New(Args&&... args) {
    return XRViewPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRViewPtr From(const U& u) {
    return mojo::TypeConverter<XRViewPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRView>::Convert(*this);
  }


  XRView();

  XRView(
      XREye eye,
      VRFieldOfViewPtr field_of_view,
      const ::gfx::Transform& mojo_from_view,
      const ::gfx::Rect& viewport,
      XRDepthDataPtr depth_data,
      bool is_first_person_observer);

XRView(const XRView&) = delete;
XRView& operator=(const XRView&) = delete;

  ~XRView();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRViewPtr>
  XRViewPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRView::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRView::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRView_UnserializedMessageContext<
            UserType, XRView::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRView::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRView::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRView_UnserializedMessageContext<
            UserType, XRView::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRView::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XREye eye;
  
  VRFieldOfViewPtr field_of_view;
  
  ::gfx::Transform mojo_from_view;
  
  ::gfx::Rect viewport;
  
  XRDepthDataPtr depth_data;
  
  bool is_first_person_observer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRView::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) VRStageParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VRStageParameters, T>::value>;
  using DataView = VRStageParametersDataView;
  using Data_ = internal::VRStageParameters_Data;

  template <typename... Args>
  static VRStageParametersPtr New(Args&&... args) {
    return VRStageParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VRStageParametersPtr From(const U& u) {
    return mojo::TypeConverter<VRStageParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VRStageParameters>::Convert(*this);
  }


  VRStageParameters();

  VRStageParameters(
      const ::gfx::Transform& mojo_from_stage,
      std::optional<std::vector<::gfx::Point3F>> bounds);


  ~VRStageParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VRStageParametersPtr>
  VRStageParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VRStageParameters::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VRStageParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VRStageParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VRStageParameters_UnserializedMessageContext<
            UserType, VRStageParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VRStageParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Transform mojo_from_stage;
  
  std::optional<std::vector<::gfx::Point3F>> bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VRStageParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPlaneData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneData, T>::value>;
  using DataView = XRPlaneDataDataView;
  using Data_ = internal::XRPlaneData_Data;

  template <typename... Args>
  static XRPlaneDataPtr New(Args&&... args) {
    return XRPlaneDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneData>::Convert(*this);
  }


  XRPlaneData();

  XRPlaneData(
      uint64_t id,
      XRPlaneOrientation orientation,
      const std::optional<::device::Pose>& mojo_from_plane,
      std::vector<XRPlanePointDataPtr> polygon);

XRPlaneData(const XRPlaneData&) = delete;
XRPlaneData& operator=(const XRPlaneData&) = delete;

  ~XRPlaneData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDataPtr>
  XRPlaneDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlaneData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneData_UnserializedMessageContext<
            UserType, XRPlaneData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;
  
  XRPlaneOrientation orientation;
  
  std::optional<::device::Pose> mojo_from_plane;
  
  std::vector<XRPlanePointDataPtr> polygon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRPlaneDetectionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRPlaneDetectionData, T>::value>;
  using DataView = XRPlaneDetectionDataDataView;
  using Data_ = internal::XRPlaneDetectionData_Data;

  template <typename... Args>
  static XRPlaneDetectionDataPtr New(Args&&... args) {
    return XRPlaneDetectionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRPlaneDetectionDataPtr From(const U& u) {
    return mojo::TypeConverter<XRPlaneDetectionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRPlaneDetectionData>::Convert(*this);
  }


  XRPlaneDetectionData();

  XRPlaneDetectionData(
      std::vector<uint64_t> all_planes_ids,
      std::vector<XRPlaneDataPtr> updated_planes_data);

XRPlaneDetectionData(const XRPlaneDetectionData&) = delete;
XRPlaneDetectionData& operator=(const XRPlaneDetectionData&) = delete;

  ~XRPlaneDetectionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRPlaneDetectionDataPtr>
  XRPlaneDetectionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRPlaneDetectionData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRPlaneDetectionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRPlaneDetectionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRPlaneDetectionData_UnserializedMessageContext<
            UserType, XRPlaneDetectionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRPlaneDetectionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint64_t> all_planes_ids;
  
  std::vector<XRPlaneDataPtr> updated_planes_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRAnchorData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorData, T>::value>;
  using DataView = XRAnchorDataDataView;
  using Data_ = internal::XRAnchorData_Data;

  template <typename... Args>
  static XRAnchorDataPtr New(Args&&... args) {
    return XRAnchorDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorData>::Convert(*this);
  }


  XRAnchorData();

  XRAnchorData(
      uint64_t id,
      const std::optional<::device::Pose>& mojo_from_anchor);


  ~XRAnchorData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorDataPtr>
  XRAnchorDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRAnchorData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorData_UnserializedMessageContext<
            UserType, XRAnchorData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t id;
  
  std::optional<::device::Pose> mojo_from_anchor;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRAnchorsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRAnchorsData, T>::value>;
  using DataView = XRAnchorsDataDataView;
  using Data_ = internal::XRAnchorsData_Data;

  template <typename... Args>
  static XRAnchorsDataPtr New(Args&&... args) {
    return XRAnchorsDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRAnchorsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRAnchorsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRAnchorsData>::Convert(*this);
  }


  XRAnchorsData();

  XRAnchorsData(
      std::vector<uint64_t> all_anchors_ids,
      std::vector<XRAnchorDataPtr> updated_anchors_data);

XRAnchorsData(const XRAnchorsData&) = delete;
XRAnchorsData& operator=(const XRAnchorsData&) = delete;

  ~XRAnchorsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRAnchorsDataPtr>
  XRAnchorsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRAnchorsData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRAnchorsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRAnchorsData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRAnchorsData_UnserializedMessageContext<
            UserType, XRAnchorsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRAnchorsData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint64_t> all_anchors_ids;
  
  std::vector<XRAnchorDataPtr> updated_anchors_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRAnchorsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHitTestSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultData, T>::value>;
  using DataView = XRHitTestSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultData>::Convert(*this);
  }


  XRHitTestSubscriptionResultData();

  XRHitTestSubscriptionResultData(
      uint64_t subscription_id,
      std::vector<XRHitResultPtr> hit_test_results);

XRHitTestSubscriptionResultData(const XRHitTestSubscriptionResultData&) = delete;
XRHitTestSubscriptionResultData& operator=(const XRHitTestSubscriptionResultData&) = delete;

  ~XRHitTestSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultDataPtr>
  XRHitTestSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestSubscriptionResultData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t subscription_id;
  
  std::vector<XRHitResultPtr> hit_test_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHitTestTransientInputSubscriptionResultData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestTransientInputSubscriptionResultData, T>::value>;
  using DataView = XRHitTestTransientInputSubscriptionResultDataDataView;
  using Data_ = internal::XRHitTestTransientInputSubscriptionResultData_Data;

  template <typename... Args>
  static XRHitTestTransientInputSubscriptionResultDataPtr New(Args&&... args) {
    return XRHitTestTransientInputSubscriptionResultDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestTransientInputSubscriptionResultDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestTransientInputSubscriptionResultDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestTransientInputSubscriptionResultData>::Convert(*this);
  }


  XRHitTestTransientInputSubscriptionResultData();

  XRHitTestTransientInputSubscriptionResultData(
      uint64_t subscription_id,
      base::flat_map<uint32_t, std::vector<XRHitResultPtr>> input_source_id_to_hit_test_results);

XRHitTestTransientInputSubscriptionResultData(const XRHitTestTransientInputSubscriptionResultData&) = delete;
XRHitTestTransientInputSubscriptionResultData& operator=(const XRHitTestTransientInputSubscriptionResultData&) = delete;

  ~XRHitTestTransientInputSubscriptionResultData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestTransientInputSubscriptionResultDataPtr>
  XRHitTestTransientInputSubscriptionResultDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestTransientInputSubscriptionResultData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestTransientInputSubscriptionResultData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestTransientInputSubscriptionResultData_UnserializedMessageContext<
            UserType, XRHitTestTransientInputSubscriptionResultData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestTransientInputSubscriptionResultData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t subscription_id;
  
  base::flat_map<uint32_t, std::vector<XRHitResultPtr>> input_source_id_to_hit_test_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRHitTestSubscriptionResultsData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRHitTestSubscriptionResultsData, T>::value>;
  using DataView = XRHitTestSubscriptionResultsDataDataView;
  using Data_ = internal::XRHitTestSubscriptionResultsData_Data;

  template <typename... Args>
  static XRHitTestSubscriptionResultsDataPtr New(Args&&... args) {
    return XRHitTestSubscriptionResultsDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRHitTestSubscriptionResultsDataPtr From(const U& u) {
    return mojo::TypeConverter<XRHitTestSubscriptionResultsDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRHitTestSubscriptionResultsData>::Convert(*this);
  }


  XRHitTestSubscriptionResultsData();

  XRHitTestSubscriptionResultsData(
      std::vector<XRHitTestSubscriptionResultDataPtr> results,
      std::vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results);

XRHitTestSubscriptionResultsData(const XRHitTestSubscriptionResultsData&) = delete;
XRHitTestSubscriptionResultsData& operator=(const XRHitTestSubscriptionResultsData&) = delete;

  ~XRHitTestSubscriptionResultsData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRHitTestSubscriptionResultsDataPtr>
  XRHitTestSubscriptionResultsDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRHitTestSubscriptionResultsData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRHitTestSubscriptionResultsData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRHitTestSubscriptionResultsData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRHitTestSubscriptionResultsData_UnserializedMessageContext<
            UserType, XRHitTestSubscriptionResultsData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRHitTestSubscriptionResultsData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<XRHitTestSubscriptionResultDataPtr> results;
  
  std::vector<XRHitTestTransientInputSubscriptionResultDataPtr> transient_input_results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRSphericalHarmonics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRSphericalHarmonics, T>::value>;
  using DataView = XRSphericalHarmonicsDataView;
  using Data_ = internal::XRSphericalHarmonics_Data;

  template <typename... Args>
  static XRSphericalHarmonicsPtr New(Args&&... args) {
    return XRSphericalHarmonicsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRSphericalHarmonicsPtr From(const U& u) {
    return mojo::TypeConverter<XRSphericalHarmonicsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRSphericalHarmonics>::Convert(*this);
  }


  XRSphericalHarmonics();

  explicit XRSphericalHarmonics(
      std::vector<::device::RgbTupleF32> coefficients);


  ~XRSphericalHarmonics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRSphericalHarmonicsPtr>
  XRSphericalHarmonicsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRSphericalHarmonics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRSphericalHarmonics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRSphericalHarmonics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRSphericalHarmonics_UnserializedMessageContext<
            UserType, XRSphericalHarmonics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRSphericalHarmonics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::device::RgbTupleF32> coefficients;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRCubeMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRCubeMap, T>::value>;
  using DataView = XRCubeMapDataView;
  using Data_ = internal::XRCubeMap_Data;
  
  static constexpr uint64_t kNumComponentsPerPixel = 4ULL;

  template <typename... Args>
  static XRCubeMapPtr New(Args&&... args) {
    return XRCubeMapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRCubeMapPtr From(const U& u) {
    return mojo::TypeConverter<XRCubeMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRCubeMap>::Convert(*this);
  }


  XRCubeMap();

  XRCubeMap(
      uint32_t width_and_height,
      std::vector<::device::RgbaTupleF16> positive_x,
      std::vector<::device::RgbaTupleF16> negative_x,
      std::vector<::device::RgbaTupleF16> positive_y,
      std::vector<::device::RgbaTupleF16> negative_y,
      std::vector<::device::RgbaTupleF16> positive_z,
      std::vector<::device::RgbaTupleF16> negative_z);


  ~XRCubeMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRCubeMapPtr>
  XRCubeMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRCubeMap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRCubeMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRCubeMap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRCubeMap_UnserializedMessageContext<
            UserType, XRCubeMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRCubeMap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t width_and_height;
  
  std::vector<::device::RgbaTupleF16> positive_x;
  
  std::vector<::device::RgbaTupleF16> negative_x;
  
  std::vector<::device::RgbaTupleF16> positive_y;
  
  std::vector<::device::RgbaTupleF16> negative_y;
  
  std::vector<::device::RgbaTupleF16> positive_z;
  
  std::vector<::device::RgbaTupleF16> negative_z;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRCubeMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRLightProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightProbe, T>::value>;
  using DataView = XRLightProbeDataView;
  using Data_ = internal::XRLightProbe_Data;

  template <typename... Args>
  static XRLightProbePtr New(Args&&... args) {
    return XRLightProbePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightProbePtr From(const U& u) {
    return mojo::TypeConverter<XRLightProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightProbe>::Convert(*this);
  }


  XRLightProbe();

  XRLightProbe(
      XRSphericalHarmonicsPtr spherical_harmonics,
      const ::gfx::Vector3dF& main_light_direction,
      const ::device::RgbTupleF32& main_light_intensity);

XRLightProbe(const XRLightProbe&) = delete;
XRLightProbe& operator=(const XRLightProbe&) = delete;

  ~XRLightProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightProbePtr>
  XRLightProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightProbe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLightProbe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightProbe_UnserializedMessageContext<
            UserType, XRLightProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightProbe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRSphericalHarmonicsPtr spherical_harmonics;
  
  ::gfx::Vector3dF main_light_direction;
  
  ::device::RgbTupleF32 main_light_intensity;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRReflectionProbe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRReflectionProbe, T>::value>;
  using DataView = XRReflectionProbeDataView;
  using Data_ = internal::XRReflectionProbe_Data;

  template <typename... Args>
  static XRReflectionProbePtr New(Args&&... args) {
    return XRReflectionProbePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRReflectionProbePtr From(const U& u) {
    return mojo::TypeConverter<XRReflectionProbePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRReflectionProbe>::Convert(*this);
  }


  XRReflectionProbe();

  explicit XRReflectionProbe(
      XRCubeMapPtr cube_map);

XRReflectionProbe(const XRReflectionProbe&) = delete;
XRReflectionProbe& operator=(const XRReflectionProbe&) = delete;

  ~XRReflectionProbe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRReflectionProbePtr>
  XRReflectionProbePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRReflectionProbe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRReflectionProbe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRReflectionProbe::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRReflectionProbe_UnserializedMessageContext<
            UserType, XRReflectionProbe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRReflectionProbe::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRCubeMapPtr cube_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRLightEstimationData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRLightEstimationData, T>::value>;
  using DataView = XRLightEstimationDataDataView;
  using Data_ = internal::XRLightEstimationData_Data;

  template <typename... Args>
  static XRLightEstimationDataPtr New(Args&&... args) {
    return XRLightEstimationDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRLightEstimationDataPtr From(const U& u) {
    return mojo::TypeConverter<XRLightEstimationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRLightEstimationData>::Convert(*this);
  }


  XRLightEstimationData();

  XRLightEstimationData(
      XRLightProbePtr light_probe,
      XRReflectionProbePtr reflection_probe);

XRLightEstimationData(const XRLightEstimationData&) = delete;
XRLightEstimationData& operator=(const XRLightEstimationData&) = delete;

  ~XRLightEstimationData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRLightEstimationDataPtr>
  XRLightEstimationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRLightEstimationData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRLightEstimationData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRLightEstimationData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRLightEstimationData_UnserializedMessageContext<
            UserType, XRLightEstimationData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRLightEstimationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRLightProbePtr light_probe;
  
  XRReflectionProbePtr reflection_probe;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRDepthDataUpdated {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRDepthDataUpdated, T>::value>;
  using DataView = XRDepthDataUpdatedDataView;
  using Data_ = internal::XRDepthDataUpdated_Data;

  template <typename... Args>
  static XRDepthDataUpdatedPtr New(Args&&... args) {
    return XRDepthDataUpdatedPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRDepthDataUpdatedPtr From(const U& u) {
    return mojo::TypeConverter<XRDepthDataUpdatedPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRDepthDataUpdated>::Convert(*this);
  }


  XRDepthDataUpdated();

  XRDepthDataUpdated(
      ::mojo_base::BigBuffer pixel_data,
      const ::gfx::Transform& norm_texture_from_norm_view,
      const ::gfx::Size& size,
      float raw_value_to_meters);

XRDepthDataUpdated(const XRDepthDataUpdated&) = delete;
XRDepthDataUpdated& operator=(const XRDepthDataUpdated&) = delete;

  ~XRDepthDataUpdated();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRDepthDataUpdatedPtr>
  XRDepthDataUpdatedPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRDepthDataUpdated::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRDepthDataUpdated::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRDepthDataUpdated_UnserializedMessageContext<
            UserType, XRDepthDataUpdated::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRDepthDataUpdated::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo_base::BigBuffer pixel_data;
  
  ::gfx::Transform norm_texture_from_norm_view;
  
  ::gfx::Size size;
  
  float raw_value_to_meters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRTrackedImageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRTrackedImageData, T>::value>;
  using DataView = XRTrackedImageDataDataView;
  using Data_ = internal::XRTrackedImageData_Data;

  template <typename... Args>
  static XRTrackedImageDataPtr New(Args&&... args) {
    return XRTrackedImageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRTrackedImageDataPtr From(const U& u) {
    return mojo::TypeConverter<XRTrackedImageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRTrackedImageData>::Convert(*this);
  }


  XRTrackedImageData();

  XRTrackedImageData(
      uint32_t index,
      const ::device::Pose& mojo_from_image,
      bool actively_tracked,
      float width_in_meters);


  ~XRTrackedImageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRTrackedImageDataPtr>
  XRTrackedImageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRTrackedImageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRTrackedImageData_UnserializedMessageContext<
            UserType, XRTrackedImageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRTrackedImageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRTrackedImageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRTrackedImageData_UnserializedMessageContext<
            UserType, XRTrackedImageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRTrackedImageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t index;
  
  ::device::Pose mojo_from_image;
  
  bool actively_tracked;
  
  float width_in_meters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRTrackedImageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRTrackedImagesData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRTrackedImagesData, T>::value>;
  using DataView = XRTrackedImagesDataDataView;
  using Data_ = internal::XRTrackedImagesData_Data;

  template <typename... Args>
  static XRTrackedImagesDataPtr New(Args&&... args) {
    return XRTrackedImagesDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRTrackedImagesDataPtr From(const U& u) {
    return mojo::TypeConverter<XRTrackedImagesDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRTrackedImagesData>::Convert(*this);
  }


  XRTrackedImagesData();

  XRTrackedImagesData(
      std::vector<XRTrackedImageDataPtr> images_data,
      std::optional<std::vector<bool>> image_trackable_scores);

XRTrackedImagesData(const XRTrackedImagesData&) = delete;
XRTrackedImagesData& operator=(const XRTrackedImagesData&) = delete;

  ~XRTrackedImagesData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRTrackedImagesDataPtr>
  XRTrackedImagesDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        XRTrackedImagesData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRTrackedImagesData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRTrackedImagesData_UnserializedMessageContext<
            UserType, XRTrackedImagesData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRTrackedImagesData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRTrackedImagesData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRTrackedImagesData_UnserializedMessageContext<
            UserType, XRTrackedImagesData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRTrackedImagesData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<XRTrackedImageDataPtr> images_data;
  
  std::optional<std::vector<bool>> image_trackable_scores;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) XRFrameData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<XRFrameData, T>::value>;
  using DataView = XRFrameDataDataView;
  using Data_ = internal::XRFrameData_Data;

  template <typename... Args>
  static XRFrameDataPtr New(Args&&... args) {
    return XRFrameDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static XRFrameDataPtr From(const U& u) {
    return mojo::TypeConverter<XRFrameDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, XRFrameData>::Convert(*this);
  }


  XRFrameData();

  XRFrameData(
      VRPosePtr mojo_from_viewer,
      ::base::TimeDelta time_delta,
      const std::optional<::gpu::ExportedSharedImage>& buffer_shared_image,
      const std::optional<::gpu::SyncToken>& buffer_sync_token,
      const std::optional<::gpu::ExportedSharedImage>& camera_image_buffer_shared_image,
      const std::optional<::gpu::SyncToken>& camera_image_buffer_sync_token,
      const std::optional<::gfx::Size>& camera_image_size,
      bool mojo_space_reset,
      const std::optional<::gfx::Transform>& mojo_from_floor,
      int16_t frame_id,
      std::vector<XRViewPtr> views,
      std::optional<std::vector<XRInputSourceStatePtr>> input_state,
      uint32_t stage_parameters_id,
      VRStageParametersPtr stage_parameters,
      XRPlaneDetectionDataPtr detected_planes_data,
      XRAnchorsDataPtr anchors_data,
      XRLightEstimationDataPtr light_estimation_data,
      XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results,
      float rendering_time_ratio,
      XRTrackedImagesDataPtr tracked_images);

XRFrameData(const XRFrameData&) = delete;
XRFrameData& operator=(const XRFrameData&) = delete;

  ~XRFrameData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = XRFrameDataPtr>
  XRFrameDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        XRFrameData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return XRFrameData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::XRFrameData_UnserializedMessageContext<
            UserType, XRFrameData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<XRFrameData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  VRPosePtr mojo_from_viewer;
  
  ::base::TimeDelta time_delta;
  
  std::optional<::gpu::ExportedSharedImage> buffer_shared_image;
  
  std::optional<::gpu::SyncToken> buffer_sync_token;
  
  std::optional<::gpu::ExportedSharedImage> camera_image_buffer_shared_image;
  
  std::optional<::gpu::SyncToken> camera_image_buffer_sync_token;
  
  std::optional<::gfx::Size> camera_image_size;
  
  bool mojo_space_reset;
  
  std::optional<::gfx::Transform> mojo_from_floor;
  
  int16_t frame_id;
  
  std::vector<XRViewPtr> views;
  
  std::optional<std::vector<XRInputSourceStatePtr>> input_state;
  
  uint32_t stage_parameters_id;
  
  VRStageParametersPtr stage_parameters;
  
  XRPlaneDetectionDataPtr detected_planes_data;
  
  XRAnchorsDataPtr anchors_data;
  
  XRLightEstimationDataPtr light_estimation_data;
  
  XRHitTestSubscriptionResultsDataPtr hit_test_subscription_results;
  
  float rendering_time_ratio;
  
  XRTrackedImagesDataPtr tracked_images;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, XRFrameData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) RequestSessionSuccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestSessionSuccess, T>::value>;
  using DataView = RequestSessionSuccessDataView;
  using Data_ = internal::RequestSessionSuccess_Data;

  template <typename... Args>
  static RequestSessionSuccessPtr New(Args&&... args) {
    return RequestSessionSuccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestSessionSuccessPtr From(const U& u) {
    return mojo::TypeConverter<RequestSessionSuccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestSessionSuccess>::Convert(*this);
  }


  RequestSessionSuccess();

  RequestSessionSuccess(
      XRSessionPtr session,
      uint64_t trace_id,
      ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder,
      ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener);

RequestSessionSuccess(const RequestSessionSuccess&) = delete;
RequestSessionSuccess& operator=(const RequestSessionSuccess&) = delete;

  ~RequestSessionSuccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestSessionSuccessPtr>
  RequestSessionSuccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestSessionSuccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestSessionSuccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestSessionSuccess_UnserializedMessageContext<
            UserType, RequestSessionSuccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestSessionSuccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  XRSessionPtr session;
  
  uint64_t trace_id;
  
  ::mojo::PendingRemote<XRSessionMetricsRecorder> metrics_recorder;
  
  ::mojo::PendingRemote<WebXrInternalsRendererListener> xr_internals_listener;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
XRNativeOriginInformationPtr XRNativeOriginInformation::Clone() const {
  switch (tag_) {
    case Tag::kInputSourceSpaceInfo:
      return NewInputSourceSpaceInfo(
          mojo::Clone(*data_.input_source_space_info));
    case Tag::kPlaneId:
      return NewPlaneId(
          mojo::Clone(data_.plane_id));
    case Tag::kAnchorId:
      return NewAnchorId(
          mojo::Clone(data_.anchor_id));
    case Tag::kReferenceSpaceType:
      return NewReferenceSpaceType(
          mojo::Clone(data_.reference_space_type));
    case Tag::kHandJointSpaceInfo:
      return NewHandJointSpaceInfo(
          mojo::Clone(*data_.hand_joint_space_info));
    case Tag::kImageIndex:
      return NewImageIndex(
          mojo::Clone(data_.image_index));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRNativeOriginInformation>::value>::type*>
bool XRNativeOriginInformation::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInputSourceSpaceInfo:
      return mojo::Equals(*(data_.input_source_space_info), *(other.data_.input_source_space_info));
    case Tag::kPlaneId:
      return mojo::Equals(data_.plane_id, other.data_.plane_id);
    case Tag::kAnchorId:
      return mojo::Equals(data_.anchor_id, other.data_.anchor_id);
    case Tag::kReferenceSpaceType:
      return mojo::Equals(data_.reference_space_type, other.data_.reference_space_type);
    case Tag::kHandJointSpaceInfo:
      return mojo::Equals(*(data_.hand_joint_space_info), *(other.data_.hand_joint_space_info));
    case Tag::kImageIndex:
      return mojo::Equals(data_.image_index, other.data_.image_index);
  }

  return false;
}
template <typename UnionPtrType>
XRDepthDataPtr XRDepthData::Clone() const {
  switch (tag_) {
    case Tag::kDataStillValid:
      return NewDataStillValid(
          mojo::Clone(*data_.data_still_valid));
    case Tag::kUpdatedDepthData:
      return NewUpdatedDepthData(
          mojo::Clone(*data_.updated_depth_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, XRDepthData>::value>::type*>
bool XRDepthData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kDataStillValid:
      return mojo::Equals(*(data_.data_still_valid), *(other.data_.data_still_valid));
    case Tag::kUpdatedDepthData:
      return mojo::Equals(*(data_.updated_depth_data), *(other.data_.updated_depth_data));
  }

  return false;
}
template <typename UnionPtrType>
RequestSessionResultPtr RequestSessionResult::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(*data_.success));
    case Tag::kFailureReason:
      return NewFailureReason(
          mojo::Clone(data_.failure_reason));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, RequestSessionResult>::value>::type*>
bool RequestSessionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(*(data_.success), *(other.data_.success));
    case Tag::kFailureReason:
      return mojo::Equals(data_.failure_reason, other.data_.failure_reason);
  }

  return false;
}
template <typename StructPtrType>
XRDepthConfigPtr XRDepthConfig::Clone() const {
  return New(
      mojo::Clone(depth_usage),
      mojo::Clone(depth_data_format)
  );
}

template <typename T, XRDepthConfig::EnableIfSame<T>*>
bool XRDepthConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->depth_usage, other_struct.depth_usage))
    return false;
  if (!mojo::Equals(this->depth_data_format, other_struct.depth_data_format))
    return false;
  return true;
}

template <typename T, XRDepthConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.depth_usage < rhs.depth_usage)
    return true;
  if (rhs.depth_usage < lhs.depth_usage)
    return false;
  if (lhs.depth_data_format < rhs.depth_data_format)
    return true;
  if (rhs.depth_data_format < lhs.depth_data_format)
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionDeviceConfigPtr XRSessionDeviceConfig::Clone() const {
  return New(
      mojo::Clone(default_framebuffer_scale),
      mojo::Clone(views),
      mojo::Clone(supports_viewport_scaling),
      mojo::Clone(enable_anti_aliasing),
      mojo::Clone(depth_configuration)
  );
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>*>
bool XRSessionDeviceConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->default_framebuffer_scale, other_struct.default_framebuffer_scale))
    return false;
  if (!mojo::Equals(this->views, other_struct.views))
    return false;
  if (!mojo::Equals(this->supports_viewport_scaling, other_struct.supports_viewport_scaling))
    return false;
  if (!mojo::Equals(this->enable_anti_aliasing, other_struct.enable_anti_aliasing))
    return false;
  if (!mojo::Equals(this->depth_configuration, other_struct.depth_configuration))
    return false;
  return true;
}

template <typename T, XRSessionDeviceConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.default_framebuffer_scale < rhs.default_framebuffer_scale)
    return true;
  if (rhs.default_framebuffer_scale < lhs.default_framebuffer_scale)
    return false;
  if (lhs.views < rhs.views)
    return true;
  if (rhs.views < lhs.views)
    return false;
  if (lhs.supports_viewport_scaling < rhs.supports_viewport_scaling)
    return true;
  if (rhs.supports_viewport_scaling < lhs.supports_viewport_scaling)
    return false;
  if (lhs.enable_anti_aliasing < rhs.enable_anti_aliasing)
    return true;
  if (rhs.enable_anti_aliasing < lhs.enable_anti_aliasing)
    return false;
  if (lhs.depth_configuration < rhs.depth_configuration)
    return true;
  if (rhs.depth_configuration < lhs.depth_configuration)
    return false;
  return false;
}
template <typename StructPtrType>
XRSessionPtr XRSession::Clone() const {
  return New(
      mojo::Clone(data_provider),
      mojo::Clone(client_receiver),
      mojo::Clone(submit_frame_sink),
      mojo::Clone(enabled_features),
      mojo::Clone(device_config),
      mojo::Clone(enviroment_blend_mode),
      mojo::Clone(interaction_mode)
  );
}

template <typename T, XRSession::EnableIfSame<T>*>
bool XRSession::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data_provider, other_struct.data_provider))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->submit_frame_sink, other_struct.submit_frame_sink))
    return false;
  if (!mojo::Equals(this->enabled_features, other_struct.enabled_features))
    return false;
  if (!mojo::Equals(this->device_config, other_struct.device_config))
    return false;
  if (!mojo::Equals(this->enviroment_blend_mode, other_struct.enviroment_blend_mode))
    return false;
  if (!mojo::Equals(this->interaction_mode, other_struct.interaction_mode))
    return false;
  return true;
}

template <typename T, XRSession::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data_provider < rhs.data_provider)
    return true;
  if (rhs.data_provider < lhs.data_provider)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  if (lhs.submit_frame_sink < rhs.submit_frame_sink)
    return true;
  if (rhs.submit_frame_sink < lhs.submit_frame_sink)
    return false;
  if (lhs.enabled_features < rhs.enabled_features)
    return true;
  if (rhs.enabled_features < lhs.enabled_features)
    return false;
  if (lhs.device_config < rhs.device_config)
    return true;
  if (rhs.device_config < lhs.device_config)
    return false;
  if (lhs.enviroment_blend_mode < rhs.enviroment_blend_mode)
    return true;
  if (rhs.enviroment_blend_mode < lhs.enviroment_blend_mode)
    return false;
  if (lhs.interaction_mode < rhs.interaction_mode)
    return true;
  if (rhs.interaction_mode < lhs.interaction_mode)
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationConnectionPtr XRPresentationConnection::Clone() const {
  return New(
      mojo::Clone(provider),
      mojo::Clone(client_receiver),
      mojo::Clone(transport_options)
  );
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool XRPresentationConnection::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider, other_struct.provider))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->transport_options, other_struct.transport_options))
    return false;
  return true;
}

template <typename T, XRPresentationConnection::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider < rhs.provider)
    return true;
  if (rhs.provider < lhs.provider)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  if (lhs.transport_options < rhs.transport_options)
    return true;
  if (rhs.transport_options < lhs.transport_options)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceDescriptionPtr XRInputSourceDescription::Clone() const {
  return New(
      mojo::Clone(target_ray_mode),
      mojo::Clone(handedness),
      mojo::Clone(input_from_pointer),
      mojo::Clone(profiles)
  );
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool XRInputSourceDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->target_ray_mode, other_struct.target_ray_mode))
    return false;
  if (!mojo::Equals(this->handedness, other_struct.handedness))
    return false;
  if (!mojo::Equals(this->input_from_pointer, other_struct.input_from_pointer))
    return false;
  if (!mojo::Equals(this->profiles, other_struct.profiles))
    return false;
  return true;
}

template <typename T, XRInputSourceDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.target_ray_mode < rhs.target_ray_mode)
    return true;
  if (rhs.target_ray_mode < lhs.target_ray_mode)
    return false;
  if (lhs.handedness < rhs.handedness)
    return true;
  if (rhs.handedness < lhs.handedness)
    return false;
  if (lhs.input_from_pointer < rhs.input_from_pointer)
    return true;
  if (rhs.input_from_pointer < lhs.input_from_pointer)
    return false;
  if (lhs.profiles < rhs.profiles)
    return true;
  if (rhs.profiles < lhs.profiles)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceStatePtr XRInputSourceState::Clone() const {
  return New(
      mojo::Clone(source_id),
      mojo::Clone(description),
      mojo::Clone(mojo_from_input),
      mojo::Clone(emulated_position),
      mojo::Clone(is_auxiliary),
      mojo::Clone(primary_input_pressed),
      mojo::Clone(primary_input_clicked),
      mojo::Clone(primary_squeeze_pressed),
      mojo::Clone(primary_squeeze_clicked),
      mojo::Clone(gamepad),
      mojo::Clone(overlay_pointer_position),
      mojo::Clone(hand_tracking_data)
  );
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool XRInputSourceState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  if (!mojo::Equals(this->mojo_from_input, other_struct.mojo_from_input))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  if (!mojo::Equals(this->is_auxiliary, other_struct.is_auxiliary))
    return false;
  if (!mojo::Equals(this->primary_input_pressed, other_struct.primary_input_pressed))
    return false;
  if (!mojo::Equals(this->primary_input_clicked, other_struct.primary_input_clicked))
    return false;
  if (!mojo::Equals(this->primary_squeeze_pressed, other_struct.primary_squeeze_pressed))
    return false;
  if (!mojo::Equals(this->primary_squeeze_clicked, other_struct.primary_squeeze_clicked))
    return false;
  if (!mojo::Equals(this->gamepad, other_struct.gamepad))
    return false;
  if (!mojo::Equals(this->overlay_pointer_position, other_struct.overlay_pointer_position))
    return false;
  if (!mojo::Equals(this->hand_tracking_data, other_struct.hand_tracking_data))
    return false;
  return true;
}

template <typename T, XRInputSourceState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  if (lhs.mojo_from_input < rhs.mojo_from_input)
    return true;
  if (rhs.mojo_from_input < lhs.mojo_from_input)
    return false;
  if (lhs.emulated_position < rhs.emulated_position)
    return true;
  if (rhs.emulated_position < lhs.emulated_position)
    return false;
  if (lhs.is_auxiliary < rhs.is_auxiliary)
    return true;
  if (rhs.is_auxiliary < lhs.is_auxiliary)
    return false;
  if (lhs.primary_input_pressed < rhs.primary_input_pressed)
    return true;
  if (rhs.primary_input_pressed < lhs.primary_input_pressed)
    return false;
  if (lhs.primary_input_clicked < rhs.primary_input_clicked)
    return true;
  if (rhs.primary_input_clicked < lhs.primary_input_clicked)
    return false;
  if (lhs.primary_squeeze_pressed < rhs.primary_squeeze_pressed)
    return true;
  if (rhs.primary_squeeze_pressed < lhs.primary_squeeze_pressed)
    return false;
  if (lhs.primary_squeeze_clicked < rhs.primary_squeeze_clicked)
    return true;
  if (rhs.primary_squeeze_clicked < lhs.primary_squeeze_clicked)
    return false;
  if (lhs.gamepad < rhs.gamepad)
    return true;
  if (rhs.gamepad < lhs.gamepad)
    return false;
  if (lhs.overlay_pointer_position < rhs.overlay_pointer_position)
    return true;
  if (rhs.overlay_pointer_position < lhs.overlay_pointer_position)
    return false;
  if (lhs.hand_tracking_data < rhs.hand_tracking_data)
    return true;
  if (rhs.hand_tracking_data < lhs.hand_tracking_data)
    return false;
  return false;
}
template <typename StructPtrType>
VRFieldOfViewPtr VRFieldOfView::Clone() const {
  return New(
      mojo::Clone(up_degrees),
      mojo::Clone(down_degrees),
      mojo::Clone(left_degrees),
      mojo::Clone(right_degrees)
  );
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool VRFieldOfView::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->up_degrees, other_struct.up_degrees))
    return false;
  if (!mojo::Equals(this->down_degrees, other_struct.down_degrees))
    return false;
  if (!mojo::Equals(this->left_degrees, other_struct.left_degrees))
    return false;
  if (!mojo::Equals(this->right_degrees, other_struct.right_degrees))
    return false;
  return true;
}

template <typename T, VRFieldOfView::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.up_degrees < rhs.up_degrees)
    return true;
  if (rhs.up_degrees < lhs.up_degrees)
    return false;
  if (lhs.down_degrees < rhs.down_degrees)
    return true;
  if (rhs.down_degrees < lhs.down_degrees)
    return false;
  if (lhs.left_degrees < rhs.left_degrees)
    return true;
  if (rhs.left_degrees < lhs.left_degrees)
    return false;
  if (lhs.right_degrees < rhs.right_degrees)
    return true;
  if (rhs.right_degrees < lhs.right_degrees)
    return false;
  return false;
}
template <typename StructPtrType>
VRPosePtr VRPose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position),
      mojo::Clone(emulated_position)
  );
}

template <typename T, VRPose::EnableIfSame<T>*>
bool VRPose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->emulated_position, other_struct.emulated_position))
    return false;
  return true;
}

template <typename T, VRPose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  if (lhs.emulated_position < rhs.emulated_position)
    return true;
  if (rhs.emulated_position < lhs.emulated_position)
    return false;
  return false;
}
template <typename StructPtrType>
PosePtr Pose::Clone() const {
  return New(
      mojo::Clone(orientation),
      mojo::Clone(position)
  );
}

template <typename T, Pose::EnableIfSame<T>*>
bool Pose::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  return true;
}

template <typename T, Pose::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.position < rhs.position)
    return true;
  if (rhs.position < lhs.position)
    return false;
  return false;
}
template <typename StructPtrType>
XRRayPtr XRRay::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(direction)
  );
}

template <typename T, XRRay::EnableIfSame<T>*>
bool XRRay::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  return true;
}

template <typename T, XRRay::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.origin < rhs.origin)
    return true;
  if (rhs.origin < lhs.origin)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitResultPtr XRHitResult::Clone() const {
  return New(
      mojo::Clone(mojo_from_result),
      mojo::Clone(plane_id)
  );
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool XRHitResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_result, other_struct.mojo_from_result))
    return false;
  if (!mojo::Equals(this->plane_id, other_struct.plane_id))
    return false;
  return true;
}

template <typename T, XRHitResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mojo_from_result < rhs.mojo_from_result)
    return true;
  if (rhs.mojo_from_result < lhs.mojo_from_result)
    return false;
  if (lhs.plane_id < rhs.plane_id)
    return true;
  if (rhs.plane_id < lhs.plane_id)
    return false;
  return false;
}
template <typename StructPtrType>
XRViewPtr XRView::Clone() const {
  return New(
      mojo::Clone(eye),
      mojo::Clone(field_of_view),
      mojo::Clone(mojo_from_view),
      mojo::Clone(viewport),
      mojo::Clone(depth_data),
      mojo::Clone(is_first_person_observer)
  );
}

template <typename T, XRView::EnableIfSame<T>*>
bool XRView::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->eye, other_struct.eye))
    return false;
  if (!mojo::Equals(this->field_of_view, other_struct.field_of_view))
    return false;
  if (!mojo::Equals(this->mojo_from_view, other_struct.mojo_from_view))
    return false;
  if (!mojo::Equals(this->viewport, other_struct.viewport))
    return false;
  if (!mojo::Equals(this->depth_data, other_struct.depth_data))
    return false;
  if (!mojo::Equals(this->is_first_person_observer, other_struct.is_first_person_observer))
    return false;
  return true;
}

template <typename T, XRView::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.eye < rhs.eye)
    return true;
  if (rhs.eye < lhs.eye)
    return false;
  if (lhs.field_of_view < rhs.field_of_view)
    return true;
  if (rhs.field_of_view < lhs.field_of_view)
    return false;
  if (lhs.mojo_from_view < rhs.mojo_from_view)
    return true;
  if (rhs.mojo_from_view < lhs.mojo_from_view)
    return false;
  if (lhs.viewport < rhs.viewport)
    return true;
  if (rhs.viewport < lhs.viewport)
    return false;
  if (lhs.depth_data < rhs.depth_data)
    return true;
  if (rhs.depth_data < lhs.depth_data)
    return false;
  if (lhs.is_first_person_observer < rhs.is_first_person_observer)
    return true;
  if (rhs.is_first_person_observer < lhs.is_first_person_observer)
    return false;
  return false;
}
template <typename StructPtrType>
VRStageParametersPtr VRStageParameters::Clone() const {
  return New(
      mojo::Clone(mojo_from_stage),
      mojo::Clone(bounds)
  );
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool VRStageParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_stage, other_struct.mojo_from_stage))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  return true;
}

template <typename T, VRStageParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mojo_from_stage < rhs.mojo_from_stage)
    return true;
  if (rhs.mojo_from_stage < lhs.mojo_from_stage)
    return false;
  if (lhs.bounds < rhs.bounds)
    return true;
  if (rhs.bounds < lhs.bounds)
    return false;
  return false;
}
template <typename StructPtrType>
XRPresentationTransportOptionsPtr XRPresentationTransportOptions::Clone() const {
  return New(
      mojo::Clone(transport_method),
      mojo::Clone(wait_for_transfer_notification),
      mojo::Clone(wait_for_render_notification),
      mojo::Clone(wait_for_gpu_fence)
  );
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool XRPresentationTransportOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->transport_method, other_struct.transport_method))
    return false;
  if (!mojo::Equals(this->wait_for_transfer_notification, other_struct.wait_for_transfer_notification))
    return false;
  if (!mojo::Equals(this->wait_for_render_notification, other_struct.wait_for_render_notification))
    return false;
  if (!mojo::Equals(this->wait_for_gpu_fence, other_struct.wait_for_gpu_fence))
    return false;
  return true;
}

template <typename T, XRPresentationTransportOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.transport_method < rhs.transport_method)
    return true;
  if (rhs.transport_method < lhs.transport_method)
    return false;
  if (lhs.wait_for_transfer_notification < rhs.wait_for_transfer_notification)
    return true;
  if (rhs.wait_for_transfer_notification < lhs.wait_for_transfer_notification)
    return false;
  if (lhs.wait_for_render_notification < rhs.wait_for_render_notification)
    return true;
  if (rhs.wait_for_render_notification < lhs.wait_for_render_notification)
    return false;
  if (lhs.wait_for_gpu_fence < rhs.wait_for_gpu_fence)
    return true;
  if (rhs.wait_for_gpu_fence < lhs.wait_for_gpu_fence)
    return false;
  return false;
}
template <typename StructPtrType>
XRInputSourceSpaceInfoPtr XRInputSourceSpaceInfo::Clone() const {
  return New(
      mojo::Clone(input_source_id),
      mojo::Clone(input_source_space_type)
  );
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>*>
bool XRInputSourceSpaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->input_source_id, other_struct.input_source_id))
    return false;
  if (!mojo::Equals(this->input_source_space_type, other_struct.input_source_space_type))
    return false;
  return true;
}

template <typename T, XRInputSourceSpaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.input_source_id < rhs.input_source_id)
    return true;
  if (rhs.input_source_id < lhs.input_source_id)
    return false;
  if (lhs.input_source_space_type < rhs.input_source_space_type)
    return true;
  if (rhs.input_source_space_type < lhs.input_source_space_type)
    return false;
  return false;
}
template <typename StructPtrType>
XRHandJointSpaceInfoPtr XRHandJointSpaceInfo::Clone() const {
  return New(
      mojo::Clone(handedness),
      mojo::Clone(joint)
  );
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>*>
bool XRHandJointSpaceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->handedness, other_struct.handedness))
    return false;
  if (!mojo::Equals(this->joint, other_struct.joint))
    return false;
  return true;
}

template <typename T, XRHandJointSpaceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.handedness < rhs.handedness)
    return true;
  if (rhs.handedness < lhs.handedness)
    return false;
  if (lhs.joint < rhs.joint)
    return true;
  if (rhs.joint < lhs.joint)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlanePointDataPtr XRPlanePointData::Clone() const {
  return New(
      mojo::Clone(x),
      mojo::Clone(z)
  );
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool XRPlanePointData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->x, other_struct.x))
    return false;
  if (!mojo::Equals(this->z, other_struct.z))
    return false;
  return true;
}

template <typename T, XRPlanePointData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.x < rhs.x)
    return true;
  if (rhs.x < lhs.x)
    return false;
  if (lhs.z < rhs.z)
    return true;
  if (rhs.z < lhs.z)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDataPtr XRPlaneData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(orientation),
      mojo::Clone(mojo_from_plane),
      mojo::Clone(polygon)
  );
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool XRPlaneData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->orientation, other_struct.orientation))
    return false;
  if (!mojo::Equals(this->mojo_from_plane, other_struct.mojo_from_plane))
    return false;
  if (!mojo::Equals(this->polygon, other_struct.polygon))
    return false;
  return true;
}

template <typename T, XRPlaneData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.orientation < rhs.orientation)
    return true;
  if (rhs.orientation < lhs.orientation)
    return false;
  if (lhs.mojo_from_plane < rhs.mojo_from_plane)
    return true;
  if (rhs.mojo_from_plane < lhs.mojo_from_plane)
    return false;
  if (lhs.polygon < rhs.polygon)
    return true;
  if (rhs.polygon < lhs.polygon)
    return false;
  return false;
}
template <typename StructPtrType>
XRPlaneDetectionDataPtr XRPlaneDetectionData::Clone() const {
  return New(
      mojo::Clone(all_planes_ids),
      mojo::Clone(updated_planes_data)
  );
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool XRPlaneDetectionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_planes_ids, other_struct.all_planes_ids))
    return false;
  if (!mojo::Equals(this->updated_planes_data, other_struct.updated_planes_data))
    return false;
  return true;
}

template <typename T, XRPlaneDetectionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_planes_ids < rhs.all_planes_ids)
    return true;
  if (rhs.all_planes_ids < lhs.all_planes_ids)
    return false;
  if (lhs.updated_planes_data < rhs.updated_planes_data)
    return true;
  if (rhs.updated_planes_data < lhs.updated_planes_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorDataPtr XRAnchorData::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(mojo_from_anchor)
  );
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool XRAnchorData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->mojo_from_anchor, other_struct.mojo_from_anchor))
    return false;
  return true;
}

template <typename T, XRAnchorData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.mojo_from_anchor < rhs.mojo_from_anchor)
    return true;
  if (rhs.mojo_from_anchor < lhs.mojo_from_anchor)
    return false;
  return false;
}
template <typename StructPtrType>
XRAnchorsDataPtr XRAnchorsData::Clone() const {
  return New(
      mojo::Clone(all_anchors_ids),
      mojo::Clone(updated_anchors_data)
  );
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool XRAnchorsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_anchors_ids, other_struct.all_anchors_ids))
    return false;
  if (!mojo::Equals(this->updated_anchors_data, other_struct.updated_anchors_data))
    return false;
  return true;
}

template <typename T, XRAnchorsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_anchors_ids < rhs.all_anchors_ids)
    return true;
  if (rhs.all_anchors_ids < lhs.all_anchors_ids)
    return false;
  if (lhs.updated_anchors_data < rhs.updated_anchors_data)
    return true;
  if (rhs.updated_anchors_data < lhs.updated_anchors_data)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultDataPtr XRHitTestSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(hit_test_results)
  );
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->hit_test_results, other_struct.hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subscription_id < rhs.subscription_id)
    return true;
  if (rhs.subscription_id < lhs.subscription_id)
    return false;
  if (lhs.hit_test_results < rhs.hit_test_results)
    return true;
  if (rhs.hit_test_results < lhs.hit_test_results)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestTransientInputSubscriptionResultDataPtr XRHitTestTransientInputSubscriptionResultData::Clone() const {
  return New(
      mojo::Clone(subscription_id),
      mojo::Clone(input_source_id_to_hit_test_results)
  );
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool XRHitTestTransientInputSubscriptionResultData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->subscription_id, other_struct.subscription_id))
    return false;
  if (!mojo::Equals(this->input_source_id_to_hit_test_results, other_struct.input_source_id_to_hit_test_results))
    return false;
  return true;
}

template <typename T, XRHitTestTransientInputSubscriptionResultData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.subscription_id < rhs.subscription_id)
    return true;
  if (rhs.subscription_id < lhs.subscription_id)
    return false;
  if (lhs.input_source_id_to_hit_test_results < rhs.input_source_id_to_hit_test_results)
    return true;
  if (rhs.input_source_id_to_hit_test_results < lhs.input_source_id_to_hit_test_results)
    return false;
  return false;
}
template <typename StructPtrType>
XRHitTestSubscriptionResultsDataPtr XRHitTestSubscriptionResultsData::Clone() const {
  return New(
      mojo::Clone(results),
      mojo::Clone(transient_input_results)
  );
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool XRHitTestSubscriptionResultsData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->results, other_struct.results))
    return false;
  if (!mojo::Equals(this->transient_input_results, other_struct.transient_input_results))
    return false;
  return true;
}

template <typename T, XRHitTestSubscriptionResultsData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.results < rhs.results)
    return true;
  if (rhs.results < lhs.results)
    return false;
  if (lhs.transient_input_results < rhs.transient_input_results)
    return true;
  if (rhs.transient_input_results < lhs.transient_input_results)
    return false;
  return false;
}
template <typename StructPtrType>
RgbTupleF32Ptr RgbTupleF32::Clone() const {
  return New(
      mojo::Clone(red),
      mojo::Clone(green),
      mojo::Clone(blue)
  );
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool RgbTupleF32::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->red, other_struct.red))
    return false;
  if (!mojo::Equals(this->green, other_struct.green))
    return false;
  if (!mojo::Equals(this->blue, other_struct.blue))
    return false;
  return true;
}

template <typename T, RgbTupleF32::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.red < rhs.red)
    return true;
  if (rhs.red < lhs.red)
    return false;
  if (lhs.green < rhs.green)
    return true;
  if (rhs.green < lhs.green)
    return false;
  if (lhs.blue < rhs.blue)
    return true;
  if (rhs.blue < lhs.blue)
    return false;
  return false;
}
template <typename StructPtrType>
XRSphericalHarmonicsPtr XRSphericalHarmonics::Clone() const {
  return New(
      mojo::Clone(coefficients)
  );
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool XRSphericalHarmonics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->coefficients, other_struct.coefficients))
    return false;
  return true;
}

template <typename T, XRSphericalHarmonics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.coefficients < rhs.coefficients)
    return true;
  if (rhs.coefficients < lhs.coefficients)
    return false;
  return false;
}
template <typename StructPtrType>
RgbaTupleF16Ptr RgbaTupleF16::Clone() const {
  return New(
      mojo::Clone(red),
      mojo::Clone(green),
      mojo::Clone(blue),
      mojo::Clone(alpha)
  );
}

template <typename T, RgbaTupleF16::EnableIfSame<T>*>
bool RgbaTupleF16::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->red, other_struct.red))
    return false;
  if (!mojo::Equals(this->green, other_struct.green))
    return false;
  if (!mojo::Equals(this->blue, other_struct.blue))
    return false;
  if (!mojo::Equals(this->alpha, other_struct.alpha))
    return false;
  return true;
}

template <typename T, RgbaTupleF16::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.red < rhs.red)
    return true;
  if (rhs.red < lhs.red)
    return false;
  if (lhs.green < rhs.green)
    return true;
  if (rhs.green < lhs.green)
    return false;
  if (lhs.blue < rhs.blue)
    return true;
  if (rhs.blue < lhs.blue)
    return false;
  if (lhs.alpha < rhs.alpha)
    return true;
  if (rhs.alpha < lhs.alpha)
    return false;
  return false;
}
template <typename StructPtrType>
XRCubeMapPtr XRCubeMap::Clone() const {
  return New(
      mojo::Clone(width_and_height),
      mojo::Clone(positive_x),
      mojo::Clone(negative_x),
      mojo::Clone(positive_y),
      mojo::Clone(negative_y),
      mojo::Clone(positive_z),
      mojo::Clone(negative_z)
  );
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool XRCubeMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width_and_height, other_struct.width_and_height))
    return false;
  if (!mojo::Equals(this->positive_x, other_struct.positive_x))
    return false;
  if (!mojo::Equals(this->negative_x, other_struct.negative_x))
    return false;
  if (!mojo::Equals(this->positive_y, other_struct.positive_y))
    return false;
  if (!mojo::Equals(this->negative_y, other_struct.negative_y))
    return false;
  if (!mojo::Equals(this->positive_z, other_struct.positive_z))
    return false;
  if (!mojo::Equals(this->negative_z, other_struct.negative_z))
    return false;
  return true;
}

template <typename T, XRCubeMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width_and_height < rhs.width_and_height)
    return true;
  if (rhs.width_and_height < lhs.width_and_height)
    return false;
  if (lhs.positive_x < rhs.positive_x)
    return true;
  if (rhs.positive_x < lhs.positive_x)
    return false;
  if (lhs.negative_x < rhs.negative_x)
    return true;
  if (rhs.negative_x < lhs.negative_x)
    return false;
  if (lhs.positive_y < rhs.positive_y)
    return true;
  if (rhs.positive_y < lhs.positive_y)
    return false;
  if (lhs.negative_y < rhs.negative_y)
    return true;
  if (rhs.negative_y < lhs.negative_y)
    return false;
  if (lhs.positive_z < rhs.positive_z)
    return true;
  if (rhs.positive_z < lhs.positive_z)
    return false;
  if (lhs.negative_z < rhs.negative_z)
    return true;
  if (rhs.negative_z < lhs.negative_z)
    return false;
  return false;
}
template <typename StructPtrType>
XRLightProbePtr XRLightProbe::Clone() const {
  return New(
      mojo::Clone(spherical_harmonics),
      mojo::Clone(main_light_direction),
      mojo::Clone(main_light_intensity)
  );
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool XRLightProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spherical_harmonics, other_struct.spherical_harmonics))
    return false;
  if (!mojo::Equals(this->main_light_direction, other_struct.main_light_direction))
    return false;
  if (!mojo::Equals(this->main_light_intensity, other_struct.main_light_intensity))
    return false;
  return true;
}

template <typename T, XRLightProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spherical_harmonics < rhs.spherical_harmonics)
    return true;
  if (rhs.spherical_harmonics < lhs.spherical_harmonics)
    return false;
  if (lhs.main_light_direction < rhs.main_light_direction)
    return true;
  if (rhs.main_light_direction < lhs.main_light_direction)
    return false;
  if (lhs.main_light_intensity < rhs.main_light_intensity)
    return true;
  if (rhs.main_light_intensity < lhs.main_light_intensity)
    return false;
  return false;
}
template <typename StructPtrType>
XRReflectionProbePtr XRReflectionProbe::Clone() const {
  return New(
      mojo::Clone(cube_map)
  );
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool XRReflectionProbe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cube_map, other_struct.cube_map))
    return false;
  return true;
}

template <typename T, XRReflectionProbe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cube_map < rhs.cube_map)
    return true;
  if (rhs.cube_map < lhs.cube_map)
    return false;
  return false;
}
template <typename StructPtrType>
XRLightEstimationDataPtr XRLightEstimationData::Clone() const {
  return New(
      mojo::Clone(light_probe),
      mojo::Clone(reflection_probe)
  );
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool XRLightEstimationData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->light_probe, other_struct.light_probe))
    return false;
  if (!mojo::Equals(this->reflection_probe, other_struct.reflection_probe))
    return false;
  return true;
}

template <typename T, XRLightEstimationData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.light_probe < rhs.light_probe)
    return true;
  if (rhs.light_probe < lhs.light_probe)
    return false;
  if (lhs.reflection_probe < rhs.reflection_probe)
    return true;
  if (rhs.reflection_probe < lhs.reflection_probe)
    return false;
  return false;
}
template <typename StructPtrType>
XRDepthDataStillValidPtr XRDepthDataStillValid::Clone() const {
  return New(
  );
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool XRDepthDataStillValid::Equals(const T& other_struct) const {
  return true;
}

template <typename T, XRDepthDataStillValid::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
XRDepthDataUpdatedPtr XRDepthDataUpdated::Clone() const {
  return New(
      mojo::Clone(pixel_data),
      mojo::Clone(norm_texture_from_norm_view),
      mojo::Clone(size),
      mojo::Clone(raw_value_to_meters)
  );
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool XRDepthDataUpdated::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  if (!mojo::Equals(this->norm_texture_from_norm_view, other_struct.norm_texture_from_norm_view))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->raw_value_to_meters, other_struct.raw_value_to_meters))
    return false;
  return true;
}

template <typename T, XRDepthDataUpdated::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.pixel_data < rhs.pixel_data)
    return true;
  if (rhs.pixel_data < lhs.pixel_data)
    return false;
  if (lhs.norm_texture_from_norm_view < rhs.norm_texture_from_norm_view)
    return true;
  if (rhs.norm_texture_from_norm_view < lhs.norm_texture_from_norm_view)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.raw_value_to_meters < rhs.raw_value_to_meters)
    return true;
  if (rhs.raw_value_to_meters < lhs.raw_value_to_meters)
    return false;
  return false;
}
template <typename StructPtrType>
XRTrackedImageDataPtr XRTrackedImageData::Clone() const {
  return New(
      mojo::Clone(index),
      mojo::Clone(mojo_from_image),
      mojo::Clone(actively_tracked),
      mojo::Clone(width_in_meters)
  );
}

template <typename T, XRTrackedImageData::EnableIfSame<T>*>
bool XRTrackedImageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  if (!mojo::Equals(this->mojo_from_image, other_struct.mojo_from_image))
    return false;
  if (!mojo::Equals(this->actively_tracked, other_struct.actively_tracked))
    return false;
  if (!mojo::Equals(this->width_in_meters, other_struct.width_in_meters))
    return false;
  return true;
}

template <typename T, XRTrackedImageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  if (lhs.mojo_from_image < rhs.mojo_from_image)
    return true;
  if (rhs.mojo_from_image < lhs.mojo_from_image)
    return false;
  if (lhs.actively_tracked < rhs.actively_tracked)
    return true;
  if (rhs.actively_tracked < lhs.actively_tracked)
    return false;
  if (lhs.width_in_meters < rhs.width_in_meters)
    return true;
  if (rhs.width_in_meters < lhs.width_in_meters)
    return false;
  return false;
}
template <typename StructPtrType>
XRTrackedImagesDataPtr XRTrackedImagesData::Clone() const {
  return New(
      mojo::Clone(images_data),
      mojo::Clone(image_trackable_scores)
  );
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>*>
bool XRTrackedImagesData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->images_data, other_struct.images_data))
    return false;
  if (!mojo::Equals(this->image_trackable_scores, other_struct.image_trackable_scores))
    return false;
  return true;
}

template <typename T, XRTrackedImagesData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.images_data < rhs.images_data)
    return true;
  if (rhs.images_data < lhs.images_data)
    return false;
  if (lhs.image_trackable_scores < rhs.image_trackable_scores)
    return true;
  if (rhs.image_trackable_scores < lhs.image_trackable_scores)
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataPtr XRFrameData::Clone() const {
  return New(
      mojo::Clone(mojo_from_viewer),
      mojo::Clone(time_delta),
      mojo::Clone(buffer_shared_image),
      mojo::Clone(buffer_sync_token),
      mojo::Clone(camera_image_buffer_shared_image),
      mojo::Clone(camera_image_buffer_sync_token),
      mojo::Clone(camera_image_size),
      mojo::Clone(mojo_space_reset),
      mojo::Clone(mojo_from_floor),
      mojo::Clone(frame_id),
      mojo::Clone(views),
      mojo::Clone(input_state),
      mojo::Clone(stage_parameters_id),
      mojo::Clone(stage_parameters),
      mojo::Clone(detected_planes_data),
      mojo::Clone(anchors_data),
      mojo::Clone(light_estimation_data),
      mojo::Clone(hit_test_subscription_results),
      mojo::Clone(rendering_time_ratio),
      mojo::Clone(tracked_images)
  );
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool XRFrameData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mojo_from_viewer, other_struct.mojo_from_viewer))
    return false;
  if (!mojo::Equals(this->time_delta, other_struct.time_delta))
    return false;
  if (!mojo::Equals(this->buffer_shared_image, other_struct.buffer_shared_image))
    return false;
  if (!mojo::Equals(this->buffer_sync_token, other_struct.buffer_sync_token))
    return false;
  if (!mojo::Equals(this->camera_image_buffer_shared_image, other_struct.camera_image_buffer_shared_image))
    return false;
  if (!mojo::Equals(this->camera_image_buffer_sync_token, other_struct.camera_image_buffer_sync_token))
    return false;
  if (!mojo::Equals(this->camera_image_size, other_struct.camera_image_size))
    return false;
  if (!mojo::Equals(this->mojo_space_reset, other_struct.mojo_space_reset))
    return false;
  if (!mojo::Equals(this->mojo_from_floor, other_struct.mojo_from_floor))
    return false;
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  if (!mojo::Equals(this->views, other_struct.views))
    return false;
  if (!mojo::Equals(this->input_state, other_struct.input_state))
    return false;
  if (!mojo::Equals(this->stage_parameters_id, other_struct.stage_parameters_id))
    return false;
  if (!mojo::Equals(this->stage_parameters, other_struct.stage_parameters))
    return false;
  if (!mojo::Equals(this->detected_planes_data, other_struct.detected_planes_data))
    return false;
  if (!mojo::Equals(this->anchors_data, other_struct.anchors_data))
    return false;
  if (!mojo::Equals(this->light_estimation_data, other_struct.light_estimation_data))
    return false;
  if (!mojo::Equals(this->hit_test_subscription_results, other_struct.hit_test_subscription_results))
    return false;
  if (!mojo::Equals(this->rendering_time_ratio, other_struct.rendering_time_ratio))
    return false;
  if (!mojo::Equals(this->tracked_images, other_struct.tracked_images))
    return false;
  return true;
}

template <typename T, XRFrameData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mojo_from_viewer < rhs.mojo_from_viewer)
    return true;
  if (rhs.mojo_from_viewer < lhs.mojo_from_viewer)
    return false;
  if (lhs.time_delta < rhs.time_delta)
    return true;
  if (rhs.time_delta < lhs.time_delta)
    return false;
  if (lhs.buffer_shared_image < rhs.buffer_shared_image)
    return true;
  if (rhs.buffer_shared_image < lhs.buffer_shared_image)
    return false;
  if (lhs.buffer_sync_token < rhs.buffer_sync_token)
    return true;
  if (rhs.buffer_sync_token < lhs.buffer_sync_token)
    return false;
  if (lhs.camera_image_buffer_shared_image < rhs.camera_image_buffer_shared_image)
    return true;
  if (rhs.camera_image_buffer_shared_image < lhs.camera_image_buffer_shared_image)
    return false;
  if (lhs.camera_image_buffer_sync_token < rhs.camera_image_buffer_sync_token)
    return true;
  if (rhs.camera_image_buffer_sync_token < lhs.camera_image_buffer_sync_token)
    return false;
  if (lhs.camera_image_size < rhs.camera_image_size)
    return true;
  if (rhs.camera_image_size < lhs.camera_image_size)
    return false;
  if (lhs.mojo_space_reset < rhs.mojo_space_reset)
    return true;
  if (rhs.mojo_space_reset < lhs.mojo_space_reset)
    return false;
  if (lhs.mojo_from_floor < rhs.mojo_from_floor)
    return true;
  if (rhs.mojo_from_floor < lhs.mojo_from_floor)
    return false;
  if (lhs.frame_id < rhs.frame_id)
    return true;
  if (rhs.frame_id < lhs.frame_id)
    return false;
  if (lhs.views < rhs.views)
    return true;
  if (rhs.views < lhs.views)
    return false;
  if (lhs.input_state < rhs.input_state)
    return true;
  if (rhs.input_state < lhs.input_state)
    return false;
  if (lhs.stage_parameters_id < rhs.stage_parameters_id)
    return true;
  if (rhs.stage_parameters_id < lhs.stage_parameters_id)
    return false;
  if (lhs.stage_parameters < rhs.stage_parameters)
    return true;
  if (rhs.stage_parameters < lhs.stage_parameters)
    return false;
  if (lhs.detected_planes_data < rhs.detected_planes_data)
    return true;
  if (rhs.detected_planes_data < lhs.detected_planes_data)
    return false;
  if (lhs.anchors_data < rhs.anchors_data)
    return true;
  if (rhs.anchors_data < lhs.anchors_data)
    return false;
  if (lhs.light_estimation_data < rhs.light_estimation_data)
    return true;
  if (rhs.light_estimation_data < lhs.light_estimation_data)
    return false;
  if (lhs.hit_test_subscription_results < rhs.hit_test_subscription_results)
    return true;
  if (rhs.hit_test_subscription_results < lhs.hit_test_subscription_results)
    return false;
  if (lhs.rendering_time_ratio < rhs.rendering_time_ratio)
    return true;
  if (rhs.rendering_time_ratio < lhs.rendering_time_ratio)
    return false;
  if (lhs.tracked_images < rhs.tracked_images)
    return true;
  if (rhs.tracked_images < lhs.tracked_images)
    return false;
  return false;
}
template <typename StructPtrType>
RequestSessionSuccessPtr RequestSessionSuccess::Clone() const {
  return New(
      mojo::Clone(session),
      mojo::Clone(trace_id),
      mojo::Clone(metrics_recorder),
      mojo::Clone(xr_internals_listener)
  );
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool RequestSessionSuccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session, other_struct.session))
    return false;
  if (!mojo::Equals(this->trace_id, other_struct.trace_id))
    return false;
  if (!mojo::Equals(this->metrics_recorder, other_struct.metrics_recorder))
    return false;
  if (!mojo::Equals(this->xr_internals_listener, other_struct.xr_internals_listener))
    return false;
  return true;
}

template <typename T, RequestSessionSuccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session < rhs.session)
    return true;
  if (rhs.session < lhs.session)
    return false;
  if (lhs.trace_id < rhs.trace_id)
    return true;
  if (rhs.trace_id < lhs.trace_id)
    return false;
  if (lhs.metrics_recorder < rhs.metrics_recorder)
    return true;
  if (rhs.metrics_recorder < lhs.metrics_recorder)
    return false;
  if (lhs.xr_internals_listener < rhs.xr_internals_listener)
    return true;
  if (rhs.xr_internals_listener < lhs.xr_internals_listener)
    return false;
  return false;
}
template <typename StructPtrType>
XRFrameDataRequestOptionsPtr XRFrameDataRequestOptions::Clone() const {
  return New(
      mojo::Clone(include_lighting_estimation_data),
      mojo::Clone(stage_parameters_id)
  );
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool XRFrameDataRequestOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->include_lighting_estimation_data, other_struct.include_lighting_estimation_data))
    return false;
  if (!mojo::Equals(this->stage_parameters_id, other_struct.stage_parameters_id))
    return false;
  return true;
}

template <typename T, XRFrameDataRequestOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.include_lighting_estimation_data < rhs.include_lighting_estimation_data)
    return true;
  if (rhs.include_lighting_estimation_data < lhs.include_lighting_estimation_data)
    return false;
  if (lhs.stage_parameters_id < rhs.stage_parameters_id)
    return true;
  if (rhs.stage_parameters_id < lhs.stage_parameters_id)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRDepthConfig::DataView,
                                         ::device::mojom::XRDepthConfigPtr> {
  static bool IsNull(const ::device::mojom::XRDepthConfigPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDepthConfigPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRDepthConfig::depth_usage) depth_usage(
      const ::device::mojom::XRDepthConfigPtr& input) {
    return input->depth_usage;
  }

  static decltype(::device::mojom::XRDepthConfig::depth_data_format) depth_data_format(
      const ::device::mojom::XRDepthConfigPtr& input) {
    return input->depth_data_format;
  }

  static bool Read(::device::mojom::XRDepthConfig::DataView input, ::device::mojom::XRDepthConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRSessionDeviceConfig::DataView,
                                         ::device::mojom::XRSessionDeviceConfigPtr> {
  static bool IsNull(const ::device::mojom::XRSessionDeviceConfigPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRSessionDeviceConfigPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRSessionDeviceConfig::default_framebuffer_scale) default_framebuffer_scale(
      const ::device::mojom::XRSessionDeviceConfigPtr& input) {
    return input->default_framebuffer_scale;
  }

  static  decltype(::device::mojom::XRSessionDeviceConfig::views)& views(
       ::device::mojom::XRSessionDeviceConfigPtr& input) {
    return input->views;
  }

  static decltype(::device::mojom::XRSessionDeviceConfig::supports_viewport_scaling) supports_viewport_scaling(
      const ::device::mojom::XRSessionDeviceConfigPtr& input) {
    return input->supports_viewport_scaling;
  }

  static decltype(::device::mojom::XRSessionDeviceConfig::enable_anti_aliasing) enable_anti_aliasing(
      const ::device::mojom::XRSessionDeviceConfigPtr& input) {
    return input->enable_anti_aliasing;
  }

  static const decltype(::device::mojom::XRSessionDeviceConfig::depth_configuration)& depth_configuration(
      const ::device::mojom::XRSessionDeviceConfigPtr& input) {
    return input->depth_configuration;
  }

  static bool Read(::device::mojom::XRSessionDeviceConfig::DataView input, ::device::mojom::XRSessionDeviceConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRSession::DataView,
                                         ::device::mojom::XRSessionPtr> {
  static bool IsNull(const ::device::mojom::XRSessionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRSessionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::XRSession::data_provider)& data_provider(
       ::device::mojom::XRSessionPtr& input) {
    return input->data_provider;
  }

  static  decltype(::device::mojom::XRSession::client_receiver)& client_receiver(
       ::device::mojom::XRSessionPtr& input) {
    return input->client_receiver;
  }

  static  decltype(::device::mojom::XRSession::submit_frame_sink)& submit_frame_sink(
       ::device::mojom::XRSessionPtr& input) {
    return input->submit_frame_sink;
  }

  static const decltype(::device::mojom::XRSession::enabled_features)& enabled_features(
      const ::device::mojom::XRSessionPtr& input) {
    return input->enabled_features;
  }

  static  decltype(::device::mojom::XRSession::device_config)& device_config(
       ::device::mojom::XRSessionPtr& input) {
    return input->device_config;
  }

  static decltype(::device::mojom::XRSession::enviroment_blend_mode) enviroment_blend_mode(
      const ::device::mojom::XRSessionPtr& input) {
    return input->enviroment_blend_mode;
  }

  static decltype(::device::mojom::XRSession::interaction_mode) interaction_mode(
      const ::device::mojom::XRSessionPtr& input) {
    return input->interaction_mode;
  }

  static bool Read(::device::mojom::XRSession::DataView input, ::device::mojom::XRSessionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRPresentationConnection::DataView,
                                         ::device::mojom::XRPresentationConnectionPtr> {
  static bool IsNull(const ::device::mojom::XRPresentationConnectionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRPresentationConnectionPtr* output) { output->reset(); }

  static  decltype(::device::mojom::XRPresentationConnection::provider)& provider(
       ::device::mojom::XRPresentationConnectionPtr& input) {
    return input->provider;
  }

  static  decltype(::device::mojom::XRPresentationConnection::client_receiver)& client_receiver(
       ::device::mojom::XRPresentationConnectionPtr& input) {
    return input->client_receiver;
  }

  static const decltype(::device::mojom::XRPresentationConnection::transport_options)& transport_options(
      const ::device::mojom::XRPresentationConnectionPtr& input) {
    return input->transport_options;
  }

  static bool Read(::device::mojom::XRPresentationConnection::DataView input, ::device::mojom::XRPresentationConnectionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRInputSourceDescription::DataView,
                                         ::device::mojom::XRInputSourceDescriptionPtr> {
  static bool IsNull(const ::device::mojom::XRInputSourceDescriptionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRInputSourceDescriptionPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRInputSourceDescription::target_ray_mode) target_ray_mode(
      const ::device::mojom::XRInputSourceDescriptionPtr& input) {
    return input->target_ray_mode;
  }

  static decltype(::device::mojom::XRInputSourceDescription::handedness) handedness(
      const ::device::mojom::XRInputSourceDescriptionPtr& input) {
    return input->handedness;
  }

  static const decltype(::device::mojom::XRInputSourceDescription::input_from_pointer)& input_from_pointer(
      const ::device::mojom::XRInputSourceDescriptionPtr& input) {
    return input->input_from_pointer;
  }

  static const decltype(::device::mojom::XRInputSourceDescription::profiles)& profiles(
      const ::device::mojom::XRInputSourceDescriptionPtr& input) {
    return input->profiles;
  }

  static bool Read(::device::mojom::XRInputSourceDescription::DataView input, ::device::mojom::XRInputSourceDescriptionPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRInputSourceState::DataView,
                                         ::device::mojom::XRInputSourceStatePtr> {
  static bool IsNull(const ::device::mojom::XRInputSourceStatePtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRInputSourceStatePtr* output) { output->reset(); }

  static decltype(::device::mojom::XRInputSourceState::source_id) source_id(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->source_id;
  }

  static const decltype(::device::mojom::XRInputSourceState::description)& description(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->description;
  }

  static const decltype(::device::mojom::XRInputSourceState::mojo_from_input)& mojo_from_input(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->mojo_from_input;
  }

  static decltype(::device::mojom::XRInputSourceState::emulated_position) emulated_position(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->emulated_position;
  }

  static decltype(::device::mojom::XRInputSourceState::is_auxiliary) is_auxiliary(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->is_auxiliary;
  }

  static decltype(::device::mojom::XRInputSourceState::primary_input_pressed) primary_input_pressed(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->primary_input_pressed;
  }

  static decltype(::device::mojom::XRInputSourceState::primary_input_clicked) primary_input_clicked(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->primary_input_clicked;
  }

  static decltype(::device::mojom::XRInputSourceState::primary_squeeze_pressed) primary_squeeze_pressed(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_pressed;
  }

  static decltype(::device::mojom::XRInputSourceState::primary_squeeze_clicked) primary_squeeze_clicked(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->primary_squeeze_clicked;
  }

  static const decltype(::device::mojom::XRInputSourceState::gamepad)& gamepad(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->gamepad;
  }

  static const decltype(::device::mojom::XRInputSourceState::overlay_pointer_position)& overlay_pointer_position(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->overlay_pointer_position;
  }

  static const decltype(::device::mojom::XRInputSourceState::hand_tracking_data)& hand_tracking_data(
      const ::device::mojom::XRInputSourceStatePtr& input) {
    return input->hand_tracking_data;
  }

  static bool Read(::device::mojom::XRInputSourceState::DataView input, ::device::mojom::XRInputSourceStatePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::VRFieldOfView::DataView,
                                         ::device::mojom::VRFieldOfViewPtr> {
  static bool IsNull(const ::device::mojom::VRFieldOfViewPtr& input) { return !input; }
  static void SetToNull(::device::mojom::VRFieldOfViewPtr* output) { output->reset(); }

  static decltype(::device::mojom::VRFieldOfView::up_degrees) up_degrees(
      const ::device::mojom::VRFieldOfViewPtr& input) {
    return input->up_degrees;
  }

  static decltype(::device::mojom::VRFieldOfView::down_degrees) down_degrees(
      const ::device::mojom::VRFieldOfViewPtr& input) {
    return input->down_degrees;
  }

  static decltype(::device::mojom::VRFieldOfView::left_degrees) left_degrees(
      const ::device::mojom::VRFieldOfViewPtr& input) {
    return input->left_degrees;
  }

  static decltype(::device::mojom::VRFieldOfView::right_degrees) right_degrees(
      const ::device::mojom::VRFieldOfViewPtr& input) {
    return input->right_degrees;
  }

  static bool Read(::device::mojom::VRFieldOfView::DataView input, ::device::mojom::VRFieldOfViewPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::VRPose::DataView,
                                         ::device::mojom::VRPosePtr> {
  static bool IsNull(const ::device::mojom::VRPosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::VRPosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::VRPose::orientation)& orientation(
      const ::device::mojom::VRPosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::VRPose::position)& position(
      const ::device::mojom::VRPosePtr& input) {
    return input->position;
  }

  static decltype(::device::mojom::VRPose::emulated_position) emulated_position(
      const ::device::mojom::VRPosePtr& input) {
    return input->emulated_position;
  }

  static bool Read(::device::mojom::VRPose::DataView input, ::device::mojom::VRPosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::Pose::DataView,
                                         ::device::mojom::PosePtr> {
  static bool IsNull(const ::device::mojom::PosePtr& input) { return !input; }
  static void SetToNull(::device::mojom::PosePtr* output) { output->reset(); }

  static const decltype(::device::mojom::Pose::orientation)& orientation(
      const ::device::mojom::PosePtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::Pose::position)& position(
      const ::device::mojom::PosePtr& input) {
    return input->position;
  }

  static bool Read(::device::mojom::Pose::DataView input, ::device::mojom::PosePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRRay::DataView,
                                         ::device::mojom::XRRayPtr> {
  static bool IsNull(const ::device::mojom::XRRayPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRRayPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRRay::origin)& origin(
      const ::device::mojom::XRRayPtr& input) {
    return input->origin;
  }

  static const decltype(::device::mojom::XRRay::direction)& direction(
      const ::device::mojom::XRRayPtr& input) {
    return input->direction;
  }

  static bool Read(::device::mojom::XRRay::DataView input, ::device::mojom::XRRayPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHitResult::DataView,
                                         ::device::mojom::XRHitResultPtr> {
  static bool IsNull(const ::device::mojom::XRHitResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHitResultPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRHitResult::mojo_from_result)& mojo_from_result(
      const ::device::mojom::XRHitResultPtr& input) {
    return input->mojo_from_result;
  }

  static decltype(::device::mojom::XRHitResult::plane_id) plane_id(
      const ::device::mojom::XRHitResultPtr& input) {
    return input->plane_id;
  }

  static bool Read(::device::mojom::XRHitResult::DataView input, ::device::mojom::XRHitResultPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRView::DataView,
                                         ::device::mojom::XRViewPtr> {
  static bool IsNull(const ::device::mojom::XRViewPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRViewPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRView::eye) eye(
      const ::device::mojom::XRViewPtr& input) {
    return input->eye;
  }

  static const decltype(::device::mojom::XRView::field_of_view)& field_of_view(
      const ::device::mojom::XRViewPtr& input) {
    return input->field_of_view;
  }

  static const decltype(::device::mojom::XRView::mojo_from_view)& mojo_from_view(
      const ::device::mojom::XRViewPtr& input) {
    return input->mojo_from_view;
  }

  static const decltype(::device::mojom::XRView::viewport)& viewport(
      const ::device::mojom::XRViewPtr& input) {
    return input->viewport;
  }

  static  decltype(::device::mojom::XRView::depth_data)& depth_data(
       ::device::mojom::XRViewPtr& input) {
    return input->depth_data;
  }

  static decltype(::device::mojom::XRView::is_first_person_observer) is_first_person_observer(
      const ::device::mojom::XRViewPtr& input) {
    return input->is_first_person_observer;
  }

  static bool Read(::device::mojom::XRView::DataView input, ::device::mojom::XRViewPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::VRStageParameters::DataView,
                                         ::device::mojom::VRStageParametersPtr> {
  static bool IsNull(const ::device::mojom::VRStageParametersPtr& input) { return !input; }
  static void SetToNull(::device::mojom::VRStageParametersPtr* output) { output->reset(); }

  static const decltype(::device::mojom::VRStageParameters::mojo_from_stage)& mojo_from_stage(
      const ::device::mojom::VRStageParametersPtr& input) {
    return input->mojo_from_stage;
  }

  static const decltype(::device::mojom::VRStageParameters::bounds)& bounds(
      const ::device::mojom::VRStageParametersPtr& input) {
    return input->bounds;
  }

  static bool Read(::device::mojom::VRStageParameters::DataView input, ::device::mojom::VRStageParametersPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRPresentationTransportOptions::DataView,
                                         ::device::mojom::XRPresentationTransportOptionsPtr> {
  static bool IsNull(const ::device::mojom::XRPresentationTransportOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRPresentationTransportOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRPresentationTransportOptions::transport_method) transport_method(
      const ::device::mojom::XRPresentationTransportOptionsPtr& input) {
    return input->transport_method;
  }

  static decltype(::device::mojom::XRPresentationTransportOptions::wait_for_transfer_notification) wait_for_transfer_notification(
      const ::device::mojom::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_transfer_notification;
  }

  static decltype(::device::mojom::XRPresentationTransportOptions::wait_for_render_notification) wait_for_render_notification(
      const ::device::mojom::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_render_notification;
  }

  static decltype(::device::mojom::XRPresentationTransportOptions::wait_for_gpu_fence) wait_for_gpu_fence(
      const ::device::mojom::XRPresentationTransportOptionsPtr& input) {
    return input->wait_for_gpu_fence;
  }

  static bool Read(::device::mojom::XRPresentationTransportOptions::DataView input, ::device::mojom::XRPresentationTransportOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRInputSourceSpaceInfo::DataView,
                                         ::device::mojom::XRInputSourceSpaceInfoPtr> {
  static bool IsNull(const ::device::mojom::XRInputSourceSpaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRInputSourceSpaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRInputSourceSpaceInfo::input_source_id) input_source_id(
      const ::device::mojom::XRInputSourceSpaceInfoPtr& input) {
    return input->input_source_id;
  }

  static decltype(::device::mojom::XRInputSourceSpaceInfo::input_source_space_type) input_source_space_type(
      const ::device::mojom::XRInputSourceSpaceInfoPtr& input) {
    return input->input_source_space_type;
  }

  static bool Read(::device::mojom::XRInputSourceSpaceInfo::DataView input, ::device::mojom::XRInputSourceSpaceInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHandJointSpaceInfo::DataView,
                                         ::device::mojom::XRHandJointSpaceInfoPtr> {
  static bool IsNull(const ::device::mojom::XRHandJointSpaceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHandJointSpaceInfoPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRHandJointSpaceInfo::handedness) handedness(
      const ::device::mojom::XRHandJointSpaceInfoPtr& input) {
    return input->handedness;
  }

  static decltype(::device::mojom::XRHandJointSpaceInfo::joint) joint(
      const ::device::mojom::XRHandJointSpaceInfoPtr& input) {
    return input->joint;
  }

  static bool Read(::device::mojom::XRHandJointSpaceInfo::DataView input, ::device::mojom::XRHandJointSpaceInfoPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRPlanePointData::DataView,
                                         ::device::mojom::XRPlanePointDataPtr> {
  static bool IsNull(const ::device::mojom::XRPlanePointDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRPlanePointDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRPlanePointData::x) x(
      const ::device::mojom::XRPlanePointDataPtr& input) {
    return input->x;
  }

  static decltype(::device::mojom::XRPlanePointData::z) z(
      const ::device::mojom::XRPlanePointDataPtr& input) {
    return input->z;
  }

  static bool Read(::device::mojom::XRPlanePointData::DataView input, ::device::mojom::XRPlanePointDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRPlaneData::DataView,
                                         ::device::mojom::XRPlaneDataPtr> {
  static bool IsNull(const ::device::mojom::XRPlaneDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRPlaneDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRPlaneData::id) id(
      const ::device::mojom::XRPlaneDataPtr& input) {
    return input->id;
  }

  static decltype(::device::mojom::XRPlaneData::orientation) orientation(
      const ::device::mojom::XRPlaneDataPtr& input) {
    return input->orientation;
  }

  static const decltype(::device::mojom::XRPlaneData::mojo_from_plane)& mojo_from_plane(
      const ::device::mojom::XRPlaneDataPtr& input) {
    return input->mojo_from_plane;
  }

  static const decltype(::device::mojom::XRPlaneData::polygon)& polygon(
      const ::device::mojom::XRPlaneDataPtr& input) {
    return input->polygon;
  }

  static bool Read(::device::mojom::XRPlaneData::DataView input, ::device::mojom::XRPlaneDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRPlaneDetectionData::DataView,
                                         ::device::mojom::XRPlaneDetectionDataPtr> {
  static bool IsNull(const ::device::mojom::XRPlaneDetectionDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRPlaneDetectionDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRPlaneDetectionData::all_planes_ids)& all_planes_ids(
      const ::device::mojom::XRPlaneDetectionDataPtr& input) {
    return input->all_planes_ids;
  }

  static const decltype(::device::mojom::XRPlaneDetectionData::updated_planes_data)& updated_planes_data(
      const ::device::mojom::XRPlaneDetectionDataPtr& input) {
    return input->updated_planes_data;
  }

  static bool Read(::device::mojom::XRPlaneDetectionData::DataView input, ::device::mojom::XRPlaneDetectionDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRAnchorData::DataView,
                                         ::device::mojom::XRAnchorDataPtr> {
  static bool IsNull(const ::device::mojom::XRAnchorDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRAnchorDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRAnchorData::id) id(
      const ::device::mojom::XRAnchorDataPtr& input) {
    return input->id;
  }

  static const decltype(::device::mojom::XRAnchorData::mojo_from_anchor)& mojo_from_anchor(
      const ::device::mojom::XRAnchorDataPtr& input) {
    return input->mojo_from_anchor;
  }

  static bool Read(::device::mojom::XRAnchorData::DataView input, ::device::mojom::XRAnchorDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRAnchorsData::DataView,
                                         ::device::mojom::XRAnchorsDataPtr> {
  static bool IsNull(const ::device::mojom::XRAnchorsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRAnchorsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRAnchorsData::all_anchors_ids)& all_anchors_ids(
      const ::device::mojom::XRAnchorsDataPtr& input) {
    return input->all_anchors_ids;
  }

  static const decltype(::device::mojom::XRAnchorsData::updated_anchors_data)& updated_anchors_data(
      const ::device::mojom::XRAnchorsDataPtr& input) {
    return input->updated_anchors_data;
  }

  static bool Read(::device::mojom::XRAnchorsData::DataView input, ::device::mojom::XRAnchorsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHitTestSubscriptionResultData::DataView,
                                         ::device::mojom::XRHitTestSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::XRHitTestSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHitTestSubscriptionResultDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRHitTestSubscriptionResultData::subscription_id) subscription_id(
      const ::device::mojom::XRHitTestSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::XRHitTestSubscriptionResultData::hit_test_results)& hit_test_results(
      const ::device::mojom::XRHitTestSubscriptionResultDataPtr& input) {
    return input->hit_test_results;
  }

  static bool Read(::device::mojom::XRHitTestSubscriptionResultData::DataView input, ::device::mojom::XRHitTestSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHitTestTransientInputSubscriptionResultData::DataView,
                                         ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr> {
  static bool IsNull(const ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRHitTestTransientInputSubscriptionResultData::subscription_id) subscription_id(
      const ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->subscription_id;
  }

  static const decltype(::device::mojom::XRHitTestTransientInputSubscriptionResultData::input_source_id_to_hit_test_results)& input_source_id_to_hit_test_results(
      const ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr& input) {
    return input->input_source_id_to_hit_test_results;
  }

  static bool Read(::device::mojom::XRHitTestTransientInputSubscriptionResultData::DataView input, ::device::mojom::XRHitTestTransientInputSubscriptionResultDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRHitTestSubscriptionResultsData::DataView,
                                         ::device::mojom::XRHitTestSubscriptionResultsDataPtr> {
  static bool IsNull(const ::device::mojom::XRHitTestSubscriptionResultsDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRHitTestSubscriptionResultsDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRHitTestSubscriptionResultsData::results)& results(
      const ::device::mojom::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->results;
  }

  static const decltype(::device::mojom::XRHitTestSubscriptionResultsData::transient_input_results)& transient_input_results(
      const ::device::mojom::XRHitTestSubscriptionResultsDataPtr& input) {
    return input->transient_input_results;
  }

  static bool Read(::device::mojom::XRHitTestSubscriptionResultsData::DataView input, ::device::mojom::XRHitTestSubscriptionResultsDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::RgbTupleF32::DataView,
                                         ::device::mojom::RgbTupleF32Ptr> {
  static bool IsNull(const ::device::mojom::RgbTupleF32Ptr& input) { return !input; }
  static void SetToNull(::device::mojom::RgbTupleF32Ptr* output) { output->reset(); }

  static decltype(::device::mojom::RgbTupleF32::red) red(
      const ::device::mojom::RgbTupleF32Ptr& input) {
    return input->red;
  }

  static decltype(::device::mojom::RgbTupleF32::green) green(
      const ::device::mojom::RgbTupleF32Ptr& input) {
    return input->green;
  }

  static decltype(::device::mojom::RgbTupleF32::blue) blue(
      const ::device::mojom::RgbTupleF32Ptr& input) {
    return input->blue;
  }

  static bool Read(::device::mojom::RgbTupleF32::DataView input, ::device::mojom::RgbTupleF32Ptr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRSphericalHarmonics::DataView,
                                         ::device::mojom::XRSphericalHarmonicsPtr> {
  static bool IsNull(const ::device::mojom::XRSphericalHarmonicsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRSphericalHarmonicsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRSphericalHarmonics::coefficients)& coefficients(
      const ::device::mojom::XRSphericalHarmonicsPtr& input) {
    return input->coefficients;
  }

  static bool Read(::device::mojom::XRSphericalHarmonics::DataView input, ::device::mojom::XRSphericalHarmonicsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::RgbaTupleF16::DataView,
                                         ::device::mojom::RgbaTupleF16Ptr> {
  static bool IsNull(const ::device::mojom::RgbaTupleF16Ptr& input) { return !input; }
  static void SetToNull(::device::mojom::RgbaTupleF16Ptr* output) { output->reset(); }

  static decltype(::device::mojom::RgbaTupleF16::red) red(
      const ::device::mojom::RgbaTupleF16Ptr& input) {
    return input->red;
  }

  static decltype(::device::mojom::RgbaTupleF16::green) green(
      const ::device::mojom::RgbaTupleF16Ptr& input) {
    return input->green;
  }

  static decltype(::device::mojom::RgbaTupleF16::blue) blue(
      const ::device::mojom::RgbaTupleF16Ptr& input) {
    return input->blue;
  }

  static decltype(::device::mojom::RgbaTupleF16::alpha) alpha(
      const ::device::mojom::RgbaTupleF16Ptr& input) {
    return input->alpha;
  }

  static bool Read(::device::mojom::RgbaTupleF16::DataView input, ::device::mojom::RgbaTupleF16Ptr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRCubeMap::DataView,
                                         ::device::mojom::XRCubeMapPtr> {
  static bool IsNull(const ::device::mojom::XRCubeMapPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRCubeMapPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRCubeMap::width_and_height) width_and_height(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->width_and_height;
  }

  static const decltype(::device::mojom::XRCubeMap::positive_x)& positive_x(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->positive_x;
  }

  static const decltype(::device::mojom::XRCubeMap::negative_x)& negative_x(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->negative_x;
  }

  static const decltype(::device::mojom::XRCubeMap::positive_y)& positive_y(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->positive_y;
  }

  static const decltype(::device::mojom::XRCubeMap::negative_y)& negative_y(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->negative_y;
  }

  static const decltype(::device::mojom::XRCubeMap::positive_z)& positive_z(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->positive_z;
  }

  static const decltype(::device::mojom::XRCubeMap::negative_z)& negative_z(
      const ::device::mojom::XRCubeMapPtr& input) {
    return input->negative_z;
  }

  static bool Read(::device::mojom::XRCubeMap::DataView input, ::device::mojom::XRCubeMapPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRLightProbe::DataView,
                                         ::device::mojom::XRLightProbePtr> {
  static bool IsNull(const ::device::mojom::XRLightProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRLightProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRLightProbe::spherical_harmonics)& spherical_harmonics(
      const ::device::mojom::XRLightProbePtr& input) {
    return input->spherical_harmonics;
  }

  static const decltype(::device::mojom::XRLightProbe::main_light_direction)& main_light_direction(
      const ::device::mojom::XRLightProbePtr& input) {
    return input->main_light_direction;
  }

  static const decltype(::device::mojom::XRLightProbe::main_light_intensity)& main_light_intensity(
      const ::device::mojom::XRLightProbePtr& input) {
    return input->main_light_intensity;
  }

  static bool Read(::device::mojom::XRLightProbe::DataView input, ::device::mojom::XRLightProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRReflectionProbe::DataView,
                                         ::device::mojom::XRReflectionProbePtr> {
  static bool IsNull(const ::device::mojom::XRReflectionProbePtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRReflectionProbePtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRReflectionProbe::cube_map)& cube_map(
      const ::device::mojom::XRReflectionProbePtr& input) {
    return input->cube_map;
  }

  static bool Read(::device::mojom::XRReflectionProbe::DataView input, ::device::mojom::XRReflectionProbePtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRLightEstimationData::DataView,
                                         ::device::mojom::XRLightEstimationDataPtr> {
  static bool IsNull(const ::device::mojom::XRLightEstimationDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRLightEstimationDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRLightEstimationData::light_probe)& light_probe(
      const ::device::mojom::XRLightEstimationDataPtr& input) {
    return input->light_probe;
  }

  static const decltype(::device::mojom::XRLightEstimationData::reflection_probe)& reflection_probe(
      const ::device::mojom::XRLightEstimationDataPtr& input) {
    return input->reflection_probe;
  }

  static bool Read(::device::mojom::XRLightEstimationData::DataView input, ::device::mojom::XRLightEstimationDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRDepthDataStillValid::DataView,
                                         ::device::mojom::XRDepthDataStillValidPtr> {
  static bool IsNull(const ::device::mojom::XRDepthDataStillValidPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDepthDataStillValidPtr* output) { output->reset(); }

  static bool Read(::device::mojom::XRDepthDataStillValid::DataView input, ::device::mojom::XRDepthDataStillValidPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRDepthDataUpdated::DataView,
                                         ::device::mojom::XRDepthDataUpdatedPtr> {
  static bool IsNull(const ::device::mojom::XRDepthDataUpdatedPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDepthDataUpdatedPtr* output) { output->reset(); }

  static  decltype(::device::mojom::XRDepthDataUpdated::pixel_data)& pixel_data(
       ::device::mojom::XRDepthDataUpdatedPtr& input) {
    return input->pixel_data;
  }

  static const decltype(::device::mojom::XRDepthDataUpdated::norm_texture_from_norm_view)& norm_texture_from_norm_view(
      const ::device::mojom::XRDepthDataUpdatedPtr& input) {
    return input->norm_texture_from_norm_view;
  }

  static const decltype(::device::mojom::XRDepthDataUpdated::size)& size(
      const ::device::mojom::XRDepthDataUpdatedPtr& input) {
    return input->size;
  }

  static decltype(::device::mojom::XRDepthDataUpdated::raw_value_to_meters) raw_value_to_meters(
      const ::device::mojom::XRDepthDataUpdatedPtr& input) {
    return input->raw_value_to_meters;
  }

  static bool Read(::device::mojom::XRDepthDataUpdated::DataView input, ::device::mojom::XRDepthDataUpdatedPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRTrackedImageData::DataView,
                                         ::device::mojom::XRTrackedImageDataPtr> {
  static bool IsNull(const ::device::mojom::XRTrackedImageDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRTrackedImageDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRTrackedImageData::index) index(
      const ::device::mojom::XRTrackedImageDataPtr& input) {
    return input->index;
  }

  static const decltype(::device::mojom::XRTrackedImageData::mojo_from_image)& mojo_from_image(
      const ::device::mojom::XRTrackedImageDataPtr& input) {
    return input->mojo_from_image;
  }

  static decltype(::device::mojom::XRTrackedImageData::actively_tracked) actively_tracked(
      const ::device::mojom::XRTrackedImageDataPtr& input) {
    return input->actively_tracked;
  }

  static decltype(::device::mojom::XRTrackedImageData::width_in_meters) width_in_meters(
      const ::device::mojom::XRTrackedImageDataPtr& input) {
    return input->width_in_meters;
  }

  static bool Read(::device::mojom::XRTrackedImageData::DataView input, ::device::mojom::XRTrackedImageDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRTrackedImagesData::DataView,
                                         ::device::mojom::XRTrackedImagesDataPtr> {
  static bool IsNull(const ::device::mojom::XRTrackedImagesDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRTrackedImagesDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRTrackedImagesData::images_data)& images_data(
      const ::device::mojom::XRTrackedImagesDataPtr& input) {
    return input->images_data;
  }

  static const decltype(::device::mojom::XRTrackedImagesData::image_trackable_scores)& image_trackable_scores(
      const ::device::mojom::XRTrackedImagesDataPtr& input) {
    return input->image_trackable_scores;
  }

  static bool Read(::device::mojom::XRTrackedImagesData::DataView input, ::device::mojom::XRTrackedImagesDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRFrameData::DataView,
                                         ::device::mojom::XRFrameDataPtr> {
  static bool IsNull(const ::device::mojom::XRFrameDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRFrameDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::XRFrameData::mojo_from_viewer)& mojo_from_viewer(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->mojo_from_viewer;
  }

  static const decltype(::device::mojom::XRFrameData::time_delta)& time_delta(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->time_delta;
  }

  static const decltype(::device::mojom::XRFrameData::buffer_shared_image)& buffer_shared_image(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->buffer_shared_image;
  }

  static const decltype(::device::mojom::XRFrameData::buffer_sync_token)& buffer_sync_token(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->buffer_sync_token;
  }

  static const decltype(::device::mojom::XRFrameData::camera_image_buffer_shared_image)& camera_image_buffer_shared_image(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->camera_image_buffer_shared_image;
  }

  static const decltype(::device::mojom::XRFrameData::camera_image_buffer_sync_token)& camera_image_buffer_sync_token(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->camera_image_buffer_sync_token;
  }

  static const decltype(::device::mojom::XRFrameData::camera_image_size)& camera_image_size(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->camera_image_size;
  }

  static decltype(::device::mojom::XRFrameData::mojo_space_reset) mojo_space_reset(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->mojo_space_reset;
  }

  static const decltype(::device::mojom::XRFrameData::mojo_from_floor)& mojo_from_floor(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->mojo_from_floor;
  }

  static decltype(::device::mojom::XRFrameData::frame_id) frame_id(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->frame_id;
  }

  static  decltype(::device::mojom::XRFrameData::views)& views(
       ::device::mojom::XRFrameDataPtr& input) {
    return input->views;
  }

  static const decltype(::device::mojom::XRFrameData::input_state)& input_state(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->input_state;
  }

  static decltype(::device::mojom::XRFrameData::stage_parameters_id) stage_parameters_id(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->stage_parameters_id;
  }

  static const decltype(::device::mojom::XRFrameData::stage_parameters)& stage_parameters(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->stage_parameters;
  }

  static const decltype(::device::mojom::XRFrameData::detected_planes_data)& detected_planes_data(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->detected_planes_data;
  }

  static const decltype(::device::mojom::XRFrameData::anchors_data)& anchors_data(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->anchors_data;
  }

  static const decltype(::device::mojom::XRFrameData::light_estimation_data)& light_estimation_data(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->light_estimation_data;
  }

  static const decltype(::device::mojom::XRFrameData::hit_test_subscription_results)& hit_test_subscription_results(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->hit_test_subscription_results;
  }

  static decltype(::device::mojom::XRFrameData::rendering_time_ratio) rendering_time_ratio(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->rendering_time_ratio;
  }

  static const decltype(::device::mojom::XRFrameData::tracked_images)& tracked_images(
      const ::device::mojom::XRFrameDataPtr& input) {
    return input->tracked_images;
  }

  static bool Read(::device::mojom::XRFrameData::DataView input, ::device::mojom::XRFrameDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::RequestSessionSuccess::DataView,
                                         ::device::mojom::RequestSessionSuccessPtr> {
  static bool IsNull(const ::device::mojom::RequestSessionSuccessPtr& input) { return !input; }
  static void SetToNull(::device::mojom::RequestSessionSuccessPtr* output) { output->reset(); }

  static  decltype(::device::mojom::RequestSessionSuccess::session)& session(
       ::device::mojom::RequestSessionSuccessPtr& input) {
    return input->session;
  }

  static decltype(::device::mojom::RequestSessionSuccess::trace_id) trace_id(
      const ::device::mojom::RequestSessionSuccessPtr& input) {
    return input->trace_id;
  }

  static  decltype(::device::mojom::RequestSessionSuccess::metrics_recorder)& metrics_recorder(
       ::device::mojom::RequestSessionSuccessPtr& input) {
    return input->metrics_recorder;
  }

  static  decltype(::device::mojom::RequestSessionSuccess::xr_internals_listener)& xr_internals_listener(
       ::device::mojom::RequestSessionSuccessPtr& input) {
    return input->xr_internals_listener;
  }

  static bool Read(::device::mojom::RequestSessionSuccess::DataView input, ::device::mojom::RequestSessionSuccessPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) StructTraits<::device::mojom::XRFrameDataRequestOptions::DataView,
                                         ::device::mojom::XRFrameDataRequestOptionsPtr> {
  static bool IsNull(const ::device::mojom::XRFrameDataRequestOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRFrameDataRequestOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::XRFrameDataRequestOptions::include_lighting_estimation_data) include_lighting_estimation_data(
      const ::device::mojom::XRFrameDataRequestOptionsPtr& input) {
    return input->include_lighting_estimation_data;
  }

  static decltype(::device::mojom::XRFrameDataRequestOptions::stage_parameters_id) stage_parameters_id(
      const ::device::mojom::XRFrameDataRequestOptionsPtr& input) {
    return input->stage_parameters_id;
  }

  static bool Read(::device::mojom::XRFrameDataRequestOptions::DataView input, ::device::mojom::XRFrameDataRequestOptionsPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) UnionTraits<::device::mojom::XRNativeOriginInformation::DataView,
                                        ::device::mojom::XRNativeOriginInformationPtr> {
  static bool IsNull(const ::device::mojom::XRNativeOriginInformationPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRNativeOriginInformationPtr* output) { output->reset(); }

  static ::device::mojom::XRNativeOriginInformation::Tag GetTag(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->which();
  }

  static const ::device::mojom::XRInputSourceSpaceInfoPtr& input_source_space_info(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_input_source_space_info();
  }

  static  uint64_t plane_id(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_plane_id();
  }

  static  uint64_t anchor_id(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_anchor_id();
  }

  static  ::device::mojom::XRReferenceSpaceType reference_space_type(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_reference_space_type();
  }

  static const ::device::mojom::XRHandJointSpaceInfoPtr& hand_joint_space_info(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_hand_joint_space_info();
  }

  static  uint32_t image_index(const ::device::mojom::XRNativeOriginInformationPtr& input) {
    return input->get_image_index();
  }

  static bool Read(::device::mojom::XRNativeOriginInformation::DataView input, ::device::mojom::XRNativeOriginInformationPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) UnionTraits<::device::mojom::XRDepthData::DataView,
                                        ::device::mojom::XRDepthDataPtr> {
  static bool IsNull(const ::device::mojom::XRDepthDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::XRDepthDataPtr* output) { output->reset(); }

  static ::device::mojom::XRDepthData::Tag GetTag(const ::device::mojom::XRDepthDataPtr& input) {
    return input->which();
  }

  static const ::device::mojom::XRDepthDataStillValidPtr& data_still_valid(const ::device::mojom::XRDepthDataPtr& input) {
    return input->get_data_still_valid();
  }

  static  ::device::mojom::XRDepthDataUpdatedPtr& updated_depth_data( ::device::mojom::XRDepthDataPtr& input) {
    return input->get_updated_depth_data();
  }

  static bool Read(::device::mojom::XRDepthData::DataView input, ::device::mojom::XRDepthDataPtr* output);
};


template <>
struct COMPONENT_EXPORT(DEVICE_VR_SERVICE_MOJO_BINDINGS) UnionTraits<::device::mojom::RequestSessionResult::DataView,
                                        ::device::mojom::RequestSessionResultPtr> {
  static bool IsNull(const ::device::mojom::RequestSessionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::RequestSessionResultPtr* output) { output->reset(); }

  static ::device::mojom::RequestSessionResult::Tag GetTag(const ::device::mojom::RequestSessionResultPtr& input) {
    return input->which();
  }

  static  ::device::mojom::RequestSessionSuccessPtr& success( ::device::mojom::RequestSessionResultPtr& input) {
    return input->get_success();
  }

  static  ::device::mojom::RequestSessionError failure_reason(const ::device::mojom::RequestSessionResultPtr& input) {
    return input->get_failure_reason();
  }

  static bool Read(::device::mojom::RequestSessionResult::DataView input, ::device::mojom::RequestSessionResultPtr* output);
};

}  // namespace mojo

#endif  // DEVICE_VR_PUBLIC_MOJOM_VR_SERVICE_MOJOM_H_