// components/variations/variations.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_
#define COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/variations/variations.mojom-shared-internal.h"







namespace variations::mojom {
class VariationsHeadersDataView;



}  // variations::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::variations::mojom::VariationsHeadersDataView> {
  using Data = ::variations::mojom::internal::VariationsHeaders_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace variations::mojom {


enum class GoogleWebVisibility : int32_t {
  
  ANY = 0,
  
  FIRST_PARTY = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GoogleWebVisibility value);
inline bool IsKnownEnumValue(GoogleWebVisibility value) {
  return internal::GoogleWebVisibility_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VariationsHeadersDataView {
 public:
  VariationsHeadersDataView() = default;

  VariationsHeadersDataView(
      internal::VariationsHeaders_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeadersMapDataView(
      mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeadersMap(UserType* output) {
    
    auto* pointer = data_->headers_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::variations::mojom::GoogleWebVisibility, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::VariationsHeaders_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // variations::mojom

namespace std {

template <>
struct hash<::variations::mojom::GoogleWebVisibility>
    : public mojo::internal::EnumHashImpl<::variations::mojom::GoogleWebVisibility> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::variations::mojom::GoogleWebVisibility, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::variations::mojom::GoogleWebVisibility, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::variations::mojom::GoogleWebVisibility>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::variations::mojom::VariationsHeadersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::variations::mojom::VariationsHeadersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::variations::mojom::internal::VariationsHeaders_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::headers_map(input)) in_headers_map = Traits::headers_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers_map)::BaseType>
        headers_map_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_map_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::variations::mojom::internal::GoogleWebVisibility_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<::variations::mojom::GoogleWebVisibility, mojo::StringDataView>>(
        in_headers_map, headers_map_fragment, &headers_map_validate_params);
    fragment->headers_map.Set(
        headers_map_fragment.is_null() ? nullptr : headers_map_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers_map.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers_map in VariationsHeaders struct");
  }

  static bool Deserialize(::variations::mojom::internal::VariationsHeaders_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::variations::mojom::VariationsHeadersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace variations::mojom {

inline void VariationsHeadersDataView::GetHeadersMapDataView(
    mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>* output) {
  auto pointer = data_->headers_map.Get();
  *output = mojo::MapDataView<GoogleWebVisibility, mojo::StringDataView>(pointer, message_);
}



}  // variations::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::variations::mojom::GoogleWebVisibility> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::variations::mojom::GoogleWebVisibility value);
};

} // namespace perfetto

#endif  // COMPONENTS_VARIATIONS_VARIATIONS_MOJOM_SHARED_H_