// third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_state.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class ServiceWorkerObjectInfoDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerObjectInfoDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerObjectInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class ServiceWorkerObjectHostInterfaceBase {};

using ServiceWorkerObjectHostPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerObjectHostInterfaceBase>;
using ServiceWorkerObjectHostRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerObjectHostInterfaceBase>;
using ServiceWorkerObjectHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerObjectHostInterfaceBase>;
using ServiceWorkerObjectHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerObjectHostInterfaceBase>;
class ServiceWorkerObjectInterfaceBase {};

using ServiceWorkerObjectPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerObjectInterfaceBase>;
using ServiceWorkerObjectRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerObjectInterfaceBase>;
using ServiceWorkerObjectAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerObjectInterfaceBase>;
using ServiceWorkerObjectAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerObjectInterfaceBase>;


class ServiceWorkerObjectInfoDataView {
 public:
  ServiceWorkerObjectInfoDataView() = default;

  ServiceWorkerObjectInfoDataView(
      internal::ServiceWorkerObjectInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t version_id() const {
    return data_->version_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerState>(
        data_value, output);
  }
  ::blink::mojom::ServiceWorkerState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ServiceWorkerState>(data_->state));
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeHostRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::ServiceWorkerObjectHostAssociatedPtrInfoDataView>(
            &data_->host_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::ServiceWorkerObjectAssociatedRequestDataView>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ServiceWorkerObjectInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerObjectInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerObjectInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServiceWorkerObjectInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->version_id = Traits::version_id(input);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerState>(
        Traits::state(input), &fragment->state);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ServiceWorkerObjectInfo struct");
    decltype(Traits::host_remote(input)) in_host_remote = Traits::host_remote(input);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectHostAssociatedPtrInfoDataView>(
        in_host_remote, &fragment->host_remote, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->host_remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid host_remote in ServiceWorkerObjectInfo struct");
    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerObjectAssociatedRequestDataView>(
        in_receiver, &fragment->receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid receiver in ServiceWorkerObjectInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerObjectInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerObjectInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void ServiceWorkerObjectInfoDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_OBJECT_MOJOM_SHARED_H_