// services/video_capture/public/mojom/virtual_device.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/video_capture/public/mojom/virtual_device.mojom-features.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/virtual_device.mojom-shared.h"  // IWYU pragma: export
#include "services/video_capture/public/mojom/virtual_device.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/producer.mojom-forward.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace video_capture::mojom {

class SharedMemoryVirtualDeviceProxy;

template <typename ImplRefTraits>
class SharedMemoryVirtualDeviceStub;

class SharedMemoryVirtualDeviceRequestValidator;
class SharedMemoryVirtualDeviceResponseValidator;


class SharedMemoryVirtualDevice
    : public SharedMemoryVirtualDeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SharedMemoryVirtualDeviceInterfaceBase;
  using Proxy_ = SharedMemoryVirtualDeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SharedMemoryVirtualDeviceStub<ImplRefTraits>;

  using RequestValidator_ = SharedMemoryVirtualDeviceRequestValidator;
  using ResponseValidator_ = SharedMemoryVirtualDeviceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestFrameBufferMinVersion = 0,
    kOnFrameReadyInBufferMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestFrameBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameReadyInBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SharedMemoryVirtualDevice() = default;


  using RequestFrameBufferCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void RequestFrameBuffer(const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, RequestFrameBufferCallback callback) = 0;

  
  virtual void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) = 0;
};

class TextureVirtualDeviceProxy;

template <typename ImplRefTraits>
class TextureVirtualDeviceStub;

class TextureVirtualDeviceRequestValidator;


class TextureVirtualDevice
    : public TextureVirtualDeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TextureVirtualDeviceInterfaceBase;
  using Proxy_ = TextureVirtualDeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = TextureVirtualDeviceStub<ImplRefTraits>;

  using RequestValidator_ = TextureVirtualDeviceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNewSharedImageBufferHandleMinVersion = 0,
    kOnFrameAccessHandlerReadyMinVersion = 0,
    kOnFrameReadyInBufferMinVersion = 0,
    kOnBufferRetiredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNewSharedImageBufferHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameAccessHandlerReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameReadyInBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferRetired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TextureVirtualDevice() = default;

  
  virtual void OnNewSharedImageBufferHandle(int32_t buffer_id, ::media::mojom::SharedImageBufferHandleSetPtr shared_image_handle) = 0;

  
  virtual void OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) = 0;

  
  virtual void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) = 0;

  
  virtual void OnBufferRetired(int32_t buffer_id) = 0;
};

class GpuMemoryBufferVirtualDeviceProxy;

template <typename ImplRefTraits>
class GpuMemoryBufferVirtualDeviceStub;

class GpuMemoryBufferVirtualDeviceRequestValidator;


class GpuMemoryBufferVirtualDevice
    : public GpuMemoryBufferVirtualDeviceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GpuMemoryBufferVirtualDeviceInterfaceBase;
  using Proxy_ = GpuMemoryBufferVirtualDeviceProxy;

  template <typename ImplRefTraits>
  using Stub_ = GpuMemoryBufferVirtualDeviceStub<ImplRefTraits>;

  using RequestValidator_ = GpuMemoryBufferVirtualDeviceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNewGpuMemoryBufferHandleMinVersion = 0,
    kOnFrameAccessHandlerReadyMinVersion = 0,
    kOnFrameReadyInBufferMinVersion = 0,
    kOnBufferRetiredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNewGpuMemoryBufferHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameAccessHandlerReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameReadyInBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBufferRetired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GpuMemoryBufferVirtualDevice() = default;

  
  virtual void OnNewGpuMemoryBufferHandle(int32_t buffer_id, ::gfx::GpuMemoryBufferHandle gmb_handle) = 0;

  
  virtual void OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) = 0;

  
  virtual void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) = 0;

  
  virtual void OnBufferRetired(int32_t buffer_id) = 0;
};



class  SharedMemoryVirtualDeviceProxy
    : public SharedMemoryVirtualDevice {
 public:
  using InterfaceType = SharedMemoryVirtualDevice;

  explicit SharedMemoryVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestFrameBuffer(const ::gfx::Size& dimension, ::media::VideoPixelFormat pixel_format, ::media::mojom::PlaneStridesPtr strides, RequestFrameBufferCallback callback) final;
  
  void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TextureVirtualDeviceProxy
    : public TextureVirtualDevice {
 public:
  using InterfaceType = TextureVirtualDevice;

  explicit TextureVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNewSharedImageBufferHandle(int32_t buffer_id, ::media::mojom::SharedImageBufferHandleSetPtr shared_image_handle) final;
  
  void OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) final;
  
  void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) final;
  
  void OnBufferRetired(int32_t buffer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GpuMemoryBufferVirtualDeviceProxy
    : public GpuMemoryBufferVirtualDevice {
 public:
  using InterfaceType = GpuMemoryBufferVirtualDevice;

  explicit GpuMemoryBufferVirtualDeviceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNewGpuMemoryBufferHandle(int32_t buffer_id, ::gfx::GpuMemoryBufferHandle gmb_handle) final;
  
  void OnFrameAccessHandlerReady(::mojo::PendingRemote<::video_capture::mojom::VideoFrameAccessHandler> frame_access_handler) final;
  
  void OnFrameReadyInBuffer(int32_t buffer_id, ::media::mojom::VideoFrameInfoPtr frame_info) final;
  
  void OnBufferRetired(int32_t buffer_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SharedMemoryVirtualDeviceStubDispatch {
 public:
  static bool Accept(SharedMemoryVirtualDevice* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SharedMemoryVirtualDevice* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SharedMemoryVirtualDevice>>
class SharedMemoryVirtualDeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SharedMemoryVirtualDeviceStub() = default;
  ~SharedMemoryVirtualDeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedMemoryVirtualDeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SharedMemoryVirtualDeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TextureVirtualDeviceStubDispatch {
 public:
  static bool Accept(TextureVirtualDevice* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TextureVirtualDevice* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TextureVirtualDevice>>
class TextureVirtualDeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TextureVirtualDeviceStub() = default;
  ~TextureVirtualDeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextureVirtualDeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TextureVirtualDeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GpuMemoryBufferVirtualDeviceStubDispatch {
 public:
  static bool Accept(GpuMemoryBufferVirtualDevice* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GpuMemoryBufferVirtualDevice* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GpuMemoryBufferVirtualDevice>>
class GpuMemoryBufferVirtualDeviceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GpuMemoryBufferVirtualDeviceStub() = default;
  ~GpuMemoryBufferVirtualDeviceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuMemoryBufferVirtualDeviceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GpuMemoryBufferVirtualDeviceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SharedMemoryVirtualDeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TextureVirtualDeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GpuMemoryBufferVirtualDeviceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SharedMemoryVirtualDeviceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // video_capture::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIRTUAL_DEVICE_MOJOM_H_