// media/mojo/mojom/stable/native_pixmap_handle.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/stable/native_pixmap_handle.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::stable::mojom {
class NativePixmapPlaneDataView;

class NativePixmapHandleDataView;



}  // media::stable::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::stable::mojom::NativePixmapPlaneDataView> {
  using Data = ::media::stable::mojom::internal::NativePixmapPlane_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::stable::mojom::NativePixmapHandleDataView> {
  using Data = ::media::stable::mojom::internal::NativePixmapHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::stable::mojom {


class NativePixmapPlaneDataView {
 public:
  NativePixmapPlaneDataView() = default;

  NativePixmapPlaneDataView(
      internal::NativePixmapPlane_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t stride() const {
    return data_->stride;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t size() const {
    return data_->size;
  }
  mojo::PlatformHandle TakeBufferHandle() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->buffer_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NativePixmapPlane_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativePixmapHandleDataView {
 public:
  NativePixmapHandleDataView() = default;

  NativePixmapHandleDataView(
      internal::NativePixmapHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlanesDataView(
      mojo::ArrayDataView<NativePixmapPlaneDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlanes(UserType* output) {
    
    auto* pointer = data_->planes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::stable::mojom::NativePixmapPlaneDataView>>(
        pointer, output, message_);
  }
  uint64_t modifier() const {
    return data_->modifier;
  }
 private:
  internal::NativePixmapHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::stable::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::NativePixmapPlaneDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::NativePixmapPlaneDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::NativePixmapPlane_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->stride = Traits::stride(input);
    fragment->offset = Traits::offset(input);
    fragment->size = Traits::size(input);
    decltype(Traits::buffer_handle(input)) in_buffer_handle = Traits::buffer_handle(input);
    mojo::internal::Serialize<mojo::PlatformHandle>(
        in_buffer_handle, &fragment->buffer_handle, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->buffer_handle),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid buffer_handle in NativePixmapPlane struct");
  }

  static bool Deserialize(::media::stable::mojom::internal::NativePixmapPlane_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::NativePixmapPlaneDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::stable::mojom::NativePixmapHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::stable::mojom::NativePixmapHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::stable::mojom::internal::NativePixmapHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::planes(input)) in_planes = Traits::planes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->planes)::BaseType>
        planes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& planes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::stable::mojom::NativePixmapPlaneDataView>>(
        in_planes, planes_fragment, &planes_validate_params);
    fragment->planes.Set(
        planes_fragment.is_null() ? nullptr : planes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->planes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null planes in NativePixmapHandle struct");
    fragment->modifier = Traits::modifier(input);
  }

  static bool Deserialize(::media::stable::mojom::internal::NativePixmapHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::stable::mojom::NativePixmapHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::stable::mojom {



inline void NativePixmapHandleDataView::GetPlanesDataView(
    mojo::ArrayDataView<NativePixmapPlaneDataView>* output) {
  auto pointer = data_->planes.Get();
  *output = mojo::ArrayDataView<NativePixmapPlaneDataView>(pointer, message_);
}



}  // media::stable::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_STABLE_NATIVE_PIXMAP_HANDLE_MOJOM_SHARED_H_