// media/mojo/mojom/cdm_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_service.mojom-params-data.h"
#include "media/mojo/mojom/cdm_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_service.mojom-blink-import-headers.h"
#include "media/mojo/mojom/cdm_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
const char CdmService::Name_[] = "media.mojom.CdmService";

CdmService::IPCStableHashFunction CdmService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmService>(message.name())) {
    case messages::CdmService::kCreateCdmFactory: {
      return &CdmService::CreateCdmFactory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmService>(message.name())) {
      case messages::CdmService::kCreateCdmFactory:
            return "Receive media::mojom::CdmService::CreateCdmFactory";
    }
  } else {
    switch (static_cast<messages::CdmService>(message.name())) {
      case messages::CdmService::kCreateCdmFactory:
            return "Receive reply media::mojom::CdmService::CreateCdmFactory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmService::CreateCdmFactory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::CdmService::CreateCdmFactory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmServiceProxy::CdmServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceProxy::CreateCdmFactory(
    ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> in_factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> in_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmService::CreateCdmFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_interfaces"), in_frame_interfaces,
                        "<value of type ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmService::kCreateCdmFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmService_CreateCdmFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in CdmService.CreateCdmFactory request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameInterfaceFactoryInterfaceBase>>(
      in_frame_interfaces, &params->frame_interfaces, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame_interfaces),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_interfaces in CdmService.CreateCdmFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmService::Name_);
  message.set_method_name("CreateCdmFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmServiceStubDispatch::Accept(
    CdmService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmService>(message->header()->name)) {
    case messages::CdmService::kCreateCdmFactory: {
      DCHECK(message->is_serialized());
      internal::CdmService_CreateCdmFactory_Params_Data* params =
          reinterpret_cast<internal::CdmService_CreateCdmFactory_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CdmService.0
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> p_factory{};
      ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> p_frame_interfaces{};
      CdmService_CreateCdmFactory_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success) {
        p_frame_interfaces =
            input_data_view.TakeFrameInterfaces<decltype(p_frame_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmFactory(        
        std::move(p_factory), 
        std::move(p_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceStubDispatch::AcceptWithResponder(
    CdmService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmService>(message->header()->name)) {
    case messages::CdmService::kCreateCdmFactory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmServiceValidationInfo[] = {
    {base::to_underlying(messages::CdmService::kCreateCdmFactory),
     { &internal::CdmService_CreateCdmFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmServiceValidationInfo);
}

const char CdmServiceBroker::Name_[] = "media.mojom.CdmServiceBroker";

CdmServiceBroker::IPCStableHashFunction CdmServiceBroker::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmServiceBroker>(message.name())) {
    case messages::CdmServiceBroker::kGetService: {
      return &CdmServiceBroker::GetService_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmServiceBroker::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmServiceBroker>(message.name())) {
      case messages::CdmServiceBroker::kGetService:
            return "Receive media::mojom::CdmServiceBroker::GetService";
    }
  } else {
    switch (static_cast<messages::CdmServiceBroker>(message.name())) {
      case messages::CdmServiceBroker::kGetService:
            return "Receive reply media::mojom::CdmServiceBroker::GetService";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmServiceBroker::GetService_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::mojom::CdmServiceBroker::GetService");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmServiceBrokerProxy::CdmServiceBrokerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceBrokerProxy::GetService(
    const ::base::FilePath& in_cdm_path, ::mojo::PendingReceiver<CdmService> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmServiceBroker::GetService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cdm_path"), in_cdm_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<CdmService>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmServiceBroker::kGetService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmServiceBroker_GetService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cdm_path)::BaseType> cdm_path_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_cdm_path, cdm_path_fragment);
  params->cdm_path.Set(
      cdm_path_fragment.is_null() ? nullptr : cdm_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_path in CdmServiceBroker.GetService request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmServiceInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in CdmServiceBroker.GetService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmServiceBroker::Name_);
  message.set_method_name("GetService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmServiceBrokerStubDispatch::Accept(
    CdmServiceBroker* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmServiceBroker>(message->header()->name)) {
    case messages::CdmServiceBroker::kGetService: {
      DCHECK(message->is_serialized());
      internal::CdmServiceBroker_GetService_Params_Data* params =
          reinterpret_cast<internal::CdmServiceBroker_GetService_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for CdmServiceBroker.0
      bool success = true;
      ::base::FilePath p_cdm_path{};
      ::mojo::PendingReceiver<CdmService> p_receiver{};
      CdmServiceBroker_GetService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCdmPath(&p_cdm_path))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmServiceBroker::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetService(        
        std::move(p_cdm_path), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceBrokerStubDispatch::AcceptWithResponder(
    CdmServiceBroker* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmServiceBroker>(message->header()->name)) {
    case messages::CdmServiceBroker::kGetService: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmServiceBrokerValidationInfo[] = {
    {base::to_underlying(messages::CdmServiceBroker::kGetService),
     { &internal::CdmServiceBroker_GetService_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmServiceBrokerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::blink::CdmServiceBroker::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmServiceBrokerValidationInfo);
}



}  // media::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {


void CdmServiceInterceptorForTesting::CreateCdmFactory(::mojo::PendingReceiver<::media::mojom::blink::CdmFactory> factory, ::mojo::PendingRemote<::media::mojom::blink::FrameInterfaceFactory> frame_interfaces) {
  GetForwardingInterface()->CreateCdmFactory(
    std::move(factory)
    , 
    std::move(frame_interfaces)
    );
}
CdmServiceAsyncWaiter::CdmServiceAsyncWaiter(
    CdmService* proxy) : proxy_(proxy) {}

CdmServiceAsyncWaiter::~CdmServiceAsyncWaiter() = default;




void CdmServiceBrokerInterceptorForTesting::GetService(const ::base::FilePath& cdm_path, ::mojo::PendingReceiver<CdmService> receiver) {
  GetForwardingInterface()->GetService(
    std::move(cdm_path)
    , 
    std::move(receiver)
    );
}
CdmServiceBrokerAsyncWaiter::CdmServiceBrokerAsyncWaiter(
    CdmServiceBroker* proxy) : proxy_(proxy) {}

CdmServiceBrokerAsyncWaiter::~CdmServiceBrokerAsyncWaiter() = default;






}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif