// media/capture/mojom/video_capture_types.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/capture/mojom/video_capture_types.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_types.mojom-params-data.h"
#include "media/capture/mojom/video_capture_types.mojom-shared-message-ids.h"

#include "media/capture/mojom/video_capture_types.mojom-blink-import-headers.h"
#include "media/capture/mojom/video_capture_types.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace media::mojom::blink {
VideoCaptureControlSupport::VideoCaptureControlSupport()
    : pan(),
      tilt(),
      zoom() {}

VideoCaptureControlSupport::VideoCaptureControlSupport(
    bool pan_in,
    bool tilt_in,
    bool zoom_in)
    : pan(std::move(pan_in)),
      tilt(std::move(tilt_in)),
      zoom(std::move(zoom_in)) {}

VideoCaptureControlSupport::~VideoCaptureControlSupport() = default;

void VideoCaptureControlSupport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pan"), this->pan,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tilt"), this->tilt,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "zoom"), this->zoom,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureControlSupport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureFormat::VideoCaptureFormat()
    : frame_size(),
      frame_rate(),
      pixel_format() {}

VideoCaptureFormat::VideoCaptureFormat(
    const ::gfx::Size& frame_size_in,
    float frame_rate_in,
    ::media::VideoPixelFormat pixel_format_in)
    : frame_size(std::move(frame_size_in)),
      frame_rate(std::move(frame_rate_in)),
      pixel_format(std::move(pixel_format_in)) {}

VideoCaptureFormat::~VideoCaptureFormat() = default;

void VideoCaptureFormat::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_size"), this->frame_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_rate"), this->frame_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pixel_format"), this->pixel_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureFormat::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureParams::VideoCaptureParams()
    : requested_format(),
      buffer_type(),
      resolution_change_policy(),
      power_line_frequency(),
      enable_face_detection(),
      is_high_dpi_enabled() {}

VideoCaptureParams::VideoCaptureParams(
    const ::media::VideoCaptureFormat& requested_format_in,
    ::media::VideoCaptureBufferType buffer_type_in,
    ::media::ResolutionChangePolicy resolution_change_policy_in,
    ::media::PowerLineFrequency power_line_frequency_in,
    bool enable_face_detection_in)
    : requested_format(std::move(requested_format_in)),
      buffer_type(std::move(buffer_type_in)),
      resolution_change_policy(std::move(resolution_change_policy_in)),
      power_line_frequency(std::move(power_line_frequency_in)),
      enable_face_detection(std::move(enable_face_detection_in)),
      is_high_dpi_enabled() {}

VideoCaptureParams::VideoCaptureParams(
    const ::media::VideoCaptureFormat& requested_format_in,
    ::media::VideoCaptureBufferType buffer_type_in,
    ::media::ResolutionChangePolicy resolution_change_policy_in,
    ::media::PowerLineFrequency power_line_frequency_in,
    bool enable_face_detection_in,
    bool is_high_dpi_enabled_in)
    : requested_format(std::move(requested_format_in)),
      buffer_type(std::move(buffer_type_in)),
      resolution_change_policy(std::move(resolution_change_policy_in)),
      power_line_frequency(std::move(power_line_frequency_in)),
      enable_face_detection(std::move(enable_face_detection_in)),
      is_high_dpi_enabled(std::move(is_high_dpi_enabled_in)) {}

VideoCaptureParams::~VideoCaptureParams() = default;

void VideoCaptureParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_format"), this->requested_format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureFormat&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buffer_type"), this->buffer_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCaptureBufferType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resolution_change_policy"), this->resolution_change_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::ResolutionChangePolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "power_line_frequency"), this->power_line_frequency,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::PowerLineFrequency>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_face_detection"), this->enable_face_detection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_high_dpi_enabled"), this->is_high_dpi_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureFeedback::VideoCaptureFeedback()
    : resource_utilization(),
      max_framerate_fps(),
      max_pixels(),
      require_mapped_frame(),
      DEPRECATED_mapped_sizes(),
      frame_id(0),
      has_frame_id(false) {}

VideoCaptureFeedback::VideoCaptureFeedback(
    double resource_utilization_in,
    float max_framerate_fps_in,
    int32_t max_pixels_in,
    bool require_mapped_frame_in)
    : resource_utilization(std::move(resource_utilization_in)),
      max_framerate_fps(std::move(max_framerate_fps_in)),
      max_pixels(std::move(max_pixels_in)),
      require_mapped_frame(std::move(require_mapped_frame_in)),
      DEPRECATED_mapped_sizes(),
      frame_id(0),
      has_frame_id(false) {}

VideoCaptureFeedback::VideoCaptureFeedback(
    double resource_utilization_in,
    float max_framerate_fps_in,
    int32_t max_pixels_in,
    bool require_mapped_frame_in,
    std::optional<WTF::Vector<::gfx::Size>> DEPRECATED_mapped_sizes_in)
    : resource_utilization(std::move(resource_utilization_in)),
      max_framerate_fps(std::move(max_framerate_fps_in)),
      max_pixels(std::move(max_pixels_in)),
      require_mapped_frame(std::move(require_mapped_frame_in)),
      DEPRECATED_mapped_sizes(std::move(DEPRECATED_mapped_sizes_in)),
      frame_id(0),
      has_frame_id(false) {}

VideoCaptureFeedback::VideoCaptureFeedback(
    double resource_utilization_in,
    float max_framerate_fps_in,
    int32_t max_pixels_in,
    bool require_mapped_frame_in,
    std::optional<WTF::Vector<::gfx::Size>> DEPRECATED_mapped_sizes_in,
    int32_t frame_id_in,
    bool has_frame_id_in)
    : resource_utilization(std::move(resource_utilization_in)),
      max_framerate_fps(std::move(max_framerate_fps_in)),
      max_pixels(std::move(max_pixels_in)),
      require_mapped_frame(std::move(require_mapped_frame_in)),
      DEPRECATED_mapped_sizes(std::move(DEPRECATED_mapped_sizes_in)),
      frame_id(std::move(frame_id_in)),
      has_frame_id(std::move(has_frame_id_in)) {}

VideoCaptureFeedback::~VideoCaptureFeedback() = default;

void VideoCaptureFeedback::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resource_utilization"), this->resource_utilization,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_framerate_fps"), this->max_framerate_fps,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_pixels"), this->max_pixels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_mapped_frame"), this->require_mapped_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "DEPRECATED_mapped_sizes"), this->DEPRECATED_mapped_sizes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<::gfx::Size>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_id"), this->frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_frame_id"), this->has_frame_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureFeedback::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PlaneStrides::PlaneStrides()
    : stride_by_plane() {}

PlaneStrides::PlaneStrides(
    WTF::Vector<uint32_t> stride_by_plane_in)
    : stride_by_plane(std::move(stride_by_plane_in)) {}

PlaneStrides::~PlaneStrides() = default;

void PlaneStrides::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stride_by_plane"), this->stride_by_plane,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PlaneStrides::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureDeviceDescriptor::VideoCaptureDeviceDescriptor()
    : display_name(),
      device_id(),
      model_id(),
      facing_mode(),
      capture_api(),
      control_support(),
      transport_type(),
      availability() {}

VideoCaptureDeviceDescriptor::VideoCaptureDeviceDescriptor(
    const WTF::String& display_name_in,
    const WTF::String& device_id_in,
    const WTF::String& model_id_in,
    ::media::VideoFacingMode facing_mode_in,
    VideoCaptureApi capture_api_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    VideoCaptureTransportType transport_type_in)
    : display_name(std::move(display_name_in)),
      device_id(std::move(device_id_in)),
      model_id(std::move(model_id_in)),
      facing_mode(std::move(facing_mode_in)),
      capture_api(std::move(capture_api_in)),
      control_support(std::move(control_support_in)),
      transport_type(std::move(transport_type_in)),
      availability() {}

VideoCaptureDeviceDescriptor::VideoCaptureDeviceDescriptor(
    const WTF::String& display_name_in,
    const WTF::String& device_id_in,
    const WTF::String& model_id_in,
    ::media::VideoFacingMode facing_mode_in,
    VideoCaptureApi capture_api_in,
    const ::media::VideoCaptureControlSupport& control_support_in,
    VideoCaptureTransportType transport_type_in,
    std::optional<CameraAvailability> availability_in)
    : display_name(std::move(display_name_in)),
      device_id(std::move(device_id_in)),
      model_id(std::move(model_id_in)),
      facing_mode(std::move(facing_mode_in)),
      capture_api(std::move(capture_api_in)),
      control_support(std::move(control_support_in)),
      transport_type(std::move(transport_type_in)),
      availability(std::move(availability_in)) {}

VideoCaptureDeviceDescriptor::~VideoCaptureDeviceDescriptor() = default;

void VideoCaptureDeviceDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_id"), this->device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_id"), this->model_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "facing_mode"), this->facing_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoFacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "capture_api"), this->capture_api,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoCaptureApi>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "control_support"), this->control_support,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureControlSupport&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transport_type"), this->transport_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type VideoCaptureTransportType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "availability"), this->availability,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<CameraAvailability>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureDeviceDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureDeviceInfo::VideoCaptureDeviceInfo()
    : descriptor(),
      supported_formats() {}

VideoCaptureDeviceInfo::VideoCaptureDeviceInfo(
    const ::media::VideoCaptureDeviceDescriptor& descriptor_in,
    WTF::Vector<::media::VideoCaptureFormat> supported_formats_in)
    : descriptor(std::move(descriptor_in)),
      supported_formats(std::move(supported_formats_in)) {}

VideoCaptureDeviceInfo::~VideoCaptureDeviceInfo() = default;

void VideoCaptureDeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor"), this->descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoCaptureDeviceDescriptor&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported_formats"), this->supported_formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<::media::VideoCaptureFormat>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // media::mojom::blink


namespace mojo {


// static
bool StructTraits<::media::mojom::blink::VideoCaptureControlSupport::DataView, ::media::mojom::blink::VideoCaptureControlSupportPtr>::Read(
    ::media::mojom::blink::VideoCaptureControlSupport::DataView input,
    ::media::mojom::blink::VideoCaptureControlSupportPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureControlSupportPtr result(::media::mojom::blink::VideoCaptureControlSupport::New());
  
      if (success)
        result->pan = input.pan();
      if (success)
        result->tilt = input.tilt();
      if (success)
        result->zoom = input.zoom();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureFormat::DataView, ::media::mojom::blink::VideoCaptureFormatPtr>::Read(
    ::media::mojom::blink::VideoCaptureFormat::DataView input,
    ::media::mojom::blink::VideoCaptureFormatPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureFormatPtr result(::media::mojom::blink::VideoCaptureFormat::New());
  
      if (success && !input.ReadFrameSize(&result->frame_size))
        success = false;
      if (success)
        result->frame_rate = input.frame_rate();
      if (success && !input.ReadPixelFormat(&result->pixel_format))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureParams::DataView, ::media::mojom::blink::VideoCaptureParamsPtr>::Read(
    ::media::mojom::blink::VideoCaptureParams::DataView input,
    ::media::mojom::blink::VideoCaptureParamsPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureParamsPtr result(::media::mojom::blink::VideoCaptureParams::New());
  
      if (success && !input.ReadRequestedFormat(&result->requested_format))
        success = false;
      if (success && !input.ReadBufferType(&result->buffer_type))
        success = false;
      if (success && !input.ReadResolutionChangePolicy(&result->resolution_change_policy))
        success = false;
      if (success && !input.ReadPowerLineFrequency(&result->power_line_frequency))
        success = false;
      if (success)
        result->enable_face_detection = input.enable_face_detection();
      if (success)
        result->is_high_dpi_enabled = input.is_high_dpi_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureFeedback::DataView, ::media::mojom::blink::VideoCaptureFeedbackPtr>::Read(
    ::media::mojom::blink::VideoCaptureFeedback::DataView input,
    ::media::mojom::blink::VideoCaptureFeedbackPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureFeedbackPtr result(::media::mojom::blink::VideoCaptureFeedback::New());
  
      if (success)
        result->resource_utilization = input.resource_utilization();
      if (success)
        result->max_framerate_fps = input.max_framerate_fps();
      if (success)
        result->max_pixels = input.max_pixels();
      if (success)
        result->require_mapped_frame = input.require_mapped_frame();
      if (success && !input.ReadDeprecatedMappedSizes(&result->DEPRECATED_mapped_sizes))
        success = false;
      if (success)
        result->frame_id = input.frame_id();
      if (success)
        result->has_frame_id = input.has_frame_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::PlaneStrides::DataView, ::media::mojom::blink::PlaneStridesPtr>::Read(
    ::media::mojom::blink::PlaneStrides::DataView input,
    ::media::mojom::blink::PlaneStridesPtr* output) {
  bool success = true;
  ::media::mojom::blink::PlaneStridesPtr result(::media::mojom::blink::PlaneStrides::New());
  
      if (success && !input.ReadStrideByPlane(&result->stride_by_plane))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView, ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr>::Read(
    ::media::mojom::blink::VideoCaptureDeviceDescriptor::DataView input,
    ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureDeviceDescriptorPtr result(::media::mojom::blink::VideoCaptureDeviceDescriptor::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadDeviceId(&result->device_id))
        success = false;
      if (success && !input.ReadModelId(&result->model_id))
        success = false;
      if (success && !input.ReadFacingMode(&result->facing_mode))
        success = false;
      if (success && !input.ReadCaptureApi(&result->capture_api))
        success = false;
      if (success && !input.ReadControlSupport(&result->control_support))
        success = false;
      if (success && !input.ReadTransportType(&result->transport_type))
        success = false;
      if (success && !input.ReadAvailability(&result->availability)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::mojom::blink::VideoCaptureDeviceInfo::DataView, ::media::mojom::blink::VideoCaptureDeviceInfoPtr>::Read(
    ::media::mojom::blink::VideoCaptureDeviceInfo::DataView input,
    ::media::mojom::blink::VideoCaptureDeviceInfoPtr* output) {
  bool success = true;
  ::media::mojom::blink::VideoCaptureDeviceInfoPtr result(::media::mojom::blink::VideoCaptureDeviceInfo::New());
  
      if (success && !input.ReadDescriptor(&result->descriptor))
        success = false;
      if (success && !input.ReadSupportedFormats(&result->supported_formats))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom::blink {




}  // media::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif