// content/common/frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_MOJOM_SHARED_H_
#define CONTENT_COMMON_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/common/frame.mojom-shared-internal.h"
#include "cc/mojom/browser_controls_state.mojom-shared.h"
#include "content/common/frame_messages.mojom-shared.h"
#include "content/common/navigation_client.mojom-shared.h"
#include "content/common/web_ui.mojom-shared.h"
#include "content/public/common/extra_mojo_js_features.mojom-shared.h"
#include "content/public/common/window_container_type.mojom-shared.h"
#include "ipc/constants.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_completion_status.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "third_party/blink/public/mojom/associated_interfaces/associated_interfaces.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "third_party/blink/public/mojom/commit_result/commit_result.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/page/browsing_context_group_info.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared.h"
#include "third_party/blink/public/mojom/page/prerender_page_param.mojom-shared.h"
#include "third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom-shared.h"
#include "third_party/blink/public/mojom/picture_in_picture_window_options/picture_in_picture_window_options.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_container.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "base/component_export.h"




namespace content::mojom {
class CreateViewParamsDataView;

class CreateLocalMainFrameParamsDataView;

class CreateProvisionalLocalMainFrameParamsDataView;

class CreateRemoteMainFrameParamsDataView;

class CreateFrameWidgetParamsDataView;

class CreateFrameParamsDataView;

class SnapshotAccessibilityTreeParamsDataView;

class CreateNewWindowParamsDataView;

class CreateNewWindowReplyDataView;

class CreateMainFrameUnionDataView;


}  // content::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::content::mojom::CreateViewParamsDataView> {
  using Data = ::content::mojom::internal::CreateViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateLocalMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateLocalMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateRemoteMainFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateRemoteMainFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameWidgetParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameWidgetParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateFrameParamsDataView> {
  using Data = ::content::mojom::internal::CreateFrameParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::SnapshotAccessibilityTreeParamsDataView> {
  using Data = ::content::mojom::internal::SnapshotAccessibilityTreeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowParamsDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateNewWindowReplyDataView> {
  using Data = ::content::mojom::internal::CreateNewWindowReply_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::content::mojom::CreateMainFrameUnionDataView> {
  using Data = ::content::mojom::internal::CreateMainFrameUnion_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace content::mojom {


enum class ViewWidgetType : int32_t {
  
  kTopLevel = 0,
  
  kGuestView = 1,
  
  kFencedFrame = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ViewWidgetType value);
inline bool IsKnownEnumValue(ViewWidgetType value) {
  return internal::ViewWidgetType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ChildFrameOwnerElementType : int32_t {
  
  kIframe = 0,
  
  kObject = 1,
  
  kEmbed = 2,
  
  kFrame = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ChildFrameOwnerElementType value);
inline bool IsKnownEnumValue(ChildFrameOwnerElementType value) {
  return internal::ChildFrameOwnerElementType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FrameDeleteIntention : int32_t {
  
  kNotMainFrame = 0,
  
  kSpeculativeMainFrameForShutdown = 1,
  
  kSpeculativeMainFrameForNavigationCancelled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, FrameDeleteIntention value);
inline bool IsKnownEnumValue(FrameDeleteIntention value) {
  return internal::FrameDeleteIntention_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateNewWindowStatus : int32_t {
  
  kBlocked = 0,
  
  kIgnore = 1,
  
  kReuse = 2,
  
  kSuccess = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, CreateNewWindowStatus value);
inline bool IsKnownEnumValue(CreateNewWindowStatus value) {
  return internal::CreateNewWindowStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class FrameHTMLSerializerHandlerInterfaceBase {};

using FrameHTMLSerializerHandlerPtrDataView =
    mojo::InterfacePtrDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerRequestDataView =
    mojo::InterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHTMLSerializerHandlerInterfaceBase>;
using FrameHTMLSerializerHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHTMLSerializerHandlerInterfaceBase>;
class FrameInterfaceBase {};

using FramePtrDataView =
    mojo::InterfacePtrDataView<FrameInterfaceBase>;
using FrameRequestDataView =
    mojo::InterfaceRequestDataView<FrameInterfaceBase>;
using FrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameInterfaceBase>;
using FrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameInterfaceBase>;
class FrameBindingsControlInterfaceBase {};

using FrameBindingsControlPtrDataView =
    mojo::InterfacePtrDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlRequestDataView =
    mojo::InterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameBindingsControlInterfaceBase>;
using FrameBindingsControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameBindingsControlInterfaceBase>;
class NavigationRendererCancellationListenerInterfaceBase {};

using NavigationRendererCancellationListenerPtrDataView =
    mojo::InterfacePtrDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerRequestDataView =
    mojo::InterfaceRequestDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigationRendererCancellationListenerInterfaceBase>;
using NavigationRendererCancellationListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigationRendererCancellationListenerInterfaceBase>;
class FrameHostInterfaceBase {};

using FrameHostPtrDataView =
    mojo::InterfacePtrDataView<FrameHostInterfaceBase>;
using FrameHostRequestDataView =
    mojo::InterfaceRequestDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FrameHostInterfaceBase>;
using FrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FrameHostInterfaceBase>;


class CreateViewParamsDataView {
 public:
  CreateViewParamsDataView() = default;

  CreateViewParamsDataView(
      internal::CreateViewParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRendererPreferencesDataView(
      ::blink::mojom::RendererPreferencesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRendererPreferences(UserType* output) {
    
    auto* pointer = data_->renderer_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::RendererPreferencesDataView>(
        pointer, output, message_);
  }
  inline void GetWebPreferencesDataView(
      ::blink::mojom::WebPreferencesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebPreferences(UserType* output) {
    
    auto* pointer = data_->web_preferences.Get();
    return mojo::internal::Deserialize<::blink::mojom::WebPreferencesDataView>(
        pointer, output, message_);
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameDataView(
      CreateMainFrameUnionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrame(UserType* output) {
    
    auto* pointer = !data_->main_frame.is_null() ? &data_->main_frame : nullptr;
    return mojo::internal::Deserialize<::content::mojom::CreateMainFrameUnionDataView>(
        pointer, output, message_);
  }
  bool hidden() const {
    return data_->hidden;
  }
  inline void GetPrerenderParamDataView(
      ::blink::mojom::PrerenderParamDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrerenderParam(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PrerenderParamDataView, UserType>(),
    "Attempting to read the optional `prerender_param` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPrerenderParam` instead "
    "of `ReadPrerenderParam if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->prerender_param.Get();
    return mojo::internal::Deserialize<::blink::mojom::PrerenderParamDataView>(
        pointer, output, message_);
  }
  bool never_composited() const {
    return data_->never_composited;
  }
  bool window_was_opened_by_another_window() const {
    return data_->window_was_opened_by_another_window;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::content::mojom::ViewWidgetType>(
        data_value, output);
  }
  ViewWidgetType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::ViewWidgetType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFencedFrameMode(UserType* output) const {
    auto data_value = data_->fenced_frame_mode;
    return mojo::internal::Deserialize<::blink::mojom::DeprecatedFencedFrameMode>(
        data_value, output);
  }
  ::blink::mojom::DeprecatedFencedFrameMode fenced_frame_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DeprecatedFencedFrameMode>(data_->fenced_frame_mode));
  }
  inline void GetOutermostOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOutermostOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `outermost_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOutermostOrigin` instead "
    "of `ReadOutermostOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->outermost_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeBlinkPageBroadcast() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
            &data_->blink_page_broadcast, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetBaseBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseBackgroundColor(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::SkColorDataView, UserType>(),
    "Attempting to read the optional `base_background_color` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBaseBackgroundColor` instead "
    "of `ReadBaseBackgroundColor if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->base_background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  inline void GetColorProviderColorsDataView(
      ::blink::mojom::ColorProviderColorMapsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorProviderColors(UserType* output) {
    
    auto* pointer = data_->color_provider_colors.Get();
    return mojo::internal::Deserialize<::blink::mojom::ColorProviderColorMapsDataView>(
        pointer, output, message_);
  }
  inline void GetBrowsingContextGroupInfoDataView(
      ::blink::mojom::BrowsingContextGroupInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupInfo(UserType* output) {
    
    auto* pointer = data_->browsing_context_group_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionSupport(UserType* output) const {
    auto data_value = data_->attribution_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_support));
  }
  inline void GetPartitionedPopinParamsDataView(
      ::blink::mojom::PartitionedPopinParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionedPopinParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PartitionedPopinParamsDataView, UserType>(),
    "Attempting to read the optional `partitioned_popin_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitionedPopinParams` instead "
    "of `ReadPartitionedPopinParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partitioned_popin_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::PartitionedPopinParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateViewParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateLocalMainFrameParamsDataView {
 public:
  CreateLocalMainFrameParamsDataView() = default;

  CreateLocalMainFrameParamsDataView(
      internal::CreateLocalMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedRequestDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProviderRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
            &data_->associated_interface_provider_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool is_on_initial_empty_document() const {
    return data_->is_on_initial_empty_document;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerDataView, UserType>(),
    "Attempting to read the optional `policy_container` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainer` instead "
    "of `ReadPolicyContainer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetParams(UserType* output) {
    
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, message_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubresourceLoaderFactories(UserType* output) {
    
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateLocalMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateProvisionalLocalMainFrameParamsDataView {
 public:
  CreateProvisionalLocalMainFrameParamsDataView() = default;

  CreateProvisionalLocalMainFrameParamsDataView(
      internal::CreateProvisionalLocalMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocalParamsDataView(
      CreateLocalMainFrameParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocalParams(UserType* output) {
    
    auto* pointer = data_->local_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousFrameToken` instead "
    "of `ReadPreviousFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_frame_token.is_null() ? &data_->previous_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateProvisionalLocalMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateRemoteMainFrameParamsDataView {
 public:
  CreateRemoteMainFrameParamsDataView() = default;

  CreateRemoteMainFrameParamsDataView(
      internal::CreateRemoteMainFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::RemoteFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameInterfacesDataView(
      ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        pointer, output, message_);
  }
  inline void GetMainFrameInterfacesDataView(
      ::blink::mojom::RemoteMainFrameInterfacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->main_frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateRemoteMainFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateFrameWidgetParamsDataView {
 public:
  CreateFrameWidgetParamsDataView() = default;

  CreateFrameWidgetParamsDataView(
      internal::CreateFrameWidgetParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  template <typename UserType>
  UserType TakeFrameWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
            &data_->frame_widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
            &data_->frame_widget, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidgetHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
            &data_->widget_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeWidget() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::WidgetAssociatedRequestDataView>(
            &data_->widget, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetVisualPropertiesDataView(
      ::blink::mojom::VisualPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualProperties(UserType* output) {
    
    auto* pointer = data_->visual_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::VisualPropertiesDataView>(
        pointer, output, message_);
  }
  bool reuse_compositor() const {
    return data_->reuse_compositor;
  }
 private:
  internal::CreateFrameWidgetParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateFrameParamsDataView {
 public:
  CreateFrameParamsDataView() = default;

  CreateFrameParamsDataView(
      internal::CreateFrameParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameToken(UserType* output) {
    
    auto* pointer = data_->frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t routing_id() const {
    return data_->routing_id;
  }
  inline void GetPreviousFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousFrameToken` instead "
    "of `ReadPreviousFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_frame_token.is_null() ? &data_->previous_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetParentFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParentFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `parent_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadParentFrameToken` instead "
    "of `ReadParentFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->parent_frame_token.is_null() ? &data_->parent_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPreviousSiblingFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreviousSiblingFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `previous_sibling_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPreviousSiblingFrameToken` instead "
    "of `ReadPreviousSiblingFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->previous_sibling_frame_token.is_null() ? &data_->previous_sibling_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTreeScopeType(UserType* output) const {
    auto data_value = data_->tree_scope_type;
    return mojo::internal::Deserialize<::blink::mojom::TreeScopeType>(
        data_value, output);
  }
  ::blink::mojom::TreeScopeType tree_scope_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TreeScopeType>(data_->tree_scope_type));
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOwnerPropertiesDataView(
      ::blink::mojom::FrameOwnerPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOwnerProperties(UserType* output) {
    
    auto* pointer = data_->frame_owner_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        pointer, output, message_);
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::CreateFrameWidgetParamsDataView, UserType>(),
    "Attempting to read the optional `widget_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWidgetParams` instead "
    "of `ReadWidgetParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, message_);
  }
  bool is_on_initial_empty_document() const {
    return data_->is_on_initial_empty_document;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PolicyContainerDataView, UserType>(),
    "Attempting to read the optional `policy_container` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPolicyContainer` instead "
    "of `ReadPolicyContainer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedRequestDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProviderRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
            &data_->associated_interface_provider_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool is_for_nested_main_frame() const {
    return data_->is_for_nested_main_frame;
  }
 private:
  internal::CreateFrameParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SnapshotAccessibilityTreeParamsDataView {
 public:
  SnapshotAccessibilityTreeParamsDataView() = default;

  SnapshotAccessibilityTreeParamsDataView(
      internal::SnapshotAccessibilityTreeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t ax_mode() const {
    return data_->ax_mode;
  }
  uint64_t max_nodes() const {
    return data_->max_nodes;
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::SnapshotAccessibilityTreeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateNewWindowParamsDataView {
 public:
  CreateNewWindowParamsDataView() = default;

  CreateNewWindowParamsDataView(
      internal::CreateNewWindowParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool allow_popup() const {
    return data_->allow_popup;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWindowContainerType(UserType* output) const {
    auto data_value = data_->window_container_type;
    return mojo::internal::Deserialize<::content::mojom::WindowContainerType>(
        data_value, output);
  }
  ::content::mojom::WindowContainerType window_container_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content::mojom::WindowContainerType>(data_->window_container_type));
  }
  inline void GetSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCloneFromSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCloneFromSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->clone_from_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFrameNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameName(UserType* output) {
    
    auto* pointer = data_->frame_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool opener_suppressed() const {
    return data_->opener_suppressed;
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  inline void GetFormSubmissionPostDataDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormSubmissionPostData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `form_submission_post_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFormSubmissionPostData` instead "
    "of `ReadFormSubmissionPostData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->form_submission_post_data.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetFormSubmissionPostContentTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormSubmissionPostContentType(UserType* output) {
    
    auto* pointer = data_->form_submission_post_content_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }
  ::ui::mojom::WindowOpenDisposition disposition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition));
  }
  inline void GetTargetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetUrl(UserType* output) {
    
    auto* pointer = data_->target_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  inline void GetFeaturesDataView(
      ::blink::mojom::WindowFeaturesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFeatures(UserType* output) {
    
    auto* pointer = data_->features.Get();
    return mojo::internal::Deserialize<::blink::mojom::WindowFeaturesDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetPipOptionsDataView(
      ::blink::mojom::PictureInPictureWindowOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPipOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PictureInPictureWindowOptionsDataView, UserType>(),
    "Attempting to read the optional `pip_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPipOptions` instead "
    "of `ReadPipOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pip_options.Get();
    return mojo::internal::Deserialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
 private:
  internal::CreateNewWindowParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateNewWindowReplyDataView {
 public:
  CreateNewWindowReplyDataView() = default;

  CreateNewWindowReplyDataView(
      internal::CreateNewWindowReply_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMainFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMainFrameToken(UserType* output) {
    
    auto* pointer = data_->main_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  int32_t main_frame_route_id() const {
    return data_->main_frame_route_id;
  }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::content::mojom::FrameAssociatedRequestDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetWidgetParamsDataView(
      CreateFrameWidgetParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidgetParams(UserType* output) {
    
    auto* pointer = data_->widget_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakePageBroadcast() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
            &data_->page_broadcast, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMainFrameInterfaceBroker() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
            &data_->main_frame_interface_broker, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeAssociatedInterfaceProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
            &data_->associated_interface_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetClonedSessionStorageNamespaceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClonedSessionStorageNamespaceId(UserType* output) {
    
    auto* pointer = data_->cloned_session_storage_namespace_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsMainFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsMainFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_main_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool wait_for_debugger() const {
    return data_->wait_for_debugger;
  }
  inline void GetDocumentTokenDataView(
      ::blink::mojom::DocumentTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentToken(UserType* output) {
    
    auto* pointer = data_->document_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::DocumentTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyContainerDataView(
      ::blink::mojom::PolicyContainerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyContainer(UserType* output) {
    
    auto* pointer = data_->policy_container.Get();
    return mojo::internal::Deserialize<::blink::mojom::PolicyContainerDataView>(
        pointer, output, message_);
  }
  inline void GetBrowsingContextGroupInfoDataView(
      ::blink::mojom::BrowsingContextGroupInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrowsingContextGroupInfo(UserType* output) {
    
    auto* pointer = data_->browsing_context_group_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        pointer, output, message_);
  }
  inline void GetColorProviderColorsDataView(
      ::blink::mojom::ColorProviderColorMapsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorProviderColors(UserType* output) {
    
    auto* pointer = data_->color_provider_colors.Get();
    return mojo::internal::Deserialize<::blink::mojom::ColorProviderColorMapsDataView>(
        pointer, output, message_);
  }
  inline void GetPartitionedPopinParamsDataView(
      ::blink::mojom::PartitionedPopinParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPartitionedPopinParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::PartitionedPopinParamsDataView, UserType>(),
    "Attempting to read the optional `partitioned_popin_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPartitionedPopinParams` instead "
    "of `ReadPartitionedPopinParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->partitioned_popin_params.Get();
    return mojo::internal::Deserialize<::blink::mojom::PartitionedPopinParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::CreateNewWindowReply_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateMainFrameUnionDataView {
 public:
  using Tag = internal::CreateMainFrameUnion_Data::CreateMainFrameUnion_Tag;

  CreateMainFrameUnionDataView() = default;

  CreateMainFrameUnionDataView(
      internal::CreateMainFrameUnion_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_local_params() const { return data_->tag == Tag::kLocalParams; }
  inline void GetLocalParamsDataView(
      CreateLocalMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadLocalParams(UserType* output) const {
    
    CHECK(is_local_params());
    return mojo::internal::Deserialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
        data_->data.f_local_params.Get(), output, message_);
  }
  bool is_provisional_local_params() const { return data_->tag == Tag::kProvisionalLocalParams; }
  inline void GetProvisionalLocalParamsDataView(
      CreateProvisionalLocalMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadProvisionalLocalParams(UserType* output) const {
    
    CHECK(is_provisional_local_params());
    return mojo::internal::Deserialize<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView>(
        data_->data.f_provisional_local_params.Get(), output, message_);
  }
  bool is_remote_params() const { return data_->tag == Tag::kRemoteParams; }
  inline void GetRemoteParamsDataView(
      CreateRemoteMainFrameParamsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadRemoteParams(UserType* output) const {
    
    CHECK(is_remote_params());
    return mojo::internal::Deserialize<::content::mojom::CreateRemoteMainFrameParamsDataView>(
        data_->data.f_remote_params.Get(), output, message_);
  }

 private:
  internal::CreateMainFrameUnion_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // content::mojom

namespace std {

template <>
struct hash<::content::mojom::ViewWidgetType>
    : public mojo::internal::EnumHashImpl<::content::mojom::ViewWidgetType> {};

template <>
struct hash<::content::mojom::ChildFrameOwnerElementType>
    : public mojo::internal::EnumHashImpl<::content::mojom::ChildFrameOwnerElementType> {};

template <>
struct hash<::content::mojom::FrameDeleteIntention>
    : public mojo::internal::EnumHashImpl<::content::mojom::FrameDeleteIntention> {};

template <>
struct hash<::content::mojom::CreateNewWindowStatus>
    : public mojo::internal::EnumHashImpl<::content::mojom::CreateNewWindowStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ViewWidgetType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::ViewWidgetType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::ViewWidgetType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::ChildFrameOwnerElementType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::ChildFrameOwnerElementType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::ChildFrameOwnerElementType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::FrameDeleteIntention, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::FrameDeleteIntention, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::FrameDeleteIntention>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::content::mojom::CreateNewWindowStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::content::mojom::CreateNewWindowStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateViewParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateViewParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::renderer_preferences(input)) in_renderer_preferences = Traits::renderer_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->renderer_preferences)::BaseType> renderer_preferences_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RendererPreferencesDataView>(
        in_renderer_preferences, renderer_preferences_fragment);
    fragment->renderer_preferences.Set(
        renderer_preferences_fragment.is_null() ? nullptr : renderer_preferences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->renderer_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_preferences in CreateViewParams struct");
    decltype(Traits::web_preferences(input)) in_web_preferences = Traits::web_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_preferences)::BaseType> web_preferences_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::WebPreferencesDataView>(
        in_web_preferences, web_preferences_fragment);
    fragment->web_preferences.Set(
        web_preferences_fragment.is_null() ? nullptr : web_preferences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->web_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_preferences in CreateViewParams struct");
    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_storage_namespace_id)::BaseType> session_storage_namespace_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_session_storage_namespace_id, session_storage_namespace_id_fragment);
    fragment->session_storage_namespace_id.Set(
        session_storage_namespace_id_fragment.is_null() ? nullptr : session_storage_namespace_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_storage_namespace_id in CreateViewParams struct");
    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->opener_frame_token)>
        opener_frame_token_fragment(fragment.message());
    opener_frame_token_fragment.Claim(&fragment->opener_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_opener_frame_token, opener_frame_token_fragment, true);
    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replication_state)::BaseType> replication_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
        in_replication_state, replication_state_fragment);
    fragment->replication_state.Set(
        replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replication_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replication_state in CreateViewParams struct");
    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_main_frame_token)::BaseType> devtools_main_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_main_frame_token, devtools_main_frame_token_fragment);
    fragment->devtools_main_frame_token.Set(
        devtools_main_frame_token_fragment.is_null() ? nullptr : devtools_main_frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->devtools_main_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_main_frame_token in CreateViewParams struct");
    decltype(Traits::main_frame(input)) in_main_frame = Traits::main_frame(input);
    mojo::internal::MessageFragment<decltype(fragment->main_frame)>
        main_frame_fragment(fragment.message());
    main_frame_fragment.Claim(&fragment->main_frame);
    mojo::internal::Serialize<::content::mojom::CreateMainFrameUnionDataView>(
        in_main_frame, main_frame_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->main_frame.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame in CreateViewParams struct");
    fragment->hidden = Traits::hidden(input);
    decltype(Traits::prerender_param(input)) in_prerender_param = Traits::prerender_param(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prerender_param)::BaseType> prerender_param_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PrerenderParamDataView>(
        in_prerender_param, prerender_param_fragment);
    fragment->prerender_param.Set(
        prerender_param_fragment.is_null() ? nullptr : prerender_param_fragment.data());
    fragment->never_composited = Traits::never_composited(input);
    fragment->window_was_opened_by_another_window = Traits::window_was_opened_by_another_window(input);
    mojo::internal::Serialize<::content::mojom::ViewWidgetType>(
        Traits::type(input), &fragment->type);
    mojo::internal::Serialize<::blink::mojom::DeprecatedFencedFrameMode>(
        Traits::fenced_frame_mode(input), &fragment->fenced_frame_mode);
    decltype(Traits::outermost_origin(input)) in_outermost_origin = Traits::outermost_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outermost_origin)::BaseType> outermost_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_outermost_origin, outermost_origin_fragment);
    fragment->outermost_origin.Set(
        outermost_origin_fragment.is_null() ? nullptr : outermost_origin_fragment.data());
    decltype(Traits::blink_page_broadcast(input)) in_blink_page_broadcast = Traits::blink_page_broadcast(input);
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
        in_blink_page_broadcast, &fragment->blink_page_broadcast, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->blink_page_broadcast),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid blink_page_broadcast in CreateViewParams struct");
    decltype(Traits::base_background_color(input)) in_base_background_color = Traits::base_background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_background_color)::BaseType> base_background_color_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
        in_base_background_color, base_background_color_fragment);
    fragment->base_background_color.Set(
        base_background_color_fragment.is_null() ? nullptr : base_background_color_fragment.data());
    decltype(Traits::color_provider_colors(input)) in_color_provider_colors = Traits::color_provider_colors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_provider_colors)::BaseType> color_provider_colors_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ColorProviderColorMapsDataView>(
        in_color_provider_colors, color_provider_colors_fragment);
    fragment->color_provider_colors.Set(
        color_provider_colors_fragment.is_null() ? nullptr : color_provider_colors_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_provider_colors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_provider_colors in CreateViewParams struct");
    decltype(Traits::browsing_context_group_info(input)) in_browsing_context_group_info = Traits::browsing_context_group_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_info)::BaseType> browsing_context_group_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        in_browsing_context_group_info, browsing_context_group_info_fragment);
    fragment->browsing_context_group_info.Set(
        browsing_context_group_info_fragment.is_null() ? nullptr : browsing_context_group_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->browsing_context_group_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null browsing_context_group_info in CreateViewParams struct");
    mojo::internal::Serialize<::network::mojom::AttributionSupport>(
        Traits::attribution_support(input), &fragment->attribution_support);
    decltype(Traits::partitioned_popin_params(input)) in_partitioned_popin_params = Traits::partitioned_popin_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partitioned_popin_params)::BaseType> partitioned_popin_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PartitionedPopinParamsDataView>(
        in_partitioned_popin_params, partitioned_popin_params_fragment);
    fragment->partitioned_popin_params.Set(
        partitioned_popin_params_fragment.is_null() ? nullptr : partitioned_popin_params_fragment.data());
  }

  static bool Deserialize(::content::mojom::internal::CreateViewParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateViewParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateLocalMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateLocalMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateLocalMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_token)::BaseType> frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_frame_token, frame_token_fragment);
    fragment->frame_token.Set(
        frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_token in CreateLocalMainFrameParams struct");
    fragment->routing_id = Traits::routing_id(input);
    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::Serialize<::content::mojom::FrameAssociatedRequestDataView>(
        in_frame, &fragment->frame, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame in CreateLocalMainFrameParams struct");
    decltype(Traits::interface_broker(input)) in_interface_broker = Traits::interface_broker(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
        in_interface_broker, &fragment->interface_broker, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->interface_broker),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid interface_broker in CreateLocalMainFrameParams struct");
    decltype(Traits::associated_interface_provider_remote(input)) in_associated_interface_provider_remote = Traits::associated_interface_provider_remote(input);
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
        in_associated_interface_provider_remote, &fragment->associated_interface_provider_remote, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider_remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid associated_interface_provider_remote in CreateLocalMainFrameParams struct");
    fragment->is_on_initial_empty_document = Traits::is_on_initial_empty_document(input);
    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
        in_document_token, document_token_fragment);
    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->document_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_token in CreateLocalMainFrameParams struct");
    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
        in_policy_container, policy_container_fragment);
    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());
    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_params)::BaseType> widget_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        in_widget_params, widget_params_fragment);
    fragment->widget_params.Set(
        widget_params_fragment.is_null() ? nullptr : widget_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->widget_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_params in CreateLocalMainFrameParams struct");
    decltype(Traits::subresource_loader_factories(input)) in_subresource_loader_factories = Traits::subresource_loader_factories(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subresource_loader_factories)::BaseType> subresource_loader_factories_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        in_subresource_loader_factories, subresource_loader_factories_fragment);
    fragment->subresource_loader_factories.Set(
        subresource_loader_factories_fragment.is_null() ? nullptr : subresource_loader_factories_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->subresource_loader_factories.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subresource_loader_factories in CreateLocalMainFrameParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateLocalMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateLocalMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::local_params(input)) in_local_params = Traits::local_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->local_params)::BaseType> local_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
        in_local_params, local_params_fragment);
    fragment->local_params.Set(
        local_params_fragment.is_null() ? nullptr : local_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->local_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null local_params in CreateProvisionalLocalMainFrameParams struct");
    decltype(Traits::previous_frame_token(input)) in_previous_frame_token = Traits::previous_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_frame_token)>
        previous_frame_token_fragment(fragment.message());
    previous_frame_token_fragment.Claim(&fragment->previous_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_previous_frame_token, previous_frame_token_fragment, true);
  }

  static bool Deserialize(::content::mojom::internal::CreateProvisionalLocalMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateProvisionalLocalMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateRemoteMainFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateRemoteMainFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateRemoteMainFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in CreateRemoteMainFrameParams struct");
    decltype(Traits::frame_interfaces(input)) in_frame_interfaces = Traits::frame_interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interfaces)::BaseType> frame_interfaces_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        in_frame_interfaces, frame_interfaces_fragment);
    fragment->frame_interfaces.Set(
        frame_interfaces_fragment.is_null() ? nullptr : frame_interfaces_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_interfaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_interfaces in CreateRemoteMainFrameParams struct");
    decltype(Traits::main_frame_interfaces(input)) in_main_frame_interfaces = Traits::main_frame_interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_interfaces)::BaseType> main_frame_interfaces_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RemoteMainFrameInterfacesDataView>(
        in_main_frame_interfaces, main_frame_interfaces_fragment);
    fragment->main_frame_interfaces.Set(
        main_frame_interfaces_fragment.is_null() ? nullptr : main_frame_interfaces_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->main_frame_interfaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_interfaces in CreateRemoteMainFrameParams struct");
  }

  static bool Deserialize(::content::mojom::internal::CreateRemoteMainFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateRemoteMainFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameWidgetParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameWidgetParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateFrameWidgetParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->routing_id = Traits::routing_id(input);
    decltype(Traits::frame_widget_host(input)) in_frame_widget_host = Traits::frame_widget_host(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetHostAssociatedPtrInfoDataView>(
        in_frame_widget_host, &fragment->frame_widget_host, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget_host in CreateFrameWidgetParams struct");
    decltype(Traits::frame_widget(input)) in_frame_widget = Traits::frame_widget(input);
    mojo::internal::Serialize<::blink::mojom::FrameWidgetAssociatedRequestDataView>(
        in_frame_widget, &fragment->frame_widget, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame_widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_widget in CreateFrameWidgetParams struct");
    decltype(Traits::widget_host(input)) in_widget_host = Traits::widget_host(input);
    mojo::internal::Serialize<::blink::mojom::WidgetHostAssociatedPtrInfoDataView>(
        in_widget_host, &fragment->widget_host, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->widget_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget_host in CreateFrameWidgetParams struct");
    decltype(Traits::widget(input)) in_widget = Traits::widget(input);
    mojo::internal::Serialize<::blink::mojom::WidgetAssociatedRequestDataView>(
        in_widget, &fragment->widget, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->widget),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid widget in CreateFrameWidgetParams struct");
    decltype(Traits::visual_properties(input)) in_visual_properties = Traits::visual_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visual_properties)::BaseType> visual_properties_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
        in_visual_properties, visual_properties_fragment);
    fragment->visual_properties.Set(
        visual_properties_fragment.is_null() ? nullptr : visual_properties_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visual_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_properties in CreateFrameWidgetParams struct");
    fragment->reuse_compositor = Traits::reuse_compositor(input);
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameWidgetParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameWidgetParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateFrameParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateFrameParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateFrameParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_token(input)) in_frame_token = Traits::frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_token)::BaseType> frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_frame_token, frame_token_fragment);
    fragment->frame_token.Set(
        frame_token_fragment.is_null() ? nullptr : frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_token in CreateFrameParams struct");
    fragment->routing_id = Traits::routing_id(input);
    decltype(Traits::previous_frame_token(input)) in_previous_frame_token = Traits::previous_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_frame_token)>
        previous_frame_token_fragment(fragment.message());
    previous_frame_token_fragment.Claim(&fragment->previous_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_previous_frame_token, previous_frame_token_fragment, true);
    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->opener_frame_token)>
        opener_frame_token_fragment(fragment.message());
    opener_frame_token_fragment.Claim(&fragment->opener_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_opener_frame_token, opener_frame_token_fragment, true);
    decltype(Traits::parent_frame_token(input)) in_parent_frame_token = Traits::parent_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->parent_frame_token)>
        parent_frame_token_fragment(fragment.message());
    parent_frame_token_fragment.Claim(&fragment->parent_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_parent_frame_token, parent_frame_token_fragment, true);
    decltype(Traits::previous_sibling_frame_token(input)) in_previous_sibling_frame_token = Traits::previous_sibling_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->previous_sibling_frame_token)>
        previous_sibling_frame_token_fragment(fragment.message());
    previous_sibling_frame_token_fragment.Claim(&fragment->previous_sibling_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_previous_sibling_frame_token, previous_sibling_frame_token_fragment, true);
    decltype(Traits::interface_broker(input)) in_interface_broker = Traits::interface_broker(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
        in_interface_broker, &fragment->interface_broker, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->interface_broker),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid interface_broker in CreateFrameParams struct");
    mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
        Traits::tree_scope_type(input), &fragment->tree_scope_type);
    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replication_state)::BaseType> replication_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
        in_replication_state, replication_state_fragment);
    fragment->replication_state.Set(
        replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replication_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replication_state in CreateFrameParams struct");
    decltype(Traits::devtools_frame_token(input)) in_devtools_frame_token = Traits::devtools_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_frame_token, devtools_frame_token_fragment);
    fragment->devtools_frame_token.Set(
        devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->devtools_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_frame_token in CreateFrameParams struct");
    decltype(Traits::frame_owner_properties(input)) in_frame_owner_properties = Traits::frame_owner_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_owner_properties)::BaseType> frame_owner_properties_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        in_frame_owner_properties, frame_owner_properties_fragment);
    fragment->frame_owner_properties.Set(
        frame_owner_properties_fragment.is_null() ? nullptr : frame_owner_properties_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_owner_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_owner_properties in CreateFrameParams struct");
    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_params)::BaseType> widget_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        in_widget_params, widget_params_fragment);
    fragment->widget_params.Set(
        widget_params_fragment.is_null() ? nullptr : widget_params_fragment.data());
    fragment->is_on_initial_empty_document = Traits::is_on_initial_empty_document(input);
    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
        in_document_token, document_token_fragment);
    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->document_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_token in CreateFrameParams struct");
    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
        in_policy_container, policy_container_fragment);
    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());
    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::Serialize<::content::mojom::FrameAssociatedRequestDataView>(
        in_frame, &fragment->frame, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame in CreateFrameParams struct");
    decltype(Traits::associated_interface_provider_remote(input)) in_associated_interface_provider_remote = Traits::associated_interface_provider_remote(input);
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
        in_associated_interface_provider_remote, &fragment->associated_interface_provider_remote, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider_remote),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid associated_interface_provider_remote in CreateFrameParams struct");
    fragment->is_for_nested_main_frame = Traits::is_for_nested_main_frame(input);
  }

  static bool Deserialize(::content::mojom::internal::CreateFrameParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateFrameParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::SnapshotAccessibilityTreeParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::SnapshotAccessibilityTreeParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::SnapshotAccessibilityTreeParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->ax_mode = Traits::ax_mode(input);
    fragment->max_nodes = Traits::max_nodes(input);
    decltype(Traits::timeout(input)) in_timeout = Traits::timeout(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout)::BaseType> timeout_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timeout, timeout_fragment);
    fragment->timeout.Set(
        timeout_fragment.is_null() ? nullptr : timeout_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timeout.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timeout in SnapshotAccessibilityTreeParams struct");
  }

  static bool Deserialize(::content::mojom::internal::SnapshotAccessibilityTreeParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::SnapshotAccessibilityTreeParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateNewWindowParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allow_popup = Traits::allow_popup(input);
    mojo::internal::Serialize<::content::mojom::WindowContainerType>(
        Traits::window_container_type(input), &fragment->window_container_type);
    decltype(Traits::session_storage_namespace_id(input)) in_session_storage_namespace_id = Traits::session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_storage_namespace_id)::BaseType> session_storage_namespace_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_session_storage_namespace_id, session_storage_namespace_id_fragment);
    fragment->session_storage_namespace_id.Set(
        session_storage_namespace_id_fragment.is_null() ? nullptr : session_storage_namespace_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_storage_namespace_id in CreateNewWindowParams struct");
    decltype(Traits::clone_from_session_storage_namespace_id(input)) in_clone_from_session_storage_namespace_id = Traits::clone_from_session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->clone_from_session_storage_namespace_id)::BaseType> clone_from_session_storage_namespace_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_clone_from_session_storage_namespace_id, clone_from_session_storage_namespace_id_fragment);
    fragment->clone_from_session_storage_namespace_id.Set(
        clone_from_session_storage_namespace_id_fragment.is_null() ? nullptr : clone_from_session_storage_namespace_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->clone_from_session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clone_from_session_storage_namespace_id in CreateNewWindowParams struct");
    decltype(Traits::frame_name(input)) in_frame_name = Traits::frame_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_name)::BaseType> frame_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_frame_name, frame_name_fragment);
    fragment->frame_name.Set(
        frame_name_fragment.is_null() ? nullptr : frame_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_name in CreateNewWindowParams struct");
    fragment->opener_suppressed = Traits::opener_suppressed(input);
    fragment->is_form_submission = Traits::is_form_submission(input);
    decltype(Traits::form_submission_post_data(input)) in_form_submission_post_data = Traits::form_submission_post_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_submission_post_data)::BaseType> form_submission_post_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_form_submission_post_data, form_submission_post_data_fragment);
    fragment->form_submission_post_data.Set(
        form_submission_post_data_fragment.is_null() ? nullptr : form_submission_post_data_fragment.data());
    decltype(Traits::form_submission_post_content_type(input)) in_form_submission_post_content_type = Traits::form_submission_post_content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->form_submission_post_content_type)::BaseType> form_submission_post_content_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_form_submission_post_content_type, form_submission_post_content_type_fragment);
    fragment->form_submission_post_content_type.Set(
        form_submission_post_content_type_fragment.is_null() ? nullptr : form_submission_post_content_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->form_submission_post_content_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null form_submission_post_content_type in CreateNewWindowParams struct");
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
        Traits::disposition(input), &fragment->disposition);
    decltype(Traits::target_url(input)) in_target_url = Traits::target_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_url)::BaseType> target_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_target_url, target_url_fragment);
    fragment->target_url.Set(
        target_url_fragment.is_null() ? nullptr : target_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->target_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target_url in CreateNewWindowParams struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in CreateNewWindowParams struct");
    decltype(Traits::features(input)) in_features = Traits::features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->features)::BaseType> features_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::WindowFeaturesDataView>(
        in_features, features_fragment);
    fragment->features.Set(
        features_fragment.is_null() ? nullptr : features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null features in CreateNewWindowParams struct");
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->impression)::BaseType> impression_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
        in_impression, impression_fragment);
    fragment->impression.Set(
        impression_fragment.is_null() ? nullptr : impression_fragment.data());
    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->download_policy)::BaseType> download_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        in_download_policy, download_policy_fragment);
    fragment->download_policy.Set(
        download_policy_fragment.is_null() ? nullptr : download_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->download_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null download_policy in CreateNewWindowParams struct");
    decltype(Traits::pip_options(input)) in_pip_options = Traits::pip_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pip_options)::BaseType> pip_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PictureInPictureWindowOptionsDataView>(
        in_pip_options, pip_options_fragment);
    fragment->pip_options.Set(
        pip_options_fragment.is_null() ? nullptr : pip_options_fragment.data());
    mojo::internal::Serialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        Traits::initiator_activation_and_ad_status(input), &fragment->initiator_activation_and_ad_status);
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateNewWindowReplyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content::mojom::CreateNewWindowReplyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content::mojom::internal::CreateNewWindowReply_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::main_frame_token(input)) in_main_frame_token = Traits::main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_frame_token)::BaseType> main_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_main_frame_token, main_frame_token_fragment);
    fragment->main_frame_token.Set(
        main_frame_token_fragment.is_null() ? nullptr : main_frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->main_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null main_frame_token in CreateNewWindowReply struct");
    fragment->main_frame_route_id = Traits::main_frame_route_id(input);
    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::Serialize<::content::mojom::FrameAssociatedRequestDataView>(
        in_frame, &fragment->frame, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame in CreateNewWindowReply struct");
    decltype(Traits::widget_params(input)) in_widget_params = Traits::widget_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->widget_params)::BaseType> widget_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::content::mojom::CreateFrameWidgetParamsDataView>(
        in_widget_params, widget_params_fragment);
    fragment->widget_params.Set(
        widget_params_fragment.is_null() ? nullptr : widget_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->widget_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget_params in CreateNewWindowReply struct");
    decltype(Traits::page_broadcast(input)) in_page_broadcast = Traits::page_broadcast(input);
    mojo::internal::Serialize<::blink::mojom::PageBroadcastAssociatedRequestDataView>(
        in_page_broadcast, &fragment->page_broadcast, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->page_broadcast),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid page_broadcast in CreateNewWindowReply struct");
    decltype(Traits::main_frame_interface_broker(input)) in_main_frame_interface_broker = Traits::main_frame_interface_broker(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
        in_main_frame_interface_broker, &fragment->main_frame_interface_broker, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->main_frame_interface_broker),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid main_frame_interface_broker in CreateNewWindowReply struct");
    decltype(Traits::associated_interface_provider(input)) in_associated_interface_provider = Traits::associated_interface_provider(input);
    mojo::internal::Serialize<::blink::mojom::AssociatedInterfaceProviderAssociatedPtrInfoDataView>(
        in_associated_interface_provider, &fragment->associated_interface_provider, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->associated_interface_provider),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid associated_interface_provider in CreateNewWindowReply struct");
    decltype(Traits::cloned_session_storage_namespace_id(input)) in_cloned_session_storage_namespace_id = Traits::cloned_session_storage_namespace_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cloned_session_storage_namespace_id)::BaseType> cloned_session_storage_namespace_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cloned_session_storage_namespace_id, cloned_session_storage_namespace_id_fragment);
    fragment->cloned_session_storage_namespace_id.Set(
        cloned_session_storage_namespace_id_fragment.is_null() ? nullptr : cloned_session_storage_namespace_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cloned_session_storage_namespace_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cloned_session_storage_namespace_id in CreateNewWindowReply struct");
    decltype(Traits::devtools_main_frame_token(input)) in_devtools_main_frame_token = Traits::devtools_main_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_main_frame_token)::BaseType> devtools_main_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_main_frame_token, devtools_main_frame_token_fragment);
    fragment->devtools_main_frame_token.Set(
        devtools_main_frame_token_fragment.is_null() ? nullptr : devtools_main_frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->devtools_main_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_main_frame_token in CreateNewWindowReply struct");
    fragment->wait_for_debugger = Traits::wait_for_debugger(input);
    decltype(Traits::document_token(input)) in_document_token = Traits::document_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_token)::BaseType> document_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DocumentTokenDataView>(
        in_document_token, document_token_fragment);
    fragment->document_token.Set(
        document_token_fragment.is_null() ? nullptr : document_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->document_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_token in CreateNewWindowReply struct");
    decltype(Traits::policy_container(input)) in_policy_container = Traits::policy_container(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_container)::BaseType> policy_container_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PolicyContainerDataView>(
        in_policy_container, policy_container_fragment);
    fragment->policy_container.Set(
        policy_container_fragment.is_null() ? nullptr : policy_container_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->policy_container.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null policy_container in CreateNewWindowReply struct");
    decltype(Traits::browsing_context_group_info(input)) in_browsing_context_group_info = Traits::browsing_context_group_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->browsing_context_group_info)::BaseType> browsing_context_group_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::BrowsingContextGroupInfoDataView>(
        in_browsing_context_group_info, browsing_context_group_info_fragment);
    fragment->browsing_context_group_info.Set(
        browsing_context_group_info_fragment.is_null() ? nullptr : browsing_context_group_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->browsing_context_group_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null browsing_context_group_info in CreateNewWindowReply struct");
    decltype(Traits::color_provider_colors(input)) in_color_provider_colors = Traits::color_provider_colors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_provider_colors)::BaseType> color_provider_colors_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ColorProviderColorMapsDataView>(
        in_color_provider_colors, color_provider_colors_fragment);
    fragment->color_provider_colors.Set(
        color_provider_colors_fragment.is_null() ? nullptr : color_provider_colors_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_provider_colors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_provider_colors in CreateNewWindowReply struct");
    decltype(Traits::partitioned_popin_params(input)) in_partitioned_popin_params = Traits::partitioned_popin_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partitioned_popin_params)::BaseType> partitioned_popin_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::PartitionedPopinParamsDataView>(
        in_partitioned_popin_params, partitioned_popin_params_fragment);
    fragment->partitioned_popin_params.Set(
        partitioned_popin_params_fragment.is_null() ? nullptr : partitioned_popin_params_fragment.data());
  }

  static bool Deserialize(::content::mojom::internal::CreateNewWindowReply_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateNewWindowReplyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content::mojom::CreateMainFrameUnionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::content::mojom::CreateMainFrameUnionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::content::mojom::internal::CreateMainFrameUnion_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::content::mojom::CreateMainFrameUnionDataView::Tag::kLocalParams: {
        decltype(Traits::local_params(input))
            in_local_params = Traits::local_params(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_local_params)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::content::mojom::CreateLocalMainFrameParamsDataView>(
            in_local_params, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null local_params in CreateMainFrameUnion union");
        fragment->data.f_local_params.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::content::mojom::CreateMainFrameUnionDataView::Tag::kProvisionalLocalParams: {
        decltype(Traits::provisional_local_params(input))
            in_provisional_local_params = Traits::provisional_local_params(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_provisional_local_params)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::content::mojom::CreateProvisionalLocalMainFrameParamsDataView>(
            in_provisional_local_params, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null provisional_local_params in CreateMainFrameUnion union");
        fragment->data.f_provisional_local_params.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::content::mojom::CreateMainFrameUnionDataView::Tag::kRemoteParams: {
        decltype(Traits::remote_params(input))
            in_remote_params = Traits::remote_params(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_remote_params)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::content::mojom::CreateRemoteMainFrameParamsDataView>(
            in_remote_params, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null remote_params in CreateMainFrameUnion union");
        fragment->data.f_remote_params.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::content::mojom::internal::CreateMainFrameUnion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::content::mojom::CreateMainFrameUnionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content::mojom {

inline void CreateViewParamsDataView::GetRendererPreferencesDataView(
    ::blink::mojom::RendererPreferencesDataView* output) {
  auto pointer = data_->renderer_preferences.Get();
  *output = ::blink::mojom::RendererPreferencesDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetWebPreferencesDataView(
    ::blink::mojom::WebPreferencesDataView* output) {
  auto pointer = data_->web_preferences.Get();
  *output = ::blink::mojom::WebPreferencesDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetOpenerFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->opener_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetReplicationStateDataView(
    ::blink::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::blink::mojom::FrameReplicationStateDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetMainFrameDataView(
    CreateMainFrameUnionDataView* output) {
  auto pointer = &data_->main_frame;
  *output = CreateMainFrameUnionDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetPrerenderParamDataView(
    ::blink::mojom::PrerenderParamDataView* output) {
  auto pointer = data_->prerender_param.Get();
  *output = ::blink::mojom::PrerenderParamDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetOutermostOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->outermost_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetBaseBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->base_background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetColorProviderColorsDataView(
    ::blink::mojom::ColorProviderColorMapsDataView* output) {
  auto pointer = data_->color_provider_colors.Get();
  *output = ::blink::mojom::ColorProviderColorMapsDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetBrowsingContextGroupInfoDataView(
    ::blink::mojom::BrowsingContextGroupInfoDataView* output) {
  auto pointer = data_->browsing_context_group_info.Get();
  *output = ::blink::mojom::BrowsingContextGroupInfoDataView(pointer, message_);
}
inline void CreateViewParamsDataView::GetPartitionedPopinParamsDataView(
    ::blink::mojom::PartitionedPopinParamsDataView* output) {
  auto pointer = data_->partitioned_popin_params.Get();
  *output = ::blink::mojom::PartitionedPopinParamsDataView(pointer, message_);
}


inline void CreateLocalMainFrameParamsDataView::GetFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, message_);
}
inline void CreateLocalMainFrameParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, message_);
}


inline void CreateProvisionalLocalMainFrameParamsDataView::GetLocalParamsDataView(
    CreateLocalMainFrameParamsDataView* output) {
  auto pointer = data_->local_params.Get();
  *output = CreateLocalMainFrameParamsDataView(pointer, message_);
}
inline void CreateProvisionalLocalMainFrameParamsDataView::GetPreviousFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}


inline void CreateRemoteMainFrameParamsDataView::GetTokenDataView(
    ::blink::mojom::RemoteFrameTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::blink::mojom::RemoteFrameTokenDataView(pointer, message_);
}
inline void CreateRemoteMainFrameParamsDataView::GetFrameInterfacesDataView(
    ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView* output) {
  auto pointer = data_->frame_interfaces.Get();
  *output = ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView(pointer, message_);
}
inline void CreateRemoteMainFrameParamsDataView::GetMainFrameInterfacesDataView(
    ::blink::mojom::RemoteMainFrameInterfacesDataView* output) {
  auto pointer = data_->main_frame_interfaces.Get();
  *output = ::blink::mojom::RemoteMainFrameInterfacesDataView(pointer, message_);
}


inline void CreateFrameWidgetParamsDataView::GetVisualPropertiesDataView(
    ::blink::mojom::VisualPropertiesDataView* output) {
  auto pointer = data_->visual_properties.Get();
  *output = ::blink::mojom::VisualPropertiesDataView(pointer, message_);
}


inline void CreateFrameParamsDataView::GetFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPreviousFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetOpenerFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->opener_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetParentFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->parent_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPreviousSiblingFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->previous_sibling_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetReplicationStateDataView(
    ::blink::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::blink::mojom::FrameReplicationStateDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetDevtoolsFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetFrameOwnerPropertiesDataView(
    ::blink::mojom::FrameOwnerPropertiesDataView* output) {
  auto pointer = data_->frame_owner_properties.Get();
  *output = ::blink::mojom::FrameOwnerPropertiesDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateFrameParamsDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}


inline void SnapshotAccessibilityTreeParamsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void CreateNewWindowParamsDataView::GetSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetCloneFromSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->clone_from_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFrameNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFormSubmissionPostDataDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->form_submission_post_data.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFormSubmissionPostContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->form_submission_post_content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetTargetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetFeaturesDataView(
    ::blink::mojom::WindowFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = ::blink::mojom::WindowFeaturesDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetImpressionDataView(
    ::blink::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::blink::mojom::ImpressionDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetDownloadPolicyDataView(
    ::blink::mojom::NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = ::blink::mojom::NavigationDownloadPolicyDataView(pointer, message_);
}
inline void CreateNewWindowParamsDataView::GetPipOptionsDataView(
    ::blink::mojom::PictureInPictureWindowOptionsDataView* output) {
  auto pointer = data_->pip_options.Get();
  *output = ::blink::mojom::PictureInPictureWindowOptionsDataView(pointer, message_);
}


inline void CreateNewWindowReplyDataView::GetMainFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->main_frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetWidgetParamsDataView(
    CreateFrameWidgetParamsDataView* output) {
  auto pointer = data_->widget_params.Get();
  *output = CreateFrameWidgetParamsDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetClonedSessionStorageNamespaceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cloned_session_storage_namespace_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetDevtoolsMainFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_main_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetDocumentTokenDataView(
    ::blink::mojom::DocumentTokenDataView* output) {
  auto pointer = data_->document_token.Get();
  *output = ::blink::mojom::DocumentTokenDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetPolicyContainerDataView(
    ::blink::mojom::PolicyContainerDataView* output) {
  auto pointer = data_->policy_container.Get();
  *output = ::blink::mojom::PolicyContainerDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetBrowsingContextGroupInfoDataView(
    ::blink::mojom::BrowsingContextGroupInfoDataView* output) {
  auto pointer = data_->browsing_context_group_info.Get();
  *output = ::blink::mojom::BrowsingContextGroupInfoDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetColorProviderColorsDataView(
    ::blink::mojom::ColorProviderColorMapsDataView* output) {
  auto pointer = data_->color_provider_colors.Get();
  *output = ::blink::mojom::ColorProviderColorMapsDataView(pointer, message_);
}
inline void CreateNewWindowReplyDataView::GetPartitionedPopinParamsDataView(
    ::blink::mojom::PartitionedPopinParamsDataView* output) {
  auto pointer = data_->partitioned_popin_params.Get();
  *output = ::blink::mojom::PartitionedPopinParamsDataView(pointer, message_);
}


inline void CreateMainFrameUnionDataView::GetLocalParamsDataView(
    CreateLocalMainFrameParamsDataView* output) const {
  CHECK(is_local_params());
  *output = CreateLocalMainFrameParamsDataView(data_->data.f_local_params.Get(), message_);
}
inline void CreateMainFrameUnionDataView::GetProvisionalLocalParamsDataView(
    CreateProvisionalLocalMainFrameParamsDataView* output) const {
  CHECK(is_provisional_local_params());
  *output = CreateProvisionalLocalMainFrameParamsDataView(data_->data.f_provisional_local_params.Get(), message_);
}
inline void CreateMainFrameUnionDataView::GetRemoteParamsDataView(
    CreateRemoteMainFrameParamsDataView* output) const {
  CHECK(is_remote_params());
  *output = CreateRemoteMainFrameParamsDataView(data_->data.f_remote_params.Get(), message_);
}


}  // content::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::ViewWidgetType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::ViewWidgetType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::ChildFrameOwnerElementType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::ChildFrameOwnerElementType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::FrameDeleteIntention> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::FrameDeleteIntention value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::content::mojom::CreateNewWindowStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::content::mojom::CreateNewWindowStatus value);
};

} // namespace perfetto

#endif  // CONTENT_COMMON_FRAME_MOJOM_SHARED_H_