// This file was generated by qtwaylandscanner
// source file is xwayland-shell-v1.xml

#ifndef QT_WAYLAND_SERVER_XWAYLAND_SHELL_V1
#define QT_WAYLAND_SERVER_XWAYLAND_SHELL_V1

#include "wayland-server-core.h"
#include "wayland-xwayland-shell-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  xwayland_shell_v1
    {
    public:
        xwayland_shell_v1(struct ::wl_client *client, int id, int version);
        xwayland_shell_v1(struct ::wl_display *display, int version);
        xwayland_shell_v1(struct ::wl_resource *resource);
        xwayland_shell_v1();

        virtual ~xwayland_shell_v1();

        class Resource
        {
        public:
            Resource() : xwayland_shell_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            xwayland_shell_v1 *xwayland_shell_v1_object;
            xwayland_shell_v1 *object() { return xwayland_shell_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_role = 0, // given wl_surface has another role
        };

    protected:
        virtual Resource *xwayland_shell_v1_allocate();

        virtual void xwayland_shell_v1_destroy_global();

        virtual void xwayland_shell_v1_bind_resource(Resource *resource);
        virtual void xwayland_shell_v1_destroy_resource(Resource *resource);

        virtual void xwayland_shell_v1_destroy(Resource *resource);
        virtual void xwayland_shell_v1_get_xwayland_surface(Resource *resource, uint32_t id, struct ::wl_resource *surface);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::xwayland_shell_v1_interface m_xwayland_shell_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_xwayland_surface(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            xwayland_shell_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  xwayland_surface_v1
    {
    public:
        xwayland_surface_v1(struct ::wl_client *client, int id, int version);
        xwayland_surface_v1(struct ::wl_display *display, int version);
        xwayland_surface_v1(struct ::wl_resource *resource);
        xwayland_surface_v1();

        virtual ~xwayland_surface_v1();

        class Resource
        {
        public:
            Resource() : xwayland_surface_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            xwayland_surface_v1 *xwayland_surface_v1_object;
            xwayland_surface_v1 *object() { return xwayland_surface_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_already_associated = 0, // given wl_surface is already associated with an X11 window
            error_invalid_serial = 1, // serial was not valid
        };

    protected:
        virtual Resource *xwayland_surface_v1_allocate();

        virtual void xwayland_surface_v1_destroy_global();

        virtual void xwayland_surface_v1_bind_resource(Resource *resource);
        virtual void xwayland_surface_v1_destroy_resource(Resource *resource);

        virtual void xwayland_surface_v1_set_serial(Resource *resource, uint32_t serial_lo, uint32_t serial_hi);
        virtual void xwayland_surface_v1_destroy(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::xwayland_surface_v1_interface m_xwayland_surface_v1_interface;

        static void handle_set_serial(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t serial_lo,
            uint32_t serial_hi);
        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            xwayland_surface_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
