// This file is generated by kconfig_compiler_kf6 from ktouch.kcfg.
// All changes you do to this file will be lost.
#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Preferences : public KConfigSkeleton
{
  public:

    static Preferences *self();
    ~Preferences() override;

    /**
      Set The keyboard layout to use on non-X11 platforms
    */
    static
    void setKeyboardLayoutName( const QString & v )
    {
      if (!self()->isKeyboardLayoutNameImmutable())
        self()->mKeyboardLayoutName = v;
    }

    /**
      Get The keyboard layout to use on non-X11 platforms
    */
    static
    QString keyboardLayoutName()
    {
      return self()->mKeyboardLayoutName;
    }

    /**
      Is The keyboard layout to use on non-X11 platforms Immutable
    */
    static
    bool isKeyboardLayoutNameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "KeyboardLayoutName" ) );
    }

    /**
      Set Controls whether typing errors have to be corrected or not.
    */
    static
    void setEnforceTypingErrorCorrection( bool v )
    {
      if (!self()->isEnforceTypingErrorCorrectionImmutable())
        self()->mEnforceTypingErrorCorrection = v;
    }

    /**
      Get Controls whether typing errors have to be corrected or not.
    */
    static
    bool enforceTypingErrorCorrection()
    {
      return self()->mEnforceTypingErrorCorrection;
    }

    /**
      Is Controls whether typing errors have to be corrected or not. Immutable
    */
    static
    bool isEnforceTypingErrorCorrectionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "EnforceTypingErrorCorrection" ) );
    }

    /**
      Set Controls the visibility of the keyboard during training.
    */
    static
    void setShowKeyboard( bool v )
    {
      if (!self()->isShowKeyboardImmutable())
        self()->mShowKeyboard = v;
    }

    /**
      Get Controls the visibility of the keyboard during training.
    */
    static
    bool showKeyboard()
    {
      return self()->mShowKeyboard;
    }

    /**
      Is Controls the visibility of the keyboard during training. Immutable
    */
    static
    bool isShowKeyboardImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowKeyboard" ) );
    }

    /**
      Set Controls the visibility of realtime statistics during training.
    */
    static
    void setShowStatistics( bool v )
    {
      if (!self()->isShowStatisticsImmutable())
        self()->mShowStatistics = v;
    }

    /**
      Get Controls the visibility of realtime statistics during training.
    */
    static
    bool showStatistics()
    {
      return self()->mShowStatistics;
    }

    /**
      Is Controls the visibility of realtime statistics during training. Immutable
    */
    static
    bool isShowStatisticsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowStatistics" ) );
    }

    /**
      Set Return key at the end of a line will switch to next line.
    */
    static
    void setNextLineWithReturn( bool v )
    {
      if (!self()->isNextLineWithReturnImmutable())
        self()->mNextLineWithReturn = v;
    }

    /**
      Get Return key at the end of a line will switch to next line.
    */
    static
    bool nextLineWithReturn()
    {
      return self()->mNextLineWithReturn;
    }

    /**
      Is Return key at the end of a line will switch to next line. Immutable
    */
    static
    bool isNextLineWithReturnImmutable()
    {
      return self()->isImmutable( QStringLiteral( "NextLineWithReturn" ) );
    }

    /**
      Set Space key at the end of a line will switch to next line.
    */
    static
    void setNextLineWithSpace( bool v )
    {
      if (!self()->isNextLineWithSpaceImmutable())
        self()->mNextLineWithSpace = v;
    }

    /**
      Get Space key at the end of a line will switch to next line.
    */
    static
    bool nextLineWithSpace()
    {
      return self()->mNextLineWithSpace;
    }

    /**
      Is Space key at the end of a line will switch to next line. Immutable
    */
    static
    bool isNextLineWithSpaceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "NextLineWithSpace" ) );
    }

    /**
      Set The minimum required amount of strokes per minute to unlock the next lesson.
    */
    static
    void setRequiredStrokesPerMinute( int v )
    {
      if (v < 0)
      {
        qDebug() << "setRequiredStrokesPerMinute: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 360)
      {
        qDebug() << "setRequiredStrokesPerMinute: value " << v << " is greater than the maximum value of 360";
        v = 360;
      }

      if (!self()->isRequiredStrokesPerMinuteImmutable())
        self()->mRequiredStrokesPerMinute = v;
    }

    /**
      Get The minimum required amount of strokes per minute to unlock the next lesson.
    */
    static
    int requiredStrokesPerMinute()
    {
      return self()->mRequiredStrokesPerMinute;
    }

    /**
      Is The minimum required amount of strokes per minute to unlock the next lesson. Immutable
    */
    static
    bool isRequiredStrokesPerMinuteImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RequiredStrokesPerMinute" ) );
    }

    /**
      Set The minimum required typing accuracy in percent to unlock the next lesson.
    */
    static
    void setRequiredAccuracy( double v )
    {
      if (v < 90)
      {
        qDebug() << "setRequiredAccuracy: value " << v << " is less than the minimum value of 90";
        v = 90;
      }

      if (v > 100)
      {
        qDebug() << "setRequiredAccuracy: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!self()->isRequiredAccuracyImmutable())
        self()->mRequiredAccuracy = v;
    }

    /**
      Get The minimum required typing accuracy in percent to unlock the next lesson.
    */
    static
    double requiredAccuracy()
    {
      return self()->mRequiredAccuracy;
    }

    /**
      Is The minimum required typing accuracy in percent to unlock the next lesson. Immutable
    */
    static
    bool isRequiredAccuracyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "RequiredAccuracy" ) );
    }

    /**
      Set The keyboard tinting color to highlight keys for each finger.
    */
    static
    void setFingerColor( int i, const QColor & v )
    {
      if (!self()->isFingerColorImmutable( i ))
        self()->mFingerColor[i] = v;
    }

    /**
      Get The keyboard tinting color to highlight keys for each finger.
    */
    static
    QColor fingerColor( int i )
    {
      return self()->mFingerColor[i];
    }

    /**
      Is The keyboard tinting color to highlight keys for each finger. Immutable
    */
    static
    bool isFingerColorImmutable( int i )
    {
      return self()->isImmutable( QStringLiteral( "FingerColor%1" ).arg( i ) );
    }

    /**
      Set How transparent finger colors should be shown.
    */
    static
    void setFingerOpacity( double v )
    {
      if (v < 0)
      {
        qDebug() << "setFingerOpacity: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 100)
      {
        qDebug() << "setFingerOpacity: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!self()->isFingerOpacityImmutable())
        self()->mFingerOpacity = v;
    }

    /**
      Get How transparent finger colors should be shown.
    */
    static
    double fingerOpacity()
    {
      return self()->mFingerOpacity;
    }

    /**
      Is How transparent finger colors should be shown. Immutable
    */
    static
    bool isFingerOpacityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "FingerOpacity" ) );
    }

    /**
      Set The ID of the last used profile.
    */
    static
    void setLastUsedProfileId( int v )
    {
      if (!self()->isLastUsedProfileIdImmutable())
        self()->mLastUsedProfileId = v;
    }

    /**
      Get The ID of the last used profile.
    */
    static
    int lastUsedProfileId()
    {
      return self()->mLastUsedProfileId;
    }

    /**
      Is The ID of the last used profile. Immutable
    */
    static
    bool isLastUsedProfileIdImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LastUsedProfileId" ) );
    }

  protected:
    Preferences();
    friend class PreferencesHelper;


    // General
    QString mKeyboardLayoutName;

    // Training
    bool mEnforceTypingErrorCorrection;
    bool mShowKeyboard;
    bool mShowStatistics;
    bool mNextLineWithReturn;
    bool mNextLineWithSpace;
    int mRequiredStrokesPerMinute;
    double mRequiredAccuracy;

    // Colors
    QColor mFingerColor[8];
    double mFingerOpacity;

    // Session
    int mLastUsedProfileId;

  private:
};

#endif

