/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.image.Opale;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.utils.Position;

public class TimingNote {
    private final TimeTick when;
    private final Player player;
    private final Display note;
    private final Position position;
    private final ISkinParam skinParam;
    private final Style style;

    public TimingNote(TimeTick when, Player player, Display note, Position position, ISkinParam skinParam, Style style) {
        this.style = style;
        this.note = note;
        this.player = player;
        this.when = when;
        this.skinParam = skinParam;
        this.position = position;
    }

    public void drawU(UGraphic ug) {
        if (this.position == Position.BOTTOM) {
            ug = ug.apply(UTranslate.dy(this.getMarginY() / 2.0));
        }
        this.createOpale().drawU(ug);
    }

    private Opale createOpale() {
        FontConfiguration fc = FontConfiguration.create(this.skinParam, this.style);
        double shadowing = this.style.getShadowing();
        HColor borderColor = this.style.value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        HColor noteBackgroundColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getIHtmlColorSet());
        UStroke stroke = this.style.getStroke();
        Sheet sheet = this.skinParam.sheet(fc, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(this.note);
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, stroke);
        return opale;
    }

    public double getHeight(StringBounder stringBounder) {
        return this.createOpale().calculateDimension(stringBounder).getHeight() + this.getMarginY();
    }

    private double getMarginY() {
        return 10.0;
    }

    public TimeTick getWhen() {
        return this.when;
    }

    public final Position getPosition() {
        return this.position;
    }
}

