/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.transform;

import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenancable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.impl.ArrayExample;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.transform.Transformer;

public final class TransformerMap
implements Provenancable<TransformerMapProvenance>,
Serializable {
    private static final Logger logger = Logger.getLogger(TransformerMap.class.getName());
    private static final long serialVersionUID = 2L;
    private final Map<String, List<Transformer>> map;
    private final DatasetProvenance datasetProvenance;
    private final ConfiguredObjectProvenance transformationMapProvenance;

    public TransformerMap(Map<String, List<Transformer>> map, DatasetProvenance datasetProvenance, ConfiguredObjectProvenance transformationMapProvenance) {
        this.map = Collections.unmodifiableMap(map);
        this.datasetProvenance = datasetProvenance;
        this.transformationMapProvenance = transformationMapProvenance;
    }

    public static double applyTransformerList(double value, List<Transformer> transformerList) {
        if (transformerList != null) {
            for (Transformer t : transformerList) {
                value = t.transform(value);
            }
        }
        return value;
    }

    public <T extends Output<T>> Example<T> transformExample(Example<T> example) {
        ArrayExample<T> newExample = new ArrayExample<T>(example);
        newExample.transform(this);
        return newExample;
    }

    public <T extends Output<T>> Example<T> transformExample(Example<T> example, List<String> featureNames) {
        ArrayExample<T> newExample = new ArrayExample<T>(example);
        newExample.densify(featureNames);
        newExample.transform(this);
        return newExample;
    }

    public <T extends Output<T>> MutableDataset<T> transformDataset(Dataset<T> dataset) {
        return this.transformDataset(dataset, false);
    }

    public <T extends Output<T>> MutableDataset<T> transformDataset(Dataset<T> dataset, boolean densify) {
        logger.fine("Creating deep copy of data set");
        MutableDataset<T> newDataset = MutableDataset.createDeepCopy(dataset);
        if (densify) {
            newDataset.densify();
        }
        logger.fine(String.format("Transforming data set copy", new Object[0]));
        newDataset.transform(this);
        return newDataset;
    }

    public int size() {
        return this.map.size();
    }

    public List<Transformer> get(String featureName) {
        return this.map.get(featureName);
    }

    public String toString() {
        return "TransformerMap(map=" + this.map.toString() + ")";
    }

    public Set<Map.Entry<String, List<Transformer>>> entrySet() {
        return this.map.entrySet();
    }

    public TransformerMapProvenance getProvenance() {
        return new TransformerMapProvenance(this);
    }

    public static final class TransformerMapProvenance
    implements ObjectProvenance {
        private static final long serialVersionUID = 1L;
        private static final String TRANSFORMATION_MAP = "transformation-map";
        private static final String DATASET = "dataset";
        private final String className;
        private final ConfiguredObjectProvenance transformationMapProvenance;
        private final DatasetProvenance datasetProvenance;

        TransformerMapProvenance(TransformerMap host) {
            this.className = host.getClass().getName();
            this.transformationMapProvenance = host.transformationMapProvenance;
            this.datasetProvenance = host.datasetProvenance;
        }

        public TransformerMapProvenance(Map<String, Provenance> map) {
            this.className = ((StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)TransformerMapProvenance.class.getSimpleName())).getValue();
            this.transformationMapProvenance = (ConfiguredObjectProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)TRANSFORMATION_MAP, ConfiguredObjectProvenance.class, (String)TransformerMapProvenance.class.getSimpleName());
            this.datasetProvenance = (DatasetProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DATASET, DatasetProvenance.class, (String)TransformerMapProvenance.class.getSimpleName());
        }

        public String getClassName() {
            return this.className;
        }

        public Iterator<Pair<String, Provenance>> iterator() {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(new Pair((Object)"class-name", (Object)new StringProvenance("class-name", this.className)));
            list.add(new Pair((Object)TRANSFORMATION_MAP, (Object)this.transformationMapProvenance));
            list.add(new Pair((Object)DATASET, (Object)this.datasetProvenance));
            return list.iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TransformerMapProvenance)) {
                return false;
            }
            TransformerMapProvenance pairs = (TransformerMapProvenance)o;
            return this.className.equals(pairs.className) && this.transformationMapProvenance.equals(pairs.transformationMapProvenance) && this.datasetProvenance.equals(pairs.datasetProvenance);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.transformationMapProvenance, this.datasetProvenance);
        }

        public String toString() {
            return this.generateString("TransformerMap");
        }
    }
}

