/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.NdJsonpSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.WaitForActiveShards;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.search.SourceConfigParam;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

public class BulkRequest
extends RequestBase
implements NdJsonpSerializable,
JsonpSerializable {
    @Nullable
    private final SourceConfigParam source;
    private final List<String> sourceExcludes;
    private final List<String> sourceIncludes;
    @Nullable
    private final String index;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    private final List<BulkOperation> operations;
    public static final Endpoint<BulkRequest, BulkResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<BulkRequest, BulkResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_bulk");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_bulk");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.source != null) {
            params.put("_source", request.source._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.sourceExcludes)) {
            params.put("_source_excludes", request.sourceExcludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.sourceIncludes)) {
            params.put("_source_includes", request.sourceIncludes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, BulkResponse._DESERIALIZER);

    private BulkRequest(Builder builder) {
        this.source = builder.source;
        this.sourceExcludes = ApiTypeHelper.unmodifiable(builder.sourceExcludes);
        this.sourceIncludes = ApiTypeHelper.unmodifiable(builder.sourceIncludes);
        this.index = builder.index;
        this.pipeline = builder.pipeline;
        this.refresh = builder.refresh;
        this.requireAlias = builder.requireAlias;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.operations = ApiTypeHelper.unmodifiableRequired(builder.operations, (Object)this, "operations");
    }

    public static BulkRequest of(Function<Builder, ObjectBuilder<BulkRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return this.operations.iterator();
    }

    @Nullable
    public final SourceConfigParam source() {
        return this.source;
    }

    public final List<String> sourceExcludes() {
        return this.sourceExcludes;
    }

    public final List<String> sourceIncludes() {
        return this.sourceIncludes;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public final List<BulkOperation> operations() {
        return this.operations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (BulkOperation item0 : this.operations) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().source(this.source).sourceExcludes(this.sourceExcludes).sourceIncludes(this.sourceIncludes).index(this.index).pipeline(this.pipeline).refresh(this.refresh).requireAlias(this.requireAlias).routing(this.routing).timeout(this.timeout).waitForActiveShards(this.waitForActiveShards).operations(this.operations);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BulkRequest> {
        @Nullable
        private SourceConfigParam source;
        @Nullable
        private List<String> sourceExcludes;
        @Nullable
        private List<String> sourceIncludes;
        @Nullable
        private String index;
        @Nullable
        private String pipeline;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        private List<BulkOperation> operations;

        public final Builder source(@Nullable SourceConfigParam value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfigParam.Builder, ObjectBuilder<SourceConfigParam>> fn) {
            return this.source(fn.apply(new SourceConfigParam.Builder()).build());
        }

        public final Builder sourceExcludes(List<String> list) {
            this.sourceExcludes = Builder._listAddAll(this.sourceExcludes, list);
            return this;
        }

        public final Builder sourceExcludes(String value, String ... values) {
            this.sourceExcludes = Builder._listAdd(this.sourceExcludes, value, values);
            return this;
        }

        public final Builder sourceIncludes(List<String> list) {
            this.sourceIncludes = Builder._listAddAll(this.sourceIncludes, list);
            return this;
        }

        public final Builder sourceIncludes(String value, String ... values) {
            this.sourceIncludes = Builder._listAdd(this.sourceIncludes, value, values);
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder operations(List<BulkOperation> list) {
            this.operations = Builder._listAddAll(this.operations, list);
            return this;
        }

        public final Builder operations(BulkOperation value, BulkOperation ... values) {
            this.operations = Builder._listAdd(this.operations, value, values);
            return this;
        }

        public final Builder operations(Function<BulkOperation.Builder, ObjectBuilder<BulkOperation>> fn) {
            return this.operations(fn.apply(new BulkOperation.Builder()).build(), new BulkOperation[0]);
        }

        @Override
        public BulkRequest build() {
            this._checkSingleUse();
            return new BulkRequest(this);
        }
    }
}

