/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndexStats;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.pagination.IndexPaginationStrategy;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.action.pagination.PageToken;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.opensearch.cluster.health.ClusterIndexHealth;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Table;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.index.IndexSettings;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.parser.ToolParser;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="ListIndexTool")
public class ListIndexTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(ListIndexTool.class);
    public static final String TYPE = "ListIndexTool";
    public static final String STRICT_FIELD = "strict";
    private static final int MAX_SUPPORTED_LIST_INDICES_PAGE_SIZE = 5000;
    public static final int DEFAULT_PAGE_SIZE = 100;
    public static final String DEFAULT_DESCRIPTION = String.join((CharSequence)" ", "This tool returns information about indices in the OpenSearch cluster along with the index `health`, `status`, `index`, `uuid`, `pri`, `rep`, `docs.count`, `docs.deleted`, `store.size`, `pri.store. size `, `pri.store.size`, `pri.store`.", "Optional arguments: 1. `indices`, a comma-delimited list of one or more indices to get information from (default is an empty list meaning all indices). Use only valid index names.", "2. `local`, whether to return information from the local node only instead of the cluster manager node (Default is false)");
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"indices\":{\"type\":\"array\",\"items\": {\"type\": \"string\"},\"description\":\"OpenSearch index name list, separated by comma. for example: [\\\"index1\\\", \\\"index2\\\"], use empty array [] to list all indices in the cluster\"}},\"additionalProperties\":false}";
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"indices\":{\"type\":\"array\",\"items\": {\"type\": \"string\"},\"description\":\"OpenSearch index name list, separated by comma. for example: [\\\"index1\\\", \\\"index2\\\"], use empty array [] to list all indices in the cluster\"}},\"additionalProperties\":false}", "strict", false);
    private String name = "ListIndexTool";
    private String description = DEFAULT_DESCRIPTION;
    private Map<String, Object> attributes;
    private String version;
    private Client client;
    private Parser<?, ?> inputParser;
    private Parser outputParser;
    private ClusterService clusterService;

    public ListIndexTool(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, false);
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            List indexList = new ArrayList();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)parameters.get("indices")))) {
                indexList = parameters.containsKey("indices") ? (List)StringUtils.gson.fromJson((String)parameters.get("indices"), List.class) : Collections.emptyList();
            }
            String[] indices = indexList.toArray(Strings.EMPTY_ARRAY);
            IndicesOptions indicesOptions = IndicesOptions.strictExpand();
            boolean local = parameters.containsKey("local") && Boolean.parseBoolean((String)parameters.get("local"));
            boolean includeUnloadedSegments = Boolean.parseBoolean((String)parameters.get("include_unloaded_segments"));
            int pageSize = parameters.containsKey("page_size") ? NumberUtils.toInt((String)((String)parameters.get("page_size")), (int)100) : 100;
            PageParams pageParams = new PageParams(null, "asc", pageSize);
            ActionListener internalListener = ActionListener.notifyOnce((ActionListener)ActionListener.wrap(table -> {
                if (table == null || table.getRows().isEmpty()) {
                    String empty = "There were no results searching the indices parameter [" + (String)parameters.get("indices") + "].";
                    listener.onResponse((Object)empty);
                    return;
                }
                StringBuilder sb = new StringBuilder(table.getHeaders().stream().map(c -> c.value.toString()).collect(Collectors.joining(",", "", "\n")));
                for (List row : table.getRows()) {
                    sb.append(row.stream().map(c -> c.value == null ? null : c.value.toString()).collect(Collectors.joining(",", "", "\n")));
                }
                String output = sb.toString();
                listener.onResponse(this.outputParser != null ? this.outputParser.parse((Object)output) : output);
            }, arg_0 -> listener.onFailure(arg_0)));
            this.fetchClusterInfoAndPages(indices, local, includeUnloadedSegments, pageParams, indicesOptions, new ConcurrentLinkedQueue<Collection<ActionResponse>>(), (ActionListener<Table>)internalListener);
        }
        catch (Exception e) {
            log.error("Failed to run ListIndexTool", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void fetchClusterInfoAndPages(final String[] indices, final boolean local, final boolean includeUnloadedSegments, final PageParams pageParams, IndicesOptions indicesOptions, final Queue<Collection<ActionResponse>> pageResults, final ActionListener<Table> originalListener) {
        this.sendGetSettingsRequest(indices, indicesOptions, local, this.client, new ActionListener<GetSettingsResponse>(){

            public void onResponse(final GetSettingsResponse getSettingsResponse) {
                final IndicesOptions subRequestIndicesOptions = IndicesOptions.lenientExpandHidden();
                ListIndexTool.this.sendClusterStateRequest(indices, subRequestIndicesOptions, local, ListIndexTool.this.client, new ActionListener<ClusterStateResponse>(){

                    public void onResponse(ClusterStateResponse clusterStateResponse) {
                        ListIndexTool.this.fetchPages(indices, local, ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT, includeUnloadedSegments, pageParams, pageResults, clusterStateResponse, getSettingsResponse, subRequestIndicesOptions, (ActionListener<Table>)originalListener);
                    }

                    public void onFailure(Exception e) {
                        originalListener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                originalListener.onFailure(e);
            }
        });
    }

    private void fetchPages(String[] indices, boolean local, TimeValue clusterManagerNodeTimeout, boolean includeUnloadedSegments, PageParams pageParams, Queue<Collection<ActionResponse>> pageResults, ClusterStateResponse clusterStateResponse, GetSettingsResponse getSettingsResponse, IndicesOptions subRequestIndicesOptions, ActionListener<Table> originalListener) {
        ActionListener iterativeListener = ActionListener.wrap(r -> {
            PageParams nextPageParams = new PageParams(r.getNextToken(), pageParams.getSort(), pageParams.getSize());
            if (r.getNextToken() == null || pageResults.size() >= 5000) {
                Table table = this.buildTable(clusterStateResponse, getSettingsResponse, pageResults);
                originalListener.onResponse((Object)table);
            } else {
                this.fetchPages(indices, local, clusterManagerNodeTimeout, includeUnloadedSegments, nextPageParams, pageResults, clusterStateResponse, getSettingsResponse, subRequestIndicesOptions, originalListener);
            }
        }, e -> {
            log.error("Failed to fetch index info for page: {}", (Object)pageParams.getRequestedToken());
            originalListener.onResponse((Object)this.buildTable(clusterStateResponse, getSettingsResponse, pageResults));
        });
        IndexPaginationStrategy paginationStrategy = this.getPaginationStrategy(pageParams, clusterStateResponse);
        String[] indicesToBeQueried = Objects.isNull(paginationStrategy) ? indices : paginationStrategy.getRequestedEntities().toArray(new String[0]);
        GroupedActionListener<ActionResponse> groupedListener = this.createGroupedListener(pageResults, paginationStrategy.getResponseToken(), (ActionListener<PageToken>)iterativeListener);
        this.sendIndicesStatsRequest(indicesToBeQueried, subRequestIndicesOptions, includeUnloadedSegments, this.client, (ActionListener<IndicesStatsResponse>)ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
        this.sendClusterHealthRequest(indicesToBeQueried, subRequestIndicesOptions, local, clusterManagerNodeTimeout, this.client, (ActionListener<ClusterHealthResponse>)ActionListener.wrap(arg_0 -> groupedListener.onResponse(arg_0), arg_0 -> groupedListener.onFailure(arg_0)));
    }

    protected IndexPaginationStrategy getPaginationStrategy(PageParams pageParams, ClusterStateResponse clusterStateResponse) {
        return new IndexPaginationStrategy(pageParams, clusterStateResponse.getState());
    }

    public String getType() {
        return TYPE;
    }

    private void sendGetSettingsRequest(String[] indices, IndicesOptions indicesOptions, boolean local, Client client, ActionListener<GetSettingsResponse> listener) {
        GetSettingsRequest request = new GetSettingsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        request.names(new String[]{IndexSettings.INDEX_SEARCH_THROTTLED.getKey()});
        client.admin().indices().getSettings(request, listener);
    }

    private void sendClusterStateRequest(String[] indices, IndicesOptions indicesOptions, boolean local, Client client, ActionListener<ClusterStateResponse> listener) {
        ClusterStateRequest request = new ClusterStateRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(ClusterManagerNodeRequest.DEFAULT_CLUSTER_MANAGER_NODE_TIMEOUT);
        client.admin().cluster().state(request, listener);
    }

    private void sendClusterHealthRequest(String[] indices, IndicesOptions indicesOptions, boolean local, TimeValue clusterManagerNodeTimeout, Client client, ActionListener<ClusterHealthResponse> listener) {
        ClusterHealthRequest request = new ClusterHealthRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.local(local);
        request.clusterManagerNodeTimeout(clusterManagerNodeTimeout);
        client.admin().cluster().health(request, listener);
    }

    private void sendIndicesStatsRequest(String[] indices, IndicesOptions indicesOptions, boolean includeUnloadedSegments, Client client, ActionListener<IndicesStatsResponse> listener) {
        IndicesStatsRequest request = new IndicesStatsRequest();
        request.indices(indices);
        request.indicesOptions(indicesOptions);
        request.all();
        request.includeUnloadedSegments(includeUnloadedSegments);
        client.admin().indices().stats(request, listener);
    }

    private GroupedActionListener<ActionResponse> createGroupedListener(final Queue<Collection<ActionResponse>> pageResults, final PageToken pageToken, final ActionListener<PageToken> listener) {
        return new GroupedActionListener((ActionListener)new ActionListener<Collection<ActionResponse>>(this){

            public void onResponse(Collection<ActionResponse> responses) {
                pageResults.add(responses);
                listener.onResponse((Object)pageToken);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, 2);
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && !parameters.isEmpty();
    }

    private Table getTableWithHeader() {
        Table table = new Table();
        table.startHeaders();
        table.addCell((Object)"row", "alias:r;desc:row number");
        table.addCell((Object)"health", "alias:h;desc:current health status");
        table.addCell((Object)"status", "alias:s;desc:open/close status");
        table.addCell((Object)"index", "alias:i,idx;desc:index name");
        table.addCell((Object)"uuid", "alias:id,uuid;desc:index uuid");
        table.addCell((Object)"pri(number of primary shards)", "alias:p,shards.primary,shardsPrimary;text-align:right;desc:number of primary shards");
        table.addCell((Object)"rep(number of replica shards)", "alias:r,shards.replica,shardsReplica;text-align:right;desc:number of replica shards");
        table.addCell((Object)"docs.count(number of available documents)", "alias:dc,docsCount;text-align:right;desc:available docs");
        table.addCell((Object)"docs.deleted(number of deleted documents)", "alias:dd,docsDeleted;text-align:right;desc:deleted docs");
        table.addCell((Object)"store.size(store size of primary and replica shards)", "sibling:pri;alias:ss,storeSize;text-align:right;desc:store size of primaries & replicas");
        table.addCell((Object)"pri.store.size(store size of primary shards)", "text-align:right;desc:store size of primaries");
        table.endHeaders();
        return table;
    }

    private Table buildTable(ClusterStateResponse clusterStateResponse, GetSettingsResponse getSettingsResponse, Queue<Collection<ActionResponse>> responses) {
        if (responses == null || responses.isEmpty() || responses.peek().isEmpty()) {
            return null;
        }
        Tuple<Map<String, IndexStats>, Map<String, ClusterIndexHealth>> tuple = this.aggregateResults(responses);
        Table table = this.getTableWithHeader();
        AtomicInteger rowNum = new AtomicInteger(0);
        Map<String, Settings> indicesSettings = StreamSupport.stream(Spliterators.spliterator(getSettingsResponse.getIndexToSettings().entrySet(), 0), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map indicesStates = StreamSupport.stream(clusterStateResponse.getState().getMetadata().spliterator(), false).collect(Collectors.toMap(indexMetadata -> indexMetadata.getIndex().getName(), Function.identity()));
        Map indicesHealths = (Map)tuple.v2();
        Map indicesStats = (Map)tuple.v1();
        indicesSettings.forEach((indexName, settings) -> {
            CommonStats totalStats;
            CommonStats primaryStats;
            if (!indicesStates.containsKey(indexName)) {
                return;
            }
            IndexMetadata indexMetadata = (IndexMetadata)indicesStates.get(indexName);
            IndexMetadata.State indexState = indexMetadata.getState();
            IndexStats indexStats = (IndexStats)indicesStats.get(indexName);
            ClusterIndexHealth indexHealth = (ClusterIndexHealth)indicesHealths.get(indexName);
            String health = indexHealth != null ? indexHealth.getStatus().toString().toLowerCase(Locale.ROOT) : (indexStats != null ? "red*" : "");
            if (indexStats == null || indexState == IndexMetadata.State.CLOSE) {
                primaryStats = new CommonStats();
                totalStats = new CommonStats();
            } else {
                primaryStats = indexStats.getPrimaries();
                totalStats = indexStats.getTotal();
            }
            table.startRow();
            table.addCell((Object)rowNum.addAndGet(1));
            table.addCell((Object)health);
            table.addCell((Object)indexState.toString().toLowerCase(Locale.ROOT));
            table.addCell(indexName);
            table.addCell((Object)indexMetadata.getIndexUUID());
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfShards()));
            table.addCell(indexHealth == null ? null : Integer.valueOf(indexHealth.getNumberOfReplicas()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getCount()));
            table.addCell(primaryStats.getDocs() == null ? null : Long.valueOf(primaryStats.getDocs().getDeleted()));
            table.addCell(totalStats.getStore() == null ? null : totalStats.getStore().size());
            table.addCell(primaryStats.getStore() == null ? null : primaryStats.getStore().size());
            table.endRow();
        });
        return table;
    }

    private Tuple<Map<String, IndexStats>, Map<String, ClusterIndexHealth>> aggregateResults(Queue<Collection<ActionResponse>> responses) {
        HashMap indexStatsMap = new HashMap();
        HashMap clusterIndexHealthMap = new HashMap();
        for (Collection collection : responses) {
            if (collection == null || collection.isEmpty()) continue;
            collection.forEach(x -> {
                if (x instanceof IndicesStatsResponse) {
                    indexStatsMap.putAll(((IndicesStatsResponse)x).getIndices());
                } else if (x instanceof ClusterHealthResponse) {
                    clusterIndexHealthMap.putAll(((ClusterHealthResponse)x).getIndices());
                } else {
                    throw new IllegalStateException("Unexpected action response type: " + x.getClass().getName());
                }
            });
        }
        return new Tuple(indexStatsMap, clusterIndexHealthMap);
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setInputParser(Parser<?, ?> inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<ListIndexTool> {
        private Client client;
        private ClusterService clusterService;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<ListIndexTool> clazz = ListIndexTool.class;
            synchronized (ListIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, ClusterService clusterService) {
            this.client = client;
            this.clusterService = clusterService;
        }

        public ListIndexTool create(Map<String, Object> params) {
            ListIndexTool tool = new ListIndexTool(this.client, this.clusterService);
            tool.setOutputParser(ToolParser.createFromToolParams(params));
            return tool;
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return ListIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

