/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.usermodel;

import java.util.Calendar;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LocaleUtil;

public final class DateAndTime
implements Duplicatable {
    public static final int SIZE = 4;
    private static final BitField _minutes = BitFieldFactory.getInstance((int)63);
    private static final BitField _hours = BitFieldFactory.getInstance((int)1984);
    private static final BitField _dom = BitFieldFactory.getInstance((int)63488);
    private static final BitField _months = BitFieldFactory.getInstance((int)15);
    private static final BitField _years = BitFieldFactory.getInstance((int)8176);
    private short _info;
    private short _info2;

    public DateAndTime() {
    }

    public DateAndTime(DateAndTime other) {
        this._info = other._info;
        this._info2 = other._info2;
    }

    public DateAndTime(byte[] buf, int offset) {
        this._info = LittleEndian.getShort((byte[])buf, (int)offset);
        this._info2 = LittleEndian.getShort((byte[])buf, (int)(offset + 2));
    }

    public Calendar getDate() {
        return LocaleUtil.getLocaleCalendar((int)(_years.getValue((int)this._info2) + 1900), (int)(_months.getValue((int)this._info2) - 1), (int)_dom.getValue((int)this._info), (int)_hours.getValue((int)this._info), (int)_minutes.getValue((int)this._info), (int)0);
    }

    public void serialize(byte[] buf, int offset) {
        LittleEndian.putShort((byte[])buf, (int)offset, (short)this._info);
        LittleEndian.putShort((byte[])buf, (int)(offset + 2), (short)this._info2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateAndTime)) {
            return false;
        }
        DateAndTime dttm = (DateAndTime)o;
        return this._info == dttm._info && this._info2 == dttm._info2;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public DateAndTime copy() {
        return new DateAndTime(this);
    }

    public boolean isEmpty() {
        return this._info == 0 && this._info2 == 0;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[DTTM] EMPTY";
        }
        return "[DTTM] " + this.getDate();
    }
}

