/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesConfiguration> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::availabilityZone)).setter(ReservedInstancesConfiguration.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("availabilityZone").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::instanceCount)).setter(ReservedInstancesConfiguration.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").unmarshallLocationName("instanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::instanceTypeAsString)).setter(ReservedInstancesConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::platform)).setter(ReservedInstancesConfiguration.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::scopeAsString)).setter(ReservedInstancesConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").unmarshallLocationName("scope").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneId").getter(ReservedInstancesConfiguration.getter(ReservedInstancesConfiguration::availabilityZoneId)).setter(ReservedInstancesConfiguration.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").unmarshallLocationName("availabilityZoneId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD, SCOPE_FIELD, AVAILABILITY_ZONE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReservedInstancesConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final Integer instanceCount;
    private final String instanceType;
    private final String platform;
    private final String scope;
    private final String availabilityZoneId;

    private ReservedInstancesConfiguration(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.scope = builder.scope;
        this.availabilityZoneId = builder.availabilityZoneId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String platform() {
        return this.platform;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesConfiguration)) {
            return false;
        }
        ReservedInstancesConfiguration other = (ReservedInstancesConfiguration)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId());
    }

    public final String toString() {
        return ToString.builder((String)"ReservedInstancesConfiguration").add("AvailabilityZone", (Object)this.availabilityZone()).add("InstanceCount", (Object)this.instanceCount()).add("InstanceType", (Object)this.instanceTypeAsString()).add("Platform", (Object)this.platform()).add("Scope", (Object)this.scopeAsString()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "AvailabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesConfiguration, T> g) {
        return obj -> g.apply((ReservedInstancesConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Integer instanceCount;
        private String instanceType;
        private String platform;
        private String scope;
        private String availabilityZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesConfiguration model) {
            this.availabilityZone(model.availabilityZone);
            this.instanceCount(model.instanceCount);
            this.instanceType(model.instanceType);
            this.platform(model.platform);
            this.scope(model.scope);
            this.availabilityZoneId(model.availabilityZoneId);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public ReservedInstancesConfiguration build() {
            return new ReservedInstancesConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesConfiguration> {
        public Builder availabilityZone(String var1);

        public Builder instanceCount(Integer var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder platform(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder availabilityZoneId(String var1);
    }
}

