/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristicBuilder;

public class JLHScore
extends SignificanceHeuristic {
    public static final String NAME = "jlh";
    public static final ObjectParser<JLHScore, Void> PARSER = new ObjectParser("jlh", JLHScore::new);

    public JLHScore() {
    }

    public JLHScore(StreamInput in) {
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        double supersetProbability;
        double subsetProbability;
        double absoluteProbabilityChange;
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "JLHScore");
        if (subsetSize == 0L || supersetSize == 0L) {
            return 0.0;
        }
        if (supersetFreq == 0L) {
            supersetFreq = 1L;
        }
        if ((absoluteProbabilityChange = (subsetProbability = (double)subsetFreq / (double)subsetSize) - (supersetProbability = (double)supersetFreq / (double)supersetSize)) <= 0.0) {
            return 0.0;
        }
        double relativeProbabilityChange = subsetProbability / supersetProbability;
        return absoluteProbabilityChange * relativeProbabilityChange;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class JLHScoreBuilder
    implements SignificanceHeuristicBuilder {
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(JLHScore.NAME).endObject();
            return builder;
        }
    }
}

