/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search;

import java.lang.runtime.SwitchBootstraps;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.search.OpenSearchToParentBlockJoinQuery;
import org.opensearch.search.approximate.ApproximateScoreQuery;

public final class NestedHelper {
    private final MapperService mapperService;

    public NestedHelper(MapperService mapperService) {
        this.mapperService = mapperService;
    }

    public boolean mightMatchNestedDocs(Query query) {
        Query query2 = query;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantScoreQuery.class, BoostQuery.class, MatchAllDocsQuery.class, MatchNoDocsQuery.class, TermQuery.class, TermInSetQuery.class, PointRangeQuery.class, IndexOrDocValuesQuery.class, ApproximateScoreQuery.class, BooleanQuery.class, OpenSearchToParentBlockJoinQuery.class}, (Object)query2, n)) {
            case 0 -> {
                ConstantScoreQuery csq = (ConstantScoreQuery)query2;
                yield this.mightMatchNestedDocs(csq.getQuery());
            }
            case 1 -> {
                BoostQuery bq = (BoostQuery)query2;
                yield this.mightMatchNestedDocs(bq.getQuery());
            }
            case 2 -> {
                MatchAllDocsQuery ignored = (MatchAllDocsQuery)query2;
                yield true;
            }
            case 3 -> {
                MatchNoDocsQuery ignored = (MatchNoDocsQuery)query2;
                yield false;
            }
            case 4 -> {
                TermQuery tq = (TermQuery)query2;
                yield this.mightMatchNestedDocs(tq.getTerm().field());
            }
            case 5 -> {
                TermInSetQuery tisq = (TermInSetQuery)query2;
                if (tisq.getTermsCount() > 0L && this.mightMatchNestedDocs(tisq.getField())) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                PointRangeQuery prq = (PointRangeQuery)query2;
                yield this.mightMatchNestedDocs(prq.getField());
            }
            case 7 -> {
                IndexOrDocValuesQuery iorvq = (IndexOrDocValuesQuery)query2;
                yield this.mightMatchNestedDocs(iorvq.getIndexQuery());
            }
            case 8 -> {
                ApproximateScoreQuery asq = (ApproximateScoreQuery)query2;
                yield this.mightMatchNestedDocs(asq.getOriginalQuery());
            }
            case 9 -> {
                BooleanQuery bq = (BooleanQuery)query2;
                boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
                if (hasRequiredClauses) {
                    yield bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(this::mightMatchNestedDocs);
                }
                yield bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(this::mightMatchNestedDocs);
            }
            case 10 -> {
                OpenSearchToParentBlockJoinQuery opbq = (OpenSearchToParentBlockJoinQuery)query2;
                if (opbq.getPath() != null) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    boolean mightMatchNestedDocs(String field) {
        if (field.startsWith("_")) {
            return true;
        }
        if (this.mapperService.fieldType(field) == null) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.mapperService.getObjectMapper(parent);
            if (mapper != null && mapper.nested().isNested()) {
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return false;
    }

    public boolean mightMatchNonNestedDocs(Query query, String nestedPath) {
        Query query2 = query;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantScoreQuery.class, BoostQuery.class, MatchAllDocsQuery.class, MatchNoDocsQuery.class, TermQuery.class, TermInSetQuery.class, PointRangeQuery.class, IndexOrDocValuesQuery.class, ApproximateScoreQuery.class, BooleanQuery.class}, (Object)query2, n)) {
            case 0 -> {
                ConstantScoreQuery csq = (ConstantScoreQuery)query2;
                yield this.mightMatchNonNestedDocs(csq.getQuery(), nestedPath);
            }
            case 1 -> {
                BoostQuery bq = (BoostQuery)query2;
                yield this.mightMatchNonNestedDocs(bq.getQuery(), nestedPath);
            }
            case 2 -> {
                MatchAllDocsQuery ignored = (MatchAllDocsQuery)query2;
                yield true;
            }
            case 3 -> {
                MatchNoDocsQuery ignored = (MatchNoDocsQuery)query2;
                yield false;
            }
            case 4 -> {
                TermQuery tq = (TermQuery)query2;
                yield this.mightMatchNonNestedDocs(tq.getTerm().field(), nestedPath);
            }
            case 5 -> {
                TermInSetQuery tisq = (TermInSetQuery)query2;
                if (tisq.getTermsCount() > 0L && this.mightMatchNonNestedDocs(tisq.getField(), nestedPath)) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                PointRangeQuery prq = (PointRangeQuery)query2;
                yield this.mightMatchNonNestedDocs(prq.getField(), nestedPath);
            }
            case 7 -> {
                IndexOrDocValuesQuery iorvq = (IndexOrDocValuesQuery)query2;
                yield this.mightMatchNonNestedDocs(iorvq.getIndexQuery(), nestedPath);
            }
            case 8 -> {
                ApproximateScoreQuery asq = (ApproximateScoreQuery)query2;
                yield this.mightMatchNonNestedDocs(asq.getOriginalQuery(), nestedPath);
            }
            case 9 -> {
                BooleanQuery bq = (BooleanQuery)query2;
                boolean hasRequiredClauses = bq.clauses().stream().anyMatch(BooleanClause::isRequired);
                if (hasRequiredClauses) {
                    yield bq.clauses().stream().filter(BooleanClause::isRequired).map(BooleanClause::query).allMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
                }
                yield bq.clauses().stream().filter(c -> c.occur() == BooleanClause.Occur.SHOULD).map(BooleanClause::query).anyMatch(q -> this.mightMatchNonNestedDocs((Query)q, nestedPath));
            }
            default -> true;
        };
    }

    boolean mightMatchNonNestedDocs(String field, String nestedPath) {
        if (field.startsWith("_")) {
            return true;
        }
        if (this.mapperService.fieldType(field) == null) {
            return false;
        }
        String parent = NestedHelper.parentObject(field);
        while (parent != null) {
            ObjectMapper mapper = this.mapperService.getObjectMapper(parent);
            if (mapper != null && mapper.nested().isNested()) {
                if (mapper.fullPath().equals(nestedPath)) {
                    return mapper.nested().isIncludeInParent() || mapper.nested().isIncludeInRoot();
                }
                return true;
            }
            parent = NestedHelper.parentObject(parent);
        }
        return true;
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

