/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.namedtopology;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

@Deprecated
public class RemoveNamedTopologyResult {
    private final KafkaFutureImpl<Void> removeTopologyFuture;
    private final KafkaFutureImpl<Void> resetOffsetsFuture;

    public RemoveNamedTopologyResult(KafkaFutureImpl<Void> removeTopologyFuture) {
        Objects.requireNonNull(removeTopologyFuture);
        this.removeTopologyFuture = removeTopologyFuture;
        this.resetOffsetsFuture = null;
    }

    public RemoveNamedTopologyResult(KafkaFutureImpl<Void> removeTopologyFuture, String removedTopology, Runnable resetOffsets) {
        Objects.requireNonNull(removeTopologyFuture);
        this.removeTopologyFuture = removeTopologyFuture;
        this.resetOffsetsFuture = new ResetOffsetsFuture(removedTopology, removeTopologyFuture, resetOffsets);
    }

    public KafkaFuture<Void> removeTopologyFuture() {
        return this.removeTopologyFuture;
    }

    public KafkaFuture<Void> resetOffsetsFuture() {
        return this.resetOffsetsFuture;
    }

    public final KafkaFuture<Void> all() {
        if (this.resetOffsetsFuture == null) {
            return this.removeTopologyFuture;
        }
        return this.resetOffsetsFuture;
    }

    private static class ResetOffsetsFuture
    extends KafkaFutureImpl<Void> {
        private final Logger log;
        final Runnable resetOffsets;
        final KafkaFutureImpl<Void> removeTopologyFuture;

        public ResetOffsetsFuture(String removedTopology, KafkaFutureImpl<Void> removeTopologyFuture, Runnable resetOffsets) {
            LogContext logContext = new LogContext(String.format("topology [%s]", removedTopology));
            this.log = logContext.logger(((Object)((Object)this)).getClass());
            this.resetOffsets = resetOffsets;
            this.removeTopologyFuture = removeTopologyFuture;
        }

        public Void get() throws ExecutionException {
            AtomicReference<Object> firstError = new AtomicReference<Object>(null);
            try {
                this.removeTopologyFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable error = e.getCause() != null ? e.getCause() : e;
                this.log.error("Removing named topology failed. Offset reset will still be attempted.", error);
                firstError.compareAndSet(e, null);
            }
            try {
                this.resetOffsets.run();
            }
            catch (Throwable e) {
                this.log.error("Failed to reset offsets, you should do so manually if you want to add new topologiesin the future that consume from the same input topics");
                firstError.compareAndSet(e, null);
            }
            if (firstError.get() != null) {
                throw new ExecutionException(firstError.get());
            }
            return null;
        }
    }
}

