/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

final class GroupBuilder {
    private final List<GroupBuilder> groupBuilders = new ArrayList<GroupBuilder>();
    private boolean capturing = true;
    private String source;
    private int startIndex;
    private int endIndex;

    GroupBuilder(int startIndex) {
        this.startIndex = startIndex;
    }

    void add(GroupBuilder groupBuilder) {
        this.groupBuilders.add(groupBuilder);
    }

    Group build(Matcher matcher, Iterator<Integer> groupIndices) {
        int groupIndex = groupIndices.next();
        ArrayList<Group> children = new ArrayList<Group>(this.groupBuilders.size());
        for (GroupBuilder childGroupBuilder : this.groupBuilders) {
            children.add(childGroupBuilder.build(matcher, groupIndices));
        }
        return new Group(matcher.group(groupIndex), matcher.start(groupIndex), matcher.end(groupIndex), children);
    }

    void setNonCapturing() {
        this.capturing = false;
    }

    boolean isCapturing() {
        return this.capturing;
    }

    void moveChildrenTo(GroupBuilder groupBuilder) {
        for (GroupBuilder child : this.groupBuilders) {
            groupBuilder.add(child);
        }
    }

    List<GroupBuilder> getChildren() {
        return this.groupBuilders;
    }

    String getSource() {
        return this.source;
    }

    void setSource(String source) {
        this.source = source;
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int getEndIndex() {
        return this.endIndex;
    }

    void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
}

