/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.latex3;

import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;

public class L3Arg {
    int id;
    int token1 = -1;
    int token2 = -1;
    TeXObject defaultValue;
    boolean isShort = true;
    boolean ignoreSpace = true;

    public L3Arg(int n) {
        this(n, -1, -1, null);
    }

    public L3Arg(int n, boolean bl) {
        this(n, -1, -1, null, bl);
    }

    public L3Arg(int n, int n2, int n3, boolean bl) {
        this(n, n2, n3, null, bl);
    }

    public L3Arg(int n, int n2, int n3, TeXObject teXObject) {
        this(n, n2, n3, teXObject, true);
    }

    public L3Arg(int n, int n2, int n3, TeXObject teXObject, boolean bl) {
        this(n, n2, n3, teXObject, bl, true);
    }

    public L3Arg(int n, int n2, int n3, TeXObject teXObject, boolean bl, boolean bl2) {
        this.id = n;
        this.token1 = n2;
        this.token2 = n3;
        this.defaultValue = teXObject;
        this.isShort = bl;
        this.ignoreSpace = bl2;
    }

    public byte getPopStyle() {
        if (this.ignoreSpace) {
            return TeXObjectList.getArgPopStyle(this.isShort);
        }
        if (this.isShort) {
            return TeXObjectList.POP_SHORT;
        }
        return 0;
    }

    public int getId() {
        return this.id;
    }

    public int getToken1() {
        return this.token1;
    }

    public int getToken2() {
        return this.token2;
    }

    public TeXObject getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isIgnoreSpace() {
        return this.ignoreSpace;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.ignoreSpace) {
            stringBuilder.append('!');
        }
        if (!this.isShort) {
            stringBuilder.append('+');
        }
        stringBuilder.appendCodePoint(this.id);
        if (this.token1 != -1) {
            stringBuilder.appendCodePoint(this.token1);
        }
        if (this.token2 != -1) {
            stringBuilder.appendCodePoint(this.token2);
        }
        if (this.defaultValue != null) {
            stringBuilder.append(String.format("{%s}", this.defaultValue.format()));
        }
        return stringBuilder.toString();
    }

    public static TeXObject createNoValue(TeXParser teXParser) {
        return new DataObjectList(teXParser.getListener(), "-NoValue-", true);
    }

    public static boolean isNoValue(TeXObject teXObject, TeXParser teXParser) {
        TeXObject teXObject2;
        TeXObjectList teXObjectList;
        if (teXObject instanceof DataObjectList) {
            return teXObject.toString(teXParser).equals("-NoValue-");
        }
        if (teXParser.isStack(teXObject) && (teXObjectList = (TeXObjectList)teXObject).size() == 1 && (teXObject2 = (TeXObject)teXObjectList.firstElement()) instanceof DataObjectList) {
            return teXObject2.toString(teXParser).equals("-NoValue-");
        }
        return false;
    }
}

