/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui.painter.hints;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jewel.ui.painter.hints.CssParser;
import org.jetbrains.jewel.ui.painter.hints.CssRule;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0004J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache;", "", "cache", "", "", "Lorg/jetbrains/jewel/ui/painter/hints/CssRule;", "<init>", "(Ljava/util/Map;)V", "getCssRuleFor", "className", "getCssPropertiesFor", "isEmpty", "", "Companion", "CacheBuilder", "intellij.platform.jewel.ui"})
final class CssClassAttributesCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, CssRule> cache;

    private CssClassAttributesCache(Map<String, CssRule> cache) {
        this.cache = cache;
    }

    @Nullable
    public final CssRule getCssRuleFor(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.cache.get(className);
    }

    @Nullable
    public final Map<String, String> getCssPropertiesFor(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        CssRule cssRule = this.cache.get(className);
        return cssRule != null ? cssRule.getProperties() : null;
    }

    public final boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public /* synthetic */ CssClassAttributesCache(Map cache, DefaultConstructorMarker $constructor_marker) {
        this(cache);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache$CacheBuilder;", "", "parser", "Lorg/jetbrains/jewel/ui/painter/hints/CssParser;", "<init>", "(Lorg/jetbrains/jewel/ui/painter/hints/CssParser;)V", "cache", "", "", "Lorg/jetbrains/jewel/ui/painter/hints/CssRule;", "addStyleElement", "", "styleElement", "Lorg/w3c/dom/Element;", "build", "Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache;", "intellij.platform.jewel.ui"})
    private static final class CacheBuilder {
        @NotNull
        private final CssParser parser;
        @NotNull
        private final Map<String, CssRule> cache;

        public CacheBuilder(@NotNull CssParser parser) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            this.parser = parser;
            this.cache = new LinkedHashMap();
        }

        public /* synthetic */ CacheBuilder(CssParser cssParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                cssParser = new CssParser();
            }
            this(cssParser);
        }

        public final void addStyleElement(@NotNull Element styleElement) {
            Intrinsics.checkNotNullParameter((Object)styleElement, (String)"styleElement");
            String type = styleElement.getAttribute("type");
            Intrinsics.checkNotNull((Object)type);
            if (((CharSequence)type).length() > 0 && !Intrinsics.areEqual((Object)type, (Object)"text/css")) {
                return;
            }
            String string = styleElement.getTextContent();
            if (string == null) {
                return;
            }
            String cssText = string;
            Map<String, CssRule> rules = this.parser.parseCssBlock(cssText);
            for (Map.Entry<String, CssRule> entry : rules.entrySet()) {
                String selector = entry.getKey();
                CssRule rule = entry.getValue();
                String className = StringsKt.removePrefix((String)selector, (CharSequence)".");
                this.cache.put(className, rule);
            }
        }

        @NotNull
        public final CssClassAttributesCache build() {
            return new CssClassAttributesCache(MapsKt.toMap(this.cache), null);
        }

        public CacheBuilder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/jewel/ui/painter/hints/CssClassAttributesCache;", "styleElements", "Lorg/w3c/dom/NodeList;", "parser", "Lorg/jetbrains/jewel/ui/painter/hints/CssParser;", "intellij.platform.jewel.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CssClassAttributesCache from(@NotNull NodeList styleElements, @NotNull CssParser parser) {
            Intrinsics.checkNotNullParameter((Object)styleElements, (String)"styleElements");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            CacheBuilder builder = new CacheBuilder(parser);
            int n = styleElements.getLength();
            for (int i = 0; i < n; ++i) {
                Element styleElement;
                Node node = styleElements.item(i);
                if ((node instanceof Element ? (Element)node : null) == null) continue;
                styleElement = styleElement;
                builder.addStyleElement(styleElement);
            }
            return builder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

