/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.plugin.impl.facet;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.python.community.plugin.impl.facet.PythonSdkTableListener;
import com.jetbrains.python.facet.PythonFacetSettings;

public final class PythonFacetUtil {
    public static String getFacetLibraryName(String sdkName) {
        return sdkName + " interpreter library";
    }

    public static void updateLibrary(Module module, PythonFacetSettings facetSettings) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = rootManager.getModifiableModel();
            boolean modelChanged = false;
            try {
                Sdk sdk = facetSettings.getSdk();
                String name = sdk != null ? PythonFacetUtil.getFacetLibraryName(sdk.getName()) : null;
                boolean librarySeen = false;
                for (OrderEntry entry : model.getOrderEntries()) {
                    if (!(entry instanceof LibraryOrderEntry)) continue;
                    String libraryName = ((LibraryOrderEntry)entry).getLibraryName();
                    if (name != null && name.equals(libraryName)) {
                        librarySeen = true;
                        continue;
                    }
                    if (libraryName == null || !libraryName.endsWith(" interpreter library")) continue;
                    model.removeOrderEntry(entry);
                    modelChanged = true;
                }
                if (name != null) {
                    ModifiableModelsProvider provider = ModifiableModelsProvider.getInstance();
                    LibraryTable.ModifiableModel libraryTableModifiableModel = provider.getGlobalLibraryTableModifiableModel(module.getProject());
                    Library library = libraryTableModifiableModel.getLibraryByName(name);
                    provider.disposeLibraryTableModifiableModel(libraryTableModifiableModel);
                    if (library == null) {
                        library = PythonSdkTableListener.addLibrary(sdk);
                    } else {
                        PythonSdkTableListener.updateLibrary(sdk);
                    }
                    if (!librarySeen) {
                        model.addLibraryEntry(library);
                        modelChanged = true;
                    }
                }
            }
            finally {
                if (modelChanged) {
                    model.commit();
                } else {
                    model.dispose();
                }
            }
        });
    }

    public static void removeLibrary(Module module) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = rootManager.getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                String libraryName;
                Library library;
                if (!(entry instanceof LibraryOrderEntry) || (library = ((LibraryOrderEntry)entry).getLibrary()) == null || (libraryName = library.getName()) == null || !libraryName.endsWith(" interpreter library")) continue;
                model.removeOrderEntry(entry);
            }
            model.commit();
        });
    }
}

