/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.lookup.LookupEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.view.TerminalContentChangeEvent;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\t*\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalLookupOutputModelListener;", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelListener;", "lookup", "Lcom/intellij/codeInsight/lookup/LookupEx;", "model", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "<init>", "(Lcom/intellij/codeInsight/lookup/LookupEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;)V", "initialTextBelowCursor", "", "afterContentChanged", "", "event", "Lorg/jetbrains/plugins/terminal/view/TerminalContentChangeEvent;", "getTextBelowCursorLine", "intellij.terminal.frontend"})
final class TerminalLookupOutputModelListener
implements TerminalOutputModelListener {
    @NotNull
    private final LookupEx lookup;
    @NotNull
    private final CharSequence initialTextBelowCursor;

    public TerminalLookupOutputModelListener(@NotNull LookupEx lookup, @NotNull TerminalOutputModel model) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.lookup = lookup;
        this.initialTextBelowCursor = StringsKt.trim((CharSequence)this.getTextBelowCursorLine(model));
    }

    @Override
    public void afterContentChanged(@NotNull TerminalContentChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CharSequence textBelowCursor = StringsKt.trim((CharSequence)this.getTextBelowCursorLine(event.getModel()));
        if (!Intrinsics.areEqual((Object)textBelowCursor, (Object)this.initialTextBelowCursor)) {
            this.lookup.hideLookup(false);
        }
    }

    private final CharSequence getTextBelowCursorLine(TerminalOutputModel $this$getTextBelowCursorLine) {
        TerminalLineIndex line = $this$getTextBelowCursorLine.getLineByOffset($this$getTextBelowCursorLine.getCursorOffset());
        TerminalOffset lineEndOffset = TerminalOutputModel.getEndOfLine$default($this$getTextBelowCursorLine, line, false, 2, null);
        return $this$getTextBelowCursorLine.getText(lineEndOffset, $this$getTextBelowCursorLine.getEndOffset());
    }
}

