/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotationHolder;
import org.jetbrains.annotations.NotNull;

public class PyReturnYieldAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    PyReturnYieldAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyReturnYieldAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyReturnStatement(@NotNull PyReturnStatement node) {
        PyFunction function;
        if (node == null) {
            PyReturnYieldAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class})) == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.return.outside.of.function", new Object[0])).create();
        }
        if (function != null && node.getExpression() != null && function.isGenerator() && function.isAsync() && function.isAsyncAllowed()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.non.empty.return.inside.asynchronous.generator", new Object[0])).create();
        }
    }

    public void visitPyYieldExpression(@NotNull PyYieldExpression node) {
        PyFunction function;
        ScopeOwner owner;
        if (node == null) {
            PyReturnYieldAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (!((owner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyFunction) && !(owner instanceof PyLambdaExpression)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.yield.outside.of.function", new Object[0])).create();
        }
        if (node.isDelegating() && owner instanceof PyFunction && (function = (PyFunction)owner).isAsync() && function.isAsyncAllowed()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.python.does.not.support.yield.from.inside.async.functions", new Object[0])).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyReturnYieldAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyReturnStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyYieldExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

