/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.utils.StringUtils;

public class MLAgentModelSpec
implements ToXContentObject {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String MODEL_PROVIDER_FIELD = "model_provider";
    public static final String CREDENTIAL_FIELD = "credential";
    public static final String MODEL_PARAMETERS_FIELD = "model_parameters";
    private final String modelId;
    private final String modelProvider;
    private Map<String, String> credential;
    private Map<String, String> modelParameters;

    public MLAgentModelSpec(String modelId, String modelProvider, Map<String, String> credential, Map<String, String> modelParameters) {
        if (modelId == null) {
            throw new IllegalArgumentException("model_id must be provided");
        }
        if (modelProvider == null) {
            throw new IllegalArgumentException("model_provider must be provided");
        }
        this.modelId = modelId;
        this.modelProvider = modelProvider;
        this.credential = credential;
        this.modelParameters = modelParameters;
    }

    public MLAgentModelSpec(StreamInput input) throws IOException {
        this.modelId = input.readString();
        this.modelProvider = input.readString();
        if (input.readBoolean()) {
            this.credential = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        if (input.readBoolean()) {
            this.modelParameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeString(this.modelProvider);
        if (this.credential != null && !this.credential.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.credential, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        if (this.modelParameters != null && !this.modelParameters.isEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.modelParameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.modelId != null) {
            builder.field(MODEL_ID_FIELD, this.modelId);
        }
        if (this.modelProvider != null) {
            builder.field(MODEL_PROVIDER_FIELD, this.modelProvider);
        }
        if (this.credential != null && !this.credential.isEmpty()) {
            builder.field(CREDENTIAL_FIELD, this.credential);
        }
        if (this.modelParameters != null && !this.modelParameters.isEmpty()) {
            builder.field(MODEL_PARAMETERS_FIELD, this.modelParameters);
        }
        builder.endObject();
        return builder;
    }

    public void removeCredential() {
        this.credential = null;
    }

    public static MLAgentModelSpec parse(XContentParser parser) throws IOException {
        String model = null;
        String modelProvider = null;
        Map<String, String> credential = null;
        Map<String, String> modelParameters = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    model = parser.text();
                    continue block12;
                }
                case "model_provider": {
                    modelProvider = parser.text();
                    continue block12;
                }
                case "credential": {
                    credential = StringUtils.getParameterMap(parser.map());
                    continue block12;
                }
                case "model_parameters": {
                    modelParameters = StringUtils.getParameterMap(parser.map());
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return new MLAgentModelSpec(model, modelProvider, credential, modelParameters);
    }

    public static MLAgentModelSpec fromStream(StreamInput in) throws IOException {
        return new MLAgentModelSpec(in);
    }

    @Generated
    public static MLAgentModelSpecBuilder builder() {
        return new MLAgentModelSpecBuilder();
    }

    @Generated
    public MLAgentModelSpecBuilder toBuilder() {
        return new MLAgentModelSpecBuilder().modelId(this.modelId).modelProvider(this.modelProvider).credential(this.credential).modelParameters(this.modelParameters);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLAgentModelSpec)) {
            return false;
        }
        MLAgentModelSpec other = (MLAgentModelSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$modelProvider = this.getModelProvider();
        String other$modelProvider = other.getModelProvider();
        if (this$modelProvider == null ? other$modelProvider != null : !this$modelProvider.equals(other$modelProvider)) {
            return false;
        }
        Map<String, String> this$credential = this.getCredential();
        Map<String, String> other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        Map<String, String> this$modelParameters = this.getModelParameters();
        Map<String, String> other$modelParameters = other.getModelParameters();
        return !(this$modelParameters == null ? other$modelParameters != null : !((Object)this$modelParameters).equals(other$modelParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLAgentModelSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $modelProvider = this.getModelProvider();
        result = result * 59 + ($modelProvider == null ? 43 : $modelProvider.hashCode());
        Map<String, String> $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        Map<String, String> $modelParameters = this.getModelParameters();
        result = result * 59 + ($modelParameters == null ? 43 : ((Object)$modelParameters).hashCode());
        return result;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getModelProvider() {
        return this.modelProvider;
    }

    @Generated
    public Map<String, String> getCredential() {
        return this.credential;
    }

    @Generated
    public Map<String, String> getModelParameters() {
        return this.modelParameters;
    }

    @Generated
    public void setCredential(Map<String, String> credential) {
        this.credential = credential;
    }

    @Generated
    public void setModelParameters(Map<String, String> modelParameters) {
        this.modelParameters = modelParameters;
    }

    @Generated
    public static class MLAgentModelSpecBuilder {
        @Generated
        private String modelId;
        @Generated
        private String modelProvider;
        @Generated
        private Map<String, String> credential;
        @Generated
        private Map<String, String> modelParameters;

        @Generated
        MLAgentModelSpecBuilder() {
        }

        @Generated
        public MLAgentModelSpecBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLAgentModelSpecBuilder modelProvider(String modelProvider) {
            this.modelProvider = modelProvider;
            return this;
        }

        @Generated
        public MLAgentModelSpecBuilder credential(Map<String, String> credential) {
            this.credential = credential;
            return this;
        }

        @Generated
        public MLAgentModelSpecBuilder modelParameters(Map<String, String> modelParameters) {
            this.modelParameters = modelParameters;
            return this;
        }

        @Generated
        public MLAgentModelSpec build() {
            return new MLAgentModelSpec(this.modelId, this.modelProvider, this.credential, this.modelParameters);
        }

        @Generated
        public String toString() {
            return "MLAgentModelSpec.MLAgentModelSpecBuilder(modelId=" + this.modelId + ", modelProvider=" + this.modelProvider + ", credential=" + String.valueOf(this.credential) + ", modelParameters=" + String.valueOf(this.modelParameters) + ")";
        }
    }
}

