/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PhoenixSqlDialect
extends SqlDialect {
    public static final RelDataTypeSystem TYPE_SYSTEM = new RelDataTypeSystemImpl(){

        @Override
        public int getMaxPrecision(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxPrecision(typeName);
        }

        @Override
        public int getMaxScale(SqlTypeName typeName) {
            switch (typeName) {
                case DECIMAL: {
                    return 38;
                }
            }
            return super.getMaxScale(typeName);
        }

        @Override
        public int getMaxNumericScale() {
            return this.getMaxScale(SqlTypeName.DECIMAL);
        }
    };
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.PHOENIX).withIdentifierQuoteString("\"").withDataTypeSystem(TYPE_SYSTEM);
    public static final SqlDialect DEFAULT = new PhoenixSqlDialect(DEFAULT_CONTEXT);

    public PhoenixSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsApproxCountDistinct() {
        return true;
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case REAL: {
                return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("FLOAT", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
            }
        }
        if (type instanceof AbstractSqlType) {
            switch (type.getSqlTypeName()) {
                case ARRAY: 
                case MAP: 
                case MULTISET: {
                    throw new UnsupportedOperationException("Phoenix dialect does not support cast to " + (Object)((Object)type.getSqlTypeName()));
                }
            }
        }
        return super.getCastSpec(type);
    }
}

