/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.schema.lookup.IgnoreCaseLookup;
import org.apache.calcite.schema.lookup.LikePattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompatibilityLookup<T>
extends IgnoreCaseLookup<T> {
    private final Function<String, @Nullable T> get;
    private final Supplier<Set<String>> getNames;

    public CompatibilityLookup(Function<String, @Nullable T> get, Supplier<Set<String>> getNames) {
        this.get = get;
        this.getNames = getNames;
    }

    @Override
    public @Nullable T get(String name) {
        return this.get.apply(name);
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        Predicate1<String> matcher = pattern.matcher();
        return this.getNames.get().stream().filter(name -> matcher.apply(name)).collect(Collectors.toSet());
    }
}

