/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.grpc.proto.request.search.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.index.query.InnerHitContextBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.neuralsearch.common.MinClusterVersionUtil;
import org.opensearch.neuralsearch.query.HybridQueryBuilder;
import org.opensearch.protobufs.HybridQuery;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

public final class HybridQueryBuilderProtoUtils {
    public static QueryBuilder fromProto(HybridQuery hybridQueryProto, QueryBuilderProtoConverterRegistry registry) {
        float boost = 1.0f;
        Integer paginationDepth = null;
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        QueryBuilder filter = null;
        String queryName = null;
        for (QueryContainer queryContainer : hybridQueryProto.getQueriesList()) {
            if (queries.size() == 5) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Number of sub-queries exceeds maximum supported by [%s] query", "hybrid"));
            }
            QueryBuilder queryBuilder = HybridQueryBuilderProtoUtils.parseInnerQueryBuilder(queryContainer, registry);
            if (queryBuilder == null) continue;
            queries.add(queryBuilder);
        }
        if (hybridQueryProto.hasFilter()) {
            filter = HybridQueryBuilderProtoUtils.parseInnerQueryBuilder(hybridQueryProto.getFilter(), registry);
        }
        if (hybridQueryProto.hasBoost() && (boost = hybridQueryProto.getBoost()) != 1.0f) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] query does not support [%s]", "hybrid", "boost"));
        }
        if (hybridQueryProto.hasXName()) {
            queryName = hybridQueryProto.getXName();
        }
        if (hybridQueryProto.hasPaginationDepth()) {
            paginationDepth = hybridQueryProto.getPaginationDepth();
        }
        if (queries.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] requires 'queries' field with at least one clause", "hybrid"));
        }
        HybridQueryBuilder compoundQueryBuilder = new HybridQueryBuilder();
        compoundQueryBuilder.queryName(queryName);
        compoundQueryBuilder.boost(boost);
        if (MinClusterVersionUtil.isClusterOnOrAfterMinReqVersionForPaginationInHybridQuery()) {
            compoundQueryBuilder.paginationDepth(paginationDepth);
        }
        boolean hasInnerHits = false;
        for (QueryBuilder query : queries) {
            if (filter == null) {
                compoundQueryBuilder.add(query);
            } else {
                compoundQueryBuilder.add(query.filter(filter));
            }
            if (hasInnerHits) continue;
            HashMap innerHits = new HashMap();
            InnerHitContextBuilder.extractInnerHits((QueryBuilder)query, innerHits);
            hasInnerHits = !innerHits.isEmpty();
        }
        boolean hasFilter = filter != null;
        boolean hasPagination = paginationDepth != null;
        HybridQueryBuilder.updateQueryStats(hasFilter, hasPagination, hasInnerHits);
        return compoundQueryBuilder;
    }

    private static QueryBuilder parseInnerQueryBuilder(QueryContainer queryContainer, QueryBuilderProtoConverterRegistry registry) {
        return registry.fromProto(queryContainer);
    }

    @Generated
    private HybridQueryBuilderProtoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

