/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.GetEmailGroupAction;
import org.opensearch.alerting.action.GetEmailGroupRequest;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/resthandler/RestGetEmailGroupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-alerting"})
public final class RestGetEmailGroupAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "get_email_group_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/{emailGroupID}", RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/{emailGroupID}"), new RestHandler.ReplacedRoute(RestRequest.Method.HEAD, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/{emailGroupID}", RestRequest.Method.HEAD, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/{emailGroupID}")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String emailGroupID = request.param("emailGroupID");
        if (emailGroupID == null || ((CharSequence)emailGroupID).length() == 0) {
            throw new IllegalArgumentException("Missing email group ID");
        }
        FetchSourceContext srcContext = RestHandlerUtilsKt.context(request);
        if (request.method() == RestRequest.Method.HEAD) {
            srcContext = FetchSourceContext.DO_NOT_FETCH_SOURCE;
        }
        long l = RestActions.parseVersion((RestRequest)request);
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        GetEmailGroupRequest getEmailGroupRequest = new GetEmailGroupRequest(emailGroupID, l, method, srcContext);
        return arg_0 -> RestGetEmailGroupAction.prepareRequest$lambda$0(client, getEmailGroupRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, GetEmailGroupRequest $getEmailGroupRequest, RestChannel channel) {
        $client.execute((ActionType)GetEmailGroupAction.Companion.getINSTANCE(), (ActionRequest)$getEmailGroupRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

