/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class DocsStats
implements Writeable,
ToXContentFragment {
    private long count = 0L;
    private long deleted = 0L;
    private long totalSizeInBytes = 0L;

    public DocsStats() {
    }

    private DocsStats(Builder builder) {
        this.count = builder.count;
        this.deleted = builder.deleted;
        this.totalSizeInBytes = builder.totalSizeInBytes;
    }

    public DocsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
        this.totalSizeInBytes = in.readVLong();
    }

    @Deprecated
    public DocsStats(long count, long deleted, long totalSizeInBytes) {
        this.count = count;
        this.deleted = deleted;
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public void add(DocsStats other) {
        if (other == null) {
            return;
        }
        if (this.totalSizeInBytes == -1L) {
            this.totalSizeInBytes = other.totalSizeInBytes;
        } else if (other.totalSizeInBytes != -1L) {
            this.totalSizeInBytes += other.totalSizeInBytes;
        }
        this.count += other.count;
        this.deleted += other.deleted;
    }

    public long getCount() {
        return this.count;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getAverageSizeInBytes() {
        long totalDocs = this.count + this.deleted;
        return totalDocs == 0L ? 0L : this.totalSizeInBytes / totalDocs;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
        out.writeVLong(this.totalSizeInBytes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("docs");
        builder.field("count", this.count);
        builder.field("deleted", this.deleted);
        builder.endObject();
        return builder;
    }

    public static class Builder {
        private long count = 0L;
        private long deleted = 0L;
        private long totalSizeInBytes = 0L;

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder deleted(long deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder totalSizeInBytes(long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public DocsStats build() {
            return new DocsStats(this);
        }
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String COUNT = "count";
        static final String DELETED = "deleted";

        Fields() {
        }
    }
}

