/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;

public final class DocsWithFieldSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocsWithFieldSet.class);
    private FixedBitSet set;
    private int cardinality = 0;
    private int lastDocId = -1;

    public void add(int docID) {
        if (docID <= this.lastDocId) {
            throw new IllegalArgumentException("Out of order doc ids: last=" + this.lastDocId + ", next=" + docID);
        }
        if (this.set != null) {
            this.set = FixedBitSet.ensureCapacity(this.set, docID);
            this.set.set(docID);
        } else if (docID != this.cardinality) {
            this.set = new FixedBitSet(docID + 1);
            this.set.set(0, this.cardinality);
            this.set.set(docID);
        }
        this.lastDocId = docID;
        ++this.cardinality;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.set == null ? 0L : this.set.ramBytesUsed());
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.set != null ? new BitSetIterator(this.set, this.cardinality) : DocIdSetIterator.all(this.cardinality);
    }

    public int cardinality() {
        return this.cardinality;
    }
}

