/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.Collector;
import org.opensearch.common.CheckedFunction;
import org.opensearch.search.aggregations.AggregationCollectorManager;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.query.ReduceableSearchResult;

public class GlobalAggCollectorManagerWithSingleCollector
extends AggregationCollectorManager {
    private final Collector collector = Objects.requireNonNull(super.newCollector(), "collector instance is null");
    private final String collectorName = this.collector.toString();

    public GlobalAggCollectorManagerWithSingleCollector(SearchContext context) throws IOException {
        super(context, (CheckedFunction<SearchContext, List<Aggregator>, IOException>)((CheckedFunction)context.aggregations().factories()::createTopLevelGlobalAggregators), "aggregation_global");
    }

    @Override
    public Collector newCollector() throws IOException {
        return this.collector;
    }

    @Override
    public ReduceableSearchResult reduce(Collection<Collector> collectors) throws IOException {
        assert (collectors.isEmpty()) : "Reduce on GlobalAggregationCollectorManagerWithCollector called with non-empty collectors";
        return super.reduce(List.of(this.collector));
    }

    @Override
    public String getCollectorName() {
        return this.collectorName;
    }
}

