/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.stats;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.3.0")
public class IndexingPressureStats
implements Writeable,
ToXContentFragment {
    private final long totalCombinedCoordinatingAndPrimaryBytes;
    private final long totalCoordinatingBytes;
    private final long totalPrimaryBytes;
    private final long totalReplicaBytes;
    private final long currentCombinedCoordinatingAndPrimaryBytes;
    private final long currentCoordinatingBytes;
    private final long currentPrimaryBytes;
    private final long currentReplicaBytes;
    private final long coordinatingRejections;
    private final long primaryRejections;
    private final long replicaRejections;
    private final long memoryLimit;
    private static final String COMBINED = "combined_coordinating_and_primary";
    private static final String COMBINED_IN_BYTES = "combined_coordinating_and_primary_in_bytes";
    private static final String COORDINATING = "coordinating";
    private static final String COORDINATING_IN_BYTES = "coordinating_in_bytes";
    private static final String PRIMARY = "primary";
    private static final String PRIMARY_IN_BYTES = "primary_in_bytes";
    private static final String REPLICA = "replica";
    private static final String REPLICA_IN_BYTES = "replica_in_bytes";
    private static final String ALL = "all";
    private static final String ALL_IN_BYTES = "all_in_bytes";
    private static final String COORDINATING_REJECTIONS = "coordinating_rejections";
    private static final String PRIMARY_REJECTIONS = "primary_rejections";
    private static final String REPLICA_REJECTIONS = "replica_rejections";
    private static final String LIMIT = "limit";
    private static final String LIMIT_IN_BYTES = "limit_in_bytes";

    private IndexingPressureStats(Builder builder) {
        this.totalCombinedCoordinatingAndPrimaryBytes = builder.totalCombinedCoordinatingAndPrimaryBytes;
        this.totalCoordinatingBytes = builder.totalCoordinatingBytes;
        this.totalPrimaryBytes = builder.totalPrimaryBytes;
        this.totalReplicaBytes = builder.totalReplicaBytes;
        this.currentCombinedCoordinatingAndPrimaryBytes = builder.currentCombinedCoordinatingAndPrimaryBytes;
        this.currentCoordinatingBytes = builder.currentCoordinatingBytes;
        this.currentPrimaryBytes = builder.currentPrimaryBytes;
        this.currentReplicaBytes = builder.currentReplicaBytes;
        this.coordinatingRejections = builder.coordinatingRejections;
        this.primaryRejections = builder.primaryRejections;
        this.replicaRejections = builder.replicaRejections;
        this.memoryLimit = builder.memoryLimit;
    }

    public IndexingPressureStats(StreamInput in) throws IOException {
        this.totalCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.totalCoordinatingBytes = in.readVLong();
        this.totalPrimaryBytes = in.readVLong();
        this.totalReplicaBytes = in.readVLong();
        this.currentCombinedCoordinatingAndPrimaryBytes = in.readVLong();
        this.currentCoordinatingBytes = in.readVLong();
        this.currentPrimaryBytes = in.readVLong();
        this.currentReplicaBytes = in.readVLong();
        this.coordinatingRejections = in.readVLong();
        this.primaryRejections = in.readVLong();
        this.replicaRejections = in.readVLong();
        this.memoryLimit = in.readVLong();
    }

    @Deprecated
    public IndexingPressureStats(long totalCombinedCoordinatingAndPrimaryBytes, long totalCoordinatingBytes, long totalPrimaryBytes, long totalReplicaBytes, long currentCombinedCoordinatingAndPrimaryBytes, long currentCoordinatingBytes, long currentPrimaryBytes, long currentReplicaBytes, long coordinatingRejections, long primaryRejections, long replicaRejections, long memoryLimit) {
        this.totalCombinedCoordinatingAndPrimaryBytes = totalCombinedCoordinatingAndPrimaryBytes;
        this.totalCoordinatingBytes = totalCoordinatingBytes;
        this.totalPrimaryBytes = totalPrimaryBytes;
        this.totalReplicaBytes = totalReplicaBytes;
        this.currentCombinedCoordinatingAndPrimaryBytes = currentCombinedCoordinatingAndPrimaryBytes;
        this.currentCoordinatingBytes = currentCoordinatingBytes;
        this.currentPrimaryBytes = currentPrimaryBytes;
        this.currentReplicaBytes = currentReplicaBytes;
        this.coordinatingRejections = coordinatingRejections;
        this.primaryRejections = primaryRejections;
        this.replicaRejections = replicaRejections;
        this.memoryLimit = memoryLimit;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.totalCoordinatingBytes);
        out.writeVLong(this.totalPrimaryBytes);
        out.writeVLong(this.totalReplicaBytes);
        out.writeVLong(this.currentCombinedCoordinatingAndPrimaryBytes);
        out.writeVLong(this.currentCoordinatingBytes);
        out.writeVLong(this.currentPrimaryBytes);
        out.writeVLong(this.currentReplicaBytes);
        out.writeVLong(this.coordinatingRejections);
        out.writeVLong(this.primaryRejections);
        out.writeVLong(this.replicaRejections);
        out.writeVLong(this.memoryLimit);
    }

    public long getTotalCombinedCoordinatingAndPrimaryBytes() {
        return this.totalCombinedCoordinatingAndPrimaryBytes;
    }

    public long getTotalCoordinatingBytes() {
        return this.totalCoordinatingBytes;
    }

    public long getTotalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public long getTotalReplicaBytes() {
        return this.totalReplicaBytes;
    }

    public long getCurrentCombinedCoordinatingAndPrimaryBytes() {
        return this.currentCombinedCoordinatingAndPrimaryBytes;
    }

    public long getCurrentCoordinatingBytes() {
        return this.currentCoordinatingBytes;
    }

    public long getCurrentPrimaryBytes() {
        return this.currentPrimaryBytes;
    }

    public long getCurrentReplicaBytes() {
        return this.currentReplicaBytes;
    }

    public long getCoordinatingRejections() {
        return this.coordinatingRejections;
    }

    public long getPrimaryRejections() {
        return this.primaryRejections;
    }

    public long getReplicaRejections() {
        return this.replicaRejections;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing_pressure");
        builder.startObject("memory");
        builder.startObject("current");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, (Object)new ByteSizeValue(this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, (Object)new ByteSizeValue(this.currentCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, (Object)new ByteSizeValue(this.currentPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, (Object)new ByteSizeValue(this.currentReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, (Object)new ByteSizeValue(this.currentReplicaBytes + this.currentCombinedCoordinatingAndPrimaryBytes));
        builder.endObject();
        builder.startObject("total");
        builder.humanReadableField(COMBINED_IN_BYTES, COMBINED, (Object)new ByteSizeValue(this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.humanReadableField(COORDINATING_IN_BYTES, COORDINATING, (Object)new ByteSizeValue(this.totalCoordinatingBytes));
        builder.humanReadableField(PRIMARY_IN_BYTES, PRIMARY, (Object)new ByteSizeValue(this.totalPrimaryBytes));
        builder.humanReadableField(REPLICA_IN_BYTES, REPLICA, (Object)new ByteSizeValue(this.totalReplicaBytes));
        builder.humanReadableField(ALL_IN_BYTES, ALL, (Object)new ByteSizeValue(this.totalReplicaBytes + this.totalCombinedCoordinatingAndPrimaryBytes));
        builder.field(COORDINATING_REJECTIONS, this.coordinatingRejections);
        builder.field(PRIMARY_REJECTIONS, this.primaryRejections);
        builder.field(REPLICA_REJECTIONS, this.replicaRejections);
        builder.endObject();
        builder.humanReadableField(LIMIT_IN_BYTES, LIMIT, (Object)new ByteSizeValue(this.memoryLimit));
        builder.endObject();
        return builder.endObject();
    }

    public static class Builder {
        private long totalCombinedCoordinatingAndPrimaryBytes = 0L;
        private long totalCoordinatingBytes = 0L;
        private long totalPrimaryBytes = 0L;
        private long totalReplicaBytes = 0L;
        private long currentCombinedCoordinatingAndPrimaryBytes = 0L;
        private long currentCoordinatingBytes = 0L;
        private long currentPrimaryBytes = 0L;
        private long currentReplicaBytes = 0L;
        private long coordinatingRejections = 0L;
        private long primaryRejections = 0L;
        private long replicaRejections = 0L;
        private long memoryLimit = 0L;

        public Builder totalCombinedCoordinatingAndPrimaryBytes(long bytes) {
            this.totalCombinedCoordinatingAndPrimaryBytes = bytes;
            return this;
        }

        public Builder totalCoordinatingBytes(long bytes) {
            this.totalCoordinatingBytes = bytes;
            return this;
        }

        public Builder totalPrimaryBytes(long bytes) {
            this.totalPrimaryBytes = bytes;
            return this;
        }

        public Builder totalReplicaBytes(long bytes) {
            this.totalReplicaBytes = bytes;
            return this;
        }

        public Builder currentCombinedCoordinatingAndPrimaryBytes(long bytes) {
            this.currentCombinedCoordinatingAndPrimaryBytes = bytes;
            return this;
        }

        public Builder currentCoordinatingBytes(long bytes) {
            this.currentCoordinatingBytes = bytes;
            return this;
        }

        public Builder currentPrimaryBytes(long bytes) {
            this.currentPrimaryBytes = bytes;
            return this;
        }

        public Builder currentReplicaBytes(long bytes) {
            this.currentReplicaBytes = bytes;
            return this;
        }

        public Builder coordinatingRejections(long rejections) {
            this.coordinatingRejections = rejections;
            return this;
        }

        public Builder primaryRejections(long rejections) {
            this.primaryRejections = rejections;
            return this;
        }

        public Builder replicaRejections(long rejections) {
            this.replicaRejections = rejections;
            return this;
        }

        public Builder memoryLimit(long limit) {
            this.memoryLimit = limit;
            return this;
        }

        public IndexingPressureStats build() {
            return new IndexingPressureStats(this);
        }
    }
}

