/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.network.RequestChannel;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaManager;
import org.apache.kafka.server.quota.ControllerMutationQuota;
import org.apache.kafka.server.quota.ThrottleCallback;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%e\u0001\u0002\n\u0014\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00051\nC\u0003g\u0001\u0011\u0005q\rC\u0003u\u0001\u0011%Q\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fB\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015%\u0001\u0006*fcV,7\u000f\u001e%b]\u0012dWM\u001d%fYB,'O\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u000fe\u0016\fX/Z:u\u0007\"\fgN\\3m!\t\tC%D\u0001#\u0015\t\u0019S#A\u0004oKR<xN]6\n\u0005\u0015\u0012#A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0007cV|G/Y:\u0011\u0005!\u0012dBA\u00151\u001d\tQsF\u0004\u0002,]5\tAF\u0003\u0002./\u00051AH]8pizJ\u0011AF\u0005\u0003)UI!!M\n\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005M\"$!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u00022'\u0005!A/[7f!\t9\u0014)D\u00019\u0015\tI$(A\u0003vi&d7O\u0003\u0002<y\u000511m\\7n_:T!AF\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005b\u0012A\u0001V5nK\u00061A(\u001b8jiz\"B!R$I\u0013B\u0011a\tA\u0007\u0002'!)q\u0004\u0002a\u0001A!)a\u0005\u0002a\u0001O!)Q\u0007\u0002a\u0001m\u0005AA\u000f\u001b:piRdW\r\u0006\u0003M\u001fb\u000b\u0007C\u0001\u000eN\u0013\tq5D\u0001\u0003V]&$\b\"\u0002)\u0006\u0001\u0004\t\u0016\u0001D9v_R\fW*\u00198bO\u0016\u0014\bC\u0001*W\u001b\u0005\u0019&B\u0001+V\u0003\u0015\tXo\u001c;b\u0015\t!B(\u0003\u0002X'\n\u00112\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u0015IV\u00011\u0001[\u0003\u001d\u0011X-];fgR\u0004\"a\u00170\u000f\u0005\u0005b\u0016BA/#\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!a\u00181\u0003\u000fI+\u0017/^3ti*\u0011QL\t\u0005\u0006E\u0016\u0001\raY\u0001\u000fi\"\u0014x\u000e\u001e;mKRKW.Z't!\tQB-\u0003\u0002f7\t\u0019\u0011J\u001c;\u0002\u0017!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u000b\u0004\u0019\"L\u0007\"B-\u0007\u0001\u0004Q\u0006\"\u00026\u0007\u0001\u0004Y\u0017!A3\u0011\u00051\fhBA7p\u001d\tYc.C\u0001\u001d\u0013\t\u00018$A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001c(!\u0003+ie><\u0018M\u00197f\u0015\t\u00018$\u0001\u000etK:$WI\u001d:pe>\u00138\t\\8tK\u000e{gN\\3di&|g\u000e\u0006\u0003Mm^L\b\"B-\b\u0001\u0004Q\u0006\"\u0002=\b\u0001\u0004Y\u0017!B3se>\u0014\b\"\u0002>\b\u0001\u0004\u0019\u0017A\u0003;ie>$H\u000f\\3Ng\u0006)2/\u001a8e\r>\u0014x/\u0019:eK\u0012\u0014Vm\u001d9p]N,Gc\u0001'~}\")\u0011\f\u0003a\u00015\"1q\u0010\u0003a\u0001\u0003\u0003\t\u0001B]3ta>t7/\u001a\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u001e\u0002\u0011I,\u0017/^3tiNLA!a\u0003\u0002\u0006\t\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/Z\u0001\u0012g\u0016tG-T1zE\u0016$\u0006N]8ui2,G#\u0002'\u0002\u0012\u0005M\u0001\"B-\n\u0001\u0004Q\u0006BB@\n\u0001\u0004\t\t!A\rtK:$'+Z:q_:\u001cX-T1zE\u0016$\u0006N]8ui2,G#\u0002'\u0002\u001a\u0005m\u0001\"B-\u000b\u0001\u0004Q\u0006bBA\u000f\u0015\u0001\u0007\u0011qD\u0001\u000fGJ,\u0017\r^3SKN\u0004xN\\:f!\u0019Q\u0012\u0011E2\u0002\u0002%\u0019\u00111E\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0014AH:f]\u0012,%O]8s%\u0016\u001c\bo\u001c8tK6\u000b\u0017PY3UQJ|G\u000f\u001e7f)\u0015a\u0015\u0011FA\u0016\u0011\u0015I6\u00021\u0001[\u0011\u0015A8\u00021\u0001l\u0003}i\u0017-\u001f2f%\u0016\u001cwN\u001d3B]\u0012<U\r\u001e+ie>$H\u000f\\3US6,Wj\u001d\u000b\u0004G\u0006E\u0002\"B-\r\u0001\u0004Q\u0016\u0001L:f]\u0012\u0014Vm\u001d9p]N,W*Y=cKRC'o\u001c;uY\u0016<\u0016\u000e\u001e5D_:$(o\u001c7mKJ\fVo\u001c;b)\u001da\u0015qGA!\u0003\u0007Bq!!\u000f\u000e\u0001\u0004\tY$A\fd_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uCB\u0019!+!\u0010\n\u0007\u0005}2KA\fD_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC\")\u0011,\u0004a\u00015\"1q0\u0004a\u0001\u0003\u0003\t!d]3oIJ+7\u000f]8og\u0016,\u00050Z7qiRC'o\u001c;uY\u0016$r\u0001TA%\u0003\u0017\ni\u0005C\u0003Z\u001d\u0001\u0007!\f\u0003\u0004\u0000\u001d\u0001\u0007\u0011\u0011\u0001\u0005\n\u0003\u001fr\u0001\u0013!a\u0001\u0003#\n!b\u001c8D_6\u0004H.\u001a;f!\u0015Q\u00121KA,\u0013\r\t)f\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\ri\t\t#!\u0017M!\u0011\tY&a\u0018\u000e\u0005\u0005u#BA\u0012;\u0013\u0011\t\t'!\u0018\u0003\tM+g\u000eZ\u0001%g\u0016tGMU3ta>t7/Z#yK6\u0004H\u000f\u00165s_R$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\r\u0016\u0005\u0003#\nIg\u000b\u0002\u0002lA!\u0011QNA<\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014!C;oG\",7m[3e\u0015\r\t)hG\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA=\u0003_\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003}\u0019XM\u001c3FeJ|'OU3ta>t7/Z#yK6\u0004H\u000f\u00165s_R$H.\u001a\u000b\u0006\u0019\u0006}\u0014\u0011\u0011\u0005\u00063B\u0001\rA\u0017\u0005\u0006qB\u0001\ra[\u0001\u001fg\u0016tGMT8PaJ+7\u000f]8og\u0016,\u00050Z7qiRC'o\u001c;uY\u0016$2\u0001TAD\u0011\u0015I\u0016\u00031\u0001[\u0001")
public class RequestHandlerHelper {
    public final RequestChannel kafka$server$RequestHandlerHelper$$requestChannel;
    private final QuotaFactory.QuotaManagers quotas;
    private final Time time;

    public void throttle(ClientQuotaManager quotaManager, RequestChannel.Request request, int throttleTimeMs) {
        ThrottleCallback callback = new ThrottleCallback(this, request){
            private final /* synthetic */ RequestHandlerHelper $outer;
            private final RequestChannel.Request request$1;

            public void startThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.startThrottling(this.request$1);
            }

            public void endThrottling() {
                this.$outer.kafka$server$RequestHandlerHelper$$requestChannel.endThrottling(this.request$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.request$1 = request$1;
            }
        };
        quotaManager.throttle(request.header().clientId(), request.session(), callback, throttleTimeMs);
    }

    public void handleError(RequestChannel.Request request, Throwable e) {
        if (e instanceof ClusterAuthorizationException || !request.header().apiKey().clusterAction) {
            this.sendErrorResponseMaybeThrottle(request, e);
            return;
        }
        this.sendErrorResponseExemptThrottle(request, e);
    }

    private void sendErrorOrCloseConnection(RequestChannel.Request request, Throwable error, int throttleMs) {
        Object requestBody = request.body(ClassTag$.MODULE$.apply(AbstractRequest.class));
        AbstractResponse response = requestBody.getErrorResponse(throttleMs, error);
        if (response == null) {
            this.kafka$server$RequestHandlerHelper$$requestChannel.closeConnection(request, requestBody.errorCounts(error));
            return;
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendForwardedResponse(RequestChannel.Request request, AbstractResponse response) {
        int controllerThrottleTimeMs = response.throttleTimeMs();
        int requestThrottleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        int appliedThrottleTimeMs = package$.MODULE$.max(controllerThrottleTimeMs, requestThrottleTimeMs);
        this.throttle(this.quotas.request(), request, appliedThrottleTimeMs);
        response.maybeSetThrottleTimeMs(appliedThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendMaybeThrottle(RequestChannel.Request request, AbstractResponse response) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        response.maybeSetThrottleTimeMs(throttleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseMaybeThrottle(RequestChannel.Request request, Function1<Object, AbstractResponse> createResponse) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (!request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, (AbstractResponse)createResponse.apply((Object)BoxesRunTime.boxToInteger((int)throttleTimeMs)), (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendErrorResponseMaybeThrottle(RequestChannel.Request request, Throwable error) {
        int throttleTimeMs = this.maybeRecordAndGetThrottleTimeMs(request);
        if (error instanceof ClusterAuthorizationException || !request.isForwarded()) {
            this.throttle(this.quotas.request(), request, throttleTimeMs);
        }
        this.sendErrorOrCloseConnection(request, error, throttleTimeMs);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int throttleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, this.time.milliseconds());
        request.apiThrottleTimeMs_$eq(throttleTimeMs);
        return throttleTimeMs;
    }

    public void sendResponseMaybeThrottleWithControllerQuota(ControllerMutationQuota controllerMutationQuota, RequestChannel.Request request, AbstractResponse response) {
        int requestThrottleTimeMs;
        long timeMs = this.time.milliseconds();
        int controllerThrottleTimeMs = controllerMutationQuota.throttleTime();
        int maxThrottleTimeMs = Math.max(controllerThrottleTimeMs, requestThrottleTimeMs = this.quotas.request().maybeRecordAndGetThrottleTimeMs(request, timeMs));
        if (maxThrottleTimeMs > 0 && !request.isForwarded()) {
            request.apiThrottleTimeMs_$eq(maxThrottleTimeMs);
            if (controllerThrottleTimeMs > requestThrottleTimeMs) {
                this.throttle((ClientQuotaManager)this.quotas.controllerMutation(), request, controllerThrottleTimeMs);
            } else {
                this.throttle(this.quotas.request(), request, requestThrottleTimeMs);
            }
        }
        response.maybeSetThrottleTimeMs(maxThrottleTimeMs);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, (Option<Function1<Send, BoxedUnit>>)None$.MODULE$);
    }

    public void sendResponseExemptThrottle(RequestChannel.Request request, AbstractResponse response, Option<Function1<Send, BoxedUnit>> onComplete) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendResponse(request, response, onComplete);
    }

    public Option<Function1<Send, BoxedUnit>> sendResponseExemptThrottle$default$3() {
        return None$.MODULE$;
    }

    private void sendErrorResponseExemptThrottle(RequestChannel.Request request, Throwable error) {
        this.quotas.request().maybeRecordExempt(request);
        this.sendErrorOrCloseConnection(request, error, 0);
    }

    public void sendNoOpResponseExemptThrottle(RequestChannel.Request request) {
        this.quotas.request().maybeRecordExempt(request);
        this.kafka$server$RequestHandlerHelper$$requestChannel.sendNoOpResponse(request);
    }

    public RequestHandlerHelper(RequestChannel requestChannel, QuotaFactory.QuotaManagers quotas, Time time) {
        this.kafka$server$RequestHandlerHelper$$requestChannel = requestChannel;
        this.quotas = quotas;
        this.time = time;
    }
}

