/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.ConfigUtils;

public final class TopicBasedRemoteLogMetadataManagerConfig {
    public static final String REMOTE_LOG_METADATA_TOPIC_NAME = "__remote_log_metadata";
    public static final String REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR_PROP = "remote.log.metadata.topic.replication.factor";
    public static final String REMOTE_LOG_METADATA_TOPIC_PARTITIONS_PROP = "remote.log.metadata.topic.num.partitions";
    public static final String REMOTE_LOG_METADATA_TOPIC_RETENTION_MS_PROP = "remote.log.metadata.topic.retention.ms";
    public static final String REMOTE_LOG_METADATA_CONSUME_WAIT_MS_PROP = "remote.log.metadata.consume.wait.ms";
    public static final String REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS_PROP = "remote.log.metadata.initialization.retry.max.timeout.ms";
    public static final String REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS_PROP = "remote.log.metadata.initialization.retry.interval.ms";
    public static final int DEFAULT_REMOTE_LOG_METADATA_TOPIC_PARTITIONS = 50;
    public static final long DEFAULT_REMOTE_LOG_METADATA_TOPIC_RETENTION_MS = -1L;
    public static final short DEFAULT_REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR = 3;
    public static final long DEFAULT_REMOTE_LOG_METADATA_CONSUME_WAIT_MS = 120000L;
    public static final long DEFAULT_REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS = 120000L;
    public static final long DEFAULT_REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS = 100L;
    public static final String REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor of remote log metadata topic.";
    public static final String REMOTE_LOG_METADATA_TOPIC_PARTITIONS_DOC = "The number of partitions for remote log metadata topic.";
    public static final String REMOTE_LOG_METADATA_TOPIC_RETENTION_MS_DOC = "Retention of remote log metadata topic in milliseconds. Default: -1, that means unlimited. Users can configure this value based on their use cases. To avoid any data loss, this value should be more than the maximum retention period of any topic enabled with tiered storage in the cluster.";
    public static final String REMOTE_LOG_METADATA_CONSUME_WAIT_MS_DOC = "The amount of time in milliseconds to wait for the local consumer to receive the published event.";
    public static final String REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS_DOC = "The retry interval in milliseconds for retrying RemoteLogMetadataManager resources initialization again.";
    public static final String REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS_DOC = "The maximum amount of time in milliseconds for retrying RemoteLogMetadataManager resources initialization. For TopicBasedRemoteLogMetadataManager's initialization, the timer starts after this local broker is ready to process requests (primarily for ensuring the local cluster is ready when metadata is stored locally as an internal topic). If initialization fails within this timeout, this broker process will terminate.";
    public static final String REMOTE_LOG_METADATA_COMMON_CLIENT_PREFIX = "remote.log.metadata.common.client.";
    public static final String REMOTE_LOG_METADATA_PRODUCER_PREFIX = "remote.log.metadata.producer.";
    public static final String REMOTE_LOG_METADATA_CONSUMER_PREFIX = "remote.log.metadata.consumer.";
    public static final String BROKER_ID = "broker.id";
    public static final String LOG_DIR = "log.dir";
    private static final String REMOTE_LOG_METADATA_CLIENT_PREFIX = "__remote_log_metadata_client";
    private static final ConfigDef CONFIG = new ConfigDef();
    private final String clientIdPrefix;
    private final int metadataTopicPartitionsCount;
    private final String logDir;
    private final long consumeWaitMs;
    private final long metadataTopicRetentionMs;
    private final short metadataTopicReplicationFactor;
    private final long initializationRetryMaxTimeoutMs;
    private final long initializationRetryIntervalMs;
    private Map<String, Object> commonProps;
    private Map<String, Object> consumerProps;
    private Map<String, Object> producerProps;

    public TopicBasedRemoteLogMetadataManagerConfig(Map<String, ?> props) {
        Objects.requireNonNull(props, "props can not be null");
        Map parsedConfigs = CONFIG.parse(props);
        this.logDir = (String)props.get(LOG_DIR);
        if (this.logDir == null || this.logDir.isEmpty()) {
            throw new IllegalArgumentException("log.dir config must not be null or empty.");
        }
        this.metadataTopicPartitionsCount = (Integer)parsedConfigs.get(REMOTE_LOG_METADATA_TOPIC_PARTITIONS_PROP);
        this.metadataTopicReplicationFactor = (Short)parsedConfigs.get(REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR_PROP);
        this.metadataTopicRetentionMs = (Long)parsedConfigs.get(REMOTE_LOG_METADATA_TOPIC_RETENTION_MS_PROP);
        if (this.metadataTopicRetentionMs != -1L && this.metadataTopicRetentionMs <= 0L) {
            throw new IllegalArgumentException("Invalid metadata topic retention in millis: " + this.metadataTopicRetentionMs);
        }
        this.consumeWaitMs = (Long)parsedConfigs.get(REMOTE_LOG_METADATA_CONSUME_WAIT_MS_PROP);
        this.initializationRetryIntervalMs = (Long)parsedConfigs.get(REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS_PROP);
        this.initializationRetryMaxTimeoutMs = (Long)parsedConfigs.get(REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS_PROP);
        this.clientIdPrefix = "__remote_log_metadata_client_" + String.valueOf(props.get(BROKER_ID));
        this.initializeProducerConsumerProperties(props);
    }

    private void initializeProducerConsumerProperties(Map<String, ?> configs) {
        HashMap commonClientConfigs = new HashMap();
        HashMap producerOnlyConfigs = new HashMap();
        HashMap consumerOnlyConfigs = new HashMap();
        for (Map.Entry<String, ?> entry : configs.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith(REMOTE_LOG_METADATA_COMMON_CLIENT_PREFIX)) {
                commonClientConfigs.put(key.substring(REMOTE_LOG_METADATA_COMMON_CLIENT_PREFIX.length()), entry.getValue());
                continue;
            }
            if (key.startsWith(REMOTE_LOG_METADATA_PRODUCER_PREFIX)) {
                producerOnlyConfigs.put(key.substring(REMOTE_LOG_METADATA_PRODUCER_PREFIX.length()), entry.getValue());
                continue;
            }
            if (!key.startsWith(REMOTE_LOG_METADATA_CONSUMER_PREFIX)) continue;
            consumerOnlyConfigs.put(key.substring(REMOTE_LOG_METADATA_CONSUMER_PREFIX.length()), entry.getValue());
        }
        this.commonProps = new HashMap<String, Object>(commonClientConfigs);
        HashMap<String, Object> allProducerConfigs = new HashMap<String, Object>(commonClientConfigs);
        allProducerConfigs.putAll(producerOnlyConfigs);
        this.producerProps = this.createProducerProps(allProducerConfigs);
        HashMap<String, Object> allConsumerConfigs = new HashMap<String, Object>(commonClientConfigs);
        allConsumerConfigs.putAll(consumerOnlyConfigs);
        this.consumerProps = this.createConsumerProps(allConsumerConfigs);
    }

    public String remoteLogMetadataTopicName() {
        return REMOTE_LOG_METADATA_TOPIC_NAME;
    }

    public int metadataTopicPartitionsCount() {
        return this.metadataTopicPartitionsCount;
    }

    public short metadataTopicReplicationFactor() {
        return this.metadataTopicReplicationFactor;
    }

    public long metadataTopicRetentionMs() {
        return this.metadataTopicRetentionMs;
    }

    public long consumeWaitMs() {
        return this.consumeWaitMs;
    }

    public long initializationRetryMaxTimeoutMs() {
        return this.initializationRetryMaxTimeoutMs;
    }

    public long initializationRetryIntervalMs() {
        return this.initializationRetryIntervalMs;
    }

    public String logDir() {
        return this.logDir;
    }

    public Map<String, Object> commonProperties() {
        return this.commonProps;
    }

    public Map<String, Object> consumerProperties() {
        return this.consumerProps;
    }

    public Map<String, Object> producerProperties() {
        return this.producerProps;
    }

    private Map<String, Object> createConsumerProps(Map<String, Object> allConsumerConfigs) {
        HashMap<String, Object> props = new HashMap<String, Object>(allConsumerConfigs);
        props.put("client.id", this.clientIdPrefix + "_consumer");
        props.put("enable.auto.commit", false);
        props.put("auto.offset.reset", "earliest");
        props.put("exclude.internal.topics", false);
        props.put("key.deserializer", ByteArrayDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        return props;
    }

    private Map<String, Object> createProducerProps(Map<String, Object> allProducerConfigs) {
        HashMap<String, Object> props = new HashMap<String, Object>(allProducerConfigs);
        props.put("client.id", this.clientIdPrefix + "_producer");
        props.put("acks", "all");
        props.put("enable.idempotence", true);
        props.put("key.serializer", ByteArraySerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        return Collections.unmodifiableMap(props);
    }

    public String toString() {
        return "TopicBasedRemoteLogMetadataManagerConfig{clientIdPrefix='" + this.clientIdPrefix + "', metadataTopicPartitionsCount=" + this.metadataTopicPartitionsCount + ", consumeWaitMs=" + this.consumeWaitMs + ", metadataTopicRetentionMs=" + this.metadataTopicRetentionMs + ", metadataTopicReplicationFactor=" + this.metadataTopicReplicationFactor + ", initializationRetryMaxTimeoutMs=" + this.initializationRetryMaxTimeoutMs + ", initializationRetryIntervalMs=" + this.initializationRetryIntervalMs + ", commonProps=" + ConfigUtils.configMapToRedactedString(this.commonProps, (ConfigDef)AdminClientConfig.configDef()) + ", consumerProps=" + ConfigUtils.configMapToRedactedString(this.consumerProps, (ConfigDef)ConsumerConfig.configDef()) + ", producerProps=" + ConfigUtils.configMapToRedactedString(this.producerProps, (ConfigDef)ProducerConfig.configDef()) + "}";
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toHtml(4, config -> "remote_log_metadata_manager_" + config));
    }

    static {
        CONFIG.define(REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR_PROP, ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_TOPIC_REPLICATION_FACTOR_DOC).define(REMOTE_LOG_METADATA_TOPIC_PARTITIONS_PROP, ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_TOPIC_PARTITIONS_DOC).define(REMOTE_LOG_METADATA_TOPIC_RETENTION_MS_PROP, ConfigDef.Type.LONG, (Object)-1L, ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_TOPIC_RETENTION_MS_DOC).define(REMOTE_LOG_METADATA_CONSUME_WAIT_MS_PROP, ConfigDef.Type.LONG, (Object)120000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_CONSUME_WAIT_MS_DOC).define(REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS_PROP, ConfigDef.Type.LONG, (Object)120000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_INITIALIZATION_RETRY_MAX_TIMEOUT_MS_DOC).define(REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS_PROP, ConfigDef.Type.LONG, (Object)100L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, REMOTE_LOG_METADATA_INITIALIZATION_RETRY_INTERVAL_MS_DOC);
    }
}

