/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    @NotNull
    @NlsSafe
    protected final String myName;
    @NotNull
    @NlsSafe
    protected final String myPath;
    @Nullable
    private final VirtualFile myParent;
    @NlsSafe
    protected String myRevision;
    protected int myModificationStamp;

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    protected AbstractVcsVirtualFile(@NotNull @NlsSafe String path, @NotNull VirtualFileSystem ignored) {
        if (path == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(0);
        }
        if (ignored == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(1);
        }
        this(path);
    }

    protected AbstractVcsVirtualFile(@NotNull @NlsSafe String path) {
        if (path == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(2);
        }
        this.myModificationStamp = 0;
        this.myPath = path;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), (VirtualFile)this) : null;
        SyntheticPsiFileSupport.markFile((VirtualFile)this);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull String name, @NotNull VirtualFileSystem ignored) {
        if (name == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(3);
        }
        if (ignored == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(4);
        }
        this(parent, name);
    }

    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull String name) {
        if (name == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(5);
        }
        this.myModificationStamp = 0;
        this.myPath = parent != null && !StringUtil.isEmpty((String)parent.getPath()) ? parent.getPath() + "/" + name : name;
        this.myName = name;
        this.myParent = parent;
        SyntheticPsiFileSupport.markFile((VirtualFile)this);
    }

    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull FilePath path) {
        if (path == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(6);
        }
        this.myModificationStamp = 0;
        this.myPath = path.getPath();
        this.myName = path.getName();
        this.myParent = parent;
        AbstractVcsVirtualFile.markSyntheticFile(this, path);
    }

    protected AbstractVcsVirtualFile(@NotNull FilePath path) {
        if (path == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(7);
        }
        this.myModificationStamp = 0;
        this.myPath = path.getPath();
        this.myName = path.getName();
        FilePath parentPath = !this.isDirectory() ? path.getParentPath() : null;
        this.myParent = parentPath != null ? new VcsVirtualFolder(parentPath, (VirtualFile)this) : null;
        AbstractVcsVirtualFile.markSyntheticFile(this, path);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VcsFileSystem vcsFileSystem = VcsFileSystem.getInstance();
        if (vcsFileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(8);
        }
        return vcsFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getPresentableName(this.myName);
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @Nls
    protected String getPresentableName(@NotNull @Nls String baseName) {
        if (baseName == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(12);
        }
        if (this.myRevision == null) {
            String string = baseName;
            if (string == null) {
                AbstractVcsVirtualFile.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = baseName + " (" + this.myRevision + ")";
        if (string == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
        if (inputStream == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(15);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new RuntimeException(VcsFileSystem.getCouldNotImplementMessage());
    }

    public abstract byte @NotNull [] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void showLoadingContentFailedMessage(@NotNull VcsException e) {
        if (e == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message((String)"message.text.could.not.load.virtual.file.content", (Object[])new Object[]{this.getPresentableUrl(), e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.could.not.load.content", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()));
    }

    private static void markSyntheticFile(@NotNull VirtualFile file, @Nullable FilePath originalPath) {
        if (file == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(17);
        }
        SyntheticPsiFileSupport.markFile((VirtualFile)file, (String)(originalPath != null ? originalPath.getPath() : null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showLoadingContentFailedMessage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markSyntheticFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

