/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;

public class XmlVcsSelectionProvider
implements VcsSelectionProvider {
    public VcsSelection getSelection(@NotNull DataContext context) {
        String actionName;
        Editor editor;
        if (context == null) {
            XmlVcsSelectionProvider.$$$reportNull$$$0(0);
        }
        if ((editor = (Editor)context.getData(CommonDataKeys.EDITOR)) == null) {
            return null;
        }
        PsiElement psiElement = TargetElementUtil.findTargetElement((Editor)editor, (int)2);
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        if (psiElement instanceof XmlTag) {
            actionName = XmlBundle.message("action.name.show.history.for.tag", new Object[0]);
        } else if (psiElement instanceof XmlText) {
            actionName = XmlBundle.message("action.name.show.history.for.text", new Object[0]);
        } else {
            return null;
        }
        TextRange textRange = psiElement.getTextRange();
        if (textRange == null) {
            return null;
        }
        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        return new VcsSelection(document, textRange, actionName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/vcsUtil/XmlVcsSelectionProvider", "getSelection"));
    }
}

