/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;

public final class ExternalProcessUtil {
    private static final Logger LOG = Logger.getInstance(ExternalProcessUtil.class);

    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams) {
        return ExternalProcessUtil.buildJavaCommandLine(javaExecutable, mainClass, bootClasspath, classpath, vmParams, programParams, true);
    }

    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams, boolean shortenClasspath) {
        return ExternalProcessUtil.buildJavaCommandLine(javaExecutable, mainClass, bootClasspath, classpath, vmParams, programParams, shortenClasspath, true);
    }

    public static List<String> buildJavaCommandLine(String javaExecutable, String mainClass, List<String> bootClasspath, List<String> classpath, List<String> vmParams, List<String> programParams, boolean shortenClasspath, boolean preferClasspathJar) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(javaExecutable);
        cmdLine.addAll(vmParams);
        if (!bootClasspath.isEmpty()) {
            cmdLine.add("-bootclasspath");
            cmdLine.add(StringUtil.join(bootClasspath, (String)File.pathSeparator));
        }
        if (!classpath.isEmpty()) {
            List<Object> shortenedCp = null;
            if (shortenClasspath) {
                try {
                    Charset cs = Charset.defaultCharset();
                    if (ExternalProcessUtil.isModularRuntime(javaExecutable)) {
                        List<String> args = Arrays.asList("-classpath", StringUtil.join(classpath, (String)File.pathSeparator));
                        File argFile = CommandLineWrapperUtil.createArgumentFile(args, (Charset)cs);
                        shortenedCp = Collections.singletonList("@" + argFile.getAbsolutePath());
                    } else if (preferClasspathJar) {
                        File classpathJar = CommandLineWrapperUtil.createClasspathJarFile((Manifest)new Manifest(), classpath);
                        shortenedCp = Arrays.asList("-classpath", classpathJar.getAbsolutePath());
                    } else {
                        Class<?> wrapperClass = CommandLineWrapperClassHolder.ourWrapperClass;
                        if (wrapperClass != null) {
                            File classpathFile = CommandLineWrapperUtil.createWrapperFile(classpath, (Charset)cs);
                            shortenedCp = Arrays.asList("-classpath", ClasspathBootstrap.getResourcePath(wrapperClass), wrapperClass.getName(), classpathFile.getAbsolutePath());
                        } else {
                            LOG.info("CommandLineWrapper class not found; classpath shortening won't be used");
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("can't create temp file; classpath shortening won't be used", (Throwable)e);
                }
            }
            if (shortenedCp != null) {
                cmdLine.addAll(shortenedCp);
            } else {
                cmdLine.add("-classpath");
                cmdLine.add(StringUtil.join(classpath, (String)File.pathSeparator));
            }
        }
        cmdLine.add(mainClass);
        cmdLine.addAll(programParams);
        return cmdLine;
    }

    private static boolean isModularRuntime(String javaExec) {
        File jreHome = new File(javaExec).getParentFile().getParentFile();
        return jreHome != null && (new File(jreHome, "lib/jrt-fs.jar").isFile() || new File(jreHome, "modules/java.base").isDirectory());
    }

    private static final class CommandLineWrapperClassHolder {
        static final Class<?> ourWrapperClass;

        private CommandLineWrapperClassHolder() {
        }

        static {
            Class<?> aClass = null;
            try {
                aClass = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ourWrapperClass = aClass;
        }
    }
}

