/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.diff;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.jetbrains.jps.dependency.diff.Difference;

public interface DiffCapable<T extends DiffCapable<T, D>, D extends Difference> {
    public boolean isSame(DiffCapable<?, ?> var1);

    public int diffHashCode();

    public D difference(T var1);

    public static <T> Adapter<T, Difference> wrap(T value) {
        return DiffCapable.wrap(value, Objects::equals, Objects::hashCode, (past, now) -> () -> Objects.equals(past, now));
    }

    public static <T, D extends Difference> Adapter<T, D> wrap(final T value, final BiPredicate<? super T, ? super T> isSameImpl, final Function<? super T, Integer> diffHashImpl, final BiFunction<? super T, ? super T, ? extends D> diffImpl) {
        return new Adapter<T, D>(){

            @Override
            public T getValue() {
                return value;
            }

            @Override
            public boolean isSame(DiffCapable<?, ?> other) {
                return other instanceof Adapter && isSameImpl.test(value, ((Adapter)other).getValue());
            }

            @Override
            public int diffHashCode() {
                return (Integer)diffHashImpl.apply(value);
            }

            @Override
            public D difference(Adapter<T, D> past) {
                return (Difference)diffImpl.apply(past.getValue(), value);
            }
        };
    }

    public static interface Adapter<T, D extends Difference>
    extends DiffCapable<Adapter<T, D>, D> {
        public T getValue();
    }
}

