/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.tools.projectWizard.compatibility;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.DependencyVersionParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinGradleCompatibilityParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinLibrariesCompatibilityParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.KotlinWizardVersionParser;
import org.jetbrains.kotlin.tools.projectWizard.compatibility.WizardDefaultDataGeneratorSettings;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataParser;
import org.jetbrains.plugins.gradle.jvmcompat.IdeVersionedDataState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001eB[\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012,\u0010\n\u001a(\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R7\u0010\n\u001a(\u0012\u0004\u0012\u00028\u0000\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000b\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings;", "T", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "", "jsonPath", "", "ktFileName", "parser", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "templatePath", "contextProvider", "Lkotlin/Function2;", "Lorg/apache/velocity/VelocityContext;", "Lkotlin/ParameterName;", "name", "context", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getJsonPath", "()Ljava/lang/String;", "getKtFileName", "getParser", "()Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataParser;", "getTemplatePath", "getContextProvider", "()Lkotlin/jvm/functions/Function2;", "generateDefaultData", "applicationVersion", "Companion", "intellij.kotlin.projectWizard.core"})
public final class WizardDefaultDataGeneratorSettings<T extends IdeVersionedDataState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jsonPath;
    @NotNull
    private final String ktFileName;
    @NotNull
    private final IdeVersionedDataParser<T> parser;
    @NotNull
    private final String templatePath;
    @NotNull
    private final Function2<T, VelocityContext, Unit> contextProvider;

    public WizardDefaultDataGeneratorSettings(@NotNull String jsonPath, @NotNull String ktFileName, @NotNull IdeVersionedDataParser<T> parser2, @NotNull String templatePath, @NotNull Function2<? super T, ? super VelocityContext, Unit> contextProvider) {
        Intrinsics.checkNotNullParameter((Object)jsonPath, (String)"jsonPath");
        Intrinsics.checkNotNullParameter((Object)ktFileName, (String)"ktFileName");
        Intrinsics.checkNotNullParameter(parser2, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)templatePath, (String)"templatePath");
        Intrinsics.checkNotNullParameter(contextProvider, (String)"contextProvider");
        this.jsonPath = jsonPath;
        this.ktFileName = ktFileName;
        this.parser = parser2;
        this.templatePath = templatePath;
        this.contextProvider = contextProvider;
    }

    @NotNull
    public final String getJsonPath() {
        return this.jsonPath;
    }

    @NotNull
    public final String getKtFileName() {
        return this.ktFileName;
    }

    @NotNull
    public final IdeVersionedDataParser<T> getParser() {
        return this.parser;
    }

    @NotNull
    public final String getTemplatePath() {
        return this.templatePath;
    }

    @NotNull
    public final Function2<T, VelocityContext, Unit> getContextProvider() {
        return this.contextProvider;
    }

    @NotNull
    public final String generateDefaultData(@NotNull String applicationVersion) {
        Intrinsics.checkNotNullParameter((Object)applicationVersion, (String)"applicationVersion");
        InputStream inputStream = WizardDefaultDataGeneratorSettings.class.getResourceAsStream(this.jsonPath);
        Intrinsics.checkNotNull((Object)inputStream);
        byte[] byArray = inputStream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        Charset charset = Charset.forName("utf8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        Charset charset2 = charset;
        String jsonData = new String(byArray2, charset2);
        IdeVersionedDataState ideVersionedDataState = this.parser.parseVersionedJson(jsonData, applicationVersion);
        Intrinsics.checkNotNull((Object)ideVersionedDataState);
        IdeVersionedDataState parsedData = ideVersionedDataState;
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loaders", (Object)"classpath");
        velocityEngine.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        Template template2 = velocityEngine.getTemplate(this.templatePath);
        VelocityContext context2 = new VelocityContext();
        context2.put("YEAR", (Object)LocalDate.now().getYear());
        this.contextProvider.invoke((Object)parsedData, (Object)context2);
        StringWriter writer = new StringWriter();
        template2.merge((Context)context2, (Writer)writer);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings$Companion;", "", "<init>", "()V", "getGenerators", "", "Lorg/jetbrains/kotlin/tools/projectWizard/compatibility/WizardDefaultDataGeneratorSettings;", "Lorg/jetbrains/plugins/gradle/jvmcompat/IdeVersionedDataState;", "intellij.kotlin.projectWizard.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<WizardDefaultDataGeneratorSettings<? extends IdeVersionedDataState>> getGenerators() {
            Object[] objectArray = new WizardDefaultDataGeneratorSettings[]{new WizardDefaultDataGeneratorSettings("/compatibility/dependencies.json", "DependencyDefaultData.kt", DependencyVersionParser.INSTANCE, "compatibility/templates/KotlinDependencyDefaultData.kt.vm", getGenerators.1.INSTANCE), new WizardDefaultDataGeneratorSettings("/compatibility/kotlin_gradle_compatibility.json", "KotlinGradleCompatibilityDefaultData.kt", KotlinGradleCompatibilityParser.INSTANCE, "compatibility/templates/KotlinGradleCompatibilityDefaultData.kt.vm", getGenerators.2.INSTANCE), new WizardDefaultDataGeneratorSettings("/compatibility/wizard_versions.json", "KotlinWizardVersionDefaultData.kt", KotlinWizardVersionParser.INSTANCE, "compatibility/templates/KotlinWizardVersionDefaultData.kt.vm", getGenerators.3.INSTANCE), new WizardDefaultDataGeneratorSettings("/compatibility/kotlin_libraries.json", "KotlinLibrariesDefaultData.kt", KotlinLibrariesCompatibilityParser.INSTANCE, "compatibility/templates/KotlinLibrariesDefaultData.kt.vm", getGenerators.4.INSTANCE)};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

