/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinResourceRootTypeKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u001a\u0010\u0010\u0007\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\r\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"isOutsideSourceRootSet", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "sourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "isOutsideKotlinAwareSourceRoot", "getSuitableDestinationSourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "", "module", "Lcom/intellij/openapi/module/Module;", "collectSuitableDestinationSourceRoots", "", "result", "isForGeneratedSources", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "intellij.kotlin.base.projectStructure"})
public final class ProjectRootUtilsKt {
    public static final boolean isOutsideSourceRootSet(@Nullable PsiFile psiFile, @NotNull Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes) {
        Intrinsics.checkNotNullParameter(sourceRootTypes, (String)"sourceRootTypes");
        if (psiFile == null || psiFile instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        if (file.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return !projectFileIndex2.isUnderSourceRootOfType(file, sourceRootTypes) && !projectFileIndex2.isInLibrary(file);
    }

    public static final boolean isOutsideKotlinAwareSourceRoot(@Nullable PsiFile psiFile) {
        return ProjectRootUtilsKt.isOutsideSourceRootSet(psiFile, ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList roots = new ArrayList();
        for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
            ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module, roots);
        }
        return roots;
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ArrayList roots = new ArrayList();
        ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module, roots);
        return roots;
    }

    public static final void collectSuitableDestinationSourceRoots(@NotNull Module module, @NotNull List<VirtualFile> result2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ContentEntry[] contentEntryArray = ModuleRootManager.getInstance((Module)module).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
        for (ContentEntry entry : contentEntryArray) {
            for (SourceFolder sourceFolder : entry.getSourceFolders(ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES())) {
                Intrinsics.checkNotNull((Object)sourceFolder);
                if (ProjectRootUtilsKt.isForGeneratedSources(sourceFolder)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)sourceFolder.getFile());
            }
        }
    }

    public static final boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        JavaSourceRootProperties properties = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(ProjectStructureUtils.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
        JavaResourceRootProperties javaResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        JavaResourceRootProperties kotlinResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(KotlinResourceRootTypeKt.getALL_KOTLIN_RESOURCE_ROOT_TYPES());
        return properties != null && properties.isForGeneratedSources() || javaResourceProperties != null && javaResourceProperties.isForGeneratedSources() || kotlinResourceProperties != null && kotlinResourceProperties.isForGeneratedSources();
    }
}

